/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         nft_parse
#define yylex           nft_lex
#define yyerror         nft_error
#define yydebug         nft_debug
#define yynerrs         nft_nerrs

/* First part of user prologue.  */
#line 11 "parser_bison.y"


#include <ctype.h>
#include <stddef.h>
#include <stdio.h>
#include <inttypes.h>
#include <syslog.h>
#include <net/if.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/if_ether.h>
#include <linux/netfilter.h>
#include <linux/netfilter/nf_tables.h>
#include <linux/netfilter/nf_conntrack_tuple_common.h>
#include <linux/netfilter/nf_nat.h>
#include <linux/netfilter/nf_log.h>
#include <linux/netfilter/nfnetlink_osf.h>
#include <linux/netfilter/nf_synproxy.h>
#include <linux/xfrm.h>
#include <netinet/ip_icmp.h>
#include <netinet/icmp6.h>
#include <libnftnl/common.h>
#include <libnftnl/set.h>
#include <libnftnl/udata.h>

#include <rule.h>
#include <statement.h>
#include <expression.h>
#include <headers.h>
#include <utils.h>
#include <parser.h>
#include <erec.h>
#include <sctp_chunk.h>

#include "parser_bison.h"

void parser_init(struct nft_ctx *nft, struct parser_state *state,
		 struct list_head *msgs, struct list_head *cmds,
		 struct scope *top_scope)
{
	memset(state, 0, sizeof(*state));
	state->msgs = msgs;
	state->cmds = cmds;
	state->scopes[0] = scope_init(top_scope, NULL);
	init_list_head(&state->indesc_list);
}

static void yyerror(struct location *loc, struct nft_ctx *nft, void *scanner,
		    struct parser_state *state, const char *s)
{
	erec_queue(error(loc, "%s", s), state->msgs);
}

static struct scope *current_scope(const struct parser_state *state)
{
	return state->scopes[state->scope];
}

static int open_scope(struct parser_state *state, struct scope *scope)
{
	if (state->scope >= array_size(state->scopes) - 1) {
		state->scope_err = true;
		return -1;
	}

	scope_init(scope, current_scope(state));
	state->scopes[++state->scope] = scope;

	return 0;
}

static void close_scope(struct parser_state *state)
{
	if (state->scope_err || state->scope == 0) {
		state->scope_err = false;
		return;
	}

	state->scope--;
}

static void location_init(void *scanner, struct parser_state *state,
			  struct location *loc)
{
	memset(loc, 0, sizeof(*loc));
	loc->indesc = state->indesc;
}

static void location_update(struct location *loc, struct location *rhs, int n)
{
	if (n) {
		loc->indesc       = rhs[n].indesc;
		loc->token_offset = rhs[1].token_offset;
		loc->line_offset  = rhs[1].line_offset;
		loc->first_line   = rhs[1].first_line;
		loc->first_column = rhs[1].first_column;
		loc->last_line    = rhs[n].last_line;
		loc->last_column  = rhs[n].last_column;
	} else {
		loc->indesc       = rhs[0].indesc;
		loc->token_offset = rhs[0].token_offset;
		loc->line_offset  = rhs[0].line_offset;
		loc->first_line   = loc->last_line   = rhs[0].last_line;
		loc->first_column = loc->last_column = rhs[0].last_column;
	}
}

static struct expr *handle_concat_expr(const struct location *loc,
					 struct expr *expr,
					 struct expr *expr_l, struct expr *expr_r,
					 struct location loc_rhs[3])
{
	if (expr->etype != EXPR_CONCAT) {
		expr = concat_expr_alloc(loc);
		compound_expr_add(expr, expr_l);
	} else {
		location_update(&expr_r->location, loc_rhs, 2);

		expr = expr_l;
		expr->location = *loc;
	}

	compound_expr_add(expr, expr_r);
	return expr;
}

static bool already_set(const void *attr, const struct location *loc,
			struct parser_state *state)
{
	if (!attr)
		return false;

	erec_queue(error(loc, "You can only specify this once. This statement is duplicated."),
		   state->msgs);
	return true;
}

static struct expr *ifname_expr_alloc(const struct location *location,
				      struct list_head *queue,
				      const char *name)
{
	unsigned int length = strlen(name);
	struct expr *expr;

	if (length == 0) {
		xfree(name);
		erec_queue(error(location, "empty interface name"), queue);
		return NULL;
	}

	if (length >= IFNAMSIZ) {
		xfree(name);
		erec_queue(error(location, "interface name too long"), queue);
		return NULL;
	}

	expr = constant_expr_alloc(location, &ifname_type, BYTEORDER_HOST_ENDIAN,
				   length * BITS_PER_BYTE, name);

	xfree(name);

	return expr;
}

static void timeout_state_free(struct timeout_state *s)
{
	xfree(s->timeout_str);
	free(s);
}

static void timeout_states_free(struct list_head *list)
{
	struct timeout_state *ts, *next;

	list_for_each_entry_safe(ts, next, list, head) {
		list_del(&ts->head);
		timeout_state_free(ts);
	}

	free(list);
}

#define YYLLOC_DEFAULT(Current, Rhs, N)	location_update(&Current, Rhs, N)

#define symbol_value(loc, str) \
	symbol_expr_alloc(loc, SYMBOL_VALUE, current_scope(state), str)

/* Declare those here to avoid compiler warnings */
void nft_set_debug(int, void *);
int nft_lex(void *, void *, void *);

#line 268 "parser_bison.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_NFT_PARSER_BISON_H_INCLUDED
# define YY_NFT_PARSER_BISON_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif
#if YYDEBUG
extern int nft_debug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    TOKEN_EOF = 0,                 /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    JUNK = 258,                    /* "junk"  */
    CRLF = 259,                    /* "CRLF line terminators"  */
    NEWLINE = 260,                 /* "newline"  */
    COLON = 261,                   /* "colon"  */
    SEMICOLON = 262,               /* "semicolon"  */
    COMMA = 263,                   /* "comma"  */
    DOT = 264,                     /* "."  */
    EQ = 265,                      /* "=="  */
    NEQ = 266,                     /* "!="  */
    LT = 267,                      /* "<"  */
    GT = 268,                      /* ">"  */
    GTE = 269,                     /* ">="  */
    LTE = 270,                     /* "<="  */
    LSHIFT = 271,                  /* "<<"  */
    RSHIFT = 272,                  /* ">>"  */
    AMPERSAND = 273,               /* "&"  */
    CARET = 274,                   /* "^"  */
    NOT = 275,                     /* "!"  */
    SLASH = 276,                   /* "/"  */
    ASTERISK = 277,                /* "*"  */
    DASH = 278,                    /* "-"  */
    AT = 279,                      /* "@"  */
    VMAP = 280,                    /* "vmap"  */
    PLUS = 281,                    /* "+"  */
    INCLUDE = 282,                 /* "include"  */
    DEFINE = 283,                  /* "define"  */
    REDEFINE = 284,                /* "redefine"  */
    UNDEFINE = 285,                /* "undefine"  */
    FIB = 286,                     /* "fib"  */
    SOCKET = 287,                  /* "socket"  */
    TRANSPARENT = 288,             /* "transparent"  */
    WILDCARD = 289,                /* "wildcard"  */
    CGROUPV2 = 290,                /* "cgroupv2"  */
    TPROXY = 291,                  /* "tproxy"  */
    OSF = 292,                     /* "osf"  */
    SYNPROXY = 293,                /* "synproxy"  */
    MSS = 294,                     /* "mss"  */
    WSCALE = 295,                  /* "wscale"  */
    TYPEOF = 296,                  /* "typeof"  */
    HOOK = 297,                    /* "hook"  */
    HOOKS = 298,                   /* "hooks"  */
    DEVICE = 299,                  /* "device"  */
    DEVICES = 300,                 /* "devices"  */
    TABLE = 301,                   /* "table"  */
    TABLES = 302,                  /* "tables"  */
    CHAIN = 303,                   /* "chain"  */
    CHAINS = 304,                  /* "chains"  */
    RULE = 305,                    /* "rule"  */
    RULES = 306,                   /* "rules"  */
    SETS = 307,                    /* "sets"  */
    SET = 308,                     /* "set"  */
    ELEMENT = 309,                 /* "element"  */
    MAP = 310,                     /* "map"  */
    MAPS = 311,                    /* "maps"  */
    FLOWTABLE = 312,               /* "flowtable"  */
    HANDLE = 313,                  /* "handle"  */
    RULESET = 314,                 /* "ruleset"  */
    TRACE = 315,                   /* "trace"  */
    INET = 316,                    /* "inet"  */
    NETDEV = 317,                  /* "netdev"  */
    ADD = 318,                     /* "add"  */
    UPDATE = 319,                  /* "update"  */
    REPLACE = 320,                 /* "replace"  */
    CREATE = 321,                  /* "create"  */
    INSERT = 322,                  /* "insert"  */
    DELETE = 323,                  /* "delete"  */
    GET = 324,                     /* "get"  */
    LIST = 325,                    /* "list"  */
    RESET = 326,                   /* "reset"  */
    FLUSH = 327,                   /* "flush"  */
    RENAME = 328,                  /* "rename"  */
    DESCRIBE = 329,                /* "describe"  */
    IMPORT = 330,                  /* "import"  */
    EXPORT = 331,                  /* "export"  */
    MONITOR = 332,                 /* "monitor"  */
    ALL = 333,                     /* "all"  */
    ACCEPT = 334,                  /* "accept"  */
    DROP = 335,                    /* "drop"  */
    CONTINUE = 336,                /* "continue"  */
    JUMP = 337,                    /* "jump"  */
    GOTO = 338,                    /* "goto"  */
    RETURN = 339,                  /* "return"  */
    TO = 340,                      /* "to"  */
    CONSTANT = 341,                /* "constant"  */
    INTERVAL = 342,                /* "interval"  */
    DYNAMIC = 343,                 /* "dynamic"  */
    AUTOMERGE = 344,               /* "auto-merge"  */
    TIMEOUT = 345,                 /* "timeout"  */
    GC_INTERVAL = 346,             /* "gc-interval"  */
    ELEMENTS = 347,                /* "elements"  */
    EXPIRES = 348,                 /* "expires"  */
    POLICY = 349,                  /* "policy"  */
    MEMORY = 350,                  /* "memory"  */
    PERFORMANCE = 351,             /* "performance"  */
    SIZE = 352,                    /* "size"  */
    FLOW = 353,                    /* "flow"  */
    OFFLOAD = 354,                 /* "offload"  */
    METER = 355,                   /* "meter"  */
    METERS = 356,                  /* "meters"  */
    FLOWTABLES = 357,              /* "flowtables"  */
    NUM = 358,                     /* "number"  */
    STRING = 359,                  /* "string"  */
    QUOTED_STRING = 360,           /* "quoted string"  */
    ASTERISK_STRING = 361,         /* "string with a trailing asterisk"  */
    LL_HDR = 362,                  /* "ll"  */
    NETWORK_HDR = 363,             /* "nh"  */
    TRANSPORT_HDR = 364,           /* "th"  */
    BRIDGE = 365,                  /* "bridge"  */
    ETHER = 366,                   /* "ether"  */
    SADDR = 367,                   /* "saddr"  */
    DADDR = 368,                   /* "daddr"  */
    TYPE = 369,                    /* "type"  */
    VLAN = 370,                    /* "vlan"  */
    ID = 371,                      /* "id"  */
    CFI = 372,                     /* "cfi"  */
    DEI = 373,                     /* "dei"  */
    PCP = 374,                     /* "pcp"  */
    ARP = 375,                     /* "arp"  */
    HTYPE = 376,                   /* "htype"  */
    PTYPE = 377,                   /* "ptype"  */
    HLEN = 378,                    /* "hlen"  */
    PLEN = 379,                    /* "plen"  */
    OPERATION = 380,               /* "operation"  */
    IP = 381,                      /* "ip"  */
    HDRVERSION = 382,              /* "version"  */
    HDRLENGTH = 383,               /* "hdrlength"  */
    DSCP = 384,                    /* "dscp"  */
    ECN = 385,                     /* "ecn"  */
    LENGTH = 386,                  /* "length"  */
    FRAG_OFF = 387,                /* "frag-off"  */
    TTL = 388,                     /* "ttl"  */
    PROTOCOL = 389,                /* "protocol"  */
    CHECKSUM = 390,                /* "checksum"  */
    PTR = 391,                     /* "ptr"  */
    VALUE = 392,                   /* "value"  */
    LSRR = 393,                    /* "lsrr"  */
    RR = 394,                      /* "rr"  */
    SSRR = 395,                    /* "ssrr"  */
    RA = 396,                      /* "ra"  */
    ICMP = 397,                    /* "icmp"  */
    CODE = 398,                    /* "code"  */
    SEQUENCE = 399,                /* "seq"  */
    GATEWAY = 400,                 /* "gateway"  */
    MTU = 401,                     /* "mtu"  */
    IGMP = 402,                    /* "igmp"  */
    MRT = 403,                     /* "mrt"  */
    OPTIONS = 404,                 /* "options"  */
    IP6 = 405,                     /* "ip6"  */
    PRIORITY = 406,                /* "priority"  */
    FLOWLABEL = 407,               /* "flowlabel"  */
    NEXTHDR = 408,                 /* "nexthdr"  */
    HOPLIMIT = 409,                /* "hoplimit"  */
    ICMP6 = 410,                   /* "icmpv6"  */
    PPTR = 411,                    /* "param-problem"  */
    MAXDELAY = 412,                /* "max-delay"  */
    AH = 413,                      /* "ah"  */
    RESERVED = 414,                /* "reserved"  */
    SPI = 415,                     /* "spi"  */
    ESP = 416,                     /* "esp"  */
    COMP = 417,                    /* "comp"  */
    FLAGS = 418,                   /* "flags"  */
    CPI = 419,                     /* "cpi"  */
    PORT = 420,                    /* "port"  */
    UDP = 421,                     /* "udp"  */
    SPORT = 422,                   /* "sport"  */
    DPORT = 423,                   /* "dport"  */
    UDPLITE = 424,                 /* "udplite"  */
    CSUMCOV = 425,                 /* "csumcov"  */
    TCP = 426,                     /* "tcp"  */
    ACKSEQ = 427,                  /* "ackseq"  */
    DOFF = 428,                    /* "doff"  */
    WINDOW = 429,                  /* "window"  */
    URGPTR = 430,                  /* "urgptr"  */
    OPTION = 431,                  /* "option"  */
    ECHO = 432,                    /* "echo"  */
    EOL = 433,                     /* "eol"  */
    MPTCP = 434,                   /* "mptcp"  */
    NOP = 435,                     /* "nop"  */
    SACK = 436,                    /* "sack"  */
    SACK0 = 437,                   /* "sack0"  */
    SACK1 = 438,                   /* "sack1"  */
    SACK2 = 439,                   /* "sack2"  */
    SACK3 = 440,                   /* "sack3"  */
    SACK_PERM = 441,               /* "sack-permitted"  */
    FASTOPEN = 442,                /* "fastopen"  */
    MD5SIG = 443,                  /* "md5sig"  */
    TIMESTAMP = 444,               /* "timestamp"  */
    COUNT = 445,                   /* "count"  */
    LEFT = 446,                    /* "left"  */
    RIGHT = 447,                   /* "right"  */
    TSVAL = 448,                   /* "tsval"  */
    TSECR = 449,                   /* "tsecr"  */
    SUBTYPE = 450,                 /* "subtype"  */
    DCCP = 451,                    /* "dccp"  */
    SCTP = 452,                    /* "sctp"  */
    CHUNK = 453,                   /* "chunk"  */
    DATA = 454,                    /* "data"  */
    INIT = 455,                    /* "init"  */
    INIT_ACK = 456,                /* "init-ack"  */
    HEARTBEAT = 457,               /* "heartbeat"  */
    HEARTBEAT_ACK = 458,           /* "heartbeat-ack"  */
    ABORT = 459,                   /* "abort"  */
    SHUTDOWN = 460,                /* "shutdown"  */
    SHUTDOWN_ACK = 461,            /* "shutdown-ack"  */
    ERROR = 462,                   /* "error"  */
    COOKIE_ECHO = 463,             /* "cookie-echo"  */
    COOKIE_ACK = 464,              /* "cookie-ack"  */
    ECNE = 465,                    /* "ecne"  */
    CWR = 466,                     /* "cwr"  */
    SHUTDOWN_COMPLETE = 467,       /* "shutdown-complete"  */
    ASCONF_ACK = 468,              /* "asconf-ack"  */
    FORWARD_TSN = 469,             /* "forward-tsn"  */
    ASCONF = 470,                  /* "asconf"  */
    TSN = 471,                     /* "tsn"  */
    STREAM = 472,                  /* "stream"  */
    SSN = 473,                     /* "ssn"  */
    PPID = 474,                    /* "ppid"  */
    INIT_TAG = 475,                /* "init-tag"  */
    A_RWND = 476,                  /* "a-rwnd"  */
    NUM_OSTREAMS = 477,            /* "num-outbound-streams"  */
    NUM_ISTREAMS = 478,            /* "num-inbound-streams"  */
    INIT_TSN = 479,                /* "initial-tsn"  */
    CUM_TSN_ACK = 480,             /* "cum-tsn-ack"  */
    NUM_GACK_BLOCKS = 481,         /* "num-gap-ack-blocks"  */
    NUM_DUP_TSNS = 482,            /* "num-dup-tsns"  */
    LOWEST_TSN = 483,              /* "lowest-tsn"  */
    SEQNO = 484,                   /* "seqno"  */
    NEW_CUM_TSN = 485,             /* "new-cum-tsn"  */
    VTAG = 486,                    /* "vtag"  */
    RT = 487,                      /* "rt"  */
    RT0 = 488,                     /* "rt0"  */
    RT2 = 489,                     /* "rt2"  */
    RT4 = 490,                     /* "srh"  */
    SEG_LEFT = 491,                /* "seg-left"  */
    ADDR = 492,                    /* "addr"  */
    LAST_ENT = 493,                /* "last-entry"  */
    TAG = 494,                     /* "tag"  */
    SID = 495,                     /* "sid"  */
    HBH = 496,                     /* "hbh"  */
    FRAG = 497,                    /* "frag"  */
    RESERVED2 = 498,               /* "reserved2"  */
    MORE_FRAGMENTS = 499,          /* "more-fragments"  */
    DST = 500,                     /* "dst"  */
    MH = 501,                      /* "mh"  */
    META = 502,                    /* "meta"  */
    MARK = 503,                    /* "mark"  */
    IIF = 504,                     /* "iif"  */
    IIFNAME = 505,                 /* "iifname"  */
    IIFTYPE = 506,                 /* "iiftype"  */
    OIF = 507,                     /* "oif"  */
    OIFNAME = 508,                 /* "oifname"  */
    OIFTYPE = 509,                 /* "oiftype"  */
    SKUID = 510,                   /* "skuid"  */
    SKGID = 511,                   /* "skgid"  */
    NFTRACE = 512,                 /* "nftrace"  */
    RTCLASSID = 513,               /* "rtclassid"  */
    IBRIPORT = 514,                /* "ibriport"  */
    OBRIPORT = 515,                /* "obriport"  */
    IBRIDGENAME = 516,             /* "ibrname"  */
    OBRIDGENAME = 517,             /* "obrname"  */
    PKTTYPE = 518,                 /* "pkttype"  */
    CPU = 519,                     /* "cpu"  */
    IIFGROUP = 520,                /* "iifgroup"  */
    OIFGROUP = 521,                /* "oifgroup"  */
    CGROUP = 522,                  /* "cgroup"  */
    TIME = 523,                    /* "time"  */
    CLASSID = 524,                 /* "classid"  */
    NEXTHOP = 525,                 /* "nexthop"  */
    CT = 526,                      /* "ct"  */
    L3PROTOCOL = 527,              /* "l3proto"  */
    PROTO_SRC = 528,               /* "proto-src"  */
    PROTO_DST = 529,               /* "proto-dst"  */
    ZONE = 530,                    /* "zone"  */
    DIRECTION = 531,               /* "direction"  */
    EVENT = 532,                   /* "event"  */
    EXPECTATION = 533,             /* "expectation"  */
    EXPIRATION = 534,              /* "expiration"  */
    HELPER = 535,                  /* "helper"  */
    LABEL = 536,                   /* "label"  */
    STATE = 537,                   /* "state"  */
    STATUS = 538,                  /* "status"  */
    ORIGINAL = 539,                /* "original"  */
    REPLY = 540,                   /* "reply"  */
    COUNTER = 541,                 /* "counter"  */
    NAME = 542,                    /* "name"  */
    PACKETS = 543,                 /* "packets"  */
    BYTES = 544,                   /* "bytes"  */
    AVGPKT = 545,                  /* "avgpkt"  */
    COUNTERS = 546,                /* "counters"  */
    QUOTAS = 547,                  /* "quotas"  */
    LIMITS = 548,                  /* "limits"  */
    SYNPROXYS = 549,               /* "synproxys"  */
    HELPERS = 550,                 /* "helpers"  */
    LOG = 551,                     /* "log"  */
    PREFIX = 552,                  /* "prefix"  */
    GROUP = 553,                   /* "group"  */
    SNAPLEN = 554,                 /* "snaplen"  */
    QUEUE_THRESHOLD = 555,         /* "queue-threshold"  */
    LEVEL = 556,                   /* "level"  */
    LIMIT = 557,                   /* "limit"  */
    RATE = 558,                    /* "rate"  */
    BURST = 559,                   /* "burst"  */
    OVER = 560,                    /* "over"  */
    UNTIL = 561,                   /* "until"  */
    QUOTA = 562,                   /* "quota"  */
    USED = 563,                    /* "used"  */
    SECMARK = 564,                 /* "secmark"  */
    SECMARKS = 565,                /* "secmarks"  */
    SECOND = 566,                  /* "second"  */
    MINUTE = 567,                  /* "minute"  */
    HOUR = 568,                    /* "hour"  */
    DAY = 569,                     /* "day"  */
    WEEK = 570,                    /* "week"  */
    _REJECT = 571,                 /* "reject"  */
    WITH = 572,                    /* "with"  */
    ICMPX = 573,                   /* "icmpx"  */
    SNAT = 574,                    /* "snat"  */
    DNAT = 575,                    /* "dnat"  */
    MASQUERADE = 576,              /* "masquerade"  */
    REDIRECT = 577,                /* "redirect"  */
    RANDOM = 578,                  /* "random"  */
    FULLY_RANDOM = 579,            /* "fully-random"  */
    PERSISTENT = 580,              /* "persistent"  */
    QUEUE = 581,                   /* "queue"  */
    QUEUENUM = 582,                /* "num"  */
    BYPASS = 583,                  /* "bypass"  */
    FANOUT = 584,                  /* "fanout"  */
    DUP = 585,                     /* "dup"  */
    FWD = 586,                     /* "fwd"  */
    NUMGEN = 587,                  /* "numgen"  */
    INC = 588,                     /* "inc"  */
    MOD = 589,                     /* "mod"  */
    OFFSET = 590,                  /* "offset"  */
    JHASH = 591,                   /* "jhash"  */
    SYMHASH = 592,                 /* "symhash"  */
    SEED = 593,                    /* "seed"  */
    POSITION = 594,                /* "position"  */
    INDEX = 595,                   /* "index"  */
    COMMENT = 596,                 /* "comment"  */
    XML = 597,                     /* "xml"  */
    JSON = 598,                    /* "json"  */
    VM = 599,                      /* "vm"  */
    NOTRACK = 600,                 /* "notrack"  */
    EXISTS = 601,                  /* "exists"  */
    MISSING = 602,                 /* "missing"  */
    EXTHDR = 603,                  /* "exthdr"  */
    IPSEC = 604,                   /* "ipsec"  */
    REQID = 605,                   /* "reqid"  */
    SPNUM = 606,                   /* "spnum"  */
    IN = 607,                      /* "in"  */
    OUT = 608,                     /* "out"  */
    XT = 609                       /* "xt"  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define TOKEN_EOF 0
#define YYerror 256
#define YYUNDEF 257
#define JUNK 258
#define CRLF 259
#define NEWLINE 260
#define COLON 261
#define SEMICOLON 262
#define COMMA 263
#define DOT 264
#define EQ 265
#define NEQ 266
#define LT 267
#define GT 268
#define GTE 269
#define LTE 270
#define LSHIFT 271
#define RSHIFT 272
#define AMPERSAND 273
#define CARET 274
#define NOT 275
#define SLASH 276
#define ASTERISK 277
#define DASH 278
#define AT 279
#define VMAP 280
#define PLUS 281
#define INCLUDE 282
#define DEFINE 283
#define REDEFINE 284
#define UNDEFINE 285
#define FIB 286
#define SOCKET 287
#define TRANSPARENT 288
#define WILDCARD 289
#define CGROUPV2 290
#define TPROXY 291
#define OSF 292
#define SYNPROXY 293
#define MSS 294
#define WSCALE 295
#define TYPEOF 296
#define HOOK 297
#define HOOKS 298
#define DEVICE 299
#define DEVICES 300
#define TABLE 301
#define TABLES 302
#define CHAIN 303
#define CHAINS 304
#define RULE 305
#define RULES 306
#define SETS 307
#define SET 308
#define ELEMENT 309
#define MAP 310
#define MAPS 311
#define FLOWTABLE 312
#define HANDLE 313
#define RULESET 314
#define TRACE 315
#define INET 316
#define NETDEV 317
#define ADD 318
#define UPDATE 319
#define REPLACE 320
#define CREATE 321
#define INSERT 322
#define DELETE 323
#define GET 324
#define LIST 325
#define RESET 326
#define FLUSH 327
#define RENAME 328
#define DESCRIBE 329
#define IMPORT 330
#define EXPORT 331
#define MONITOR 332
#define ALL 333
#define ACCEPT 334
#define DROP 335
#define CONTINUE 336
#define JUMP 337
#define GOTO 338
#define RETURN 339
#define TO 340
#define CONSTANT 341
#define INTERVAL 342
#define DYNAMIC 343
#define AUTOMERGE 344
#define TIMEOUT 345
#define GC_INTERVAL 346
#define ELEMENTS 347
#define EXPIRES 348
#define POLICY 349
#define MEMORY 350
#define PERFORMANCE 351
#define SIZE 352
#define FLOW 353
#define OFFLOAD 354
#define METER 355
#define METERS 356
#define FLOWTABLES 357
#define NUM 358
#define STRING 359
#define QUOTED_STRING 360
#define ASTERISK_STRING 361
#define LL_HDR 362
#define NETWORK_HDR 363
#define TRANSPORT_HDR 364
#define BRIDGE 365
#define ETHER 366
#define SADDR 367
#define DADDR 368
#define TYPE 369
#define VLAN 370
#define ID 371
#define CFI 372
#define DEI 373
#define PCP 374
#define ARP 375
#define HTYPE 376
#define PTYPE 377
#define HLEN 378
#define PLEN 379
#define OPERATION 380
#define IP 381
#define HDRVERSION 382
#define HDRLENGTH 383
#define DSCP 384
#define ECN 385
#define LENGTH 386
#define FRAG_OFF 387
#define TTL 388
#define PROTOCOL 389
#define CHECKSUM 390
#define PTR 391
#define VALUE 392
#define LSRR 393
#define RR 394
#define SSRR 395
#define RA 396
#define ICMP 397
#define CODE 398
#define SEQUENCE 399
#define GATEWAY 400
#define MTU 401
#define IGMP 402
#define MRT 403
#define OPTIONS 404
#define IP6 405
#define PRIORITY 406
#define FLOWLABEL 407
#define NEXTHDR 408
#define HOPLIMIT 409
#define ICMP6 410
#define PPTR 411
#define MAXDELAY 412
#define AH 413
#define RESERVED 414
#define SPI 415
#define ESP 416
#define COMP 417
#define FLAGS 418
#define CPI 419
#define PORT 420
#define UDP 421
#define SPORT 422
#define DPORT 423
#define UDPLITE 424
#define CSUMCOV 425
#define TCP 426
#define ACKSEQ 427
#define DOFF 428
#define WINDOW 429
#define URGPTR 430
#define OPTION 431
#define ECHO 432
#define EOL 433
#define MPTCP 434
#define NOP 435
#define SACK 436
#define SACK0 437
#define SACK1 438
#define SACK2 439
#define SACK3 440
#define SACK_PERM 441
#define FASTOPEN 442
#define MD5SIG 443
#define TIMESTAMP 444
#define COUNT 445
#define LEFT 446
#define RIGHT 447
#define TSVAL 448
#define TSECR 449
#define SUBTYPE 450
#define DCCP 451
#define SCTP 452
#define CHUNK 453
#define DATA 454
#define INIT 455
#define INIT_ACK 456
#define HEARTBEAT 457
#define HEARTBEAT_ACK 458
#define ABORT 459
#define SHUTDOWN 460
#define SHUTDOWN_ACK 461
#define ERROR 462
#define COOKIE_ECHO 463
#define COOKIE_ACK 464
#define ECNE 465
#define CWR 466
#define SHUTDOWN_COMPLETE 467
#define ASCONF_ACK 468
#define FORWARD_TSN 469
#define ASCONF 470
#define TSN 471
#define STREAM 472
#define SSN 473
#define PPID 474
#define INIT_TAG 475
#define A_RWND 476
#define NUM_OSTREAMS 477
#define NUM_ISTREAMS 478
#define INIT_TSN 479
#define CUM_TSN_ACK 480
#define NUM_GACK_BLOCKS 481
#define NUM_DUP_TSNS 482
#define LOWEST_TSN 483
#define SEQNO 484
#define NEW_CUM_TSN 485
#define VTAG 486
#define RT 487
#define RT0 488
#define RT2 489
#define RT4 490
#define SEG_LEFT 491
#define ADDR 492
#define LAST_ENT 493
#define TAG 494
#define SID 495
#define HBH 496
#define FRAG 497
#define RESERVED2 498
#define MORE_FRAGMENTS 499
#define DST 500
#define MH 501
#define META 502
#define MARK 503
#define IIF 504
#define IIFNAME 505
#define IIFTYPE 506
#define OIF 507
#define OIFNAME 508
#define OIFTYPE 509
#define SKUID 510
#define SKGID 511
#define NFTRACE 512
#define RTCLASSID 513
#define IBRIPORT 514
#define OBRIPORT 515
#define IBRIDGENAME 516
#define OBRIDGENAME 517
#define PKTTYPE 518
#define CPU 519
#define IIFGROUP 520
#define OIFGROUP 521
#define CGROUP 522
#define TIME 523
#define CLASSID 524
#define NEXTHOP 525
#define CT 526
#define L3PROTOCOL 527
#define PROTO_SRC 528
#define PROTO_DST 529
#define ZONE 530
#define DIRECTION 531
#define EVENT 532
#define EXPECTATION 533
#define EXPIRATION 534
#define HELPER 535
#define LABEL 536
#define STATE 537
#define STATUS 538
#define ORIGINAL 539
#define REPLY 540
#define COUNTER 541
#define NAME 542
#define PACKETS 543
#define BYTES 544
#define AVGPKT 545
#define COUNTERS 546
#define QUOTAS 547
#define LIMITS 548
#define SYNPROXYS 549
#define HELPERS 550
#define LOG 551
#define PREFIX 552
#define GROUP 553
#define SNAPLEN 554
#define QUEUE_THRESHOLD 555
#define LEVEL 556
#define LIMIT 557
#define RATE 558
#define BURST 559
#define OVER 560
#define UNTIL 561
#define QUOTA 562
#define USED 563
#define SECMARK 564
#define SECMARKS 565
#define SECOND 566
#define MINUTE 567
#define HOUR 568
#define DAY 569
#define WEEK 570
#define _REJECT 571
#define WITH 572
#define ICMPX 573
#define SNAT 574
#define DNAT 575
#define MASQUERADE 576
#define REDIRECT 577
#define RANDOM 578
#define FULLY_RANDOM 579
#define PERSISTENT 580
#define QUEUE 581
#define QUEUENUM 582
#define BYPASS 583
#define FANOUT 584
#define DUP 585
#define FWD 586
#define NUMGEN 587
#define INC 588
#define MOD 589
#define OFFSET 590
#define JHASH 591
#define SYMHASH 592
#define SEED 593
#define POSITION 594
#define INDEX 595
#define COMMENT 596
#define XML 597
#define JSON 598
#define VM 599
#define NOTRACK 600
#define EXISTS 601
#define MISSING 602
#define EXTHDR 603
#define IPSEC 604
#define REQID 605
#define SPNUM 606
#define IN 607
#define OUT 608
#define XT 609

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 223 "parser_bison.y"

	uint64_t		val;
	uint32_t		val32;
	uint8_t			val8;
	const char *		string;

	struct list_head	*list;
	struct cmd		*cmd;
	struct handle		handle;
	struct table		*table;
	struct chain		*chain;
	struct rule		*rule;
	struct stmt		*stmt;
	struct expr		*expr;
	struct set		*set;
	struct obj		*obj;
	struct flowtable	*flowtable;
	struct ct		*ct;
	const struct datatype	*datatype;
	struct handle_spec	handle_spec;
	struct position_spec	position_spec;
	struct prio_spec	prio_spec;
	struct limit_rate	limit_rate;
	struct tcp_kind_field {
		uint16_t kind; /* must allow > 255 for SACK1, 2.. hack */
		uint8_t field;
	} tcp_kind_field;
	struct timeout_state	*timeout_state;

#line 1059 "parser_bison.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif




int nft_parse (struct nft_ctx *nft, void *scanner, struct parser_state *state);


#endif /* !YY_NFT_PARSER_BISON_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_JUNK = 3,                       /* "junk"  */
  YYSYMBOL_CRLF = 4,                       /* "CRLF line terminators"  */
  YYSYMBOL_NEWLINE = 5,                    /* "newline"  */
  YYSYMBOL_COLON = 6,                      /* "colon"  */
  YYSYMBOL_SEMICOLON = 7,                  /* "semicolon"  */
  YYSYMBOL_COMMA = 8,                      /* "comma"  */
  YYSYMBOL_DOT = 9,                        /* "."  */
  YYSYMBOL_EQ = 10,                        /* "=="  */
  YYSYMBOL_NEQ = 11,                       /* "!="  */
  YYSYMBOL_LT = 12,                        /* "<"  */
  YYSYMBOL_GT = 13,                        /* ">"  */
  YYSYMBOL_GTE = 14,                       /* ">="  */
  YYSYMBOL_LTE = 15,                       /* "<="  */
  YYSYMBOL_LSHIFT = 16,                    /* "<<"  */
  YYSYMBOL_RSHIFT = 17,                    /* ">>"  */
  YYSYMBOL_AMPERSAND = 18,                 /* "&"  */
  YYSYMBOL_CARET = 19,                     /* "^"  */
  YYSYMBOL_NOT = 20,                       /* "!"  */
  YYSYMBOL_SLASH = 21,                     /* "/"  */
  YYSYMBOL_ASTERISK = 22,                  /* "*"  */
  YYSYMBOL_DASH = 23,                      /* "-"  */
  YYSYMBOL_AT = 24,                        /* "@"  */
  YYSYMBOL_VMAP = 25,                      /* "vmap"  */
  YYSYMBOL_PLUS = 26,                      /* "+"  */
  YYSYMBOL_INCLUDE = 27,                   /* "include"  */
  YYSYMBOL_DEFINE = 28,                    /* "define"  */
  YYSYMBOL_REDEFINE = 29,                  /* "redefine"  */
  YYSYMBOL_UNDEFINE = 30,                  /* "undefine"  */
  YYSYMBOL_FIB = 31,                       /* "fib"  */
  YYSYMBOL_SOCKET = 32,                    /* "socket"  */
  YYSYMBOL_TRANSPARENT = 33,               /* "transparent"  */
  YYSYMBOL_WILDCARD = 34,                  /* "wildcard"  */
  YYSYMBOL_CGROUPV2 = 35,                  /* "cgroupv2"  */
  YYSYMBOL_TPROXY = 36,                    /* "tproxy"  */
  YYSYMBOL_OSF = 37,                       /* "osf"  */
  YYSYMBOL_SYNPROXY = 38,                  /* "synproxy"  */
  YYSYMBOL_MSS = 39,                       /* "mss"  */
  YYSYMBOL_WSCALE = 40,                    /* "wscale"  */
  YYSYMBOL_TYPEOF = 41,                    /* "typeof"  */
  YYSYMBOL_HOOK = 42,                      /* "hook"  */
  YYSYMBOL_HOOKS = 43,                     /* "hooks"  */
  YYSYMBOL_DEVICE = 44,                    /* "device"  */
  YYSYMBOL_DEVICES = 45,                   /* "devices"  */
  YYSYMBOL_TABLE = 46,                     /* "table"  */
  YYSYMBOL_TABLES = 47,                    /* "tables"  */
  YYSYMBOL_CHAIN = 48,                     /* "chain"  */
  YYSYMBOL_CHAINS = 49,                    /* "chains"  */
  YYSYMBOL_RULE = 50,                      /* "rule"  */
  YYSYMBOL_RULES = 51,                     /* "rules"  */
  YYSYMBOL_SETS = 52,                      /* "sets"  */
  YYSYMBOL_SET = 53,                       /* "set"  */
  YYSYMBOL_ELEMENT = 54,                   /* "element"  */
  YYSYMBOL_MAP = 55,                       /* "map"  */
  YYSYMBOL_MAPS = 56,                      /* "maps"  */
  YYSYMBOL_FLOWTABLE = 57,                 /* "flowtable"  */
  YYSYMBOL_HANDLE = 58,                    /* "handle"  */
  YYSYMBOL_RULESET = 59,                   /* "ruleset"  */
  YYSYMBOL_TRACE = 60,                     /* "trace"  */
  YYSYMBOL_INET = 61,                      /* "inet"  */
  YYSYMBOL_NETDEV = 62,                    /* "netdev"  */
  YYSYMBOL_ADD = 63,                       /* "add"  */
  YYSYMBOL_UPDATE = 64,                    /* "update"  */
  YYSYMBOL_REPLACE = 65,                   /* "replace"  */
  YYSYMBOL_CREATE = 66,                    /* "create"  */
  YYSYMBOL_INSERT = 67,                    /* "insert"  */
  YYSYMBOL_DELETE = 68,                    /* "delete"  */
  YYSYMBOL_GET = 69,                       /* "get"  */
  YYSYMBOL_LIST = 70,                      /* "list"  */
  YYSYMBOL_RESET = 71,                     /* "reset"  */
  YYSYMBOL_FLUSH = 72,                     /* "flush"  */
  YYSYMBOL_RENAME = 73,                    /* "rename"  */
  YYSYMBOL_DESCRIBE = 74,                  /* "describe"  */
  YYSYMBOL_IMPORT = 75,                    /* "import"  */
  YYSYMBOL_EXPORT = 76,                    /* "export"  */
  YYSYMBOL_MONITOR = 77,                   /* "monitor"  */
  YYSYMBOL_ALL = 78,                       /* "all"  */
  YYSYMBOL_ACCEPT = 79,                    /* "accept"  */
  YYSYMBOL_DROP = 80,                      /* "drop"  */
  YYSYMBOL_CONTINUE = 81,                  /* "continue"  */
  YYSYMBOL_JUMP = 82,                      /* "jump"  */
  YYSYMBOL_GOTO = 83,                      /* "goto"  */
  YYSYMBOL_RETURN = 84,                    /* "return"  */
  YYSYMBOL_TO = 85,                        /* "to"  */
  YYSYMBOL_CONSTANT = 86,                  /* "constant"  */
  YYSYMBOL_INTERVAL = 87,                  /* "interval"  */
  YYSYMBOL_DYNAMIC = 88,                   /* "dynamic"  */
  YYSYMBOL_AUTOMERGE = 89,                 /* "auto-merge"  */
  YYSYMBOL_TIMEOUT = 90,                   /* "timeout"  */
  YYSYMBOL_GC_INTERVAL = 91,               /* "gc-interval"  */
  YYSYMBOL_ELEMENTS = 92,                  /* "elements"  */
  YYSYMBOL_EXPIRES = 93,                   /* "expires"  */
  YYSYMBOL_POLICY = 94,                    /* "policy"  */
  YYSYMBOL_MEMORY = 95,                    /* "memory"  */
  YYSYMBOL_PERFORMANCE = 96,               /* "performance"  */
  YYSYMBOL_SIZE = 97,                      /* "size"  */
  YYSYMBOL_FLOW = 98,                      /* "flow"  */
  YYSYMBOL_OFFLOAD = 99,                   /* "offload"  */
  YYSYMBOL_METER = 100,                    /* "meter"  */
  YYSYMBOL_METERS = 101,                   /* "meters"  */
  YYSYMBOL_FLOWTABLES = 102,               /* "flowtables"  */
  YYSYMBOL_NUM = 103,                      /* "number"  */
  YYSYMBOL_STRING = 104,                   /* "string"  */
  YYSYMBOL_QUOTED_STRING = 105,            /* "quoted string"  */
  YYSYMBOL_ASTERISK_STRING = 106,          /* "string with a trailing asterisk"  */
  YYSYMBOL_LL_HDR = 107,                   /* "ll"  */
  YYSYMBOL_NETWORK_HDR = 108,              /* "nh"  */
  YYSYMBOL_TRANSPORT_HDR = 109,            /* "th"  */
  YYSYMBOL_BRIDGE = 110,                   /* "bridge"  */
  YYSYMBOL_ETHER = 111,                    /* "ether"  */
  YYSYMBOL_SADDR = 112,                    /* "saddr"  */
  YYSYMBOL_DADDR = 113,                    /* "daddr"  */
  YYSYMBOL_TYPE = 114,                     /* "type"  */
  YYSYMBOL_VLAN = 115,                     /* "vlan"  */
  YYSYMBOL_ID = 116,                       /* "id"  */
  YYSYMBOL_CFI = 117,                      /* "cfi"  */
  YYSYMBOL_DEI = 118,                      /* "dei"  */
  YYSYMBOL_PCP = 119,                      /* "pcp"  */
  YYSYMBOL_ARP = 120,                      /* "arp"  */
  YYSYMBOL_HTYPE = 121,                    /* "htype"  */
  YYSYMBOL_PTYPE = 122,                    /* "ptype"  */
  YYSYMBOL_HLEN = 123,                     /* "hlen"  */
  YYSYMBOL_PLEN = 124,                     /* "plen"  */
  YYSYMBOL_OPERATION = 125,                /* "operation"  */
  YYSYMBOL_IP = 126,                       /* "ip"  */
  YYSYMBOL_HDRVERSION = 127,               /* "version"  */
  YYSYMBOL_HDRLENGTH = 128,                /* "hdrlength"  */
  YYSYMBOL_DSCP = 129,                     /* "dscp"  */
  YYSYMBOL_ECN = 130,                      /* "ecn"  */
  YYSYMBOL_LENGTH = 131,                   /* "length"  */
  YYSYMBOL_FRAG_OFF = 132,                 /* "frag-off"  */
  YYSYMBOL_TTL = 133,                      /* "ttl"  */
  YYSYMBOL_PROTOCOL = 134,                 /* "protocol"  */
  YYSYMBOL_CHECKSUM = 135,                 /* "checksum"  */
  YYSYMBOL_PTR = 136,                      /* "ptr"  */
  YYSYMBOL_VALUE = 137,                    /* "value"  */
  YYSYMBOL_LSRR = 138,                     /* "lsrr"  */
  YYSYMBOL_RR = 139,                       /* "rr"  */
  YYSYMBOL_SSRR = 140,                     /* "ssrr"  */
  YYSYMBOL_RA = 141,                       /* "ra"  */
  YYSYMBOL_ICMP = 142,                     /* "icmp"  */
  YYSYMBOL_CODE = 143,                     /* "code"  */
  YYSYMBOL_SEQUENCE = 144,                 /* "seq"  */
  YYSYMBOL_GATEWAY = 145,                  /* "gateway"  */
  YYSYMBOL_MTU = 146,                      /* "mtu"  */
  YYSYMBOL_IGMP = 147,                     /* "igmp"  */
  YYSYMBOL_MRT = 148,                      /* "mrt"  */
  YYSYMBOL_OPTIONS = 149,                  /* "options"  */
  YYSYMBOL_IP6 = 150,                      /* "ip6"  */
  YYSYMBOL_PRIORITY = 151,                 /* "priority"  */
  YYSYMBOL_FLOWLABEL = 152,                /* "flowlabel"  */
  YYSYMBOL_NEXTHDR = 153,                  /* "nexthdr"  */
  YYSYMBOL_HOPLIMIT = 154,                 /* "hoplimit"  */
  YYSYMBOL_ICMP6 = 155,                    /* "icmpv6"  */
  YYSYMBOL_PPTR = 156,                     /* "param-problem"  */
  YYSYMBOL_MAXDELAY = 157,                 /* "max-delay"  */
  YYSYMBOL_AH = 158,                       /* "ah"  */
  YYSYMBOL_RESERVED = 159,                 /* "reserved"  */
  YYSYMBOL_SPI = 160,                      /* "spi"  */
  YYSYMBOL_ESP = 161,                      /* "esp"  */
  YYSYMBOL_COMP = 162,                     /* "comp"  */
  YYSYMBOL_FLAGS = 163,                    /* "flags"  */
  YYSYMBOL_CPI = 164,                      /* "cpi"  */
  YYSYMBOL_PORT = 165,                     /* "port"  */
  YYSYMBOL_UDP = 166,                      /* "udp"  */
  YYSYMBOL_SPORT = 167,                    /* "sport"  */
  YYSYMBOL_DPORT = 168,                    /* "dport"  */
  YYSYMBOL_UDPLITE = 169,                  /* "udplite"  */
  YYSYMBOL_CSUMCOV = 170,                  /* "csumcov"  */
  YYSYMBOL_TCP = 171,                      /* "tcp"  */
  YYSYMBOL_ACKSEQ = 172,                   /* "ackseq"  */
  YYSYMBOL_DOFF = 173,                     /* "doff"  */
  YYSYMBOL_WINDOW = 174,                   /* "window"  */
  YYSYMBOL_URGPTR = 175,                   /* "urgptr"  */
  YYSYMBOL_OPTION = 176,                   /* "option"  */
  YYSYMBOL_ECHO = 177,                     /* "echo"  */
  YYSYMBOL_EOL = 178,                      /* "eol"  */
  YYSYMBOL_MPTCP = 179,                    /* "mptcp"  */
  YYSYMBOL_NOP = 180,                      /* "nop"  */
  YYSYMBOL_SACK = 181,                     /* "sack"  */
  YYSYMBOL_SACK0 = 182,                    /* "sack0"  */
  YYSYMBOL_SACK1 = 183,                    /* "sack1"  */
  YYSYMBOL_SACK2 = 184,                    /* "sack2"  */
  YYSYMBOL_SACK3 = 185,                    /* "sack3"  */
  YYSYMBOL_SACK_PERM = 186,                /* "sack-permitted"  */
  YYSYMBOL_FASTOPEN = 187,                 /* "fastopen"  */
  YYSYMBOL_MD5SIG = 188,                   /* "md5sig"  */
  YYSYMBOL_TIMESTAMP = 189,                /* "timestamp"  */
  YYSYMBOL_COUNT = 190,                    /* "count"  */
  YYSYMBOL_LEFT = 191,                     /* "left"  */
  YYSYMBOL_RIGHT = 192,                    /* "right"  */
  YYSYMBOL_TSVAL = 193,                    /* "tsval"  */
  YYSYMBOL_TSECR = 194,                    /* "tsecr"  */
  YYSYMBOL_SUBTYPE = 195,                  /* "subtype"  */
  YYSYMBOL_DCCP = 196,                     /* "dccp"  */
  YYSYMBOL_SCTP = 197,                     /* "sctp"  */
  YYSYMBOL_CHUNK = 198,                    /* "chunk"  */
  YYSYMBOL_DATA = 199,                     /* "data"  */
  YYSYMBOL_INIT = 200,                     /* "init"  */
  YYSYMBOL_INIT_ACK = 201,                 /* "init-ack"  */
  YYSYMBOL_HEARTBEAT = 202,                /* "heartbeat"  */
  YYSYMBOL_HEARTBEAT_ACK = 203,            /* "heartbeat-ack"  */
  YYSYMBOL_ABORT = 204,                    /* "abort"  */
  YYSYMBOL_SHUTDOWN = 205,                 /* "shutdown"  */
  YYSYMBOL_SHUTDOWN_ACK = 206,             /* "shutdown-ack"  */
  YYSYMBOL_ERROR = 207,                    /* "error"  */
  YYSYMBOL_COOKIE_ECHO = 208,              /* "cookie-echo"  */
  YYSYMBOL_COOKIE_ACK = 209,               /* "cookie-ack"  */
  YYSYMBOL_ECNE = 210,                     /* "ecne"  */
  YYSYMBOL_CWR = 211,                      /* "cwr"  */
  YYSYMBOL_SHUTDOWN_COMPLETE = 212,        /* "shutdown-complete"  */
  YYSYMBOL_ASCONF_ACK = 213,               /* "asconf-ack"  */
  YYSYMBOL_FORWARD_TSN = 214,              /* "forward-tsn"  */
  YYSYMBOL_ASCONF = 215,                   /* "asconf"  */
  YYSYMBOL_TSN = 216,                      /* "tsn"  */
  YYSYMBOL_STREAM = 217,                   /* "stream"  */
  YYSYMBOL_SSN = 218,                      /* "ssn"  */
  YYSYMBOL_PPID = 219,                     /* "ppid"  */
  YYSYMBOL_INIT_TAG = 220,                 /* "init-tag"  */
  YYSYMBOL_A_RWND = 221,                   /* "a-rwnd"  */
  YYSYMBOL_NUM_OSTREAMS = 222,             /* "num-outbound-streams"  */
  YYSYMBOL_NUM_ISTREAMS = 223,             /* "num-inbound-streams"  */
  YYSYMBOL_INIT_TSN = 224,                 /* "initial-tsn"  */
  YYSYMBOL_CUM_TSN_ACK = 225,              /* "cum-tsn-ack"  */
  YYSYMBOL_NUM_GACK_BLOCKS = 226,          /* "num-gap-ack-blocks"  */
  YYSYMBOL_NUM_DUP_TSNS = 227,             /* "num-dup-tsns"  */
  YYSYMBOL_LOWEST_TSN = 228,               /* "lowest-tsn"  */
  YYSYMBOL_SEQNO = 229,                    /* "seqno"  */
  YYSYMBOL_NEW_CUM_TSN = 230,              /* "new-cum-tsn"  */
  YYSYMBOL_VTAG = 231,                     /* "vtag"  */
  YYSYMBOL_RT = 232,                       /* "rt"  */
  YYSYMBOL_RT0 = 233,                      /* "rt0"  */
  YYSYMBOL_RT2 = 234,                      /* "rt2"  */
  YYSYMBOL_RT4 = 235,                      /* "srh"  */
  YYSYMBOL_SEG_LEFT = 236,                 /* "seg-left"  */
  YYSYMBOL_ADDR = 237,                     /* "addr"  */
  YYSYMBOL_LAST_ENT = 238,                 /* "last-entry"  */
  YYSYMBOL_TAG = 239,                      /* "tag"  */
  YYSYMBOL_SID = 240,                      /* "sid"  */
  YYSYMBOL_HBH = 241,                      /* "hbh"  */
  YYSYMBOL_FRAG = 242,                     /* "frag"  */
  YYSYMBOL_RESERVED2 = 243,                /* "reserved2"  */
  YYSYMBOL_MORE_FRAGMENTS = 244,           /* "more-fragments"  */
  YYSYMBOL_DST = 245,                      /* "dst"  */
  YYSYMBOL_MH = 246,                       /* "mh"  */
  YYSYMBOL_META = 247,                     /* "meta"  */
  YYSYMBOL_MARK = 248,                     /* "mark"  */
  YYSYMBOL_IIF = 249,                      /* "iif"  */
  YYSYMBOL_IIFNAME = 250,                  /* "iifname"  */
  YYSYMBOL_IIFTYPE = 251,                  /* "iiftype"  */
  YYSYMBOL_OIF = 252,                      /* "oif"  */
  YYSYMBOL_OIFNAME = 253,                  /* "oifname"  */
  YYSYMBOL_OIFTYPE = 254,                  /* "oiftype"  */
  YYSYMBOL_SKUID = 255,                    /* "skuid"  */
  YYSYMBOL_SKGID = 256,                    /* "skgid"  */
  YYSYMBOL_NFTRACE = 257,                  /* "nftrace"  */
  YYSYMBOL_RTCLASSID = 258,                /* "rtclassid"  */
  YYSYMBOL_IBRIPORT = 259,                 /* "ibriport"  */
  YYSYMBOL_OBRIPORT = 260,                 /* "obriport"  */
  YYSYMBOL_IBRIDGENAME = 261,              /* "ibrname"  */
  YYSYMBOL_OBRIDGENAME = 262,              /* "obrname"  */
  YYSYMBOL_PKTTYPE = 263,                  /* "pkttype"  */
  YYSYMBOL_CPU = 264,                      /* "cpu"  */
  YYSYMBOL_IIFGROUP = 265,                 /* "iifgroup"  */
  YYSYMBOL_OIFGROUP = 266,                 /* "oifgroup"  */
  YYSYMBOL_CGROUP = 267,                   /* "cgroup"  */
  YYSYMBOL_TIME = 268,                     /* "time"  */
  YYSYMBOL_CLASSID = 269,                  /* "classid"  */
  YYSYMBOL_NEXTHOP = 270,                  /* "nexthop"  */
  YYSYMBOL_CT = 271,                       /* "ct"  */
  YYSYMBOL_L3PROTOCOL = 272,               /* "l3proto"  */
  YYSYMBOL_PROTO_SRC = 273,                /* "proto-src"  */
  YYSYMBOL_PROTO_DST = 274,                /* "proto-dst"  */
  YYSYMBOL_ZONE = 275,                     /* "zone"  */
  YYSYMBOL_DIRECTION = 276,                /* "direction"  */
  YYSYMBOL_EVENT = 277,                    /* "event"  */
  YYSYMBOL_EXPECTATION = 278,              /* "expectation"  */
  YYSYMBOL_EXPIRATION = 279,               /* "expiration"  */
  YYSYMBOL_HELPER = 280,                   /* "helper"  */
  YYSYMBOL_LABEL = 281,                    /* "label"  */
  YYSYMBOL_STATE = 282,                    /* "state"  */
  YYSYMBOL_STATUS = 283,                   /* "status"  */
  YYSYMBOL_ORIGINAL = 284,                 /* "original"  */
  YYSYMBOL_REPLY = 285,                    /* "reply"  */
  YYSYMBOL_COUNTER = 286,                  /* "counter"  */
  YYSYMBOL_NAME = 287,                     /* "name"  */
  YYSYMBOL_PACKETS = 288,                  /* "packets"  */
  YYSYMBOL_BYTES = 289,                    /* "bytes"  */
  YYSYMBOL_AVGPKT = 290,                   /* "avgpkt"  */
  YYSYMBOL_COUNTERS = 291,                 /* "counters"  */
  YYSYMBOL_QUOTAS = 292,                   /* "quotas"  */
  YYSYMBOL_LIMITS = 293,                   /* "limits"  */
  YYSYMBOL_SYNPROXYS = 294,                /* "synproxys"  */
  YYSYMBOL_HELPERS = 295,                  /* "helpers"  */
  YYSYMBOL_LOG = 296,                      /* "log"  */
  YYSYMBOL_PREFIX = 297,                   /* "prefix"  */
  YYSYMBOL_GROUP = 298,                    /* "group"  */
  YYSYMBOL_SNAPLEN = 299,                  /* "snaplen"  */
  YYSYMBOL_QUEUE_THRESHOLD = 300,          /* "queue-threshold"  */
  YYSYMBOL_LEVEL = 301,                    /* "level"  */
  YYSYMBOL_LIMIT = 302,                    /* "limit"  */
  YYSYMBOL_RATE = 303,                     /* "rate"  */
  YYSYMBOL_BURST = 304,                    /* "burst"  */
  YYSYMBOL_OVER = 305,                     /* "over"  */
  YYSYMBOL_UNTIL = 306,                    /* "until"  */
  YYSYMBOL_QUOTA = 307,                    /* "quota"  */
  YYSYMBOL_USED = 308,                     /* "used"  */
  YYSYMBOL_SECMARK = 309,                  /* "secmark"  */
  YYSYMBOL_SECMARKS = 310,                 /* "secmarks"  */
  YYSYMBOL_SECOND = 311,                   /* "second"  */
  YYSYMBOL_MINUTE = 312,                   /* "minute"  */
  YYSYMBOL_HOUR = 313,                     /* "hour"  */
  YYSYMBOL_DAY = 314,                      /* "day"  */
  YYSYMBOL_WEEK = 315,                     /* "week"  */
  YYSYMBOL__REJECT = 316,                  /* "reject"  */
  YYSYMBOL_WITH = 317,                     /* "with"  */
  YYSYMBOL_ICMPX = 318,                    /* "icmpx"  */
  YYSYMBOL_SNAT = 319,                     /* "snat"  */
  YYSYMBOL_DNAT = 320,                     /* "dnat"  */
  YYSYMBOL_MASQUERADE = 321,               /* "masquerade"  */
  YYSYMBOL_REDIRECT = 322,                 /* "redirect"  */
  YYSYMBOL_RANDOM = 323,                   /* "random"  */
  YYSYMBOL_FULLY_RANDOM = 324,             /* "fully-random"  */
  YYSYMBOL_PERSISTENT = 325,               /* "persistent"  */
  YYSYMBOL_QUEUE = 326,                    /* "queue"  */
  YYSYMBOL_QUEUENUM = 327,                 /* "num"  */
  YYSYMBOL_BYPASS = 328,                   /* "bypass"  */
  YYSYMBOL_FANOUT = 329,                   /* "fanout"  */
  YYSYMBOL_DUP = 330,                      /* "dup"  */
  YYSYMBOL_FWD = 331,                      /* "fwd"  */
  YYSYMBOL_NUMGEN = 332,                   /* "numgen"  */
  YYSYMBOL_INC = 333,                      /* "inc"  */
  YYSYMBOL_MOD = 334,                      /* "mod"  */
  YYSYMBOL_OFFSET = 335,                   /* "offset"  */
  YYSYMBOL_JHASH = 336,                    /* "jhash"  */
  YYSYMBOL_SYMHASH = 337,                  /* "symhash"  */
  YYSYMBOL_SEED = 338,                     /* "seed"  */
  YYSYMBOL_POSITION = 339,                 /* "position"  */
  YYSYMBOL_INDEX = 340,                    /* "index"  */
  YYSYMBOL_COMMENT = 341,                  /* "comment"  */
  YYSYMBOL_XML = 342,                      /* "xml"  */
  YYSYMBOL_JSON = 343,                     /* "json"  */
  YYSYMBOL_VM = 344,                       /* "vm"  */
  YYSYMBOL_NOTRACK = 345,                  /* "notrack"  */
  YYSYMBOL_EXISTS = 346,                   /* "exists"  */
  YYSYMBOL_MISSING = 347,                  /* "missing"  */
  YYSYMBOL_EXTHDR = 348,                   /* "exthdr"  */
  YYSYMBOL_IPSEC = 349,                    /* "ipsec"  */
  YYSYMBOL_REQID = 350,                    /* "reqid"  */
  YYSYMBOL_SPNUM = 351,                    /* "spnum"  */
  YYSYMBOL_IN = 352,                       /* "in"  */
  YYSYMBOL_OUT = 353,                      /* "out"  */
  YYSYMBOL_XT = 354,                       /* "xt"  */
  YYSYMBOL_355_ = 355,                     /* '='  */
  YYSYMBOL_356_ = 356,                     /* '{'  */
  YYSYMBOL_357_ = 357,                     /* '}'  */
  YYSYMBOL_358_ = 358,                     /* '('  */
  YYSYMBOL_359_ = 359,                     /* ')'  */
  YYSYMBOL_360_ = 360,                     /* '|'  */
  YYSYMBOL_361_ = 361,                     /* '$'  */
  YYSYMBOL_362_ = 362,                     /* '['  */
  YYSYMBOL_363_ = 363,                     /* ']'  */
  YYSYMBOL_YYACCEPT = 364,                 /* $accept  */
  YYSYMBOL_input = 365,                    /* input  */
  YYSYMBOL_stmt_separator = 366,           /* stmt_separator  */
  YYSYMBOL_opt_newline = 367,              /* opt_newline  */
  YYSYMBOL_close_scope_ah = 368,           /* close_scope_ah  */
  YYSYMBOL_close_scope_arp = 369,          /* close_scope_arp  */
  YYSYMBOL_close_scope_at = 370,           /* close_scope_at  */
  YYSYMBOL_close_scope_comp = 371,         /* close_scope_comp  */
  YYSYMBOL_close_scope_ct = 372,           /* close_scope_ct  */
  YYSYMBOL_close_scope_counter = 373,      /* close_scope_counter  */
  YYSYMBOL_close_scope_dccp = 374,         /* close_scope_dccp  */
  YYSYMBOL_close_scope_dst = 375,          /* close_scope_dst  */
  YYSYMBOL_close_scope_dup = 376,          /* close_scope_dup  */
  YYSYMBOL_close_scope_esp = 377,          /* close_scope_esp  */
  YYSYMBOL_close_scope_eth = 378,          /* close_scope_eth  */
  YYSYMBOL_close_scope_export = 379,       /* close_scope_export  */
  YYSYMBOL_close_scope_fib = 380,          /* close_scope_fib  */
  YYSYMBOL_close_scope_frag = 381,         /* close_scope_frag  */
  YYSYMBOL_close_scope_fwd = 382,          /* close_scope_fwd  */
  YYSYMBOL_close_scope_hash = 383,         /* close_scope_hash  */
  YYSYMBOL_close_scope_hbh = 384,          /* close_scope_hbh  */
  YYSYMBOL_close_scope_ip = 385,           /* close_scope_ip  */
  YYSYMBOL_close_scope_ip6 = 386,          /* close_scope_ip6  */
  YYSYMBOL_close_scope_vlan = 387,         /* close_scope_vlan  */
  YYSYMBOL_close_scope_icmp = 388,         /* close_scope_icmp  */
  YYSYMBOL_close_scope_igmp = 389,         /* close_scope_igmp  */
  YYSYMBOL_close_scope_import = 390,       /* close_scope_import  */
  YYSYMBOL_close_scope_ipsec = 391,        /* close_scope_ipsec  */
  YYSYMBOL_close_scope_list = 392,         /* close_scope_list  */
  YYSYMBOL_close_scope_limit = 393,        /* close_scope_limit  */
  YYSYMBOL_close_scope_meta = 394,         /* close_scope_meta  */
  YYSYMBOL_close_scope_mh = 395,           /* close_scope_mh  */
  YYSYMBOL_close_scope_monitor = 396,      /* close_scope_monitor  */
  YYSYMBOL_close_scope_nat = 397,          /* close_scope_nat  */
  YYSYMBOL_close_scope_numgen = 398,       /* close_scope_numgen  */
  YYSYMBOL_close_scope_osf = 399,          /* close_scope_osf  */
  YYSYMBOL_close_scope_policy = 400,       /* close_scope_policy  */
  YYSYMBOL_close_scope_quota = 401,        /* close_scope_quota  */
  YYSYMBOL_close_scope_queue = 402,        /* close_scope_queue  */
  YYSYMBOL_close_scope_reject = 403,       /* close_scope_reject  */
  YYSYMBOL_close_scope_reset = 404,        /* close_scope_reset  */
  YYSYMBOL_close_scope_rt = 405,           /* close_scope_rt  */
  YYSYMBOL_close_scope_sctp = 406,         /* close_scope_sctp  */
  YYSYMBOL_close_scope_sctp_chunk = 407,   /* close_scope_sctp_chunk  */
  YYSYMBOL_close_scope_secmark = 408,      /* close_scope_secmark  */
  YYSYMBOL_close_scope_socket = 409,       /* close_scope_socket  */
  YYSYMBOL_close_scope_tcp = 410,          /* close_scope_tcp  */
  YYSYMBOL_close_scope_tproxy = 411,       /* close_scope_tproxy  */
  YYSYMBOL_close_scope_type = 412,         /* close_scope_type  */
  YYSYMBOL_close_scope_th = 413,           /* close_scope_th  */
  YYSYMBOL_close_scope_udp = 414,          /* close_scope_udp  */
  YYSYMBOL_close_scope_udplite = 415,      /* close_scope_udplite  */
  YYSYMBOL_close_scope_log = 416,          /* close_scope_log  */
  YYSYMBOL_close_scope_synproxy = 417,     /* close_scope_synproxy  */
  YYSYMBOL_close_scope_xt = 418,           /* close_scope_xt  */
  YYSYMBOL_common_block = 419,             /* common_block  */
  YYSYMBOL_line = 420,                     /* line  */
  YYSYMBOL_base_cmd = 421,                 /* base_cmd  */
  YYSYMBOL_add_cmd = 422,                  /* add_cmd  */
  YYSYMBOL_replace_cmd = 423,              /* replace_cmd  */
  YYSYMBOL_create_cmd = 424,               /* create_cmd  */
  YYSYMBOL_insert_cmd = 425,               /* insert_cmd  */
  YYSYMBOL_table_or_id_spec = 426,         /* table_or_id_spec  */
  YYSYMBOL_chain_or_id_spec = 427,         /* chain_or_id_spec  */
  YYSYMBOL_set_or_id_spec = 428,           /* set_or_id_spec  */
  YYSYMBOL_obj_or_id_spec = 429,           /* obj_or_id_spec  */
  YYSYMBOL_delete_cmd = 430,               /* delete_cmd  */
  YYSYMBOL_get_cmd = 431,                  /* get_cmd  */
  YYSYMBOL_list_cmd = 432,                 /* list_cmd  */
  YYSYMBOL_basehook_device_name = 433,     /* basehook_device_name  */
  YYSYMBOL_basehook_spec = 434,            /* basehook_spec  */
  YYSYMBOL_reset_cmd = 435,                /* reset_cmd  */
  YYSYMBOL_flush_cmd = 436,                /* flush_cmd  */
  YYSYMBOL_rename_cmd = 437,               /* rename_cmd  */
  YYSYMBOL_import_cmd = 438,               /* import_cmd  */
  YYSYMBOL_export_cmd = 439,               /* export_cmd  */
  YYSYMBOL_monitor_cmd = 440,              /* monitor_cmd  */
  YYSYMBOL_monitor_event = 441,            /* monitor_event  */
  YYSYMBOL_monitor_object = 442,           /* monitor_object  */
  YYSYMBOL_monitor_format = 443,           /* monitor_format  */
  YYSYMBOL_markup_format = 444,            /* markup_format  */
  YYSYMBOL_describe_cmd = 445,             /* describe_cmd  */
  YYSYMBOL_table_block_alloc = 446,        /* table_block_alloc  */
  YYSYMBOL_table_options = 447,            /* table_options  */
  YYSYMBOL_table_block = 448,              /* table_block  */
  YYSYMBOL_chain_block_alloc = 449,        /* chain_block_alloc  */
  YYSYMBOL_chain_block = 450,              /* chain_block  */
  YYSYMBOL_subchain_block = 451,           /* subchain_block  */
  YYSYMBOL_typeof_verdict_expr = 452,      /* typeof_verdict_expr  */
  YYSYMBOL_typeof_data_expr = 453,         /* typeof_data_expr  */
  YYSYMBOL_primary_typeof_expr = 454,      /* primary_typeof_expr  */
  YYSYMBOL_typeof_expr = 455,              /* typeof_expr  */
  YYSYMBOL_set_block_alloc = 456,          /* set_block_alloc  */
  YYSYMBOL_typeof_key_expr = 457,          /* typeof_key_expr  */
  YYSYMBOL_set_block = 458,                /* set_block  */
  YYSYMBOL_set_block_expr = 459,           /* set_block_expr  */
  YYSYMBOL_set_flag_list = 460,            /* set_flag_list  */
  YYSYMBOL_set_flag = 461,                 /* set_flag  */
  YYSYMBOL_map_block_alloc = 462,          /* map_block_alloc  */
  YYSYMBOL_ct_obj_type_map = 463,          /* ct_obj_type_map  */
  YYSYMBOL_map_block_obj_type = 464,       /* map_block_obj_type  */
  YYSYMBOL_map_block_obj_typeof = 465,     /* map_block_obj_typeof  */
  YYSYMBOL_map_block_data_interval = 466,  /* map_block_data_interval  */
  YYSYMBOL_map_block = 467,                /* map_block  */
  YYSYMBOL_set_mechanism = 468,            /* set_mechanism  */
  YYSYMBOL_set_policy_spec = 469,          /* set_policy_spec  */
  YYSYMBOL_flowtable_block_alloc = 470,    /* flowtable_block_alloc  */
  YYSYMBOL_flowtable_block = 471,          /* flowtable_block  */
  YYSYMBOL_flowtable_expr = 472,           /* flowtable_expr  */
  YYSYMBOL_flowtable_list_expr = 473,      /* flowtable_list_expr  */
  YYSYMBOL_flowtable_expr_member = 474,    /* flowtable_expr_member  */
  YYSYMBOL_data_type_atom_expr = 475,      /* data_type_atom_expr  */
  YYSYMBOL_data_type_expr = 476,           /* data_type_expr  */
  YYSYMBOL_obj_block_alloc = 477,          /* obj_block_alloc  */
  YYSYMBOL_counter_block = 478,            /* counter_block  */
  YYSYMBOL_quota_block = 479,              /* quota_block  */
  YYSYMBOL_ct_helper_block = 480,          /* ct_helper_block  */
  YYSYMBOL_ct_timeout_block = 481,         /* ct_timeout_block  */
  YYSYMBOL_ct_expect_block = 482,          /* ct_expect_block  */
  YYSYMBOL_limit_block = 483,              /* limit_block  */
  YYSYMBOL_secmark_block = 484,            /* secmark_block  */
  YYSYMBOL_synproxy_block = 485,           /* synproxy_block  */
  YYSYMBOL_type_identifier = 486,          /* type_identifier  */
  YYSYMBOL_hook_spec = 487,                /* hook_spec  */
  YYSYMBOL_prio_spec = 488,                /* prio_spec  */
  YYSYMBOL_extended_prio_name = 489,       /* extended_prio_name  */
  YYSYMBOL_extended_prio_spec = 490,       /* extended_prio_spec  */
  YYSYMBOL_int_num = 491,                  /* int_num  */
  YYSYMBOL_dev_spec = 492,                 /* dev_spec  */
  YYSYMBOL_flags_spec = 493,               /* flags_spec  */
  YYSYMBOL_policy_spec = 494,              /* policy_spec  */
  YYSYMBOL_policy_expr = 495,              /* policy_expr  */
  YYSYMBOL_chain_policy = 496,             /* chain_policy  */
  YYSYMBOL_identifier = 497,               /* identifier  */
  YYSYMBOL_string = 498,                   /* string  */
  YYSYMBOL_time_spec = 499,                /* time_spec  */
  YYSYMBOL_time_spec_or_num_s = 500,       /* time_spec_or_num_s  */
  YYSYMBOL_family_spec = 501,              /* family_spec  */
  YYSYMBOL_family_spec_explicit = 502,     /* family_spec_explicit  */
  YYSYMBOL_table_spec = 503,               /* table_spec  */
  YYSYMBOL_tableid_spec = 504,             /* tableid_spec  */
  YYSYMBOL_chain_spec = 505,               /* chain_spec  */
  YYSYMBOL_chainid_spec = 506,             /* chainid_spec  */
  YYSYMBOL_chain_identifier = 507,         /* chain_identifier  */
  YYSYMBOL_set_spec = 508,                 /* set_spec  */
  YYSYMBOL_setid_spec = 509,               /* setid_spec  */
  YYSYMBOL_set_identifier = 510,           /* set_identifier  */
  YYSYMBOL_flowtable_spec = 511,           /* flowtable_spec  */
  YYSYMBOL_flowtableid_spec = 512,         /* flowtableid_spec  */
  YYSYMBOL_flowtable_identifier = 513,     /* flowtable_identifier  */
  YYSYMBOL_obj_spec = 514,                 /* obj_spec  */
  YYSYMBOL_objid_spec = 515,               /* objid_spec  */
  YYSYMBOL_obj_identifier = 516,           /* obj_identifier  */
  YYSYMBOL_handle_spec = 517,              /* handle_spec  */
  YYSYMBOL_position_spec = 518,            /* position_spec  */
  YYSYMBOL_index_spec = 519,               /* index_spec  */
  YYSYMBOL_rule_position = 520,            /* rule_position  */
  YYSYMBOL_ruleid_spec = 521,              /* ruleid_spec  */
  YYSYMBOL_comment_spec = 522,             /* comment_spec  */
  YYSYMBOL_ruleset_spec = 523,             /* ruleset_spec  */
  YYSYMBOL_rule = 524,                     /* rule  */
  YYSYMBOL_rule_alloc = 525,               /* rule_alloc  */
  YYSYMBOL_stmt_list = 526,                /* stmt_list  */
  YYSYMBOL_stateful_stmt_list = 527,       /* stateful_stmt_list  */
  YYSYMBOL_objref_stmt_counter = 528,      /* objref_stmt_counter  */
  YYSYMBOL_objref_stmt_limit = 529,        /* objref_stmt_limit  */
  YYSYMBOL_objref_stmt_quota = 530,        /* objref_stmt_quota  */
  YYSYMBOL_objref_stmt_synproxy = 531,     /* objref_stmt_synproxy  */
  YYSYMBOL_objref_stmt_ct = 532,           /* objref_stmt_ct  */
  YYSYMBOL_objref_stmt = 533,              /* objref_stmt  */
  YYSYMBOL_stateful_stmt = 534,            /* stateful_stmt  */
  YYSYMBOL_stmt = 535,                     /* stmt  */
  YYSYMBOL_xt_stmt = 536,                  /* xt_stmt  */
  YYSYMBOL_chain_stmt_type = 537,          /* chain_stmt_type  */
  YYSYMBOL_chain_stmt = 538,               /* chain_stmt  */
  YYSYMBOL_verdict_stmt = 539,             /* verdict_stmt  */
  YYSYMBOL_verdict_map_stmt = 540,         /* verdict_map_stmt  */
  YYSYMBOL_verdict_map_expr = 541,         /* verdict_map_expr  */
  YYSYMBOL_verdict_map_list_expr = 542,    /* verdict_map_list_expr  */
  YYSYMBOL_verdict_map_list_member_expr = 543, /* verdict_map_list_member_expr  */
  YYSYMBOL_connlimit_stmt = 544,           /* connlimit_stmt  */
  YYSYMBOL_counter_stmt = 545,             /* counter_stmt  */
  YYSYMBOL_counter_stmt_alloc = 546,       /* counter_stmt_alloc  */
  YYSYMBOL_counter_args = 547,             /* counter_args  */
  YYSYMBOL_counter_arg = 548,              /* counter_arg  */
  YYSYMBOL_log_stmt = 549,                 /* log_stmt  */
  YYSYMBOL_log_stmt_alloc = 550,           /* log_stmt_alloc  */
  YYSYMBOL_log_args = 551,                 /* log_args  */
  YYSYMBOL_log_arg = 552,                  /* log_arg  */
  YYSYMBOL_level_type = 553,               /* level_type  */
  YYSYMBOL_log_flags = 554,                /* log_flags  */
  YYSYMBOL_log_flags_tcp = 555,            /* log_flags_tcp  */
  YYSYMBOL_log_flag_tcp = 556,             /* log_flag_tcp  */
  YYSYMBOL_limit_stmt = 557,               /* limit_stmt  */
  YYSYMBOL_quota_mode = 558,               /* quota_mode  */
  YYSYMBOL_quota_unit = 559,               /* quota_unit  */
  YYSYMBOL_quota_used = 560,               /* quota_used  */
  YYSYMBOL_quota_stmt = 561,               /* quota_stmt  */
  YYSYMBOL_limit_mode = 562,               /* limit_mode  */
  YYSYMBOL_limit_burst_pkts = 563,         /* limit_burst_pkts  */
  YYSYMBOL_limit_rate_pkts = 564,          /* limit_rate_pkts  */
  YYSYMBOL_limit_burst_bytes = 565,        /* limit_burst_bytes  */
  YYSYMBOL_limit_rate_bytes = 566,         /* limit_rate_bytes  */
  YYSYMBOL_limit_bytes = 567,              /* limit_bytes  */
  YYSYMBOL_time_unit = 568,                /* time_unit  */
  YYSYMBOL_reject_stmt = 569,              /* reject_stmt  */
  YYSYMBOL_reject_stmt_alloc = 570,        /* reject_stmt_alloc  */
  YYSYMBOL_reject_with_expr = 571,         /* reject_with_expr  */
  YYSYMBOL_reject_opts = 572,              /* reject_opts  */
  YYSYMBOL_nat_stmt = 573,                 /* nat_stmt  */
  YYSYMBOL_nat_stmt_alloc = 574,           /* nat_stmt_alloc  */
  YYSYMBOL_tproxy_stmt = 575,              /* tproxy_stmt  */
  YYSYMBOL_synproxy_stmt = 576,            /* synproxy_stmt  */
  YYSYMBOL_synproxy_stmt_alloc = 577,      /* synproxy_stmt_alloc  */
  YYSYMBOL_synproxy_args = 578,            /* synproxy_args  */
  YYSYMBOL_synproxy_arg = 579,             /* synproxy_arg  */
  YYSYMBOL_synproxy_config = 580,          /* synproxy_config  */
  YYSYMBOL_synproxy_obj = 581,             /* synproxy_obj  */
  YYSYMBOL_synproxy_ts = 582,              /* synproxy_ts  */
  YYSYMBOL_synproxy_sack = 583,            /* synproxy_sack  */
  YYSYMBOL_primary_stmt_expr = 584,        /* primary_stmt_expr  */
  YYSYMBOL_shift_stmt_expr = 585,          /* shift_stmt_expr  */
  YYSYMBOL_and_stmt_expr = 586,            /* and_stmt_expr  */
  YYSYMBOL_exclusive_or_stmt_expr = 587,   /* exclusive_or_stmt_expr  */
  YYSYMBOL_inclusive_or_stmt_expr = 588,   /* inclusive_or_stmt_expr  */
  YYSYMBOL_basic_stmt_expr = 589,          /* basic_stmt_expr  */
  YYSYMBOL_concat_stmt_expr = 590,         /* concat_stmt_expr  */
  YYSYMBOL_map_stmt_expr_set = 591,        /* map_stmt_expr_set  */
  YYSYMBOL_map_stmt_expr = 592,            /* map_stmt_expr  */
  YYSYMBOL_prefix_stmt_expr = 593,         /* prefix_stmt_expr  */
  YYSYMBOL_range_stmt_expr = 594,          /* range_stmt_expr  */
  YYSYMBOL_multiton_stmt_expr = 595,       /* multiton_stmt_expr  */
  YYSYMBOL_stmt_expr = 596,                /* stmt_expr  */
  YYSYMBOL_nat_stmt_args = 597,            /* nat_stmt_args  */
  YYSYMBOL_masq_stmt = 598,                /* masq_stmt  */
  YYSYMBOL_masq_stmt_alloc = 599,          /* masq_stmt_alloc  */
  YYSYMBOL_masq_stmt_args = 600,           /* masq_stmt_args  */
  YYSYMBOL_redir_stmt = 601,               /* redir_stmt  */
  YYSYMBOL_redir_stmt_alloc = 602,         /* redir_stmt_alloc  */
  YYSYMBOL_redir_stmt_arg = 603,           /* redir_stmt_arg  */
  YYSYMBOL_dup_stmt = 604,                 /* dup_stmt  */
  YYSYMBOL_fwd_stmt = 605,                 /* fwd_stmt  */
  YYSYMBOL_nf_nat_flags = 606,             /* nf_nat_flags  */
  YYSYMBOL_nf_nat_flag = 607,              /* nf_nat_flag  */
  YYSYMBOL_queue_stmt = 608,               /* queue_stmt  */
  YYSYMBOL_queue_stmt_compat = 609,        /* queue_stmt_compat  */
  YYSYMBOL_queue_stmt_alloc = 610,         /* queue_stmt_alloc  */
  YYSYMBOL_queue_stmt_args = 611,          /* queue_stmt_args  */
  YYSYMBOL_queue_stmt_arg = 612,           /* queue_stmt_arg  */
  YYSYMBOL_queue_expr = 613,               /* queue_expr  */
  YYSYMBOL_queue_stmt_expr_simple = 614,   /* queue_stmt_expr_simple  */
  YYSYMBOL_queue_stmt_expr = 615,          /* queue_stmt_expr  */
  YYSYMBOL_queue_stmt_flags = 616,         /* queue_stmt_flags  */
  YYSYMBOL_queue_stmt_flag = 617,          /* queue_stmt_flag  */
  YYSYMBOL_set_elem_expr_stmt = 618,       /* set_elem_expr_stmt  */
  YYSYMBOL_set_elem_expr_stmt_alloc = 619, /* set_elem_expr_stmt_alloc  */
  YYSYMBOL_set_stmt = 620,                 /* set_stmt  */
  YYSYMBOL_set_stmt_op = 621,              /* set_stmt_op  */
  YYSYMBOL_map_stmt = 622,                 /* map_stmt  */
  YYSYMBOL_meter_stmt = 623,               /* meter_stmt  */
  YYSYMBOL_flow_stmt_legacy_alloc = 624,   /* flow_stmt_legacy_alloc  */
  YYSYMBOL_meter_stmt_alloc = 625,         /* meter_stmt_alloc  */
  YYSYMBOL_match_stmt = 626,               /* match_stmt  */
  YYSYMBOL_variable_expr = 627,            /* variable_expr  */
  YYSYMBOL_symbol_expr = 628,              /* symbol_expr  */
  YYSYMBOL_set_ref_expr = 629,             /* set_ref_expr  */
  YYSYMBOL_set_ref_symbol_expr = 630,      /* set_ref_symbol_expr  */
  YYSYMBOL_integer_expr = 631,             /* integer_expr  */
  YYSYMBOL_selector_expr = 632,            /* selector_expr  */
  YYSYMBOL_primary_expr = 633,             /* primary_expr  */
  YYSYMBOL_fib_expr = 634,                 /* fib_expr  */
  YYSYMBOL_fib_result = 635,               /* fib_result  */
  YYSYMBOL_fib_flag = 636,                 /* fib_flag  */
  YYSYMBOL_fib_tuple = 637,                /* fib_tuple  */
  YYSYMBOL_osf_expr = 638,                 /* osf_expr  */
  YYSYMBOL_osf_ttl = 639,                  /* osf_ttl  */
  YYSYMBOL_shift_expr = 640,               /* shift_expr  */
  YYSYMBOL_and_expr = 641,                 /* and_expr  */
  YYSYMBOL_exclusive_or_expr = 642,        /* exclusive_or_expr  */
  YYSYMBOL_inclusive_or_expr = 643,        /* inclusive_or_expr  */
  YYSYMBOL_basic_expr = 644,               /* basic_expr  */
  YYSYMBOL_concat_expr = 645,              /* concat_expr  */
  YYSYMBOL_prefix_rhs_expr = 646,          /* prefix_rhs_expr  */
  YYSYMBOL_range_rhs_expr = 647,           /* range_rhs_expr  */
  YYSYMBOL_multiton_rhs_expr = 648,        /* multiton_rhs_expr  */
  YYSYMBOL_map_expr = 649,                 /* map_expr  */
  YYSYMBOL_expr = 650,                     /* expr  */
  YYSYMBOL_set_expr = 651,                 /* set_expr  */
  YYSYMBOL_set_list_expr = 652,            /* set_list_expr  */
  YYSYMBOL_set_list_member_expr = 653,     /* set_list_member_expr  */
  YYSYMBOL_meter_key_expr = 654,           /* meter_key_expr  */
  YYSYMBOL_meter_key_expr_alloc = 655,     /* meter_key_expr_alloc  */
  YYSYMBOL_set_elem_expr = 656,            /* set_elem_expr  */
  YYSYMBOL_set_elem_key_expr = 657,        /* set_elem_key_expr  */
  YYSYMBOL_set_elem_expr_alloc = 658,      /* set_elem_expr_alloc  */
  YYSYMBOL_set_elem_options = 659,         /* set_elem_options  */
  YYSYMBOL_set_elem_option = 660,          /* set_elem_option  */
  YYSYMBOL_set_elem_expr_options = 661,    /* set_elem_expr_options  */
  YYSYMBOL_set_elem_stmt_list = 662,       /* set_elem_stmt_list  */
  YYSYMBOL_set_elem_stmt = 663,            /* set_elem_stmt  */
  YYSYMBOL_set_elem_expr_option = 664,     /* set_elem_expr_option  */
  YYSYMBOL_set_lhs_expr = 665,             /* set_lhs_expr  */
  YYSYMBOL_set_rhs_expr = 666,             /* set_rhs_expr  */
  YYSYMBOL_initializer_expr = 667,         /* initializer_expr  */
  YYSYMBOL_counter_config = 668,           /* counter_config  */
  YYSYMBOL_counter_obj = 669,              /* counter_obj  */
  YYSYMBOL_quota_config = 670,             /* quota_config  */
  YYSYMBOL_quota_obj = 671,                /* quota_obj  */
  YYSYMBOL_secmark_config = 672,           /* secmark_config  */
  YYSYMBOL_secmark_obj = 673,              /* secmark_obj  */
  YYSYMBOL_ct_obj_type = 674,              /* ct_obj_type  */
  YYSYMBOL_ct_cmd_type = 675,              /* ct_cmd_type  */
  YYSYMBOL_ct_l4protoname = 676,           /* ct_l4protoname  */
  YYSYMBOL_ct_helper_config = 677,         /* ct_helper_config  */
  YYSYMBOL_timeout_states = 678,           /* timeout_states  */
  YYSYMBOL_timeout_state = 679,            /* timeout_state  */
  YYSYMBOL_ct_timeout_config = 680,        /* ct_timeout_config  */
  YYSYMBOL_ct_expect_config = 681,         /* ct_expect_config  */
  YYSYMBOL_ct_obj_alloc = 682,             /* ct_obj_alloc  */
  YYSYMBOL_limit_config = 683,             /* limit_config  */
  YYSYMBOL_limit_obj = 684,                /* limit_obj  */
  YYSYMBOL_relational_expr = 685,          /* relational_expr  */
  YYSYMBOL_list_rhs_expr = 686,            /* list_rhs_expr  */
  YYSYMBOL_rhs_expr = 687,                 /* rhs_expr  */
  YYSYMBOL_shift_rhs_expr = 688,           /* shift_rhs_expr  */
  YYSYMBOL_and_rhs_expr = 689,             /* and_rhs_expr  */
  YYSYMBOL_exclusive_or_rhs_expr = 690,    /* exclusive_or_rhs_expr  */
  YYSYMBOL_inclusive_or_rhs_expr = 691,    /* inclusive_or_rhs_expr  */
  YYSYMBOL_basic_rhs_expr = 692,           /* basic_rhs_expr  */
  YYSYMBOL_concat_rhs_expr = 693,          /* concat_rhs_expr  */
  YYSYMBOL_boolean_keys = 694,             /* boolean_keys  */
  YYSYMBOL_boolean_expr = 695,             /* boolean_expr  */
  YYSYMBOL_keyword_expr = 696,             /* keyword_expr  */
  YYSYMBOL_primary_rhs_expr = 697,         /* primary_rhs_expr  */
  YYSYMBOL_relational_op = 698,            /* relational_op  */
  YYSYMBOL_verdict_expr = 699,             /* verdict_expr  */
  YYSYMBOL_chain_expr = 700,               /* chain_expr  */
  YYSYMBOL_meta_expr = 701,                /* meta_expr  */
  YYSYMBOL_meta_key = 702,                 /* meta_key  */
  YYSYMBOL_meta_key_qualified = 703,       /* meta_key_qualified  */
  YYSYMBOL_meta_key_unqualified = 704,     /* meta_key_unqualified  */
  YYSYMBOL_meta_stmt = 705,                /* meta_stmt  */
  YYSYMBOL_socket_expr = 706,              /* socket_expr  */
  YYSYMBOL_socket_key = 707,               /* socket_key  */
  YYSYMBOL_offset_opt = 708,               /* offset_opt  */
  YYSYMBOL_numgen_type = 709,              /* numgen_type  */
  YYSYMBOL_numgen_expr = 710,              /* numgen_expr  */
  YYSYMBOL_xfrm_spnum = 711,               /* xfrm_spnum  */
  YYSYMBOL_xfrm_dir = 712,                 /* xfrm_dir  */
  YYSYMBOL_xfrm_state_key = 713,           /* xfrm_state_key  */
  YYSYMBOL_xfrm_state_proto_key = 714,     /* xfrm_state_proto_key  */
  YYSYMBOL_xfrm_expr = 715,                /* xfrm_expr  */
  YYSYMBOL_hash_expr = 716,                /* hash_expr  */
  YYSYMBOL_nf_key_proto = 717,             /* nf_key_proto  */
  YYSYMBOL_rt_expr = 718,                  /* rt_expr  */
  YYSYMBOL_rt_key = 719,                   /* rt_key  */
  YYSYMBOL_ct_expr = 720,                  /* ct_expr  */
  YYSYMBOL_ct_dir = 721,                   /* ct_dir  */
  YYSYMBOL_ct_key = 722,                   /* ct_key  */
  YYSYMBOL_ct_key_dir = 723,               /* ct_key_dir  */
  YYSYMBOL_ct_key_proto_field = 724,       /* ct_key_proto_field  */
  YYSYMBOL_ct_key_dir_optional = 725,      /* ct_key_dir_optional  */
  YYSYMBOL_symbol_stmt_expr = 726,         /* symbol_stmt_expr  */
  YYSYMBOL_list_stmt_expr = 727,           /* list_stmt_expr  */
  YYSYMBOL_ct_stmt = 728,                  /* ct_stmt  */
  YYSYMBOL_payload_stmt = 729,             /* payload_stmt  */
  YYSYMBOL_payload_expr = 730,             /* payload_expr  */
  YYSYMBOL_payload_raw_len = 731,          /* payload_raw_len  */
  YYSYMBOL_payload_raw_expr = 732,         /* payload_raw_expr  */
  YYSYMBOL_payload_base_spec = 733,        /* payload_base_spec  */
  YYSYMBOL_eth_hdr_expr = 734,             /* eth_hdr_expr  */
  YYSYMBOL_eth_hdr_field = 735,            /* eth_hdr_field  */
  YYSYMBOL_vlan_hdr_expr = 736,            /* vlan_hdr_expr  */
  YYSYMBOL_vlan_hdr_field = 737,           /* vlan_hdr_field  */
  YYSYMBOL_arp_hdr_expr = 738,             /* arp_hdr_expr  */
  YYSYMBOL_arp_hdr_field = 739,            /* arp_hdr_field  */
  YYSYMBOL_ip_hdr_expr = 740,              /* ip_hdr_expr  */
  YYSYMBOL_ip_hdr_field = 741,             /* ip_hdr_field  */
  YYSYMBOL_ip_option_type = 742,           /* ip_option_type  */
  YYSYMBOL_ip_option_field = 743,          /* ip_option_field  */
  YYSYMBOL_icmp_hdr_expr = 744,            /* icmp_hdr_expr  */
  YYSYMBOL_icmp_hdr_field = 745,           /* icmp_hdr_field  */
  YYSYMBOL_igmp_hdr_expr = 746,            /* igmp_hdr_expr  */
  YYSYMBOL_igmp_hdr_field = 747,           /* igmp_hdr_field  */
  YYSYMBOL_ip6_hdr_expr = 748,             /* ip6_hdr_expr  */
  YYSYMBOL_ip6_hdr_field = 749,            /* ip6_hdr_field  */
  YYSYMBOL_icmp6_hdr_expr = 750,           /* icmp6_hdr_expr  */
  YYSYMBOL_icmp6_hdr_field = 751,          /* icmp6_hdr_field  */
  YYSYMBOL_auth_hdr_expr = 752,            /* auth_hdr_expr  */
  YYSYMBOL_auth_hdr_field = 753,           /* auth_hdr_field  */
  YYSYMBOL_esp_hdr_expr = 754,             /* esp_hdr_expr  */
  YYSYMBOL_esp_hdr_field = 755,            /* esp_hdr_field  */
  YYSYMBOL_comp_hdr_expr = 756,            /* comp_hdr_expr  */
  YYSYMBOL_comp_hdr_field = 757,           /* comp_hdr_field  */
  YYSYMBOL_udp_hdr_expr = 758,             /* udp_hdr_expr  */
  YYSYMBOL_udp_hdr_field = 759,            /* udp_hdr_field  */
  YYSYMBOL_udplite_hdr_expr = 760,         /* udplite_hdr_expr  */
  YYSYMBOL_udplite_hdr_field = 761,        /* udplite_hdr_field  */
  YYSYMBOL_tcp_hdr_expr = 762,             /* tcp_hdr_expr  */
  YYSYMBOL_optstrip_stmt = 763,            /* optstrip_stmt  */
  YYSYMBOL_tcp_hdr_field = 764,            /* tcp_hdr_field  */
  YYSYMBOL_tcp_hdr_option_kind_and_field = 765, /* tcp_hdr_option_kind_and_field  */
  YYSYMBOL_tcp_hdr_option_sack = 766,      /* tcp_hdr_option_sack  */
  YYSYMBOL_tcp_hdr_option_type = 767,      /* tcp_hdr_option_type  */
  YYSYMBOL_tcpopt_field_sack = 768,        /* tcpopt_field_sack  */
  YYSYMBOL_tcpopt_field_window = 769,      /* tcpopt_field_window  */
  YYSYMBOL_tcpopt_field_tsopt = 770,       /* tcpopt_field_tsopt  */
  YYSYMBOL_tcpopt_field_maxseg = 771,      /* tcpopt_field_maxseg  */
  YYSYMBOL_tcpopt_field_mptcp = 772,       /* tcpopt_field_mptcp  */
  YYSYMBOL_dccp_hdr_expr = 773,            /* dccp_hdr_expr  */
  YYSYMBOL_dccp_hdr_field = 774,           /* dccp_hdr_field  */
  YYSYMBOL_sctp_chunk_type = 775,          /* sctp_chunk_type  */
  YYSYMBOL_sctp_chunk_common_field = 776,  /* sctp_chunk_common_field  */
  YYSYMBOL_sctp_chunk_data_field = 777,    /* sctp_chunk_data_field  */
  YYSYMBOL_sctp_chunk_init_field = 778,    /* sctp_chunk_init_field  */
  YYSYMBOL_sctp_chunk_sack_field = 779,    /* sctp_chunk_sack_field  */
  YYSYMBOL_sctp_chunk_alloc = 780,         /* sctp_chunk_alloc  */
  YYSYMBOL_sctp_hdr_expr = 781,            /* sctp_hdr_expr  */
  YYSYMBOL_sctp_hdr_field = 782,           /* sctp_hdr_field  */
  YYSYMBOL_th_hdr_expr = 783,              /* th_hdr_expr  */
  YYSYMBOL_th_hdr_field = 784,             /* th_hdr_field  */
  YYSYMBOL_exthdr_expr = 785,              /* exthdr_expr  */
  YYSYMBOL_hbh_hdr_expr = 786,             /* hbh_hdr_expr  */
  YYSYMBOL_hbh_hdr_field = 787,            /* hbh_hdr_field  */
  YYSYMBOL_rt_hdr_expr = 788,              /* rt_hdr_expr  */
  YYSYMBOL_rt_hdr_field = 789,             /* rt_hdr_field  */
  YYSYMBOL_rt0_hdr_expr = 790,             /* rt0_hdr_expr  */
  YYSYMBOL_rt0_hdr_field = 791,            /* rt0_hdr_field  */
  YYSYMBOL_rt2_hdr_expr = 792,             /* rt2_hdr_expr  */
  YYSYMBOL_rt2_hdr_field = 793,            /* rt2_hdr_field  */
  YYSYMBOL_rt4_hdr_expr = 794,             /* rt4_hdr_expr  */
  YYSYMBOL_rt4_hdr_field = 795,            /* rt4_hdr_field  */
  YYSYMBOL_frag_hdr_expr = 796,            /* frag_hdr_expr  */
  YYSYMBOL_frag_hdr_field = 797,           /* frag_hdr_field  */
  YYSYMBOL_dst_hdr_expr = 798,             /* dst_hdr_expr  */
  YYSYMBOL_dst_hdr_field = 799,            /* dst_hdr_field  */
  YYSYMBOL_mh_hdr_expr = 800,              /* mh_hdr_expr  */
  YYSYMBOL_mh_hdr_field = 801,             /* mh_hdr_field  */
  YYSYMBOL_exthdr_exists_expr = 802,       /* exthdr_exists_expr  */
  YYSYMBOL_exthdr_key = 803                /* exthdr_key  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   8366

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  364
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  440
/* YYNRULES -- Number of rules.  */
#define YYNRULES  1302
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  2234

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   609


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,   361,     2,     2,     2,
     358,   359,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   355,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   362,     2,   363,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   356,   360,   357,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   987,   987,   988,   997,   998,  1001,  1002,  1005,  1006,
    1007,  1008,  1009,  1010,  1011,  1012,  1013,  1014,  1015,  1016,
    1017,  1018,  1019,  1020,  1021,  1022,  1023,  1024,  1025,  1026,
    1027,  1028,  1029,  1030,  1031,  1032,  1033,  1034,  1035,  1036,
    1037,  1038,  1039,  1040,  1041,  1042,  1043,  1044,  1045,  1046,
    1047,  1048,  1049,  1050,  1051,  1052,  1054,  1055,  1056,  1058,
    1066,  1081,  1088,  1100,  1108,  1109,  1110,  1111,  1131,  1132,
    1133,  1134,  1135,  1136,  1137,  1138,  1139,  1140,  1141,  1142,
    1143,  1144,  1145,  1148,  1152,  1159,  1163,  1171,  1175,  1179,
    1186,  1193,  1197,  1204,  1213,  1217,  1221,  1225,  1229,  1233,
    1237,  1241,  1245,  1249,  1253,  1257,  1261,  1267,  1273,  1277,
    1284,  1288,  1296,  1303,  1310,  1314,  1321,  1330,  1334,  1338,
    1342,  1346,  1350,  1354,  1358,  1364,  1370,  1371,  1374,  1375,
    1378,  1379,  1382,  1383,  1386,  1390,  1394,  1398,  1402,  1406,
    1410,  1414,  1418,  1425,  1429,  1433,  1439,  1443,  1447,  1453,
    1459,  1463,  1467,  1471,  1475,  1479,  1483,  1487,  1491,  1495,
    1499,  1503,  1507,  1511,  1515,  1519,  1523,  1527,  1531,  1535,
    1539,  1543,  1547,  1551,  1555,  1559,  1563,  1567,  1571,  1575,
    1579,  1583,  1587,  1591,  1597,  1603,  1607,  1617,  1621,  1625,
    1629,  1633,  1637,  1643,  1647,  1651,  1655,  1659,  1663,  1667,
    1673,  1680,  1686,  1694,  1700,  1708,  1717,  1718,  1721,  1722,
    1723,  1724,  1725,  1726,  1727,  1728,  1731,  1732,  1735,  1736,
    1737,  1740,  1749,  1759,  1774,  1784,  1785,  1786,  1787,  1788,
    1799,  1809,  1820,  1830,  1841,  1852,  1861,  1870,  1879,  1890,
    1901,  1915,  1925,  1926,  1927,  1928,  1929,  1930,  1931,  1936,
    1946,  1947,  1948,  1955,  1967,  1978,  1983,  1987,  1991,  2008,
    2021,  2025,  2038,  2043,  2044,  2047,  2048,  2049,  2050,  2060,
    2065,  2070,  2075,  2081,  2090,  2095,  2096,  2107,  2108,  2111,
    2115,  2118,  2119,  2120,  2121,  2125,  2130,  2131,  2134,  2135,
    2136,  2137,  2138,  2141,  2142,  2145,  2146,  2149,  2150,  2151,
    2152,  2157,  2162,  2179,  2202,  2216,  2225,  2230,  2236,  2241,
    2250,  2253,  2257,  2263,  2264,  2268,  2273,  2274,  2275,  2276,
    2291,  2295,  2299,  2305,  2310,  2317,  2322,  2327,  2330,  2339,
    2348,  2355,  2368,  2375,  2376,  2388,  2393,  2394,  2395,  2396,
    2400,  2410,  2411,  2412,  2413,  2417,  2427,  2428,  2429,  2430,
    2434,  2445,  2450,  2451,  2452,  2456,  2466,  2467,  2468,  2469,
    2473,  2483,  2484,  2485,  2486,  2490,  2500,  2501,  2502,  2503,
    2507,  2517,  2518,  2519,  2520,  2524,  2534,  2535,  2536,  2537,
    2538,  2541,  2577,  2584,  2588,  2591,  2601,  2608,  2619,  2632,
    2647,  2648,  2651,  2662,  2668,  2672,  2675,  2681,  2694,  2699,
    2708,  2709,  2712,  2715,  2716,  2717,  2720,  2736,  2737,  2740,
    2741,  2744,  2745,  2746,  2747,  2748,  2749,  2752,  2761,  2770,
    2778,  2786,  2794,  2802,  2810,  2818,  2826,  2834,  2842,  2850,
    2858,  2866,  2874,  2882,  2890,  2894,  2899,  2907,  2914,  2921,
    2935,  2939,  2946,  2950,  2956,  2968,  2974,  2981,  2987,  2994,
    3002,  3010,  3018,  3026,  3033,  3041,  3042,  3043,  3044,  3045,
    3048,  3049,  3050,  3051,  3054,  3055,  3056,  3057,  3058,  3059,
    3060,  3061,  3062,  3063,  3064,  3065,  3066,  3067,  3068,  3069,
    3070,  3071,  3072,  3073,  3074,  3075,  3076,  3079,  3090,  3091,
    3094,  3103,  3107,  3113,  3119,  3124,  3127,  3132,  3137,  3140,
    3146,  3151,  3159,  3160,  3162,  3168,  3172,  3175,  3180,  3187,
    3188,  3191,  3197,  3201,  3204,  3329,  3334,  3339,  3344,  3349,
    3355,  3385,  3389,  3393,  3397,  3401,  3407,  3411,  3414,  3418,
    3424,  3438,  3449,  3450,  3451,  3454,  3455,  3458,  3459,  3474,
    3492,  3493,  3494,  3497,  3498,  3501,  3508,  3509,  3512,  3526,
    3533,  3534,  3549,  3550,  3551,  3552,  3553,  3556,  3559,  3565,
    3571,  3575,  3579,  3586,  3593,  3600,  3607,  3613,  3619,  3625,
    3628,  3629,  3632,  3638,  3644,  3650,  3657,  3664,  3672,  3673,
    3676,  3682,  3686,  3689,  3694,  3699,  3703,  3709,  3725,  3744,
    3750,  3751,  3757,  3758,  3764,  3765,  3766,  3767,  3768,  3769,
    3770,  3771,  3772,  3773,  3774,  3775,  3776,  3779,  3780,  3784,
    3790,  3791,  3797,  3798,  3804,  3805,  3811,  3814,  3815,  3826,
    3827,  3830,  3834,  3837,  3843,  3849,  3850,  3853,  3854,  3855,
    3858,  3862,  3866,  3871,  3876,  3881,  3887,  3891,  3895,  3899,
    3905,  3910,  3914,  3922,  3931,  3932,  3935,  3938,  3942,  3947,
    3953,  3954,  3957,  3960,  3964,  3968,  3972,  3977,  3984,  3989,
    3997,  4002,  4011,  4012,  4018,  4019,  4020,  4023,  4024,  4028,
    4032,  4038,  4039,  4042,  4048,  4052,  4055,  4060,  4066,  4067,
    4070,  4071,  4072,  4078,  4079,  4080,  4081,  4084,  4085,  4091,
    4092,  4095,  4096,  4099,  4105,  4112,  4119,  4130,  4131,  4132,
    4135,  4143,  4155,  4163,  4166,  4172,  4181,  4192,  4198,  4224,
    4225,  4234,  4235,  4238,  4247,  4258,  4259,  4260,  4261,  4262,
    4263,  4264,  4265,  4266,  4267,  4268,  4269,  4272,  4273,  4274,
    4275,  4278,  4301,  4302,  4303,  4306,  4307,  4308,  4309,  4310,
    4313,  4317,  4320,  4324,  4331,  4334,  4350,  4351,  4355,  4361,
    4362,  4368,  4369,  4375,  4376,  4382,  4385,  4386,  4397,  4403,
    4409,  4410,  4413,  4419,  4420,  4421,  4424,  4431,  4436,  4441,
    4444,  4448,  4452,  4458,  4459,  4466,  4472,  4473,  4474,  4482,
    4483,  4486,  4492,  4498,  4502,  4505,  4509,  4513,  4523,  4527,
    4530,  4536,  4543,  4547,  4553,  4567,  4576,  4581,  4587,  4605,
    4609,  4613,  4623,  4626,  4627,  4630,  4631,  4632,  4633,  4644,
    4655,  4661,  4682,  4688,  4705,  4711,  4712,  4713,  4716,  4717,
    4718,  4721,  4722,  4725,  4748,  4754,  4760,  4767,  4780,  4788,
    4796,  4802,  4806,  4810,  4814,  4818,  4825,  4830,  4841,  4855,
    4861,  4865,  4869,  4873,  4877,  4881,  4885,  4889,  4895,  4901,
    4909,  4910,  4911,  4914,  4915,  4919,  4925,  4926,  4932,  4933,
    4939,  4940,  4946,  4949,  4950,  4951,  4960,  4971,  4972,  4975,
    4983,  4984,  4985,  4986,  4987,  4988,  4989,  4990,  4991,  4992,
    4993,  4994,  4997,  4998,  4999,  5000,  5001,  5008,  5015,  5022,
    5029,  5036,  5043,  5050,  5057,  5064,  5071,  5078,  5085,  5088,
    5089,  5090,  5091,  5092,  5093,  5094,  5097,  5101,  5105,  5109,
    5113,  5117,  5123,  5124,  5134,  5138,  5142,  5158,  5159,  5162,
    5163,  5164,  5165,  5166,  5169,  5170,  5171,  5172,  5173,  5174,
    5175,  5176,  5177,  5178,  5179,  5180,  5181,  5182,  5183,  5184,
    5185,  5186,  5187,  5188,  5189,  5190,  5191,  5192,  5195,  5215,
    5219,  5234,  5238,  5242,  5248,  5252,  5258,  5259,  5260,  5263,
    5264,  5267,  5268,  5271,  5277,  5278,  5281,  5282,  5285,  5286,
    5289,  5290,  5293,  5301,  5328,  5333,  5338,  5344,  5345,  5348,
    5352,  5372,  5373,  5374,  5375,  5378,  5382,  5386,  5392,  5393,
    5396,  5397,  5398,  5399,  5400,  5401,  5402,  5403,  5404,  5405,
    5406,  5407,  5408,  5409,  5410,  5411,  5412,  5415,  5416,  5417,
    5418,  5419,  5420,  5421,  5424,  5425,  5426,  5427,  5430,  5431,
    5432,  5433,  5436,  5437,  5440,  5446,  5454,  5467,  5473,  5482,
    5483,  5484,  5485,  5486,  5487,  5488,  5489,  5490,  5491,  5492,
    5493,  5494,  5495,  5496,  5497,  5498,  5499,  5502,  5520,  5529,
    5530,  5531,  5532,  5545,  5551,  5552,  5553,  5556,  5562,  5563,
    5564,  5565,  5566,  5569,  5575,  5576,  5577,  5578,  5579,  5580,
    5581,  5582,  5583,  5586,  5590,  5601,  5608,  5609,  5610,  5611,
    5612,  5613,  5614,  5615,  5616,  5617,  5618,  5619,  5622,  5623,
    5624,  5625,  5628,  5629,  5630,  5631,  5632,  5635,  5641,  5642,
    5643,  5644,  5645,  5646,  5647,  5650,  5656,  5657,  5658,  5659,
    5662,  5668,  5669,  5670,  5671,  5672,  5673,  5674,  5675,  5676,
    5678,  5684,  5685,  5686,  5687,  5688,  5689,  5690,  5691,  5694,
    5700,  5701,  5702,  5703,  5704,  5707,  5713,  5714,  5717,  5723,
    5724,  5725,  5728,  5734,  5735,  5736,  5737,  5740,  5746,  5747,
    5748,  5749,  5752,  5756,  5761,  5769,  5776,  5783,  5784,  5785,
    5786,  5787,  5788,  5789,  5790,  5791,  5792,  5795,  5800,  5805,
    5810,  5815,  5820,  5827,  5828,  5829,  5830,  5831,  5834,  5835,
    5836,  5837,  5838,  5839,  5840,  5841,  5842,  5843,  5844,  5845,
    5854,  5855,  5858,  5861,  5862,  5865,  5868,  5871,  5877,  5878,
    5879,  5882,  5883,  5884,  5885,  5886,  5887,  5888,  5889,  5890,
    5891,  5892,  5893,  5894,  5895,  5896,  5897,  5898,  5899,  5902,
    5903,  5904,  5907,  5908,  5909,  5910,  5913,  5914,  5915,  5916,
    5917,  5920,  5921,  5922,  5923,  5926,  5931,  5935,  5939,  5943,
    5947,  5951,  5956,  5961,  5966,  5971,  5976,  5983,  5987,  5993,
    5994,  5995,  5996,  5999,  6007,  6008,  6011,  6012,  6013,  6014,
    6015,  6016,  6017,  6018,  6021,  6027,  6028,  6031,  6037,  6038,
    6039,  6040,  6043,  6049,  6055,  6061,  6064,  6070,  6071,  6072,
    6073,  6079,  6085,  6086,  6087,  6088,  6089,  6090,  6093,  6099,
    6100,  6103,  6109,  6110,  6111,  6112,  6113,  6116,  6130,  6131,
    6132,  6133,  6134
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "\"junk\"",
  "\"CRLF line terminators\"", "\"newline\"", "\"colon\"", "\"semicolon\"",
  "\"comma\"", "\".\"", "\"==\"", "\"!=\"", "\"<\"", "\">\"", "\">=\"",
  "\"<=\"", "\"<<\"", "\">>\"", "\"&\"", "\"^\"", "\"!\"", "\"/\"",
  "\"*\"", "\"-\"", "\"@\"", "\"vmap\"", "\"+\"", "\"include\"",
  "\"define\"", "\"redefine\"", "\"undefine\"", "\"fib\"", "\"socket\"",
  "\"transparent\"", "\"wildcard\"", "\"cgroupv2\"", "\"tproxy\"",
  "\"osf\"", "\"synproxy\"", "\"mss\"", "\"wscale\"", "\"typeof\"",
  "\"hook\"", "\"hooks\"", "\"device\"", "\"devices\"", "\"table\"",
  "\"tables\"", "\"chain\"", "\"chains\"", "\"rule\"", "\"rules\"",
  "\"sets\"", "\"set\"", "\"element\"", "\"map\"", "\"maps\"",
  "\"flowtable\"", "\"handle\"", "\"ruleset\"", "\"trace\"", "\"inet\"",
  "\"netdev\"", "\"add\"", "\"update\"", "\"replace\"", "\"create\"",
  "\"insert\"", "\"delete\"", "\"get\"", "\"list\"", "\"reset\"",
  "\"flush\"", "\"rename\"", "\"describe\"", "\"import\"", "\"export\"",
  "\"monitor\"", "\"all\"", "\"accept\"", "\"drop\"", "\"continue\"",
  "\"jump\"", "\"goto\"", "\"return\"", "\"to\"", "\"constant\"",
  "\"interval\"", "\"dynamic\"", "\"auto-merge\"", "\"timeout\"",
  "\"gc-interval\"", "\"elements\"", "\"expires\"", "\"policy\"",
  "\"memory\"", "\"performance\"", "\"size\"", "\"flow\"", "\"offload\"",
  "\"meter\"", "\"meters\"", "\"flowtables\"", "\"number\"", "\"string\"",
  "\"quoted string\"", "\"string with a trailing asterisk\"", "\"ll\"",
  "\"nh\"", "\"th\"", "\"bridge\"", "\"ether\"", "\"saddr\"", "\"daddr\"",
  "\"type\"", "\"vlan\"", "\"id\"", "\"cfi\"", "\"dei\"", "\"pcp\"",
  "\"arp\"", "\"htype\"", "\"ptype\"", "\"hlen\"", "\"plen\"",
  "\"operation\"", "\"ip\"", "\"version\"", "\"hdrlength\"", "\"dscp\"",
  "\"ecn\"", "\"length\"", "\"frag-off\"", "\"ttl\"", "\"protocol\"",
  "\"checksum\"", "\"ptr\"", "\"value\"", "\"lsrr\"", "\"rr\"", "\"ssrr\"",
  "\"ra\"", "\"icmp\"", "\"code\"", "\"seq\"", "\"gateway\"", "\"mtu\"",
  "\"igmp\"", "\"mrt\"", "\"options\"", "\"ip6\"", "\"priority\"",
  "\"flowlabel\"", "\"nexthdr\"", "\"hoplimit\"", "\"icmpv6\"",
  "\"param-problem\"", "\"max-delay\"", "\"ah\"", "\"reserved\"",
  "\"spi\"", "\"esp\"", "\"comp\"", "\"flags\"", "\"cpi\"", "\"port\"",
  "\"udp\"", "\"sport\"", "\"dport\"", "\"udplite\"", "\"csumcov\"",
  "\"tcp\"", "\"ackseq\"", "\"doff\"", "\"window\"", "\"urgptr\"",
  "\"option\"", "\"echo\"", "\"eol\"", "\"mptcp\"", "\"nop\"", "\"sack\"",
  "\"sack0\"", "\"sack1\"", "\"sack2\"", "\"sack3\"", "\"sack-permitted\"",
  "\"fastopen\"", "\"md5sig\"", "\"timestamp\"", "\"count\"", "\"left\"",
  "\"right\"", "\"tsval\"", "\"tsecr\"", "\"subtype\"", "\"dccp\"",
  "\"sctp\"", "\"chunk\"", "\"data\"", "\"init\"", "\"init-ack\"",
  "\"heartbeat\"", "\"heartbeat-ack\"", "\"abort\"", "\"shutdown\"",
  "\"shutdown-ack\"", "\"error\"", "\"cookie-echo\"", "\"cookie-ack\"",
  "\"ecne\"", "\"cwr\"", "\"shutdown-complete\"", "\"asconf-ack\"",
  "\"forward-tsn\"", "\"asconf\"", "\"tsn\"", "\"stream\"", "\"ssn\"",
  "\"ppid\"", "\"init-tag\"", "\"a-rwnd\"", "\"num-outbound-streams\"",
  "\"num-inbound-streams\"", "\"initial-tsn\"", "\"cum-tsn-ack\"",
  "\"num-gap-ack-blocks\"", "\"num-dup-tsns\"", "\"lowest-tsn\"",
  "\"seqno\"", "\"new-cum-tsn\"", "\"vtag\"", "\"rt\"", "\"rt0\"",
  "\"rt2\"", "\"srh\"", "\"seg-left\"", "\"addr\"", "\"last-entry\"",
  "\"tag\"", "\"sid\"", "\"hbh\"", "\"frag\"", "\"reserved2\"",
  "\"more-fragments\"", "\"dst\"", "\"mh\"", "\"meta\"", "\"mark\"",
  "\"iif\"", "\"iifname\"", "\"iiftype\"", "\"oif\"", "\"oifname\"",
  "\"oiftype\"", "\"skuid\"", "\"skgid\"", "\"nftrace\"", "\"rtclassid\"",
  "\"ibriport\"", "\"obriport\"", "\"ibrname\"", "\"obrname\"",
  "\"pkttype\"", "\"cpu\"", "\"iifgroup\"", "\"oifgroup\"", "\"cgroup\"",
  "\"time\"", "\"classid\"", "\"nexthop\"", "\"ct\"", "\"l3proto\"",
  "\"proto-src\"", "\"proto-dst\"", "\"zone\"", "\"direction\"",
  "\"event\"", "\"expectation\"", "\"expiration\"", "\"helper\"",
  "\"label\"", "\"state\"", "\"status\"", "\"original\"", "\"reply\"",
  "\"counter\"", "\"name\"", "\"packets\"", "\"bytes\"", "\"avgpkt\"",
  "\"counters\"", "\"quotas\"", "\"limits\"", "\"synproxys\"",
  "\"helpers\"", "\"log\"", "\"prefix\"", "\"group\"", "\"snaplen\"",
  "\"queue-threshold\"", "\"level\"", "\"limit\"", "\"rate\"", "\"burst\"",
  "\"over\"", "\"until\"", "\"quota\"", "\"used\"", "\"secmark\"",
  "\"secmarks\"", "\"second\"", "\"minute\"", "\"hour\"", "\"day\"",
  "\"week\"", "\"reject\"", "\"with\"", "\"icmpx\"", "\"snat\"",
  "\"dnat\"", "\"masquerade\"", "\"redirect\"", "\"random\"",
  "\"fully-random\"", "\"persistent\"", "\"queue\"", "\"num\"",
  "\"bypass\"", "\"fanout\"", "\"dup\"", "\"fwd\"", "\"numgen\"",
  "\"inc\"", "\"mod\"", "\"offset\"", "\"jhash\"", "\"symhash\"",
  "\"seed\"", "\"position\"", "\"index\"", "\"comment\"", "\"xml\"",
  "\"json\"", "\"vm\"", "\"notrack\"", "\"exists\"", "\"missing\"",
  "\"exthdr\"", "\"ipsec\"", "\"reqid\"", "\"spnum\"", "\"in\"", "\"out\"",
  "\"xt\"", "'='", "'{'", "'}'", "'('", "')'", "'|'", "'$'", "'['", "']'",
  "$accept", "input", "stmt_separator", "opt_newline", "close_scope_ah",
  "close_scope_arp", "close_scope_at", "close_scope_comp",
  "close_scope_ct", "close_scope_counter", "close_scope_dccp",
  "close_scope_dst", "close_scope_dup", "close_scope_esp",
  "close_scope_eth", "close_scope_export", "close_scope_fib",
  "close_scope_frag", "close_scope_fwd", "close_scope_hash",
  "close_scope_hbh", "close_scope_ip", "close_scope_ip6",
  "close_scope_vlan", "close_scope_icmp", "close_scope_igmp",
  "close_scope_import", "close_scope_ipsec", "close_scope_list",
  "close_scope_limit", "close_scope_meta", "close_scope_mh",
  "close_scope_monitor", "close_scope_nat", "close_scope_numgen",
  "close_scope_osf", "close_scope_policy", "close_scope_quota",
  "close_scope_queue", "close_scope_reject", "close_scope_reset",
  "close_scope_rt", "close_scope_sctp", "close_scope_sctp_chunk",
  "close_scope_secmark", "close_scope_socket", "close_scope_tcp",
  "close_scope_tproxy", "close_scope_type", "close_scope_th",
  "close_scope_udp", "close_scope_udplite", "close_scope_log",
  "close_scope_synproxy", "close_scope_xt", "common_block", "line",
  "base_cmd", "add_cmd", "replace_cmd", "create_cmd", "insert_cmd",
  "table_or_id_spec", "chain_or_id_spec", "set_or_id_spec",
  "obj_or_id_spec", "delete_cmd", "get_cmd", "list_cmd",
  "basehook_device_name", "basehook_spec", "reset_cmd", "flush_cmd",
  "rename_cmd", "import_cmd", "export_cmd", "monitor_cmd", "monitor_event",
  "monitor_object", "monitor_format", "markup_format", "describe_cmd",
  "table_block_alloc", "table_options", "table_block", "chain_block_alloc",
  "chain_block", "subchain_block", "typeof_verdict_expr",
  "typeof_data_expr", "primary_typeof_expr", "typeof_expr",
  "set_block_alloc", "typeof_key_expr", "set_block", "set_block_expr",
  "set_flag_list", "set_flag", "map_block_alloc", "ct_obj_type_map",
  "map_block_obj_type", "map_block_obj_typeof", "map_block_data_interval",
  "map_block", "set_mechanism", "set_policy_spec", "flowtable_block_alloc",
  "flowtable_block", "flowtable_expr", "flowtable_list_expr",
  "flowtable_expr_member", "data_type_atom_expr", "data_type_expr",
  "obj_block_alloc", "counter_block", "quota_block", "ct_helper_block",
  "ct_timeout_block", "ct_expect_block", "limit_block", "secmark_block",
  "synproxy_block", "type_identifier", "hook_spec", "prio_spec",
  "extended_prio_name", "extended_prio_spec", "int_num", "dev_spec",
  "flags_spec", "policy_spec", "policy_expr", "chain_policy", "identifier",
  "string", "time_spec", "time_spec_or_num_s", "family_spec",
  "family_spec_explicit", "table_spec", "tableid_spec", "chain_spec",
  "chainid_spec", "chain_identifier", "set_spec", "setid_spec",
  "set_identifier", "flowtable_spec", "flowtableid_spec",
  "flowtable_identifier", "obj_spec", "objid_spec", "obj_identifier",
  "handle_spec", "position_spec", "index_spec", "rule_position",
  "ruleid_spec", "comment_spec", "ruleset_spec", "rule", "rule_alloc",
  "stmt_list", "stateful_stmt_list", "objref_stmt_counter",
  "objref_stmt_limit", "objref_stmt_quota", "objref_stmt_synproxy",
  "objref_stmt_ct", "objref_stmt", "stateful_stmt", "stmt", "xt_stmt",
  "chain_stmt_type", "chain_stmt", "verdict_stmt", "verdict_map_stmt",
  "verdict_map_expr", "verdict_map_list_expr",
  "verdict_map_list_member_expr", "connlimit_stmt", "counter_stmt",
  "counter_stmt_alloc", "counter_args", "counter_arg", "log_stmt",
  "log_stmt_alloc", "log_args", "log_arg", "level_type", "log_flags",
  "log_flags_tcp", "log_flag_tcp", "limit_stmt", "quota_mode",
  "quota_unit", "quota_used", "quota_stmt", "limit_mode",
  "limit_burst_pkts", "limit_rate_pkts", "limit_burst_bytes",
  "limit_rate_bytes", "limit_bytes", "time_unit", "reject_stmt",
  "reject_stmt_alloc", "reject_with_expr", "reject_opts", "nat_stmt",
  "nat_stmt_alloc", "tproxy_stmt", "synproxy_stmt", "synproxy_stmt_alloc",
  "synproxy_args", "synproxy_arg", "synproxy_config", "synproxy_obj",
  "synproxy_ts", "synproxy_sack", "primary_stmt_expr", "shift_stmt_expr",
  "and_stmt_expr", "exclusive_or_stmt_expr", "inclusive_or_stmt_expr",
  "basic_stmt_expr", "concat_stmt_expr", "map_stmt_expr_set",
  "map_stmt_expr", "prefix_stmt_expr", "range_stmt_expr",
  "multiton_stmt_expr", "stmt_expr", "nat_stmt_args", "masq_stmt",
  "masq_stmt_alloc", "masq_stmt_args", "redir_stmt", "redir_stmt_alloc",
  "redir_stmt_arg", "dup_stmt", "fwd_stmt", "nf_nat_flags", "nf_nat_flag",
  "queue_stmt", "queue_stmt_compat", "queue_stmt_alloc", "queue_stmt_args",
  "queue_stmt_arg", "queue_expr", "queue_stmt_expr_simple",
  "queue_stmt_expr", "queue_stmt_flags", "queue_stmt_flag",
  "set_elem_expr_stmt", "set_elem_expr_stmt_alloc", "set_stmt",
  "set_stmt_op", "map_stmt", "meter_stmt", "flow_stmt_legacy_alloc",
  "meter_stmt_alloc", "match_stmt", "variable_expr", "symbol_expr",
  "set_ref_expr", "set_ref_symbol_expr", "integer_expr", "selector_expr",
  "primary_expr", "fib_expr", "fib_result", "fib_flag", "fib_tuple",
  "osf_expr", "osf_ttl", "shift_expr", "and_expr", "exclusive_or_expr",
  "inclusive_or_expr", "basic_expr", "concat_expr", "prefix_rhs_expr",
  "range_rhs_expr", "multiton_rhs_expr", "map_expr", "expr", "set_expr",
  "set_list_expr", "set_list_member_expr", "meter_key_expr",
  "meter_key_expr_alloc", "set_elem_expr", "set_elem_key_expr",
  "set_elem_expr_alloc", "set_elem_options", "set_elem_option",
  "set_elem_expr_options", "set_elem_stmt_list", "set_elem_stmt",
  "set_elem_expr_option", "set_lhs_expr", "set_rhs_expr",
  "initializer_expr", "counter_config", "counter_obj", "quota_config",
  "quota_obj", "secmark_config", "secmark_obj", "ct_obj_type",
  "ct_cmd_type", "ct_l4protoname", "ct_helper_config", "timeout_states",
  "timeout_state", "ct_timeout_config", "ct_expect_config", "ct_obj_alloc",
  "limit_config", "limit_obj", "relational_expr", "list_rhs_expr",
  "rhs_expr", "shift_rhs_expr", "and_rhs_expr", "exclusive_or_rhs_expr",
  "inclusive_or_rhs_expr", "basic_rhs_expr", "concat_rhs_expr",
  "boolean_keys", "boolean_expr", "keyword_expr", "primary_rhs_expr",
  "relational_op", "verdict_expr", "chain_expr", "meta_expr", "meta_key",
  "meta_key_qualified", "meta_key_unqualified", "meta_stmt", "socket_expr",
  "socket_key", "offset_opt", "numgen_type", "numgen_expr", "xfrm_spnum",
  "xfrm_dir", "xfrm_state_key", "xfrm_state_proto_key", "xfrm_expr",
  "hash_expr", "nf_key_proto", "rt_expr", "rt_key", "ct_expr", "ct_dir",
  "ct_key", "ct_key_dir", "ct_key_proto_field", "ct_key_dir_optional",
  "symbol_stmt_expr", "list_stmt_expr", "ct_stmt", "payload_stmt",
  "payload_expr", "payload_raw_len", "payload_raw_expr",
  "payload_base_spec", "eth_hdr_expr", "eth_hdr_field", "vlan_hdr_expr",
  "vlan_hdr_field", "arp_hdr_expr", "arp_hdr_field", "ip_hdr_expr",
  "ip_hdr_field", "ip_option_type", "ip_option_field", "icmp_hdr_expr",
  "icmp_hdr_field", "igmp_hdr_expr", "igmp_hdr_field", "ip6_hdr_expr",
  "ip6_hdr_field", "icmp6_hdr_expr", "icmp6_hdr_field", "auth_hdr_expr",
  "auth_hdr_field", "esp_hdr_expr", "esp_hdr_field", "comp_hdr_expr",
  "comp_hdr_field", "udp_hdr_expr", "udp_hdr_field", "udplite_hdr_expr",
  "udplite_hdr_field", "tcp_hdr_expr", "optstrip_stmt", "tcp_hdr_field",
  "tcp_hdr_option_kind_and_field", "tcp_hdr_option_sack",
  "tcp_hdr_option_type", "tcpopt_field_sack", "tcpopt_field_window",
  "tcpopt_field_tsopt", "tcpopt_field_maxseg", "tcpopt_field_mptcp",
  "dccp_hdr_expr", "dccp_hdr_field", "sctp_chunk_type",
  "sctp_chunk_common_field", "sctp_chunk_data_field",
  "sctp_chunk_init_field", "sctp_chunk_sack_field", "sctp_chunk_alloc",
  "sctp_hdr_expr", "sctp_hdr_field", "th_hdr_expr", "th_hdr_field",
  "exthdr_expr", "hbh_hdr_expr", "hbh_hdr_field", "rt_hdr_expr",
  "rt_hdr_field", "rt0_hdr_expr", "rt0_hdr_field", "rt2_hdr_expr",
  "rt2_hdr_field", "rt4_hdr_expr", "rt4_hdr_field", "frag_hdr_expr",
  "frag_hdr_field", "dst_hdr_expr", "dst_hdr_field", "mh_hdr_expr",
  "mh_hdr_field", "exthdr_exists_expr", "exthdr_key", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-1793)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1024)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -1793,  3532, -1793,   640, -1793, -1793,   146,   183,   183,   183,
    1249,  1249,  1249,  1249,  1249,  1249,  1249,  1249, -1793, -1793,
    3867,   295,  2035,   299,  2398,   205,  3616,   770,  2267,   217,
    6885,    98,   257,   210, -1793, -1793, -1793, -1793,   209,  1249,
    1249,  1249,  1249, -1793, -1793, -1793,   955, -1793,   183, -1793,
     183,   105,  6456, -1793,   640, -1793,    24,    45,   640,   183,
   -1793,    77,   112,  6456,   183, -1793,   -65, -1793,   183, -1793,
   -1793,  1249, -1793,  1249,  1249,  1249,  1249,  1249,  1249,  1249,
     415,  1249,  1249,  1249,  1249, -1793,  1249, -1793,  1249,  1249,
    1249,  1249,  1249,  1249,  1249,  1249,   437,  1249,  1249,  1249,
    1249, -1793,  1249, -1793,  1249,  1249,  1249,  1249,  1249,  1249,
    1137,  1249,  1249,  1249,  1249,  1249,   522,  1249,  1249,  1249,
     382,  1249,  1311,  1626,  1726,  1795,  1249,  1249,  1249,  1804,
   -1793,  1249,  1808,  2279,  1249, -1793,  1249,  1249,  1249,  1249,
    1249,   405,  1249, -1793,  1249, -1793,   869,   584,   324,   342,
   -1793, -1793, -1793, -1793,   328,  1095,  1038,  2309,  3067,  1251,
     194,  2831,  1247,   930,    58,   768,   589,   947,  2970,   135,
     487,  1425,   224,   314,   667,   100,   868,   181,  1155,  4341,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793,  3968, -1793, -1793,    30,  6716,   244,   697,   733,  6885,
     183, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793,   975, -1793, -1793,
     283, -1793, -1793,   975, -1793, -1793, -1793, -1793,  1164, -1793,
   -1793, -1793,  1249,  1249,  1249,   -61, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793,   493,   504,   528, -1793, -1793, -1793,   228,
     350,   698, -1793, -1793, -1793,   508, -1793, -1793, -1793,    62,
      62, -1793,   161,   183,  8017,  2307,   388, -1793,    33,   529,
   -1793, -1793, -1793, -1793, -1793,   169,   627,   738, -1793,   603,
     714, -1793,   394,  6456, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,   862,
   -1793,   648, -1793, -1793, -1793,   441, -1793,  4976, -1793, -1793,
     709, -1793,   318, -1793,   375, -1793, -1793, -1793, -1793,   994,
   -1793,   132, -1793, -1793,   724, -1793, -1793, -1793,  1162,   790,
     761,   428, -1793,   804, -1793,  5981, -1793, -1793, -1793,   750,
   -1793, -1793, -1793,   784, -1793, -1793,  6320,  6320, -1793, -1793,
     121,   458,   465, -1793, -1793,   488, -1793, -1793, -1793,   496,
   -1793,   502,   817,  6456, -1793,    77,   112, -1793,   -65, -1793,
   -1793,  1249,  1249,  1249,   597, -1793, -1793, -1793,  6456, -1793,
     264, -1793, -1793, -1793,   266, -1793, -1793, -1793,   348, -1793,
   -1793, -1793, -1793,   485, -1793, -1793,   -65, -1793,   544,   534,
   -1793, -1793, -1793, -1793,  1249, -1793, -1793, -1793, -1793,   -65,
   -1793, -1793, -1793,   859, -1793, -1793, -1793, -1793,  1249, -1793,
   -1793, -1793, -1793, -1793, -1793,  1249,  1249, -1793, -1793, -1793,
     873,   880, -1793,  1249,   887, -1793,  1249, -1793,  1249, -1793,
    1249, -1793,  1249, -1793, -1793, -1793, -1793,  1249, -1793, -1793,
   -1793,  1249, -1793,  1249, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793,  1249, -1793,   183, -1793, -1793, -1793, -1793,   943,
   -1793, -1793, -1793, -1793, -1793,   977,   302, -1793, -1793,   688,
   -1793, -1793,   893,    64, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793,   275,   413, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793,  1080, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793,  2445, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793,  3411, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793,   490, -1793, -1793,   644,
   -1793, -1793, -1793, -1793, -1793, -1793,   677, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,  1409,
   -1793, -1793, -1793, -1793,   707,   604,   715,   952, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793,   737,   747, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793,   975, -1793, -1793, -1793, -1793,   -38,
     -30,   223,   158, -1793, -1793, -1793,  5177,   979,  7054,  6885,
     890, -1793, -1793, -1793, -1793,  1073,  1111,    83,  1085,  1088,
    1090,    87,  1105,  1409,  1110,  7054,  7054,   921,  7054, -1793,
   -1793,  1016,  6885,   912,  7054,  7054,  1096,  1296, -1793,  6050,
     133, -1793,  1296, -1793, -1793, -1793,   829, -1793,  1070,  1093,
     862, -1793, -1793,   872,  1296,  1109,  1127,  1140,  1296,   648,
   -1793, -1793,   103, -1793, -1793,  7054, -1793,  5378,  1106,  1095,
    1038,  2309,  3067, -1793,  2831,   705, -1793, -1793, -1793,  1161,
   -1793, -1793, -1793, -1793,  7054, -1793,  1272,  1240,  1245,   902,
     889,   671, -1793, -1793, -1793, -1793,  1262,  1133,  1271, -1793,
   -1793, -1793, -1793,  1273, -1793, -1793, -1793, -1793,   248, -1793,
   -1793,  1276,  1278, -1793, -1793, -1793,  1188,  1190, -1793, -1793,
     709, -1793, -1793,  1309, -1793, -1793, -1793, -1793,  1325, -1793,
   -1793,  5579, -1793,  1325, -1793, -1793, -1793,    86, -1793, -1793,
     994, -1793,  1334, -1793,   183, -1793,   980, -1793,   183,  7893,
    7893,  7893,  7893,  7893,  6885,   162,  7255, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793,  7893, -1793, -1793, -1793, -1793, -1793, -1793, -1793,   756,
   -1793,  1328,  1330,  1343,   993,   396,  1351, -1793, -1793, -1793,
    7255,  7054,  7054,  1261,   134,   640,  1358, -1793,   876,   640,
    1265, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
    1340,  1029,  1042,  1050, -1793,  1055,  1063, -1793, -1793, -1793,
   -1793,  1139,  1078,  1007,  1296, -1793, -1793,  1332,  1345,  1348,
    1362, -1793,  1370,  1077, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793,  1376, -1793, -1793, -1793, -1793, -1793,  1249, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793,  1384,   584, -1793, -1793, -1793, -1793,
    1386, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,   778,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793,  1394, -1793,  1317, -1793, -1793,  1319,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,  1221,
   -1793,  1238,  1381, -1793, -1793,   895,  1591,  1469,  1469, -1793,
   -1793, -1793,  1299, -1793, -1793, -1793, -1793,  1304,  1305, -1793,
    1307,  1314,  1308,   233, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793,  1431, -1793, -1793,  1442, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,  1333,
   -1793,  1341, -1793, -1793, -1793, -1793, -1793, -1793, -1793,  1444,
    1446,  1217, -1793, -1793, -1793, -1793, -1793,  1453,   215, -1793,
   -1793, -1793,  1201,  1202,  1204,  1459, -1793, -1793,   921, -1793,
   -1793, -1793,  1460, -1793, -1793, -1793, -1793,  7054,  3067,  2831,
    1558,  5780, -1793,   132,   118,  1557,  3308,  1296,  1296,  1464,
    6885,  7054,  7054,  7054, -1793,  1467,  7054,  1519,  7054, -1793,
   -1793, -1793, -1793,  1473, -1793,   113,  1554, -1793, -1793,   252,
     439,   604, -1793,   672,   721,   157,  1535, -1793,  7054, -1793,
   -1793,   714,  1470,   838,   199, -1793,   995,  1351,   714, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793,  1433,   239, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,   956,  1025,
   -1793,  1033, -1793, -1793,  7054,  1574,  7054, -1793, -1793, -1793,
     327,   449,  7054, -1793, -1793,  1226, -1793, -1793,  7054,  7054,
    7054,  7054,  7054,  1480,  7054,  7054,   164,  7054,  1325,  7054,
    1502,  1580,  1506,  3150,  3150, -1793, -1793, -1793,  7054,  1133,
    7054,  1133, -1793,  1569,  1570, -1793,   912, -1793,  6885,  1250,
   -1793, -1793,  1328,  1330,  1343, -1793,   714, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793,  1244,  7893,  7893,  7893,  7893,  7893,  7893,
    7893,  7893,  7941,  7893,  7893,   779, -1793,   964, -1793, -1793,
   -1793, -1793, -1793,  1505, -1793,   785,  1066, -1793,  2997,  3702,
    1103,   777,   408, -1793, -1793, -1793, -1793, -1793, -1793,  1254,
    1257,  1259, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793,  1597, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793,  3308, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793,  1264,  1267, -1793,
   -1793, -1793, -1793, -1793, -1793,  1217,   474,  1521, -1793, -1793,
   -1793, -1793, -1793,  1372, -1793, -1793, -1793,  1336,  2013, -1793,
    1473,  2005, -1793,   622,   113, -1793,   639, -1793, -1793,  7054,
    7054,  1622, -1793, -1793,  1527,  1527, -1793,   118, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793,  1280,  1557,  6456,
     118, -1793, -1793, -1793, -1793, -1793, -1793,  7054, -1793, -1793,
   -1793,   143,  1335,  1344,  1613, -1793, -1793, -1793,  1337,    86,
   -1793,  6885,    86,  7054,  1600, -1793,  7845, -1793,  1457,  1363,
    1350,  1007,   838, -1793,  1527,  1527, -1793,   616, -1793,  6050,
   -1793,  4708, -1793, -1793, -1793, -1793,  1649, -1793, -1793,  1400,
   -1793, -1793,  1400, -1793,  1587,  1400, -1793, -1793,  7054, -1793,
   -1793, -1793, -1793, -1793,  1272,  1240,  1245, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793,  1654,  7054,  1497,  7054, -1793, -1793,
   -1793, -1793,  1133, -1793,  1133,  1325, -1793, -1793,   235,  6885,
    6098,   140, -1793, -1793, -1793,  1358,  1662, -1793, -1793,  1328,
    1330,  1343, -1793,   166,  1358, -1793, -1793,   995,  7893,  7941,
   -1793,  1573,  1645, -1793, -1793, -1793, -1793, -1793,   183,   183,
     183,   183,   183,  1582,   443,   183,   183,   183,   183, -1793,
   -1793, -1793,   640, -1793,    88, -1793,  1601, -1793, -1793, -1793,
     640,   640,   640,   640,   640,  7641, -1793,  1527,  1527,  1346,
    1414,  1603,   713,  1148,  1520, -1793,  1393,  1007, -1793, -1793,
   -1793,   640,   640,   640,   332, -1793,  7641,  1527,  1527,  1356,
     713,  1148, -1793, -1793, -1793,   640,   640,   332,  1609,  1364,
    1618, -1793, -1793, -1793, -1793, -1793,  3418,  4041,  2634,  2833,
     963, -1793, -1793, -1793, -1793, -1793, -1793, -1793,  1023, -1793,
   -1793,  1615, -1793, -1793, -1793,  1714, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793,  1620, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793,   819,   766,   481,  1628, -1793, -1793, -1793,
   -1793, -1793,  1335,  1344, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793,  1337, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793,  7054, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
    6885,  1377,   118, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
    1436,  1712, -1793,  1632, -1793,  1635, -1793,  1436,  1637, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793,  7054,    62,    62,   714,
    1351, -1793,    92,  1640, -1793,   921,  1650, -1793, -1793, -1793,
     838, -1793, -1793, -1793,   640, -1793,   239, -1793, -1793, -1793,
   -1793, -1793, -1793,  7054, -1793,  1669, -1793,  1325,  1325,  6885,
   -1793,   385,  6456,  1749,   714, -1793,  1358,  1358,  1568,  1657,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793,   183,   183,   183, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793,  1659, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793,  1766, -1793,   640,   640,   -65, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,  1773, -1793,
   -1793, -1793, -1793, -1793,  1028, -1793, -1793, -1793, -1793, -1793,
   -1793,   581,   640,   640,   -65,   864,  1028, -1793, -1793, -1793,
    1641,   201,   640, -1793, -1793, -1793, -1793, -1793, -1793,  1501,
    2546,  1141, -1793, -1793, -1793,  1682, -1793,  1217, -1793, -1793,
    1441,   346,  1249, -1793, -1793, -1793, -1793, -1793,  1527,  1694,
     346,  1695,  1249, -1793, -1793, -1793, -1793, -1793,  1696,  1249,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793,  6456, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793,  1512, -1793,   182, -1793, -1793, -1793,   113,
   -1793, -1793, -1793, -1793, -1793, -1793,  1699,  1516,  1473,   113,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793,  7054,  1455,  6885,
   -1793,  1456,  1686,  6098, -1793, -1793,  1629,   640,  1461,  1472,
    1476,  1477,  1478, -1793, -1793, -1793,  1482,  1483,  1484,  1489,
   -1793,  1774,  7641, -1793, -1793, -1793, -1793,   713, -1793,  1148,
   -1793,  7396, -1793, -1793, -1793,   615, -1793,   321,   640,    68,
     640, -1793, -1793, -1793, -1793, -1793, -1793,  1818, -1793,  1491,
   -1793, -1793,   640,   640, -1793,   640,   640,   640,   640,   640,
   -1793,  1715,   640, -1793,  1494, -1793, -1793, -1793, -1793, -1793,
    1745,  1335,  1344,  1337, -1793, -1793, -1793, -1793,  1496, -1793,
     714, -1793, -1793,  1568, -1793, -1793, -1793, -1793, -1793,  1499,
    1517,  1518, -1793, -1793, -1793, -1793,  1758, -1793, -1793, -1793,
   -1793,  7641, -1793,  2237, -1793, -1793, -1793, -1793, -1793, -1793,
     640,  1859, -1793,   640,  1869, -1793,   640,   713,  1777, -1793,
   -1793, -1793,   978, -1793, -1793, -1793, -1793, -1793, -1793,   142,
   -1793, -1793, -1793, -1793, -1793, -1793,  1615, -1793,  1778, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,   346, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,  1629,  1243,
    4380,  2734,  3079,  2192, -1793, -1793, -1793,  2253,  2356,  1071,
    1224,  1471, -1793,  1766, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793,  7641, -1793, -1793,   960, -1793,  1781,  1783,   139,
   -1793, -1793,  1881,   147, -1793,   640, -1793, -1793, -1793, -1793,
   -1793,   640,   640,   640,   640,   640,  1959,  2682,  1160,   640,
     640,   640,   640,   177,  1536,  1641, -1793,  1869, -1793, -1793,
   -1793, -1793, -1793, -1793,  1415,  1778,   640, -1793, -1793, -1793,
   -1793, -1793, -1793,   640,   640,   640, -1793, -1793, -1793, -1793,
   -1793, -1793,   201, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     1,     0,     4,     5,     0,     0,     0,     0,
     409,   409,   409,   409,   409,   409,   409,   409,   413,   416,
     409,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   206,   415,     9,    25,    26,     0,   409,
     409,   409,   409,    65,    64,     3,     0,    68,     0,   410,
       0,   434,     0,    63,     0,   402,     0,     0,     0,     0,
     589,    83,    85,     0,     0,   262,     0,   285,     0,   315,
      69,   409,    70,   409,   409,   409,   409,   409,   409,   409,
       0,   409,   409,   409,   409,    71,   409,    72,   409,   409,
     409,   409,   409,   409,   409,   409,     0,   409,   409,   409,
     409,    73,   409,    74,   409,   440,   409,   440,   409,   440,
     440,   409,   409,   440,   409,   440,     0,   409,   440,   440,
       0,   409,   440,   440,   440,   440,   409,   409,   409,   440,
      32,   409,   440,   440,   409,    44,   409,   409,   409,   409,
     440,     0,   409,    77,   409,    78,     0,     0,     0,   744,
     714,   403,   404,   405,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     924,   925,   926,   927,   928,   929,   930,   931,   932,   933,
     934,   935,   936,   937,   938,   939,   940,   941,   942,   943,
     945,     0,   947,   946,     0,     0,     0,     0,    31,     0,
       0,    82,   710,   709,   727,   728,   729,   221,   724,   725,
     718,   915,   719,   722,   726,   723,   720,   721,   715,  1029,
    1030,  1031,  1032,  1033,  1034,  1035,  1036,  1037,  1038,  1039,
    1040,  1041,  1042,    50,  1044,  1045,  1046,   716,  1256,  1257,
    1258,  1259,  1260,  1261,  1262,  1263,   717,     0,   218,   219,
       0,    30,   202,     0,    19,   204,   207,    36,   208,   414,
     411,   412,   409,   409,   409,    13,   839,   812,   814,    67,
      66,   417,   419,     0,     0,     0,   436,   435,   437,     0,
     580,     0,   697,   698,   699,     0,   906,   907,   908,   488,
     489,   911,   704,     0,     0,     0,   504,   511,     0,   534,
     558,   570,   571,   646,   652,   673,     0,     0,   951,     0,
       7,    88,   442,   444,   455,   456,   457,   458,   459,   486,
     468,   445,    58,   241,   483,   464,   492,   463,    13,   502,
      56,   509,   461,   462,    43,   561,    37,     0,    51,    57,
     578,    37,   645,    37,   651,    16,    22,   474,    42,   671,
     480,     0,   481,   466,     0,   703,   465,   746,   749,   751,
     753,   755,   756,   763,   765,     0,   764,   707,   491,   915,
     469,   475,   467,   715,   484,    59,     0,     0,    62,   428,
       0,     0,     0,    87,   422,     0,    91,   278,   277,     0,
     425,     0,     0,     0,   589,   108,   110,   262,     0,   285,
     315,   409,   409,   409,    13,   839,   812,   814,     0,    57,
       0,   132,   133,   134,     0,   126,   127,   135,     0,   128,
     129,   136,   137,     0,   130,   131,     0,   138,     0,   140,
     141,   816,   817,   815,   409,    13,    33,    41,    48,     0,
      57,   183,   441,   185,   150,   151,   152,   153,   409,   154,
     156,   180,   179,   178,   172,   409,   440,   176,   175,   177,
     816,   817,   818,   409,     0,    13,   409,   157,   409,   160,
     409,   163,   409,   169,    33,    41,    48,   409,   166,    75,
      13,   409,   187,   409,   190,    41,    76,   193,   194,   195,
     196,   199,   409,   198,     0,  1052,  1049,  1050,    53,     0,
     735,   736,   737,   738,   739,   741,     0,   956,   958,     0,
     957,    49,     0,     0,  1254,  1255,    53,  1054,  1055,    52,
      18,    52,  1058,  1059,  1060,  1061,    27,     0,     0,  1064,
    1065,  1066,  1067,  1068,     9,  1086,  1087,  1081,  1076,  1077,
    1078,  1079,  1080,  1082,  1083,  1084,  1085,     0,    25,    52,
    1101,  1100,  1099,  1102,  1103,  1104,    28,    52,  1107,  1108,
    1109,    29,  1118,  1119,  1111,  1112,  1113,  1115,  1114,  1116,
    1117,    26,    52,  1126,  1123,  1122,  1127,  1125,  1124,  1128,
      28,  1131,  1134,  1130,  1132,  1133,     8,  1137,  1136,    17,
    1139,  1140,  1141,    11,  1145,  1146,  1143,  1144,    54,  1151,
    1148,  1149,  1150,    55,  1165,  1159,  1162,  1163,  1157,  1158,
    1160,  1161,  1164,  1166,     0,  1152,    52,  1198,  1199,    14,
    1252,  1249,  1250,     0,  1251,    46,    52,    25,  1269,   983,
      26,  1268,  1271,   981,   982,    31,     0,    45,    45,     0,
      45,  1275,    45,  1278,  1277,  1279,     0,    45,  1266,  1265,
      24,  1287,  1284,  1282,  1283,  1285,  1286,    21,  1290,  1289,
      15,    52,  1293,  1296,  1292,  1295,    35,    34,   919,   920,
     921,    48,   922,    31,    34,   917,   918,   998,   999,  1005,
     991,   992,   990,  1000,  1001,  1021,   994,  1003,   996,   997,
    1002,   993,   995,   988,   989,  1019,  1018,  1020,    48,     0,
      12,  1006,   962,   961,     0,   763,     0,     0,    45,    24,
      21,    15,    35,  1297,   966,   967,   944,   965,     0,   708,
    1043,   201,   220,    79,   203,    80,    81,   209,   210,   212,
     211,   214,   215,   213,   216,   836,   836,   836,    93,     0,
       0,   534,     0,   431,   432,   433,     0,     0,     0,     0,
       0,   913,   912,   909,   910,     0,     0,     0,    34,    34,
       0,     0,     0,     0,    12,     0,     0,   542,     0,   532,
     533,     0,     0,     0,     0,     0,     0,     0,     6,     0,
       0,   767,     0,   443,   446,   485,     0,   460,     0,     0,
     503,   505,   470,     0,     0,     0,     0,     0,     0,   510,
     512,   471,     0,   557,   472,     0,    44,     0,     0,    18,
      27,     9,    25,   877,    26,     0,   881,   879,   880,     0,
      37,    37,   867,   868,     0,   607,   610,   612,   614,   616,
     617,   622,   627,   625,   626,   628,   630,   569,   594,   595,
     605,   869,   596,   603,   597,   604,   600,   601,     0,   598,
     599,     0,   629,   602,   473,   482,     0,     0,   586,   585,
     579,   581,   476,     0,   664,   665,   666,   644,   649,   662,
     477,     0,   650,   655,   478,   479,   667,     0,   689,   690,
     672,   674,   677,   687,     0,   712,     0,   711,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   899,   900,   901,
     902,   903,   904,   905,    18,    27,     9,    25,    28,   892,
      26,    28,     8,    17,    11,    54,    55,    50,    14,    46,
      37,     0,   882,   852,   883,   760,   761,   864,   851,   841,
     840,   856,   858,   860,   862,   863,   850,   884,   885,   853,
       0,     0,     0,     0,     7,     0,   806,   805,   863,     0,
       0,   371,    57,   225,   242,   265,   297,   316,   438,   107,
       0,     0,     0,     0,   114,     0,     0,   836,   836,   836,
     116,     0,     0,   534,     0,   125,   148,     0,     0,     0,
       0,   139,     0,     0,   836,   143,   146,   144,   147,   149,
     171,     0,   186,   155,   174,   173,    12,   409,   159,   158,
     161,   164,   170,   165,   162,   168,   167,   189,   188,   191,
     192,   197,   200,  1051,     0,     0,    52,   732,   733,    20,
       0,   954,   745,    39,    39,  1253,  1056,  1053,  1062,  1057,
      18,    25,    18,    25,  1063,  1088,  1089,  1090,  1091,    25,
    1073,  1098,  1097,  1106,  1105,  1110,  1121,  1120,  1129,  1135,
    1138,  1142,  1147,    10,  1183,  1189,  1187,  1178,  1179,  1182,
    1184,  1173,  1174,  1175,  1176,  1177,  1185,  1180,  1181,  1186,
    1154,  1188,  1153,  1200,  1197,  1204,  1201,  1202,  1203,  1205,
    1206,  1207,  1208,  1209,  1210,  1211,  1212,  1213,  1214,  1215,
    1216,  1217,  1218,  1235,    47,  1247,  1270,   977,   978,   984,
      45,   979,  1267,     0,  1272,  1274,     0,  1276,  1264,  1281,
    1288,  1294,  1291,   916,   923,   914,  1004,  1007,  1008,     0,
    1010,     0,  1009,  1011,  1012,    12,    12,  1013,   985,     0,
       0,   959,  1299,  1298,  1300,  1301,  1302,     0,     0,   730,
     205,   217,     0,     0,     0,     0,   336,    13,   542,   361,
      33,   341,     0,    41,   366,   813,    48,     0,    25,    26,
     572,     0,    57,     0,   691,   693,     0,     0,     0,     0,
       0,     0,     0,     0,    12,     0,     0,  1013,     0,    13,
      33,   540,   541,     0,    41,     0,     0,   686,    42,   681,
     680,     0,   685,   683,   684,     0,   658,   660,     0,   487,
     780,     7,     7,   782,   776,   779,   863,   802,     7,   766,
     439,   250,   507,   508,   506,   525,    18,     0,     0,   523,
     519,   514,   515,   516,   517,   520,   518,   513,     0,     0,
      50,     0,   636,   878,     0,   631,     0,   870,   873,   874,
     871,   872,     0,   876,   875,     0,   594,   603,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   638,     0,
       0,     0,     0,     0,     0,   583,   584,   582,     0,     0,
       0,   653,   676,   681,   680,   675,     0,    10,     0,     0,
     747,   748,   750,   752,   754,   757,     7,   493,   495,   762,
     871,   891,   872,   893,   890,   889,   894,   887,   888,   886,
     895,   896,   897,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   847,   846,   863,   949,  1028,
     808,   807,    60,     0,    61,     0,     0,   105,     0,     0,
       0,     0,     0,    57,   225,   242,   265,   297,   316,     0,
       0,     0,    13,    33,    41,    48,   429,   418,   420,   423,
     426,   316,    12,   184,   181,    12,     0,   740,   734,   731,
      49,   742,   743,  1069,  1071,  1070,  1072,    52,  1093,  1095,
    1094,  1096,  1075,    25,     0,  1195,  1167,  1192,  1169,  1196,
    1172,  1193,  1194,  1170,  1190,  1191,  1168,  1171,  1232,  1231,
    1233,  1234,  1240,  1222,  1223,  1224,  1225,  1237,  1226,  1227,
    1228,  1229,  1230,  1238,  1239,  1241,  1242,  1243,  1244,  1245,
    1246,    52,  1221,  1220,  1236,    46,   980,     0,     0,    25,
      25,    26,    26,   986,   987,   959,   959,     0,    23,   964,
     968,   969,    31,     0,   351,   356,   346,     0,     0,    94,
       0,     0,   101,     0,     0,    96,     0,   103,   574,     0,
       0,   573,   452,   694,     0,     0,   787,   692,   783,  1183,
    1187,  1182,  1186,  1188,    50,    10,    10,     0,   775,     0,
     773,    34,    34,    12,   500,    12,    12,     0,    12,   449,
     450,     0,   543,   546,     0,   451,   536,   535,   537,     0,
     668,     0,     0,     0,     0,   770,     0,   771,     0,    13,
       0,   534,   781,   790,     0,     0,   801,   777,   788,   769,
     768,     0,   524,    25,   528,   529,    50,   527,   559,     0,
     563,   560,     0,   565,     0,     0,   567,   637,     0,   641,
     643,   606,   608,   609,   611,   613,   615,   623,   624,   618,
     621,   620,   619,   633,   632,     0,     0,     0,  1022,  1023,
    1024,  1025,   647,   663,   654,   656,   688,   713,     0,     0,
       0,     0,   496,   898,   849,   843,     0,   854,   855,   857,
     859,   861,   848,   758,   842,   759,   865,   866,     0,     0,
     758,     0,     0,    57,   373,   372,   375,   374,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    84,
     227,   226,     0,   224,     0,    52,     0,    86,   244,   243,
       0,     0,     0,     0,     0,     0,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   504,     0,   534,    89,   267,
     266,     0,     0,     0,     0,   447,     0,     0,     0,     0,
       0,     0,    90,   299,   298,     0,     0,     0,     0,     0,
       0,    13,    92,   318,   317,   124,     0,     0,     0,     0,
       0,   351,   356,   346,   117,   122,   118,   123,     0,   145,
     182,     0,   955,  1092,  1074,     0,  1219,  1248,  1273,  1280,
    1014,  1015,  1016,  1017,    38,     0,    23,   960,   976,   972,
     971,   970,    31,     0,     0,     0,     0,    13,   338,   337,
     340,   339,   543,   546,    33,   363,   362,   365,   364,    41,
     343,   342,   345,   344,   537,    48,   368,   367,   370,   369,
     575,   577,     0,   406,   785,   786,   784,  1156,   953,   952,
       0,     0,   774,   950,   948,   453,   501,   454,    12,  1026,
       0,   548,   550,     0,    33,     0,    33,     0,     0,    41,
     682,   678,   679,    42,    42,   659,     0,     0,     0,     7,
     803,   804,     0,     0,   792,   542,     0,   791,   799,   800,
     778,   789,   490,   251,     0,   522,     0,   521,    52,    52,
      44,    52,   634,     0,   640,     0,   642,   648,   657,     0,
     695,     0,     0,     0,     7,   494,   845,   844,   590,     0,
     106,   430,   335,   421,   241,   424,   262,   285,   427,   315,
     223,     0,     0,     0,   335,   335,   335,   335,   228,   400,
     401,    40,   399,   398,     0,   396,   245,   247,   246,   249,
     248,   260,   263,   259,     0,     0,     0,   314,   313,    40,
     312,   376,   378,   379,   377,   332,   380,   333,    52,   331,
     281,   282,   284,   283,     0,   280,   268,   275,   276,   272,
     448,     0,     0,     0,     0,     0,     0,   310,   309,   307,
       0,     0,     0,   321,   109,   111,   112,   113,   115,     0,
       0,     0,   142,  1047,    10,     0,   963,   959,   975,   973,
       0,     0,     0,    12,   353,   352,   355,   354,     0,     0,
       0,     0,     0,    12,   358,   357,   360,   359,     0,     0,
      12,   348,   347,   350,   349,   809,    95,   837,   838,   102,
      97,   811,   104,   576,     0,   705,  1027,   552,   553,   554,
     555,   556,   545,     0,   530,     0,   547,   531,   549,     0,
     539,   669,   670,   661,   772,    12,     0,     0,     0,     0,
     252,   526,    28,    28,   568,   566,   635,     0,     0,     0,
     696,     0,     0,   498,   497,   591,   592,     0,     0,     0,
       0,     0,     0,   335,   335,   335,     0,     0,     0,     0,
     397,     0,     0,   270,   271,   273,   311,     0,   264,     0,
     269,     0,   300,   301,   308,   296,   306,     0,     0,     0,
       0,   324,   322,    12,    12,    12,  1048,     0,    23,     0,
      54,    50,     0,     0,    99,     0,     0,     0,     0,     0,
     100,     0,     0,    98,     0,   544,   551,   538,   796,    12,
       0,   543,   546,   537,   562,   564,   639,   700,     0,   702,
       7,   593,   587,   590,   371,   242,   265,   297,   316,     0,
       0,     0,   336,   361,   341,   366,     0,   261,   334,   279,
      57,     0,   258,     0,    13,    33,    41,    48,   257,   256,
       0,     0,   293,     0,   253,   295,     0,     0,     0,   390,
     384,   383,   387,   382,   385,   386,   319,   329,   328,     0,
     325,   330,   320,   120,   121,   119,     0,   974,     0,   822,
     821,   828,   830,   833,   834,   831,   832,   835,     0,   824,
     706,   797,    13,    33,    33,    41,   701,   499,   592,     0,
       0,     0,     0,     0,   351,   356,   346,     0,     0,     0,
       0,   395,   292,   255,   286,   287,    12,   288,   290,   289,
     291,   303,     0,   305,    52,     0,   391,     0,     0,     7,
     323,  1155,     0,     0,   825,     0,   793,   794,   795,   798,
     588,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   294,   254,   304,    52,
     389,   388,   327,   326,     0,     0,     0,    52,    57,   229,
     230,   231,   232,     0,     0,     0,    13,    33,    41,    48,
     392,   393,     0,   381,   302,   407,   408,   827,   826,    40,
     823,   240,    12,    12,    12,   233,   238,   234,   239,   394,
     829,   236,   237,   235
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1793, -1793,    -1, -1134,   970,    71, -1191,   969,  -754,  -329,
     971,  1177, -1793,   988,  -454, -1793, -1793,  1183, -1793, -1542,
    1193,   -12,   -23,  1380,  -575, -1793, -1793,  -627, -1793,  -449,
    -616,  1191, -1793,  -246, -1793,   883, -1717,  -413, -1099, -1793,
    -756,  -519,  -827, -1793,  -483,   550,  -868, -1793,  -433,  1396,
    -895,  1003, -1793,  -418, -1793,    11, -1793, -1793,  1911, -1793,
   -1793, -1793, -1793, -1793,  1838,  1810, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
      54, -1793,  1528, -1793,   593,  -326, -1276, -1793, -1793, -1793,
   -1792, -1518,  -394, -1793, -1265,  -397,   288,   -59,  -401, -1793,
     -63, -1793, -1793, -1260, -1279, -1793,  -393, -1269,  -269, -1793,
    -213,   -49, -1537,  -780,  -112,  -113, -1561, -1557, -1555,  -108,
    -106,   -97, -1793, -1793,  -223, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793,   128,  -704, -1392, -1793,  1874,   -82,  3219,
   -1793,  1634, -1793, -1793,   155, -1793,   366,   762, -1793, -1793,
    2333, -1793,  -281,  1567, -1793, -1793,   192,  1879,   156,    97,
     -47, -1793, -1793, -1292, -1793, -1793, -1793, -1793, -1793, -1793,
   -1270,  -302, -1793, -1793, -1793, -1793, -1793, -1793, -1793,   167,
   -1793, -1793, -1793, -1793,  1175, -1793, -1793, -1793,  1169, -1793,
   -1793, -1793,   195, -1793,  -283, -1345, -1579, -1793, -1067, -1560,
   -1349, -1562, -1342,   227,   226, -1793, -1793,  -962, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793,  1115,  -297,  1586,   -62,  -136,
    -245,   734,   740,   741, -1793,  -723, -1793, -1793, -1793, -1793,
   -1793, -1793,  1786, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793,  -325,   716, -1793, -1793, -1793, -1793,  1112,   500,
    -792,   507,  1228,   727, -1194, -1793, -1793,  1724, -1793, -1793,
   -1793, -1793, -1793,   -60,  1215,  -765,  -295,  1889, -1522,  1986,
   -1793, -1793, -1793,   992,    -8, -1793, -1793, -1793, -1793, -1793,
    -119,  -185, -1793, -1793,   695,  -718,  1825,   -56, -1793,   818,
   -1346, -1793, -1443, -1793, -1793,   557, -1308, -1793,   527, -1337,
     531, -1793, -1793,  1652,  -570,  1638,  -557,  1639,  -538,  1644,
    1931, -1793, -1733, -1793, -1793,  -141, -1793, -1793,   -42,  -516,
    1643, -1793,  -356,  -278,  -786,  -784,  -773, -1793,  -312,  -751,
   -1793,   -20,  1593,  -757, -1793, -1396,  -296,     4,  1752, -1793,
       2, -1793,    95, -1793, -1315, -1793,   258, -1793, -1793, -1793,
   -1793, -1793,   260,  -228,   298,  1419,   310,  1761,  1762, -1793,
   -1793,  -404,   253, -1793, -1793, -1793,   684,   -37, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793,  1447,  -930, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793,   982, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793,
   -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793, -1793
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,  1663,   789,  1058,  1249,  1384,  1060,  1138,   748,
    1084,  1120,   884,  1059,  1247,   735,  1369,  1119,   885,  1698,
    1118,  1300,  1302,  1248,  1052,  1054,   733,   726,   489,   996,
    1123,  1122,   736,   814,  1896,  1371,  1990,   997,   886,   811,
     496,  1111,  1105,  1425,   998,  1031,   730,   864,  1036,  1023,
    1061,  1062,   802,   865,   795,  1664,    45,    46,    47,    72,
      85,    87,   423,   427,   432,   419,   101,   103,   130,  1002,
     451,   135,   143,   145,   261,   264,   267,   268,   744,  1150,
     262,   211,   391,  1612,  1338,   392,  1339,  1521,  2079,  2080,
    1841,  1842,   395,  1641,  1340,   396,  1864,  1865,   399,  2146,
    2082,  2083,  2087,  1341,  1642,  1849,   401,  1342,  2010,  2099,
    2100,  1857,  1858,  1978,  1448,  1453,  1705,  1703,  1704,  1451,
    1456,  1336,  1859,  1620,  2008,  2092,  2093,  2094,  2185,  1621,
    1622,  1831,  1832,  1811,   212,  1734,  2217,    48,    49,    59,
     426,    51,   430,  1814,   434,   435,  1816,    69,   440,  1819,
     421,   422,  1812,   286,   287,   288,    52,   403,  1466,   453,
    1624,   322,   323,  1644,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,  1297,  1571,  1572,
     337,   338,   339,   800,   801,   340,   341,   809,   810,  1236,
    1230,  1526,  1527,   342,  1162,  1498,  1759,   343,  1193,  1754,
    1492,  1756,  1493,  1494,  1942,   344,   345,  1530,   813,   346,
     347,   348,   349,   350,   870,   871,  1597,   390,  1976,  2052,
     835,   836,   837,   838,   839,   840,   841,  1550,   842,   843,
     844,   845,   846,   847,   351,   352,   877,   353,   354,   882,
     355,   356,   878,   879,   357,   358,   359,   890,   891,  1196,
    1197,  1198,   892,   893,  1173,  1174,   360,   361,   362,   363,
     364,   365,   366,   213,   848,   896,   933,   849,   216,   367,
     218,  1029,   515,   516,   850,   523,   368,   369,   370,   371,
     372,   373,   935,   936,   937,   374,   375,   376,   790,   791,
    1479,  1480,  1212,  1213,  1214,  1467,  1468,  1517,  1512,  1513,
    1518,  1215,  1769,   955,  1711,   749,  1723,   751,  1729,   752,
     444,   474,  2022,  1924,  2163,  2164,  1907,  1917,  1152,  1718,
     750,   377,   956,   957,   941,   942,   943,   944,  1216,   946,
     851,   852,   853,   949,   950,   378,   763,   854,   684,   685,
     221,   380,   855,   521,  1438,   714,   856,  1148,   727,  1442,
    1702,   224,   857,   646,   859,   647,   860,   709,   710,  1135,
    1136,   711,   861,   862,   381,   382,   863,  1894,   229,   509,
     230,   530,   231,   536,   232,   544,   233,   558,  1049,  1383,
     234,   566,   235,   571,   236,   581,   237,   590,   238,   596,
     239,   599,   240,   603,   241,   608,   242,   613,   243,   384,
     625,  1080,  1473,  1082,  1396,  1388,  1393,  1386,  1390,   244,
     629,  1103,  1424,  1407,  1413,  1402,  1104,   245,   635,   246,
     526,   247,   248,   660,   249,   648,   250,   650,   251,   652,
     252,   657,   253,   667,   254,   670,   255,   676,   256,   723
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      43,   986,    53,  1015,   764,   321,   397,   796,   975,   797,
     398,   974,    44,   973,   271,  1057,   393,   976,  1109,   939,
     715,   794,   219,   452,   270,   452,   781,   452,   452,   883,
    1307,   452,  1000,   452,   220,  1013,   452,   452,  1217,   991,
     452,   452,   452,   452,   219,   280,   993,   452,  1165,  1657,
     452,   452,   999,   385,   379,   219,   220,   388,   452,  1309,
    1243,   757,  1655,   945,  1202,   379,   897,   220,  1125,  1667,
    1645,  1645,  1014,  1735,   958,   958,  1037,  1505,  1507,  1670,
     972,  1668,  1020,  1209,  1519,   980,   265,  1669,  1220,   786,
     728,  1450,  1678,   962,  1568,  1282,  1567,   940,  1038,  1500,
    1231,  1712,  1311,  1843,  1235,   872,   269,   880,  1713,  1724,
    1771,  1255,  1891,  1875,  1889,  1292,   995,  1890,  1293,   858,
    1694,  1696,  1778,  1779,  1843,   222,  1051,  1803,  1871,  1112,
    1294,  1114,  1996,  1115,  1053,    56,    57,    58,  1117,   788,
    1298,  1218,  1290,  1291,   788,  1931,  1008,   222,  1804,  1056,
    2159,  1928,  1927,  1125,  1898,  2195,   894,   257,   222,  1736,
     960,  1017,  1570,   283,  1750,  1286,    55,  1829,  1830,    65,
      66,    67,  2097,  2098,  -714,  1777,   281,  2027,   282,  1157,
    1179,   686,  -714,  -714,  -714,  -714,   894,   389,   894,   150,
    1184,  1033,   394,  1083,  1163,  1955,   400,   219,  1124,  1142,
    2067,   219,   597,  1106,   455,    63,   457,   459,  1464,   220,
     462,  1465,   464,   220,  1166,   468,   469,  1496,   598,   477,
     479,   481,   483,  1802,   765,  1126,   488,  -810,   658,   492,
     494,   407,   408,   409,  1160,  1844,  1845,   501,  1121,   762,
     762,  1799,  1501,  2097,  2098,  1238,  1474,  1751,   436,   626,
    1155,    54,  1364,   659,   782,  1872,  1873,   449,  1239,   102,
     766,  -709,   151,   152,   153,   144,   460,   461,  -709,  -709,
    -709,  -709,   467,  1158,  1240,  -678,  1801,  1533,   418,  1536,
    1165,   151,   152,   153,  1738,  1739,  2036,    55,   223,  1514,
     225,   320,  1515,   499,   500,  -810,   210,   503,  1645,   272,
     222,   895,   627,   628,   222,  1137,   686,  -709,   567,   668,
     223,   731,   225,   756,   266,   219,   263,   734,  1156,   938,
     776,   223,   987,   225,   988,   379,  1159,   220,   226,   568,
     938,   938,   783,  1269,   669,  1270,   777,     4,   729,     5,
     227,   637,   569,  1301,  2088,    71,  1303,  1421,   397,    86,
     226,  1034,   398,   712,   637,   947,   969,   517,   518,   519,
    2067,   226,   227,   713,  1422,   640,   947,   947,    55,  1187,
      55,   985,  1534,   227,  1870,  1440,   397,  1657,   640,   386,
     398,  1433,  1434,  1524,   452,  2165,  1040,  1870,  1525,   397,
    1655,  1969,  1185,   398,  1934,   219,  1423,  1956,  1645,  1645,
     387,  1041,  1497,   873,  1321,   379,   989,   220,  1463,     3,
     219,  1352,  -977,     4,  -977,     5,  1026,  1322,   222,  1323,
     379,  1241,   220,   210,  2089,  2090,  1354,   761,   761,   210,
    1484,   767,  1752,  -222,  1736,     6,     7,     8,     9,  1180,
     258,   259,   260,  1777,   284,   285,  1355,   210,  -728,   210,
    1658,   502,    55,  1659,  1685,  -728,  -728,  -728,  -728,   792,
     881,   649,  -679,   223,  2125,   225,  1353,   223,  -241,   225,
    1843,  1752,   470,  1475,  1476,   522,  2107,   961,   793,  2084,
    2124,  2123,     3,  2081,  1502,  1271,     4,   273,     5,   274,
    1219,  1331,   570,   210,  -728,   524,   525,  1805,   222,  2160,
     210,  1551,  2230,   226,  2196,   411,  1634,   226,     6,     7,
       8,     9,  2020,   222,  1164,   227,  2025,  2021,  1296,   227,
     320,  1635,  1268,   210,  1042,   210,  -714,   441,   779,   780,
    1803,  1870,  1579,  1821,  -978,  1580,  -978,  1636,   210,  1043,
     792,  1548,  1637,   990,  1337,  1272,  1050,  1581,   389,  1843,
    2155,   651,   281,  2143,  1027,  1028,   282,  2009,  1055,  1577,
    1578,   394,   210,  1005,  -977,  1441,   400,  1788,   465,   466,
    1789,  1660,   520,  1791,  1175,  2178,  2050,  2176,   717,  1161,
    2177,   223,  2018,   225,  1253,  1254,  1373,  2001,  1375,    55,
    1992,  1426,  1800,  1368,  1325,  1918,   753,  1201,  1687,   258,
     259,   260,   992,  1634,  2037,  1968,  1737,   754,  1679,  2041,
     897,  1680,  -709,   904,  2043,  1044,  2042,  1108,  1635,  1313,
    1004,   226,   630,     3,  -977,  1107,   732,     4,  1299,     5,
    2187,   755,  1022,   227,  1636,  1954,   639,   758,  1327,  1637,
       3,   874,   875,   876,     4,     4,     5,     5,    55,     6,
       7,     8,     9,  2070,   631,   632,  1634,  1021,  1787,   906,
     471,   223,   443,   225,  1951,  1952,     6,     7,     8,     9,
    1973,  1635,  1326,  1343,  2091,   775,   223,   472,   225,   760,
    1265,  -722,   210,  1457,  1312,   633,  -978,  1636,  -722,  -722,
    -722,  -722,  1637,   412,  1661,   413,   510,   511,   874,   875,
     876,   226,  2085,  2016,  1153,  1154,  1514,   787,  1958,  1515,
    1764,  1452,   784,   227,   228,   442,   226,   443,   634,   788,
     604,  1822,  1199,  1823,   605,  -534,  1266,  -722,   227,  1745,
    -723,  1746,  1747,  1211,  1749,   792,   383,  -723,  -723,  -723,
    -723,  1490,  1970,   151,   152,   153,  -978,   383,   866,   867,
    1455,   219,  1165,  1919,  1462,  1770,   606,   607,   812,   643,
     644,   292,   293,   220,  1314,  1662,   294,     3,  1217,   947,
     898,     4,  1522,     5,   219,  2048,  -723,  1315,     3,  2130,
     902,  1495,     4,  1202,     5,  1295,   220,  1314,   903,  2133,
       4,  2131,     5,     6,     7,     8,     9,  2132,  1151,  -728,
    1588,  1251,  2216,   951,     6,     7,     8,     9,   901,  1437,
    1250,   803,  1695,   904,   963,  1699,   778,  1851,  1646,  1217,
       3,   964,   792,   785,     4,  1591,     5,  1283,  1449,   905,
     653,   637,   512,   513,   779,   780,   514,   952,  1920,   645,
    1657,   410,  1852,  1853,   965,   895,     6,     7,     8,     9,
     938,   639,   966,  1655,   222,   640,  1908,   439,   967,   906,
    1489,  1645,  1645,  1909,   637,  1743,  1744,  1647,  1648,  1649,
    2005,  1630,  1677,  1997,  1631,   283,   463,   222,   897,   947,
     947,   947,   947,   947,  1321,  -810,   947,  1508,   640,   228,
    -315,  1650,  1377,   228,   938,   868,   219,  1333,   869,  1323,
    1910,  2074,  1509,  1001,  1675,   654,   655,   656,   220,  1378,
    1263,   947,  1264,  1900,  1379,  1380,  2127,  2075,  1510,  -819,
    1443,   600,  2076,  1511,  2077,  1665,  -820,   779,   780,   718,
     947,   601,   602,  1007,  1911,  1349,  1350,  1351,   719,   720,
    1651,  1676,   721,   722,  1683,   804,   805,   806,   807,   808,
    1225,  1024,  1362,  1901,  1332,   279,  1565,   792,  1334,  1575,
       4,  1854,     5,   792,     3,     4,  1584,     5,     4,  1997,
       5,   897,  1321,   505,   643,   644,   506,   507,   508,  1719,
     792,  1855,  1856,  1226,   661,  1589,  1025,  1323,  1686,  1030,
       6,     7,     8,     9,  1936,  1478,  1725,  1032,  1227,   222,
     662,  2157,  1574,  1576,  2158,  1658,  1113,   383,  1659,  1582,
    1576,  1585,  1587,  1542,  1543,  1381,  1333,   223,  1323,   225,
    1549,   663,  1287,  1674,     3,  2192,  1289,   664,     4,  1374,
       5,  1376,  -722,     4,  1964,     5,  1999,  1382,  1912,  1116,
    1203,  1139,  1204,  1228,  1986,  1987,  1988,  1989,  1634,  1140,
       6,     7,     8,     9,   645,  1141,   131,   226,   591,   150,
    1528,   132,   133,  1635,  1171,  1658,  1176,     3,  1659,   227,
    1529,     4,     3,     5,   592,  1899,     4,   134,     5,  1636,
     226,  -723,   609,   593,  1637,   724,   725,   383,  1147,   594,
     595,  1902,   227,     6,     7,     8,     9,  1177,     6,     7,
       8,     9,   383,  1175,     3,   960,  1149,   792,     4,  1508,
       5,   665,   666,   895,   610,   611,  1398,   612,   792,  1195,
    1399,  1400,  1401,  1913,  1509,  2109,  1660,  1229,   150,  1528,
       6,     7,     8,     9,  1652,  1178,   150,  1528,  1181,  1532,
    1510,  1182,     3,  1183,  1625,  1511,     4,  1535,     5,  2024,
     798,   799,   531,  2110,   532,   533,   534,   535,  1186,  2030,
     792,     3,   223,  1188,   225,     4,  2033,     5,     6,     7,
       8,     9,   219,  1222,  -534,  1810,  1903,  1741,   899,   900,
    1774,  1208,  1834,   458,   220,  1221,  1660,     6,     7,     8,
       9,  1246,  1626,  1627,  1628,  1629,  1223,  1630,    18,    19,
    1631,  2038,   226,  2059,  2060,  2061,   895,   527,   528,   529,
    1552,   737,  1232,   738,   227,   739,   740,  1632,  1045,  1046,
    1047,  1048,  1217,   741,   742,     3,  1191,  1192,  1776,     4,
    1233,     5,  1806,  1807,  1860,  1861,  1862,  1797,  1863,  1798,
     888,   889,  1932,  1234,     3,   214,  1252,    34,     4,  1661,
       5,     6,     7,     8,     9,  1918,   743,    35,  1260,  2103,
    2104,  2105,  1262,    36,  1261,  1929,  1633,   214,  1267,   671,
       6,     7,     8,     9,  1918,   222,  1576,  1576,   214, -1022,
     219, -1023,   960,   672,  1273,  2121,  1274,    37,  1258,  1259,
     673,  1275,   220,  1276,   947,   947,   947,   947,   947,   947,
     947,   947,   947,   947,   947,  1944,  1930,  1947,   674,  1661,
      18,    19,   779,   780,   675,  1278,  1201,   258,   259,   260,
    1888,   887,   888,   889,  1824,  1825,  1826,  1827,   151,   152,
     153,   219,  1883,  1279,  1592,  1594,  1288,  1610,  1618,  1639,
    1653,   379,  1286,   220,  1316,  1317,  1950,  1595,  1318,  1611,
    1619,  1640,  1654,  1320,   781,  1962,  1963,   476,  1965,    34,
    1324,   582,  1319,   583,  1330,   559,  1314,   560,  1335,    35,
    1516,  1684,    18,    19,  1634,    36,   779,   780,  1926,   960,
    1892,  1158,   584,   222,  1478,  1344,   561,  2044,  2045,  1635,
     585,   586,  2186,   587,   562,   563,   564,   565,  1345,    37,
     151,   152,   153,   588,   589,  1636,  1346,   792,  1692,  1693,
    1637,  1347,   792,  1919,  1391,  1392,  1981,  1690,  1691,  1348,
     214,    34,  1980,  1593,   214,  1998,  1982,  1155,  2181,  1394,
    1395,    35,  1919,  1361,   222,  1356,  1165,    36,   223,  1761,
     225,  1199,  1283,   228,   792,  1429,  1430,  1708,  1357,  1995,
    1715,  1358,  1720,  1431,  1432,  1726,   874,   875,   876,  1709,
    1638,    37,  1716,  1211,  1721,  1359,   228,  1727,  2231,  2232,
    2233,   219,   764,  1360,  1784,   788,  1506,  2004,   226,  2210,
    1363,   379,   792,   220,  1700,  1701,   947,  1366,  1979,  1370,
     227,  1385,  1596,   219,  1613,  1623,  1643,  1656,  2015,   947,
    1971,   792,     3,   150,  1528,   220,     4,  1387,     5,  1847,
    1848,  1785,  1397,   219,  1389,  2183,  2184,  2205,  2215,  1733,
    1783,  1127,  1128,   379,  1415,   220,  1560,  1561,     6,     7,
       8,     9,  1416,  1417,  1427,  1129,  1418,  1420,   214,   636,
    1983,  1984,  1985,  1130,  1419,  1428,   223,  1435,   225,  1436,
     947,   637,  1437,   638,  1833,  1478,  1439,  1444,  1445,  1131,
    1446,   219,  1447,  1454,  1459,   792,   904,  1477,   947,   947,
    1485,   639,  1487,   220,   222,   640,  1491,  1499,   641,  1503,
    1538,  2182,  1523,  1547,   792,  1541,   226,  1555,   228,  1556,
     932,  1557,  -678,  -679,  2150,  1900,   222,   223,   227,   225,
    2171,   932,   932,  1573,  1710,  1681,  1569,  1717,  1590,  1722,
    1671,  1828,  1728,  1672,  1175,  1673,   222,   219,   214,  1836,
    1837,  1838,  1839,  1840,  1697,  1706,  2148,  1688,  1732,   220,
    1689,  1733,  2034,   214,  1757,  1901,  1740,   226,   219,  1753,
    1866,  1867,  1868,  1869,  1766,  1758,    62,  1772,  1755,   227,
     220,  1773,  2142,  1775,  1877,  1878,  1879,  1786,  1790,   219,
    1793,   642,  1795,  2149,   222,  1610,  1618,  1639,  1653,   379,
    1321,   220,   478,  1516,  2167,  2168,  1808,  1611,  1619,  1640,
    1654,  1132,  1133,  1134,   695,  1809,  1820,    18,    19,  1408,
    1409,  1410,  1411,  1412,   643,   644,   777,   705,   706,   707,
    1835,  1846,  1904,  1914,  1921,   402,  1850,   762,   762,   406,
     771,  1874,  2169,  1880,  1905,  1915,  1922,  1882,  1893,  1881,
     222,  2188,  1895,  1897,   429,   402,  2228,  1813,  1815,  1815,
    1818,  1925,   219,  -551,  1935,  1943,    34,   223,  1945,   225,
    1949,   222,   456,  1957,   220,  2147,    35,  1937,  1938,  1939,
    1940,  1941,    36,  1959,  1967,  1972,  2214,  1975,  2226,  1203,
    1977,  1204,   222,  1991,  2220,   296,   297,   298,  1767,  1768,
     301,   498,   480,  1902,   645,  1992,    37,   226,   504,   223,
    2221,   225,  1997,  1960,  1175,  2017,   397,    18,    19,   227,
     398,   219,  2007,  2166,   219,  2227,  2019,  2026,  2028,   226,
    2035,  2031,  2039,   220,   379,  2040,   220,  1403,  1404,  1405,
    1406,   227,  2047,  2049,   397,  2051,  2066,  2054,   398,   226,
    2023,  2011,  1613,  1623,  1643,  1656,  2106,   223,  2055,   225,
    2029,   227,  2056,  2057,  2058,   222,    34,  2032,  2062,  2063,
    2064,   482,   792,  1993,  1994,  2065,    35,  2108,  2122,  2118,
     487,  2120,    36,  2126,   491,  2134,    18,    19,  2013,  1906,
    1916,  1923,  2141,  2000,   228,    18,    19,   226,  2152,    18,
      19,  2002,  2003,  2135,  2136,  2006,    37,  2225,  -259,   227,
    2156,  2012,  2162,   223,  2190,   225,  2191,  2194,  1904,  1914,
    1921,  2212,  1304,  1306,   222,   761,   761,   222,  1145,  1310,
    1905,  1915,  1922,  1144,   223,    34,   225,   445,   446,   447,
     448,  1305,  1143,  1146,    34,    35,  1039,  1372,    34,   215,
    1682,    36,  1035,   226,    35,   223,   219,   225,    35,  1308,
      36,    70,   437,   971,    36,   227,   379,  1666,   220,  1876,
    2069,   215,  2086,  2229,   226,    37,  2193,  2095,  2068,  2101,
    2137,  2139,   215,   947,    37,  2138,   227,  2129,    37,  2140,
       3,   219,  2213,   424,     4,   226,     5,  1817,   948,   968,
     431,  1974,   228,   220,   214,  1224,  2053,   227,  1237,   948,
     948,  1961,  1946,  1948,   219,  1277,     6,     7,     8,     9,
     970,  2128,  2170,   219,  1544,  1563,   220,   214,   223,  1760,
     225,  1545,  1285,  1546,   932,   220,     3,  2096,  1763,  2102,
       4,  1205,     5,  1566,     3,   759,   217,  1367,     4,  1586,
       5,  2111,  2112,   383,  2113,  2114,  2115,  2116,  2117,   222,
     716,  2119,     6,     7,     8,     9,  1520,  1742,   226,   959,
       6,     7,     8,     9,  1780,  1906,  1916,  1923,  1781,  1256,
     227,   473,   981,  1900,  2218,   983,   769,   223,   982,   225,
     223,   984,   225,   219,   222,  1110,   773,   774,     0,  2161,
    1414,  1081,     0,    73,     0,   220,     0,     0,     0,  2151,
       0,    74,  2153,    75,     0,  2154,     0,   222,    76,    77,
      78,     0,    79,  1901,   215,     0,   222,   226,   215,  2101,
     226,     0,     0,     0,     0,     0,     0,     0,     0,   227,
       0,     0,   227,     0,   932,   932,   932,   932,   932,   214,
       0,   932,   219,  2211,     0,     0,     0,     0,  1594,  1618,
    1639,  1653,   379,     0,   220,     0,  1708,  1715,  1720,  1726,
    1595,  1619,  1640,  1654,   219,     0,   932,     0,  1709,  1716,
    1721,  1727,  2011,     0,  2189,     0,   220,     0,     0,     0,
       0,     0,     0,   383,  2197,   932,   222,     0,     0,     0,
    2198,  2199,  2200,  2201,  2202,  1904,  1914,  1921,  2206,  2207,
    2208,  2209,     0,     0,     0,   228,     0,  1905,  1915,  1922,
       0,     0,   223,     3,   225,  2219,     0,     4,     0,     5,
       0,     0,  2222,  2223,  2224,   383,     0,     0,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,     0,     6,
       7,     8,     9,     0,     0,   222,     0,   223,     0,   225,
       0,  1902,   226,     0,  1658,     0,     0,  1659,     0,     0,
       0,     0,     0,     0,   227,     0,     0,   222,     0,     0,
     223,     0,   225,   228,     3,     0,     0,     0,     4,   223,
       5,   225,     0,     0,   934,     0,     0,   226,     0,     0,
       0,     0,     0,     0,     0,   934,   934,     0,     0,   227,
       6,     7,     8,     9,     0,  1596,  1623,  1643,  1656,     0,
     226,     0,   215,  1710,  1717,  1722,  1728,     0,     0,   226,
     792,  1155,   227,     0,     0,     0,    80,   215,  1158,   228,
       0,   227,     0,   136,     0,   137,  2203,     0,     0,     0,
     138,    81,   139,     0,     0,   493,   140,  2144,     0,   223,
     228,   225,  1906,  1916,  1923,     0,     0,    82,     0,     0,
      18,    19,    83,    60,    84,     0,   792,     0,     0,   687,
     688,   383,     0,   689,   792,  1660,     0,     3,     0,     0,
       0,     4,  1714,     5,     0,   141,     0,   142,     0,   226,
    1707,   690,   275,   276,   277,   278,     0,     0,     0,     0,
       0,   227,   948,     6,     7,     8,     9,     0,   223,    34,
     225,     0,     0,     0,     0,   214,     0,   770,     0,    35,
       0,     0,     0,     0,     0,    36,   404,     0,     0,     0,
     223,     0,   225,     0,   414,   415,   416,   417,     0,   687,
     688,   537,   538,   689,   228,     0,     0,  1257,   226,    37,
     539,   540,   541,   542,   543,     0,    88,   450,     0,     0,
     227,   690,     0,     0,    89,     0,    90,     0,    91,     0,
     226,    92,    93,    94,   475,    95,     0,     0,     0,   484,
     485,   486,   227,     0,   490,     0,     0,   495,     0,  1063,
       0,     0,     0,  1256,  1256,  1256,  1256,  1256,  1661,  1256,
    1256,     0,     0,   228,  1064,   691,   383,     0,  1558,  1558,
       0,     0,   948,   948,   948,   948,   948,   771,     0,   948,
       0,     0,     0,   214,     0,     0,     0,     0,     0,   692,
     693,   694,   695,   696,   697,  2145,   698,   699,   700,   701,
     702,   703,   704,     0,   948,   705,   706,   707,     0,   932,
     932,   932,   932,   932,   932,   932,   932,   932,   932,   932,
       0,  1155,  1170,   948,  1172,     0,   708,     3,  1065,  2175,
       0,     4,     0,     5,   214,   691,     0,     0,     0,     0,
       0,  1189,  1190,     0,  1194,     0,     0,     0,     0,     0,
    1206,  1207,     0,     6,     7,     8,     9,     0,     0,   692,
     693,   694,   695,   696,   697,   772,   698,   699,   700,   701,
     702,   703,   704,     0,   792,   705,   706,   707,     0,     0,
       0,  1242,     0,  1245,     0,   745,   746,   747,     0,     0,
    2179,     0,     0,     0,     0,     0,   708,     0,   383,  1066,
       0,     0,  1067,  1068,  1069,  1070,  1071,  1072,  1073,  1074,
    1075,  1076,  1077,  1078,  1079,     3,  1908,     0,     0,     4,
       0,     5,     0,  1909,     0,     0,     0,     0,   215,     0,
       0,     0,     0,   228,     0,     0,     0,     0,     0,  1158,
       0,     6,     7,     8,     9,     0,     0,  1281,     0,    96,
       0,  1200,     0,     0,     0,  1625,   228,     0,   934,     0,
    1910,     0,     0,     3,    97,   228,     0,     4,     0,     5,
       0,     0,     0,     0,   214,     0,     0,   792,     0,     0,
      98,     0,     0,     0,     0,    99,     0,   100,     0,     6,
       7,     8,     9,  2180,  1911,     0,   214,     0,     0,     0,
       0,   932,     0,  1626,  1627,  1628,  1629,     0,  1630,     0,
       0,  1631,     0,     0,   932,     3,   214,  1328,  1329,     4,
       0,     5,     0,     0,   977,   978,   979,     0,  1632,     0,
       0,     0,     0,     0,     0,   228,     0,     0,     0,     0,
       0,     6,     7,     8,     9,     0,     0,     0,     0,     0,
       0,     0,  1908,     0,     0,  1625,  1284,   994,     0,  1909,
       0,     0,     0,     0,   214,   932,     0,     0,   934,   934,
     934,   934,   934,   215,     0,   934,     0,  1633,     0,     0,
       0,     0,     0,   932,   932,     0,  1006,     0,     0,     0,
       0,     0,     0,     0,   383,     0,  1910,     0,  1912,     0,
     934,     0,     0,  1626,  1627,  1628,  1629,     0,  1630,     0,
       0,  1631,     0,     0,     3,     0,   228,     0,     4,   934,
       5,     0,     0,     0,     0,     0,     0,     0,  1632,     0,
    1911,  1257,  1257,  1257,  1257,  1257,     0,  1257,  1257,     0,
       6,     7,     8,     9,     0,     0,  1559,  1559,     0,     0,
       0,     0,     0,     0,  1646,     0,     0,     0,     0,     0,
       0,     0,   214,     0,     0,     0,     0,   792,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1633,     0,     0,
       0,     0,     0,  2014,     0,  1634,     0,   948,   948,   948,
     948,   948,   948,   948,   948,   948,   948,   948,     0,     0,
    1635,     0,     0,  1647,  1648,  1649,     0,  1630,     0,     0,
    1631,     0,     0,     0,     0,     0,  1636,     0,     0,     0,
       0,  1637,     0,   572,   573,     0,     0,  1650,     0,     0,
       0,     0,     0,  1458,  1912,   214,     0,  1461,   574,     0,
     575,   576,   577,     0,     0,     0,     0,  1481,  1482,  1483,
       0,     0,  1486,     0,  1488,   792,     0,     0,     0,     0,
       0,     0,     0,   578,   579,   580,     0,     0,     0,     0,
       0,  1886,     0,     0,  1504,     0,  1651,     0,     3,     0,
       0,     0,     4,     0,     5,  1634,     0,     0,     0,     0,
       0,     0,     0,     0,   214,     0,     0,   214,     0,     0,
    1635,     0,     0,   792,     6,     7,     8,     9,     0,     0,
    1537,     0,  1539,     0,     0,  1598,  1636,     0,  1540,  2204,
       0,  1637,     0,     0,     0,  1599,     0,     0,     0,     0,
    1600,     0,  1601,  1553,  1602,  1554,     0,     0,     0,     0,
       0,     0,     0,     0,  1562,     0,  1564,     0,     0,   215,
       0,     0,     0,     0,     0,   792,     0,     0,     0,     0,
       3,     0,     0,     0,     4,     0,     5,     0,     0,     0,
       0,  2173,     0,     0,     0,     0,     0,     0,     0,   948,
       0,     0,     0,     0,  1634,   614,     6,     7,     8,     9,
       0,     0,   948,     0,   615,     0,     0,     0,     0,  1635,
    1646,     0,     0,     0,     0,     0,     0,  1531,  1531,   616,
    1531,     0,     0,   617,     0,  1636,     0,   618,   619,     0,
    1637,     0,   620,   621,   622,   623,   624,     0,     0,   214,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1603,     0,     0,   948,     0,     0,     0,     0,     0,  1647,
    1648,  1649,     0,  1630,   792,     0,  1631,   215,     0,   545,
     546,   948,   948,   547,   214,     0,     0,     0,   932,     0,
    1887,     0,     0,  1650,   548,   549,   550,   551,   552,   553,
     554,   555,   556,   934,   934,   934,   934,   934,   934,   934,
     934,   934,   934,   934,     0,     0,     0,     0,     0,     0,
      50,   816,     0,     0,     0,     0,     0,     0,   215,     0,
      61,    50,    50,    64,    64,    64,    68,     0,     0,    50,
       0,     0,  1651,   557,     0,  1730,  1731,     0,     0,     0,
       0,     0,     0,     0,   151,   152,   153,     0,     0,     0,
       0,   914,     0,     0,     0,   915,     0,     0,  1604,     0,
     916,     0,     0,  1748,     0,     0,   917,     0,     0,     0,
     823,     0,     0,  1605,     0,     0,     0,     0,     0,  1765,
      50,     0,     0,   405,    50,    64,    64,    64,    68,  1606,
     920,     0,     0,     0,  1607,    50,  1608,   420,   425,   428,
      50,   433,    64,   433,   438,     0,   420,   420,   420,   420,
       0,    64,     0,     0,  1792,   454,     0,    50,     0,     0,
      64,    64,     0,    68,     0,     0,    64,     0,   792,     0,
       0,  1794,     0,  1796,     0,   214,     0,  1469,     0,     0,
    1634,     0,     0,     0,  1609,   497,    50,    64,    64,     0,
       0,    64,     0,    50,     0,  1635,     0,     0,   215,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1636,     0,     0,     0,     0,  1637,     0,  1762,     0,
    1200,  1284,     0,     0,     0,   934,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   934,     0,
     215,  1065,     0,     0,     0,     0,     0,     0,  1531,     3,
     792,  1531,     0,     4,  1531,     5,     0,     0,     0,     0,
       0,   826,     0,     0,   827,   828,  2174,     0,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     8,     9,     0,
       0,     0,     0,     0,     0,     0,  1598,     0,   215,   934,
       0,     0,     0,     0,     0,     0,  1599,     0,     0,   830,
     831,  1600,     0,  1601,     0,  1602,     0,   934,   934,     0,
       0,     0,  1470,     0,     0,  1067,  1068,  1471,  1070,  1071,
    1072,  1073,  1074,  1075,  1076,  1077,  1078,  1472,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,     0,     0,     0,     0,     0,     0,  1933,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     2,     3,     0,     0,     0,     4,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1953,     0,     0,     0,   215,     0,     0,     6,
       7,     8,     9,     0,     0,     0,   948,     0,     0,     0,
      10,     0,     0,     0,     0,     0,     0,     0,    11,  1966,
      12,  1603,    13,     0,     0,    14,    15,    16,     0,    17,
       0,     0,  1085,    18,    19,    20,     0,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
    1086,  1087,  1088,  1089,  1090,  1091,  1092,  1093,  1094,  1095,
    1096,  1097,  1098,  1099,  1100,  1101,  1102,     0,     0,   215,
       0,     0,     0,     0,     0,     0,  -409,     0,     0,     0,
       0,     0,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,   104,     0,     0,     0,    36,   105,
       0,     0,   106,   107,   108,   109,     0,     0,   110,   111,
       0,   112,   113,   114,     0,   115,     0,  1003,     0,     0,
       0,     0,    37,     0,    64,     0,     0,     0,   215,  1604,
       0,   215,     0,     0,     0,  1009,     0,  1010,     0,  1011,
       0,  1012,     0,     3,  1605,     0,  1016,     4,     0,     5,
    1018,     0,  1019,     0,   116,     0,   117,   118,   119,     0,
    1606,    64,     0,     0,     0,  1607,   146,  1608,     0,     6,
       7,     8,     9,   147,   148,     0,     0,     0,   289,   149,
     290,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2046,     0,   291,     0,     0,     0,   792,
       0,     0,     0,     0,     0,   292,   293,     0,     0,     0,
     294,     0,     0,   295,     0,  1884,     0,     0,     0,     0,
       0,   296,   297,   298,   299,   300,   301,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1614,     0,     0,     0,
     302,     0,   303,    38,     0,   150,   151,   152,   153,     0,
       0,   154,     0,   155,     0,     0,  1615,   156,    39,     0,
       0,     0,   157,   215,     0,     0,     0,     0,   158,     0,
       0,     0,     0,     0,    40,     0,     0,     0,     0,    41,
       0,    42,     0,     0,   159,     0,     0,     0,     0,   160,
       0,     0,   161,     0,     0,     0,     0,   162,   215,     0,
     163,     0,   934,   164,   165,  1616,     0,     0,   166,     0,
       0,   167,     0,   168,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   120,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   169,   170,
       0,     0,   121,     0,     0,    10,     0,   122,   123,   124,
     125,     0,     0,    11,     0,    12,     0,    13,   126,     0,
      14,    15,    16,   127,    17,   128,   129,     0,    18,    19,
       0,     0,     0,     0,   171,   172,   173,   174,     0,     0,
       0,     0,     0,   175,   176,     0,     0,   177,   178,   304,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,   197,   198,   199,
     200,     0,     0,   305,     0,     0,     0,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,   306,     0,
       0,     0,     0,    36,     0,     0,     0,     0,   307,     0,
       0,     0,     0,     0,   308,     0,     0,     0,     0,   309,
       0,     0,     0,     0,     0,   202,   203,    37,   310,   215,
       0,   311,   312,   313,   314,     0,     0,     0,   315,     0,
       0,     0,   316,   317,   204,     0,     0,     0,   205,   206,
       0,     0,     3,   792,     0,     0,     4,   318,     5,     0,
     207,   208,     0,     0,     0,     0,   319,     0,   320,  1617,
     209,     0,     0,   210,     0,   146,     0,     0,     6,     7,
       8,     9,   147,   148,     0,     0,     0,   289,   149,   290,
     687,   688,     0,     0,   689,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   291,     0,     0,     0,     0,     0,
       0,     0,   690,     0,   292,   293,     0,     0,     0,   294,
       0,     0,   295,     0,     0,     0,     0,     0,     0,     0,
     296,   297,   298,   299,   300,   301,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1614,     0,     0,    38,   302,
       0,   303,     0,     0,   150,   151,   152,   153,     0,     0,
     154,     0,   155,    39,     0,  1615,   156,     0,     0,     0,
       0,   157,     0,     0,     0,     0,     0,   158,     0,    40,
       0,     0,     0,     0,    41,     0,    42,     0,     0,     0,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
       0,   161,     0,     0,     0,     0,   162,     0,     0,   163,
       0,     0,   164,   165,  1616,     0,     0,   166,     0,     0,
     167,     0,   168,     0,     0,     0,   691,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1365,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   169,   170,     0,
     692,   693,   694,   695,   696,   697,     0,   698,   699,   700,
     701,   702,   703,   704,     0,     0,   705,   706,   707,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   171,   172,   173,   174,   708,     0,     0,
       0,     0,   175,   176,     0,     0,   177,   178,   304,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   197,   198,   199,   200,
       0,     0,   305,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   306,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   307,     0,     0,
       0,     0,     0,   308,     0,     0,     0,     0,   309,     0,
       0,     0,     0,     0,   202,   203,     0,   310,     0,     0,
     311,   312,   313,   314,     0,     0,     0,   315,     0,     0,
       0,   316,   317,   204,     0,     0,     0,   205,   206,     0,
       0,     3,   792,     0,     0,     4,   318,     5,     0,   207,
     208,     0,     0,     0,     0,   319,     0,   320,  1885,   209,
       0,     0,   210,     0,   146,     0,     0,     6,     7,     8,
       9,   147,   148,     0,     0,     0,   289,   149,   290,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   291,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   292,   293,   677,     0,     0,   294,     0,
       0,   295,     0,     0,     0,     0,     0,     0,     0,   296,
     297,   298,   299,   300,   301,     0,     0,     0,     0,     0,
       0,     0,   678,     0,  1614,   679,     0,     0,   302,     0,
     303,     0,     0,   150,   151,   152,   153,     0,     0,   154,
       0,   155,   680,     0,  1615,   156,     0,     0,     0,     0,
     157,     0,     0,     0,     0,     0,   158,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   159,     0,     0,     0,     0,   160,     0,     0,
     161,     0,     0,     0,     0,   162,     0,     0,   163,     0,
       0,   164,   165,  1616,     0,     0,   166,     0,     0,   167,
       0,   168,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   169,   170,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   197,   198,   199,   200,
       0,     0,   171,   172,   173,   174,     0,     0,     0,     0,
       0,   175,   176,     0,     0,   177,   178,   304,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,   197,   198,   199,   200,     0,
     681,   305,     0,     0,   202,   203,     0,     0,     0,     0,
       0,     0,     0,     0,   682,     0,   306,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   307,     0,     0,     0,
       0,     0,   308,     0,     0,     0,     0,   309,     0,     0,
     683,     0,     0,   202,   203,     0,   310,     0,     0,   311,
     312,   313,   314,     0,     0,     0,   315,     0,     0,     0,
     316,   317,   204,     4,     0,     5,   205,   206,     0,     0,
       0,   792,     0,     0,     0,   318,     0,     0,   207,   208,
       0,     0,   146,     0,   319,     0,   320,  2172,   209,   147,
     148,   210,     0,     0,   289,   149,   290,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   291,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   292,   293,     0,     0,     0,   294,     0,     0,   295,
       0,     0,     0,     0,     0,     0,     0,   296,   297,   298,
     299,   300,   301,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   302,     0,   303,     0,
       0,   150,   151,   152,   153,     0,     0,   154,     0,   155,
       0,     0,     0,   156,     0,     0,     0,     0,   157,     0,
       0,     0,     0,     0,   158,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     159,     0,     0,     0,     0,   160,     0,     0,   161,     0,
       0,     0,     0,   162,     0,     0,   163,     0,     0,   164,
     165,     0,     0,     0,   166,     0,     0,   167,     0,   168,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   169,   170,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     171,   172,   173,   174,     0,     0,     0,     0,     0,   175,
     176,     0,     0,   177,   178,   304,   180,   181,   182,   183,
     184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,   197,   198,   199,   200,     0,     0,   305,
       0,     0,   815,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   306,     0,     0,     0,     0,     0,
     146,     0,     0,     0,   307,     0,     0,     0,   148,     0,
     308,     0,     0,   149,     0,   309,     0,     0,     0,     0,
       0,   202,   203,     0,   310,     0,     0,   311,   312,   313,
     314,     0,     0,     0,   315,     0,     0,     0,   316,   317,
     204,     0,     0,     0,   205,   206,     0,   816,     0,     0,
       0,     0,     0,   318,     0,     0,   207,   208,     0,     0,
       0,   817,   319,   818,   320,  1782,   209,     0,     0,   210,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   150,
     151,   152,   153,     0,     0,   154,     0,   819,     0,     0,
       0,   820,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,   822,     0,     0,     0,   823,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   159,     0,
       0,     0,     0,   160,     0,     0,   824,     0,     0,     0,
       0,   162,     0,     0,   163,     0,     0,   164,   165,     0,
       0,     0,   166,     0,     0,   167,     0,   168,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   169,   170,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1167,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   146,     0,     0,     0,     0,     0,     0,   825,   148,
       0,     0,     0,     0,   149,     0,     0,     0,     0,     0,
       0,     0,     0,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,   197,   198,   199,   200,     0,     0,   201,   816,     0,
       0,     0,     0,     0,     0,     0,     0,   826,     0,     0,
     827,   828,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   829,     0,     0,     0,     0,     0,     0,
     150,   151,   152,   153,     0,     0,   154,     0,   819,   202,
     203,     0,   820,     0,     0,   830,   831,   821,     0,     0,
       0,     0,     0,  1168,     0,     0,     0,   823,   204,     0,
       0,     0,   205,   206,     0,     0,     0,     0,     0,   159,
       0,     0,   832,   833,   160,   683,     0,  1169,     0,     0,
       0,     0,   162,     0,   834,   163,     0,   210,   164,   165,
       0,     0,     0,   166,     0,     0,   167,     0,   168,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   169,   170,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1244,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   146,     0,     0,     0,     0,     0,     0,   825,
     148,     0,     0,     0,     0,   149,     0,     0,     0,     0,
       0,     0,     0,     0,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,     0,     0,   201,   816,
       0,     0,     0,     0,     0,     0,     0,     0,   826,     0,
       0,   827,   828,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   150,   151,   152,   153,     0,     0,   154,     0,   819,
     202,   203,     0,   820,     0,     0,   830,   831,   821,     0,
       0,     0,     0,     0,  1168,     0,     0,     0,   823,   204,
       0,     0,     0,   205,   206,     0,     0,     0,     0,     0,
     159,     0,     0,   832,   833,   160,   683,     0,  1169,     0,
       0,     0,     0,   162,     0,   834,   163,     0,   210,   164,
     165,     0,     0,     0,   166,     0,     0,   167,     0,   168,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   169,   170,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1280,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   146,     0,     0,     0,     0,     0,     0,
     825,   148,     0,     0,     0,     0,   149,     0,     0,     0,
       0,     0,     0,     0,     0,   179,   180,   181,   182,   183,
     184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,   197,   198,   199,   200,     0,     0,   201,
     816,     0,     0,     0,     0,     0,     0,     0,     0,   826,
       0,     0,   827,   828,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   150,   151,   152,   153,     0,     0,   154,     0,
     819,   202,   203,     0,   820,     0,     0,   830,   831,   821,
       0,     0,     0,     0,     0,  1168,     0,     0,     0,   823,
     204,     0,     0,     0,   205,   206,     0,     0,     0,     0,
       0,   159,     0,     0,   832,   833,   160,   683,     0,  1169,
       0,     0,     0,     0,   162,     0,   834,   163,     0,   210,
     164,   165,     0,     0,     0,   166,     0,     0,   167,     0,
     168,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   169,   170,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1460,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   146,     0,     0,     0,     0,     0,
       0,   825,   148,     0,     0,     0,     0,   149,     0,     0,
       0,     0,     0,     0,     0,     0,   179,   180,   181,   182,
     183,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,   196,   197,   198,   199,   200,     0,     0,
     201,   816,     0,     0,     0,     0,     0,     0,     0,     0,
     826,     0,     0,   827,   828,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   150,   151,   152,   153,     0,     0,   154,
       0,   819,   202,   203,     0,   820,     0,     0,   830,   831,
     821,     0,     0,     0,     0,     0,  1168,     0,     0,     0,
     823,   204,     0,     0,     0,   205,   206,     0,     0,     0,
       0,     0,   159,     0,     0,   832,   833,   160,   683,     0,
    1169,     0,     0,     0,     0,   162,     0,   834,   163,     0,
     210,   164,   165,     0,     0,     0,   166,     0,     0,   167,
       0,   168,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   169,   170,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   907,   908,   909,   910,   911,   912,     0,     0,     0,
       0,   913,     0,     0,     0,   894,     0,     0,     0,     0,
       0,     0,   825,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   179,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,   197,   198,   199,   200,     0,
       0,   201,   816,     0,     0,     0,     0,     0,     0,     0,
       0,   826,     0,     0,   827,   828,     0,     0,     0,     0,
       0,     0,  1210,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   150,   151,   152,   153,     0,     0,
       0,     0,   914,   202,   203,     0,   915,     0,     0,   830,
     831,   916,     0,     0,     0,     0,     0,   917,     0,     0,
       0,   823,   204,     0,     0,     0,   205,   206,     0,     0,
    1210,   816,     0,   918,     0,     0,   832,   833,   919,   683,
       0,   920,     0,     0,     0,     0,   921,     0,   834,   922,
       0,   210,   923,   924,     0,     0,     0,   925,     0,     0,
     926,     0,   927,   150,   151,   152,   153,     0,     0,     0,
       0,   914,     0,     0,     0,   915,     0,     0,     0,   816,
     916,     0,     0,     0,     0,     0,   917,   928,   929,     0,
     823,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   918,     0,     0,     0,     0,   919,     0,     0,
     920,   150,   151,   152,   153,   921,     0,     0,   922,   914,
       0,   923,   924,   915,     0,     0,   925,     0,   916,   926,
       0,   927,     0,     0,   917,     0,     0,     0,   823,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     918,     0,     0,     0,     0,   919,   928,   929,   920,     0,
       0,     0,     0,   921,     0,     0,   922,     0,     0,   923,
     924,     0,   826,     0,   925,   827,   828,   926,     0,   927,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   928,   929,     0,     0,     0,     0,
     830,   831,     0,   930,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   832,   833,     0,
       0,   826,     0,     0,   827,   828,     0,   320,     0,   931,
       0,     0,   210,   953,   894,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   830,
     831,     0,   930,     0,     0,     0,     0,     0,     0,   826,
       0,     0,   827,   828,     0,     0,     0,     0,     0,     0,
       0,   816,     0,     0,     0,     0,   832,   833,     0,     0,
       0,     0,     0,     0,     0,     0,   320,     0,   931,     0,
       0,   210,     0,     0,     0,     0,     0,   830,   831,     0,
     930,     0,     0,   150,   151,   152,   153,     0,     0,     0,
       0,   914,     0,     0,     0,   915,     0,     0,     0,     0,
     916,     0,     0,     0,   832,   833,   917,     0,     0,     0,
     823,     0,     0,     0,     0,     0,   931,     0,     0,   210,
       0,     0,   918,     0,     0,     0,     0,   919,     0,     0,
     920,     0,     0,     0,     0,   921,     0,     0,   922,     0,
     146,   923,   924,     0,     0,     0,   925,   147,   148,   926,
       0,   927,   289,   149,   290,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   291,
       0,     0,     0,     0,     0,     0,   928,   929,     0,   292,
     293,     0,     0,     0,   294,     0,     0,   295,     0,     0,
       0,     0,     0,     0,     0,   296,   297,   298,   299,   300,
     301,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   302,     0,   303,     0,     0,   150,
     151,   152,   153,     0,     0,   154,     0,   155,     0,     0,
       0,   156,     0,     0,     0,     0,   157,     0,     0,     0,
       0,     0,   158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   159,     0,
       0,   826,     0,   160,   827,   828,   161,     0,     0,     0,
       0,   162,     0,     0,   163,     0,     0,   164,   165,     0,
       0,     0,   166,     0,     0,   167,     0,   168,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   830,
     831,     0,   930,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   169,   170,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   832,   833,     0,     0,
       0,     0,     0,     0,     0,     0,   954,     0,   931,     0,
       0,   210,     0,     0,     0,     0,     0,     0,   171,   172,
     173,   174,     0,     0,     0,     0,     0,   175,   176,     0,
       0,   177,   178,   304,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,   197,   198,   199,   200,     0,     0,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     146,     0,   306,     0,     0,     0,     0,   147,   148,     0,
       0,     0,   307,   149,     0,     0,     0,     0,   308,     0,
       0,     0,     0,   309,     0,     0,     0,     0,     0,   202,
     203,     0,   310,     0,     0,   311,   312,   313,   314,     0,
       0,     0,   315,     0,     0,     0,   316,   317,   204,     0,
       0,     0,   205,   206,     0,     0,     0,     0,     0,     0,
       0,   318,     0,     0,   207,   208,     0,     0,     0,     0,
     319,     0,   320,     0,   209,     0,     0,   210,     0,   150,
     151,   152,   153,     0,     0,   154,     0,   155,     0,     0,
       0,   156,     0,     0,     0,     0,   157,     0,     0,     0,
       0,     0,   158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   159,     0,
       0,     0,     0,   160,     0,     0,   161,     0,     0,     0,
       0,   162,     0,     0,   163,     0,     0,   164,   165,     0,
       0,     0,   166,     0,     0,   167,     0,   168,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   146,
       0,     0,   169,   170,     0,     0,   147,   148,     0,     0,
       0,     0,   149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   171,   172,
     173,   174,     0,     0,     0,     0,     0,   175,   176,     0,
       0,   177,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,   197,   198,   199,   200,     0,     0,   201,   150,   151,
     152,   153,     0,     0,   154,     0,   155,     0,     0,     0,
     156,     0,     0,     0,     0,   157,     0,     0,     0,     0,
       0,   158,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   159,     0,   202,
     203,     0,   160,     0,     0,   161,     0,     0,     0,     0,
     162,     0,     0,   163,     0,     0,   164,   165,   204,     0,
       0,   166,   205,   206,   167,     0,   168,     0,     0,     0,
       0,     0,     0,     0,   207,   208,     0,     0,     0,     0,
       0,     0,   320,     0,   209,     0,     0,   210,   146,     0,
       0,   169,   170,     0,     0,     0,   148,     0,     0,     0,
       0,   149,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   171,   172,   173,
     174,     0,     0,     0,     0,   816,   175,   176,     0,     0,
     177,   178,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,   195,   196,
     197,   198,   199,   200,     0,     0,   201,   150,   151,   152,
     153,     0,     0,   154,     0,   819,     0,     0,     0,   820,
       0,     0,     0,     0,   821,     0,     0,     0,     0,     0,
    1168,     0,     0,     0,   823,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   159,     0,   202,   203,
       0,   160,     0,     0,  1169,     0,     0,     0,     0,   162,
       0,     0,   163,     0,     0,   164,   165,   204,     0,     0,
     166,   205,   206,   167,     0,   168,     0,     0,     0,     0,
       0,     0,     0,   207,   208,     0,     0,     0,     0,     0,
       0,     0,     0,   209,     0,     0,   210,     0,     0,     0,
     169,   170,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   894,
       0,     0,     0,     0,     0,     0,   825,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,     0,     0,   201,   816,     0,     0,     0,
       0,     0,     0,     0,     0,   826,     0,     0,   827,   828,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   150,   151,
     152,   153,     0,     0,     0,     0,   914,   202,   203,     0,
     915,     0,     0,   830,   831,   916,     0,     0,     0,     0,
       0,   917,     0,     0,     0,   823,   204,     0,     0,     0,
     205,   206,     0,     0,     0,     0,     0,   918,     0,     0,
     832,   833,   919,   683,     0,   920,     0,     0,     0,     0,
     921,     0,   834,   922,     0,   210,   923,   924,     0,     0,
     146,   925,     0,     0,   926,     0,   927,   147,   148,     0,
       0,     0,     0,   149,  2070,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   928,   929,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2071,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2072,     0,     0,     0,     0,   154,     0,   155,     0,     0,
       0,   156,     0,     0,     0,     0,   157,     0,     0,     0,
       0,     0,   158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   826,     0,   159,   827,
     828,     0,     0,   160,     0,     0,   161,     0,     0,     0,
       0,   162,     0,     0,   163,     0,     0,   164,   165,     0,
       0,     0,   166,     0,     0,   167,     0,   168,     0,     0,
       0,     0,     0,     0,   830,   831,     0,   930,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   169,   170,     0,     0,     0,     0,     0,     0,
       0,   832,   833,     0,     0,     0,     0,     0,     0,     0,
       0,   320,     0,   931,     0,     0,   210,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   171,   172,
     173,   174,     0,     0,     0,     0,     0,   175,   176,     0,
       0,   177,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,   197,   198,   199,   200,   146,     0,  2073,     0,     0,
       0,     0,   147,   148,     0,     0,     0,     0,   149,     0,
       0,     0,  2074,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2075,     0,
       0,     0,     0,  2076,     0,  2077,     0,     0,     0,   202,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2078,     0,     0,     0,     0,     0,   204,     0,
       0,     0,   205,   206,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   207,   208,     0,     0,     0,     0,
     154,     0,   155,     0,     0,     0,   156,     0,     0,     0,
       0,   157,     0,     0,     0,     0,     0,   158,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
       0,   161,     0,     0,     0,     0,   162,     0,     0,   163,
       0,     0,   164,   165,     0,     0,     0,   166,     0,     0,
     167,     0,   168,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   169,   170,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   171,   172,   173,   174,     0,     0,     0,
       0,     0,   175,   176,     0,     0,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   197,   198,   199,   200,
       0,     0,   201,     0,     0,     0,   816,     0,     0,     0,
       0,     0,     0,     0,   296,   297,   298,  1767,  1768,   301,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   150,   151,
     152,   153,     0,     0,   202,   203,   914,     0,     0,     0,
     915,     0,     0,     0,   816,   916,     0,     0,     0,     0,
       0,   917,     0,   204,     0,   823,     0,   205,   206,     0,
       0,     0,     0,     0,     0,     0,     0,   918,     0,   207,
     208,     0,   919,     0,     0,   920,   150,   151,   152,   153,
     921,     0,     0,   922,   914,     0,   923,   924,   915,     0,
       0,   925,   816,   916,   926,     0,   927,     0,     0,   917,
       0,     0,     0,   823,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   918,     0,     0,     0,     0,
     919,   928,   929,   920,  1583,   151,   152,   153,   921,     0,
       0,   922,   914,     0,   923,   924,   915,     0,     0,   925,
       0,   916,   926,     0,   927,     0,     0,   917,     0,     0,
       0,   823,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   918,     0,     0,     0,     0,   919,   928,
     929,   920,     0,     0,     0,     0,   921,     0,     0,   922,
       0,     0,   923,   924,     0,     0,     0,   925,     0,     0,
     926,     0,   927,     0,     0,     0,     0,     0,     0,     0,
       0,   768,     0,     0,     0,     0,   826,     0,     0,   827,
     828,     0,     0,     0,     0,     0,     0,   928,   929,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
       0,   679,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   830,   831,     0,   930,   680,     0,
       0,     0,     0,     0,   826,     0,     0,   827,   828,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   832,   833,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   931,     0,     0,   210,     0,     0,     0,
       0,     0,   830,   831,     0,   930,     0,     0,     0,     0,
       0,     0,   826,     0,     0,   827,   828,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   832,
     833,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   931,     0,     0,   210,     0,     0,     0,     0,     0,
     830,   831,     0,   930,     0,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,     0,   832,   833,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   931,
       0,     0,   210,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   681,     0,     0,     0,
     202,   203,     0,     0,     0,     0,     0,     0,     0,     0,
     682,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   683
};

static const yytype_int16 yycheck[] =
{
       1,   419,     3,   486,   300,    52,    66,   333,   409,   338,
      66,   408,     1,   407,    37,   590,    63,   410,   645,   375,
     205,   323,    30,   105,    36,   107,   309,   109,   110,   354,
     925,   113,   450,   115,    30,   484,   118,   119,   789,   436,
     122,   123,   124,   125,    52,    46,   439,   129,   752,  1341,
     132,   133,   449,    54,    52,    63,    52,    58,   140,   927,
     816,   289,  1341,   375,   782,    63,   361,    63,   684,  1345,
    1340,  1341,   485,  1465,   386,   387,   530,  1211,  1212,  1348,
     406,  1346,   495,   787,  1218,   414,    32,  1347,   792,   317,
     209,  1158,  1361,   390,  1288,   887,  1287,   375,   531,  1198,
     804,  1450,   929,  1625,   808,   351,    35,   353,  1450,  1454,
    1506,   834,  1673,  1650,  1671,   901,   445,  1672,   902,   347,
    1435,  1436,  1514,  1515,  1646,    30,   559,  1570,  1646,   648,
     903,   650,  1849,   652,   567,     7,     8,     9,   657,     5,
     905,     8,   899,   900,     5,  1724,   475,    52,     8,   582,
       8,  1713,  1712,   769,  1696,     8,    24,    59,    63,  1467,
      39,   490,  1296,    58,    21,     8,   104,    79,    80,    14,
      15,    16,   104,   105,     8,  1512,    48,  1910,    50,   749,
      97,   179,    16,    17,    18,    19,    24,    59,    24,   103,
     103,   127,    64,   626,   751,   103,    68,   205,   681,   718,
    1992,   209,   144,   636,   107,    13,   109,   110,    90,   205,
     113,    93,   115,   209,   752,   118,   119,   104,   160,   122,
     123,   124,   125,  1569,    63,   708,   129,   288,   128,   132,
     133,    76,    77,    78,   750,  1627,  1628,   140,   671,   299,
     300,     6,    85,   104,   105,   142,  1176,   104,    93,   114,
     288,   105,  1006,   153,    85,  1647,  1648,   102,   155,    54,
      99,     9,   104,   105,   106,    48,   111,   112,    16,    17,
      18,    19,   117,   303,   171,    23,  1568,  1239,    86,  1241,
     984,   104,   105,   106,  1475,  1476,   104,   104,    30,    90,
      30,   356,    93,   138,   139,   356,   361,   142,  1568,    90,
     205,   361,   167,   168,   209,   709,   304,    55,   114,   128,
      52,   257,    52,    85,   104,   323,    59,   263,   356,   375,
     287,    63,    58,    63,    58,   323,   356,   323,    30,   135,
     386,   387,   163,    85,   153,    87,   303,     5,   210,     7,
      30,   126,   148,   918,    23,    50,   921,   114,   408,    50,
      52,   287,   408,   323,   126,   375,   403,    33,    34,    35,
    2152,    63,    52,   333,   131,   150,   386,   387,   104,   773,
     104,   418,  1240,    63,  1644,   160,   436,  1669,   150,   355,
     436,  1135,  1136,   144,   466,  2118,   111,  1657,   149,   449,
    1669,     6,   305,   449,  1740,   403,   163,   305,  1668,  1669,
     355,   126,   289,    85,     8,   403,    58,   403,  1173,     1,
     418,   981,    85,     5,    87,     7,   114,    21,   323,    23,
     418,   318,   418,   361,   103,   104,   983,   299,   300,   361,
    1184,   303,   289,   356,  1742,    27,    28,    29,    30,   356,
     342,   343,   344,  1780,   339,   340,   984,   361,     9,   361,
      42,    46,   104,    45,  1384,    16,    17,    18,    19,   341,
      85,   237,    23,   205,  2043,   205,   982,   209,   356,   209,
    1992,   289,    90,  1177,  1178,   133,  2018,   356,   322,  2001,
    2042,  2041,     1,  2001,   327,   237,     5,   278,     7,   280,
     357,   357,   298,   361,    55,   167,   168,   357,   403,   357,
     361,  1266,  2219,   205,   357,    90,   271,   209,    27,    28,
      29,    30,   166,   418,   356,   205,  1908,   171,   356,   209,
     356,   286,   847,   361,   111,   361,   360,    90,   305,   306,
    1973,  1801,  1318,    90,    85,  1319,    87,   302,   361,   126,
     341,  1264,   307,    58,   962,   297,   558,  1320,   420,  2071,
    2087,   237,   424,  2071,   252,   253,   428,   356,   581,  1316,
    1317,   433,   361,   466,   237,   350,   438,  1529,    46,    47,
    1532,   163,   248,  1535,   759,  2136,  1972,  2134,   334,   356,
    2135,   323,  1897,   323,   830,   831,  1040,     6,  1042,   104,
       9,  1110,   357,  1026,   950,   114,   103,   782,  1425,   342,
     343,   344,    58,   271,  1949,  1799,  1474,   103,  1362,  1958,
     905,  1365,   360,     9,  1959,   544,  1958,   640,   286,   931,
     465,   323,   135,     1,   297,   637,   343,     5,   906,     7,
    2152,   103,   504,   323,   302,  1769,   146,   287,   950,   307,
       1,   323,   324,   325,     5,     5,     7,     7,   104,    27,
      28,    29,    30,    38,   167,   168,   271,   502,  1526,    55,
     278,   403,   280,   403,  1763,  1764,    27,    28,    29,    30,
    1804,   286,   950,   970,   353,   287,   418,   295,   418,   171,
       9,     9,   361,  1166,   930,   198,   237,   302,    16,    17,
      18,    19,   307,   278,   286,   280,   112,   113,   323,   324,
     325,   403,    87,  1894,   746,   747,    90,   104,  1775,    93,
    1502,  1160,    85,   403,    30,   278,   418,   280,   231,     5,
     131,   278,   782,   280,   135,   103,    55,    55,   418,  1483,
       9,  1485,  1486,   789,  1488,   341,    52,    16,    17,    18,
      19,  1190,   357,   104,   105,   106,   297,    63,    39,    40,
    1163,   759,  1456,   272,  1172,  1506,   167,   168,   317,   269,
     270,    63,    64,   759,     8,   357,    68,     1,  1519,   789,
      46,     5,  1226,     7,   782,  1969,    55,    21,     1,  2055,
      19,  1194,     5,  1501,     7,   904,   782,     8,   360,  2058,
       5,  2056,     7,    27,    28,    29,    30,  2057,   744,   360,
      21,   824,  2194,    53,    27,    28,    29,    30,    18,   335,
     822,   163,   338,     9,   356,  1442,   287,   104,    41,  1570,
       1,   356,   341,    85,     5,    40,     7,   887,  1157,    25,
     163,   126,   248,   249,   305,   306,   252,    53,   357,   349,
    2132,    79,   129,   130,   356,   905,    27,    28,    29,    30,
     906,   146,   356,  2132,   759,   150,    90,    95,   356,    55,
    1189,  2131,  2132,    97,   126,  1481,  1482,    90,    91,    92,
       6,    94,  1355,     9,    97,    58,   114,   782,  1173,   899,
     900,   901,   902,   903,     8,   288,   906,   271,   150,   205,
     356,   114,   114,   209,   950,   186,   904,    21,   189,    23,
     134,   286,   286,    44,  1353,   238,   239,   240,   904,   131,
      21,   931,    23,    94,   136,   137,  2050,   302,   302,    46,
    1148,   153,   307,   307,   309,  1343,    46,   305,   306,   232,
     950,   163,   164,    46,   168,   977,   978,   979,   241,   242,
     163,  1354,   245,   246,  1377,   297,   298,   299,   300,   301,
      78,     8,   994,   134,   955,     0,  1281,   341,   959,  1315,
       5,   248,     7,   341,     1,     5,  1322,     7,     5,     9,
       7,  1266,     8,   104,   269,   270,   107,   108,   109,   357,
     341,   268,   269,   111,   116,    21,     9,    23,  1421,   301,
      27,    28,    29,    30,  1748,  1180,   357,   104,   126,   904,
     132,    23,  1314,  1315,    26,    42,   362,   323,    45,  1321,
    1322,  1323,  1324,  1258,  1259,   237,    21,   759,    23,   759,
    1265,   153,   894,  1352,     1,  2159,   898,   159,     5,  1041,
       7,  1043,   360,     5,  1790,     7,     8,  1049,   272,   362,
     782,   334,   782,   171,  1824,  1825,  1826,  1827,   271,   334,
      27,    28,    29,    30,   349,   103,   286,   759,   128,   103,
     104,   291,   292,   286,    85,    42,   176,     1,    45,   759,
     114,     5,     1,     7,   144,  1702,     5,   307,     7,   302,
     782,   360,   135,   153,   307,   352,   353,   403,   351,   159,
     160,   272,   782,    27,    28,    29,    30,    24,    27,    28,
      29,    30,   418,  1288,     1,    39,   359,   341,     5,   271,
       7,   243,   244,  1173,   167,   168,   221,   170,   341,   103,
     225,   226,   227,   357,   286,  2020,   163,   255,   103,   104,
      27,    28,    29,    30,   357,    24,   103,   104,    53,   114,
     302,    53,     1,    53,    41,   307,     5,   114,     7,  1903,
     288,   289,   114,  2021,   116,   117,   118,   119,    53,  1913,
     341,     1,   904,    53,   904,     5,  1920,     7,    27,    28,
      29,    30,  1180,   103,   103,  1593,   357,  1479,    16,    17,
    1509,    85,  1615,    46,  1180,   356,   163,    27,    28,    29,
      30,    85,    89,    90,    91,    92,   103,    94,    61,    62,
      97,  1955,   904,  1983,  1984,  1985,  1266,   112,   113,   114,
    1266,    47,   103,    49,   904,    51,    52,   114,   138,   139,
     140,   141,  1973,    59,    60,     1,   305,   306,  1511,     5,
     103,     7,  1588,  1589,    86,    87,    88,  1562,    90,  1564,
     328,   329,  1725,   103,     1,    30,    85,   110,     5,   286,
       7,    27,    28,    29,    30,   114,    92,   120,    18,  2013,
    2014,  2015,   360,   126,    19,  1714,   163,    52,     6,   114,
      27,    28,    29,    30,   114,  1180,  1588,  1589,    63,     8,
    1288,     8,    39,   128,     8,  2039,     8,   150,    16,    17,
     135,   103,  1288,   103,  1314,  1315,  1316,  1317,  1318,  1319,
    1320,  1321,  1322,  1323,  1324,  1754,  1719,  1756,   153,   286,
      61,    62,   305,   306,   159,     6,  1501,   342,   343,   344,
     357,   327,   328,   329,  1605,  1606,  1607,  1608,   104,   105,
     106,  1339,  1661,     8,  1335,  1336,   356,  1338,  1339,  1340,
    1341,  1339,     8,  1339,    16,    17,  1759,  1336,    18,  1338,
    1339,  1340,  1341,   360,  1637,  1788,  1789,    46,  1791,   110,
       9,   114,    19,   116,   103,   114,     8,   116,   103,   120,
    1214,  1383,    61,    62,   271,   126,   305,   306,  1707,    39,
     357,   303,   135,  1288,  1569,   356,   135,  1962,  1963,   286,
     143,   144,  2146,   146,   143,   144,   145,   146,   356,   150,
     104,   105,   106,   156,   157,   302,   356,   341,  1431,  1432,
     307,   356,   341,   272,   193,   194,  1817,  1429,  1430,   356,
     205,   110,  1816,   357,   209,  1858,  1819,   288,   357,   191,
     192,   120,   272,   356,  1339,   103,  2140,   126,  1180,  1499,
    1180,  1501,  1502,   759,   341,   112,   113,  1448,   103,  1846,
    1451,   103,  1453,   112,   113,  1456,   323,   324,   325,  1448,
     357,   150,  1451,  1519,  1453,   103,   782,  1456,  2222,  2223,
    2224,  1479,  1768,   103,  1521,     5,     6,  1874,  1180,  2183,
     104,  1479,   341,  1479,   112,   113,  1506,   103,  1814,   103,
    1180,    97,  1336,  1501,  1338,  1339,  1340,  1341,   357,  1519,
    1802,   341,     1,   103,   104,  1501,     5,   190,     7,    95,
      96,  1523,   131,  1521,   195,    44,    45,   357,   103,   104,
    1521,   112,   113,  1521,   225,  1521,  1273,  1274,    27,    28,
      29,    30,   228,   228,   103,   126,   229,   229,   323,   114,
    1821,  1822,  1823,   134,   230,   103,  1288,   103,  1288,   103,
    1570,   126,   335,   128,  1614,  1740,   103,   356,   356,   150,
     356,  1569,   103,   103,     6,   341,     9,   103,  1588,  1589,
     103,   146,    53,  1569,  1479,   150,   103,    23,   153,    44,
       6,   357,   149,   103,   341,   359,  1288,    85,   904,     9,
     375,    85,    23,    23,  2077,    94,  1501,  1339,  1288,  1339,
     357,   386,   387,   359,  1448,     8,   356,  1451,   103,  1453,
     356,  1612,  1456,   356,  1799,   356,  1521,  1625,   403,  1620,
    1621,  1622,  1623,  1624,   103,   289,  2075,   363,     6,  1625,
     363,   104,  1934,   418,    21,   134,   356,  1339,  1646,   304,
    1641,  1642,  1643,  1644,    44,   308,    12,   190,   304,  1339,
    1646,   288,  2070,   303,  1655,  1656,  1657,     8,    71,  1667,
       6,   236,   165,  2076,  1569,  1666,  1667,  1668,  1669,  1667,
       8,  1667,    46,  1517,  2123,  2124,   103,  1666,  1667,  1668,
    1669,   272,   273,   274,   275,    40,   104,    61,    62,   220,
     221,   222,   223,   224,   269,   270,   303,   288,   289,   290,
      99,   355,  1703,  1704,  1705,    71,   103,  1767,  1768,    75,
     190,   355,  2125,   104,  1703,  1704,  1705,    99,   103,   355,
    1625,  2154,     8,   103,    90,    91,  2209,  1599,  1600,  1601,
    1602,   103,  1740,    21,   357,   103,   110,  1479,   103,  1479,
     103,  1646,   108,   103,  1740,  2074,   120,   311,   312,   313,
     314,   315,   126,   103,    85,     6,  2189,   189,  2207,  1501,
     103,  1501,  1667,   104,  2197,    79,    80,    81,    82,    83,
      84,   137,    46,   272,   349,     9,   150,  1479,   144,  1521,
    2198,  1521,     9,  1784,  1969,   103,  1846,    61,    62,  1479,
    1846,  1799,   151,  2122,  1802,  2208,   355,   103,   103,  1501,
     288,   105,   103,  1799,  1802,   289,  1802,   216,   217,   218,
     219,  1501,   357,   357,  1874,   186,    42,   356,  1874,  1521,
    1902,  1881,  1666,  1667,  1668,  1669,     8,  1569,   356,  1569,
    1912,  1521,   356,   356,   356,  1740,   110,  1919,   356,   356,
     356,    46,   341,  1844,  1845,   356,   120,   356,   103,   134,
      46,   357,   126,   357,    46,   356,    61,    62,   357,  1703,
    1704,  1705,   104,  1864,  1180,    61,    62,  1569,     9,    61,
      62,  1872,  1873,   356,   356,  1876,   150,  2206,     9,  1569,
     103,  1882,   104,  1625,   103,  1625,   103,     6,  1889,  1890,
    1891,   355,   922,   924,  1799,  1767,  1768,  1802,   721,   928,
    1889,  1890,  1891,   720,  1646,   110,  1646,    97,    98,    99,
     100,   923,   719,   722,   110,   120,   536,  1034,   110,    30,
    1370,   126,   526,  1625,   120,  1667,  1934,  1667,   120,   926,
     126,    20,    94,   405,   126,  1625,  1934,  1344,  1934,  1651,
    1999,    52,  2005,  2212,  1646,   150,  2159,  2007,  1997,  2009,
    2062,  2064,    63,  1973,   150,  2063,  1646,  2054,   150,  2065,
       1,  1969,  2185,    89,     5,  1667,     7,  1601,   375,   402,
      91,  1804,  1288,  1969,   759,   800,  1977,  1667,   809,   386,
     387,  1786,  1755,  1757,  1992,   870,    27,    28,    29,    30,
     404,  2053,  2128,  2001,  1260,  1279,  1992,   782,  1740,  1499,
    1740,  1261,   890,  1262,   789,  2001,     1,  2008,  1501,  2010,
       5,   783,     7,  1286,     1,   291,    30,  1025,     5,  1324,
       7,  2022,  2023,  1339,  2025,  2026,  2027,  2028,  2029,  1934,
     205,  2032,    27,    28,    29,    30,  1218,  1480,  1740,   387,
      27,    28,    29,    30,  1517,  1889,  1890,  1891,  1517,   834,
    1740,   120,   414,    94,  2195,   416,   304,  1799,   415,  1799,
    1802,   417,  1802,  2071,  1969,   646,   305,   305,    -1,  2106,
    1088,   624,    -1,    38,    -1,  2071,    -1,    -1,    -1,  2080,
      -1,    46,  2083,    48,    -1,  2086,    -1,  1992,    53,    54,
      55,    -1,    57,   134,   205,    -1,  2001,  1799,   209,  2159,
    1802,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1799,
      -1,    -1,  1802,    -1,   899,   900,   901,   902,   903,   904,
      -1,   906,  2130,  2183,    -1,    -1,    -1,    -1,  2129,  2130,
    2131,  2132,  2130,    -1,  2130,    -1,  2137,  2138,  2139,  2140,
    2129,  2130,  2131,  2132,  2152,    -1,   931,    -1,  2137,  2138,
    2139,  2140,  2212,    -1,  2155,    -1,  2152,    -1,    -1,    -1,
      -1,    -1,    -1,  1479,  2165,   950,  2071,    -1,    -1,    -1,
    2171,  2172,  2173,  2174,  2175,  2176,  2177,  2178,  2179,  2180,
    2181,  2182,    -1,    -1,    -1,  1501,    -1,  2176,  2177,  2178,
      -1,    -1,  1934,     1,  1934,  2196,    -1,     5,    -1,     7,
      -1,    -1,  2203,  2204,  2205,  1521,    -1,    -1,    -1,    -1,
      -1,    -1,   323,    -1,    -1,    -1,    -1,    -1,    -1,    27,
      28,    29,    30,    -1,    -1,  2130,    -1,  1969,    -1,  1969,
      -1,   272,  1934,    -1,    42,    -1,    -1,    45,    -1,    -1,
      -1,    -1,    -1,    -1,  1934,    -1,    -1,  2152,    -1,    -1,
    1992,    -1,  1992,  1569,     1,    -1,    -1,    -1,     5,  2001,
       7,  2001,    -1,    -1,   375,    -1,    -1,  1969,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   386,   387,    -1,    -1,  1969,
      27,    28,    29,    30,    -1,  2129,  2130,  2131,  2132,    -1,
    1992,    -1,   403,  2137,  2138,  2139,  2140,    -1,    -1,  2001,
     341,   288,  1992,    -1,    -1,    -1,   271,   418,   303,  1625,
      -1,  2001,    -1,    46,    -1,    48,   357,    -1,    -1,    -1,
      53,   286,    55,    -1,    -1,    46,    59,    90,    -1,  2071,
    1646,  2071,  2176,  2177,  2178,    -1,    -1,   302,    -1,    -1,
      61,    62,   307,    10,   309,    -1,   341,    -1,    -1,   112,
     113,  1667,    -1,   116,   341,   163,    -1,     1,    -1,    -1,
      -1,     5,   357,     7,    -1,    98,    -1,   100,    -1,  2071,
     357,   134,    39,    40,    41,    42,    -1,    -1,    -1,    -1,
      -1,  2071,   789,    27,    28,    29,    30,    -1,  2130,   110,
    2130,    -1,    -1,    -1,    -1,  1180,    -1,    90,    -1,   120,
      -1,    -1,    -1,    -1,    -1,   126,    73,    -1,    -1,    -1,
    2152,    -1,  2152,    -1,    81,    82,    83,    84,    -1,   112,
     113,   112,   113,   116,  1740,    -1,    -1,   834,  2130,   150,
     121,   122,   123,   124,   125,    -1,    38,   104,    -1,    -1,
    2130,   134,    -1,    -1,    46,    -1,    48,    -1,    50,    -1,
    2152,    53,    54,    55,   121,    57,    -1,    -1,    -1,   126,
     127,   128,  2152,    -1,   131,    -1,    -1,   134,    -1,    24,
      -1,    -1,    -1,  1258,  1259,  1260,  1261,  1262,   286,  1264,
    1265,    -1,    -1,  1799,    39,   248,  1802,    -1,  1273,  1274,
      -1,    -1,   899,   900,   901,   902,   903,   190,    -1,   906,
      -1,    -1,    -1,  1288,    -1,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,   931,   288,   289,   290,    -1,  1314,
    1315,  1316,  1317,  1318,  1319,  1320,  1321,  1322,  1323,  1324,
      -1,   288,   756,   950,   758,    -1,   309,     1,   103,   357,
      -1,     5,    -1,     7,  1339,   248,    -1,    -1,    -1,    -1,
      -1,   775,   776,    -1,   778,    -1,    -1,    -1,    -1,    -1,
     784,   785,    -1,    27,    28,    29,    30,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,   341,   288,   289,   290,    -1,    -1,
      -1,   815,    -1,   817,    -1,   272,   273,   274,    -1,    -1,
     357,    -1,    -1,    -1,    -1,    -1,   309,    -1,  1934,   174,
      -1,    -1,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,     1,    90,    -1,    -1,     5,
      -1,     7,    -1,    97,    -1,    -1,    -1,    -1,   759,    -1,
      -1,    -1,    -1,  1969,    -1,    -1,    -1,    -1,    -1,   303,
      -1,    27,    28,    29,    30,    -1,    -1,   881,    -1,   271,
      -1,   782,    -1,    -1,    -1,    41,  1992,    -1,   789,    -1,
     134,    -1,    -1,     1,   286,  2001,    -1,     5,    -1,     7,
      -1,    -1,    -1,    -1,  1479,    -1,    -1,   341,    -1,    -1,
     302,    -1,    -1,    -1,    -1,   307,    -1,   309,    -1,    27,
      28,    29,    30,   357,   168,    -1,  1501,    -1,    -1,    -1,
      -1,  1506,    -1,    89,    90,    91,    92,    -1,    94,    -1,
      -1,    97,    -1,    -1,  1519,     1,  1521,   951,   952,     5,
      -1,     7,    -1,    -1,   411,   412,   413,    -1,   114,    -1,
      -1,    -1,    -1,    -1,    -1,  2071,    -1,    -1,    -1,    -1,
      -1,    27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    -1,    -1,    41,   887,   444,    -1,    97,
      -1,    -1,    -1,    -1,  1569,  1570,    -1,    -1,   899,   900,
     901,   902,   903,   904,    -1,   906,    -1,   163,    -1,    -1,
      -1,    -1,    -1,  1588,  1589,    -1,   473,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2130,    -1,   134,    -1,   272,    -1,
     931,    -1,    -1,    89,    90,    91,    92,    -1,    94,    -1,
      -1,    97,    -1,    -1,     1,    -1,  2152,    -1,     5,   950,
       7,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   114,    -1,
     168,  1258,  1259,  1260,  1261,  1262,    -1,  1264,  1265,    -1,
      27,    28,    29,    30,    -1,    -1,  1273,  1274,    -1,    -1,
      -1,    -1,    -1,    -1,    41,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1667,    -1,    -1,    -1,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   163,    -1,    -1,
      -1,    -1,    -1,   357,    -1,   271,    -1,  1314,  1315,  1316,
    1317,  1318,  1319,  1320,  1321,  1322,  1323,  1324,    -1,    -1,
     286,    -1,    -1,    90,    91,    92,    -1,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,    -1,
      -1,   307,    -1,   112,   113,    -1,    -1,   114,    -1,    -1,
      -1,    -1,    -1,  1167,   272,  1740,    -1,  1171,   127,    -1,
     129,   130,   131,    -1,    -1,    -1,    -1,  1181,  1182,  1183,
      -1,    -1,  1186,    -1,  1188,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,    -1,
      -1,   357,    -1,    -1,  1208,    -1,   163,    -1,     1,    -1,
      -1,    -1,     5,    -1,     7,   271,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1799,    -1,    -1,  1802,    -1,    -1,
     286,    -1,    -1,   341,    27,    28,    29,    30,    -1,    -1,
    1244,    -1,  1246,    -1,    -1,    38,   302,    -1,  1252,   357,
      -1,   307,    -1,    -1,    -1,    48,    -1,    -1,    -1,    -1,
      53,    -1,    55,  1267,    57,  1269,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1278,    -1,  1280,    -1,    -1,  1180,
      -1,    -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,
       1,    -1,    -1,    -1,     5,    -1,     7,    -1,    -1,    -1,
      -1,   357,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1506,
      -1,    -1,    -1,    -1,   271,   135,    27,    28,    29,    30,
      -1,    -1,  1519,    -1,   144,    -1,    -1,    -1,    -1,   286,
      41,    -1,    -1,    -1,    -1,    -1,    -1,  1238,  1239,   159,
    1241,    -1,    -1,   163,    -1,   302,    -1,   167,   168,    -1,
     307,    -1,   172,   173,   174,   175,   176,    -1,    -1,  1934,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     163,    -1,    -1,  1570,    -1,    -1,    -1,    -1,    -1,    90,
      91,    92,    -1,    94,   341,    -1,    97,  1288,    -1,   112,
     113,  1588,  1589,   116,  1969,    -1,    -1,    -1,  1973,    -1,
     357,    -1,    -1,   114,   127,   128,   129,   130,   131,   132,
     133,   134,   135,  1314,  1315,  1316,  1317,  1318,  1319,  1320,
    1321,  1322,  1323,  1324,    -1,    -1,    -1,    -1,    -1,    -1,
       1,    71,    -1,    -1,    -1,    -1,    -1,    -1,  1339,    -1,
      11,    12,    13,    14,    15,    16,    17,    -1,    -1,    20,
      -1,    -1,   163,   176,    -1,  1459,  1460,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,    -1,    -1,    -1,   115,    -1,    -1,   271,    -1,
     120,    -1,    -1,  1487,    -1,    -1,   126,    -1,    -1,    -1,
     130,    -1,    -1,   286,    -1,    -1,    -1,    -1,    -1,  1503,
      71,    -1,    -1,    74,    75,    76,    77,    78,    79,   302,
     150,    -1,    -1,    -1,   307,    86,   309,    88,    89,    90,
      91,    92,    93,    94,    95,    -1,    97,    98,    99,   100,
      -1,   102,    -1,    -1,  1538,   106,    -1,   108,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,   117,    -1,   341,    -1,
      -1,  1555,    -1,  1557,    -1,  2130,    -1,    39,    -1,    -1,
     271,    -1,    -1,    -1,   357,   136,   137,   138,   139,    -1,
      -1,   142,    -1,   144,    -1,   286,    -1,    -1,  1479,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   302,    -1,    -1,    -1,    -1,   307,    -1,  1499,    -1,
    1501,  1502,    -1,    -1,    -1,  1506,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1519,    -1,
    1521,   103,    -1,    -1,    -1,    -1,    -1,    -1,  1529,     1,
     341,  1532,    -1,     5,  1535,     7,    -1,    -1,    -1,    -1,
      -1,   281,    -1,    -1,   284,   285,   357,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    27,    28,    29,    30,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    38,    -1,  1569,  1570,
      -1,    -1,    -1,    -1,    -1,    -1,    48,    -1,    -1,   319,
     320,    53,    -1,    55,    -1,    57,    -1,  1588,  1589,    -1,
      -1,    -1,   174,    -1,    -1,   177,   178,   179,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   189,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,  1732,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     0,     1,    -1,    -1,    -1,     5,    -1,     7,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1766,    -1,    -1,    -1,  1667,    -1,    -1,    27,
      28,    29,    30,    -1,    -1,    -1,  1973,    -1,    -1,    -1,
      38,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    46,  1793,
      48,   163,    50,    -1,    -1,    53,    54,    55,    -1,    57,
      -1,    -1,   181,    61,    62,    63,    -1,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,    -1,    -1,  1740,
      -1,    -1,    -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,
      -1,    -1,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   120,    -1,    38,    -1,    -1,    -1,   126,    43,
      -1,    -1,    46,    47,    48,    49,    -1,    -1,    52,    53,
      -1,    55,    56,    57,    -1,    59,    -1,   458,    -1,    -1,
      -1,    -1,   150,    -1,   465,    -1,    -1,    -1,  1799,   271,
      -1,  1802,    -1,    -1,    -1,   476,    -1,   478,    -1,   480,
      -1,   482,    -1,     1,   286,    -1,   487,     5,    -1,     7,
     491,    -1,   493,    -1,    98,    -1,   100,   101,   102,    -1,
     302,   502,    -1,    -1,    -1,   307,    24,   309,    -1,    27,
      28,    29,    30,    31,    32,    -1,    -1,    -1,    36,    37,
      38,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1967,    -1,    53,    -1,    -1,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    63,    64,    -1,    -1,    -1,
      68,    -1,    -1,    71,    -1,   357,    -1,    -1,    -1,    -1,
      -1,    79,    80,    81,    82,    83,    84,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    -1,    -1,    -1,
      98,    -1,   100,   271,    -1,   103,   104,   105,   106,    -1,
      -1,   109,    -1,   111,    -1,    -1,   114,   115,   286,    -1,
      -1,    -1,   120,  1934,    -1,    -1,    -1,    -1,   126,    -1,
      -1,    -1,    -1,    -1,   302,    -1,    -1,    -1,    -1,   307,
      -1,   309,    -1,    -1,   142,    -1,    -1,    -1,    -1,   147,
      -1,    -1,   150,    -1,    -1,    -1,    -1,   155,  1969,    -1,
     158,    -1,  1973,   161,   162,   163,    -1,    -1,   166,    -1,
      -1,   169,    -1,   171,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   271,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   196,   197,
      -1,    -1,   286,    -1,    -1,    38,    -1,   291,   292,   293,
     294,    -1,    -1,    46,    -1,    48,    -1,    50,   302,    -1,
      53,    54,    55,   307,    57,   309,   310,    -1,    61,    62,
      -1,    -1,    -1,    -1,   232,   233,   234,   235,    -1,    -1,
      -1,    -1,    -1,   241,   242,    -1,    -1,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,    -1,    -1,   271,    -1,    -1,    -1,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,   286,    -1,
      -1,    -1,    -1,   126,    -1,    -1,    -1,    -1,   296,    -1,
      -1,    -1,    -1,    -1,   302,    -1,    -1,    -1,    -1,   307,
      -1,    -1,    -1,    -1,    -1,   313,   314,   150,   316,  2130,
      -1,   319,   320,   321,   322,    -1,    -1,    -1,   326,    -1,
      -1,    -1,   330,   331,   332,    -1,    -1,    -1,   336,   337,
      -1,    -1,     1,   341,    -1,    -1,     5,   345,     7,    -1,
     348,   349,    -1,    -1,    -1,    -1,   354,    -1,   356,   357,
     358,    -1,    -1,   361,    -1,    24,    -1,    -1,    27,    28,
      29,    30,    31,    32,    -1,    -1,    -1,    36,    37,    38,
     112,   113,    -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   134,    -1,    63,    64,    -1,    -1,    -1,    68,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    94,    -1,    -1,   271,    98,
      -1,   100,    -1,    -1,   103,   104,   105,   106,    -1,    -1,
     109,    -1,   111,   286,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,    -1,    -1,    -1,    -1,   126,    -1,   302,
      -1,    -1,    -1,    -1,   307,    -1,   309,    -1,    -1,    -1,
      -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,   147,    -1,
      -1,   150,    -1,    -1,    -1,    -1,   155,    -1,    -1,   158,
      -1,    -1,   161,   162,   163,    -1,    -1,   166,    -1,    -1,
     169,    -1,   171,    -1,    -1,    -1,   248,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1007,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   196,   197,    -1,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,   281,
     282,   283,   284,   285,    -1,    -1,   288,   289,   290,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   232,   233,   234,   235,   309,    -1,    -1,
      -1,    -1,   241,   242,    -1,    -1,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
      -1,    -1,   271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,
      -1,    -1,    -1,   302,    -1,    -1,    -1,    -1,   307,    -1,
      -1,    -1,    -1,    -1,   313,   314,    -1,   316,    -1,    -1,
     319,   320,   321,   322,    -1,    -1,    -1,   326,    -1,    -1,
      -1,   330,   331,   332,    -1,    -1,    -1,   336,   337,    -1,
      -1,     1,   341,    -1,    -1,     5,   345,     7,    -1,   348,
     349,    -1,    -1,    -1,    -1,   354,    -1,   356,   357,   358,
      -1,    -1,   361,    -1,    24,    -1,    -1,    27,    28,    29,
      30,    31,    32,    -1,    -1,    -1,    36,    37,    38,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,   104,    -1,    -1,    68,    -1,
      -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    94,   134,    -1,    -1,    98,    -1,
     100,    -1,    -1,   103,   104,   105,   106,    -1,    -1,   109,
      -1,   111,   151,    -1,   114,   115,    -1,    -1,    -1,    -1,
     120,    -1,    -1,    -1,    -1,    -1,   126,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   142,    -1,    -1,    -1,    -1,   147,    -1,    -1,
     150,    -1,    -1,    -1,    -1,   155,    -1,    -1,   158,    -1,
      -1,   161,   162,   163,    -1,    -1,   166,    -1,    -1,   169,
      -1,   171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   196,   197,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
      -1,    -1,   232,   233,   234,   235,    -1,    -1,    -1,    -1,
      -1,   241,   242,    -1,    -1,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,    -1,
     309,   271,    -1,    -1,   313,   314,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   323,    -1,   286,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,
      -1,    -1,   302,    -1,    -1,    -1,    -1,   307,    -1,    -1,
     349,    -1,    -1,   313,   314,    -1,   316,    -1,    -1,   319,
     320,   321,   322,    -1,    -1,    -1,   326,    -1,    -1,    -1,
     330,   331,   332,     5,    -1,     7,   336,   337,    -1,    -1,
      -1,   341,    -1,    -1,    -1,   345,    -1,    -1,   348,   349,
      -1,    -1,    24,    -1,   354,    -1,   356,   357,   358,    31,
      32,   361,    -1,    -1,    36,    37,    38,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    63,    64,    -1,    -1,    -1,    68,    -1,    -1,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    81,
      82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,   100,    -1,
      -1,   103,   104,   105,   106,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,   120,    -1,
      -1,    -1,    -1,    -1,   126,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     142,    -1,    -1,    -1,    -1,   147,    -1,    -1,   150,    -1,
      -1,    -1,    -1,   155,    -1,    -1,   158,    -1,    -1,   161,
     162,    -1,    -1,    -1,   166,    -1,    -1,   169,    -1,   171,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   196,   197,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     232,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,   241,
     242,    -1,    -1,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,    -1,    -1,   271,
      -1,    -1,     6,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   286,    -1,    -1,    -1,    -1,    -1,
      24,    -1,    -1,    -1,   296,    -1,    -1,    -1,    32,    -1,
     302,    -1,    -1,    37,    -1,   307,    -1,    -1,    -1,    -1,
      -1,   313,   314,    -1,   316,    -1,    -1,   319,   320,   321,
     322,    -1,    -1,    -1,   326,    -1,    -1,    -1,   330,   331,
     332,    -1,    -1,    -1,   336,   337,    -1,    71,    -1,    -1,
      -1,    -1,    -1,   345,    -1,    -1,   348,   349,    -1,    -1,
      -1,    85,   354,    87,   356,   357,   358,    -1,    -1,   361,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,
     104,   105,   106,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,   115,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,   126,    -1,    -1,    -1,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,    -1,
      -1,    -1,    -1,   147,    -1,    -1,   150,    -1,    -1,    -1,
      -1,   155,    -1,    -1,   158,    -1,    -1,   161,   162,    -1,
      -1,    -1,   166,    -1,    -1,   169,    -1,   171,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   196,   197,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     6,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    24,    -1,    -1,    -1,    -1,    -1,    -1,   232,    32,
      -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,    -1,    -1,   271,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   281,    -1,    -1,
     284,   285,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   297,    -1,    -1,    -1,    -1,    -1,    -1,
     103,   104,   105,   106,    -1,    -1,   109,    -1,   111,   313,
     314,    -1,   115,    -1,    -1,   319,   320,   120,    -1,    -1,
      -1,    -1,    -1,   126,    -1,    -1,    -1,   130,   332,    -1,
      -1,    -1,   336,   337,    -1,    -1,    -1,    -1,    -1,   142,
      -1,    -1,   346,   347,   147,   349,    -1,   150,    -1,    -1,
      -1,    -1,   155,    -1,   358,   158,    -1,   361,   161,   162,
      -1,    -1,    -1,   166,    -1,    -1,   169,    -1,   171,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   196,   197,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     6,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    24,    -1,    -1,    -1,    -1,    -1,    -1,   232,
      32,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,    -1,    -1,   271,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   281,    -1,
      -1,   284,   285,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   103,   104,   105,   106,    -1,    -1,   109,    -1,   111,
     313,   314,    -1,   115,    -1,    -1,   319,   320,   120,    -1,
      -1,    -1,    -1,    -1,   126,    -1,    -1,    -1,   130,   332,
      -1,    -1,    -1,   336,   337,    -1,    -1,    -1,    -1,    -1,
     142,    -1,    -1,   346,   347,   147,   349,    -1,   150,    -1,
      -1,    -1,    -1,   155,    -1,   358,   158,    -1,   361,   161,
     162,    -1,    -1,    -1,   166,    -1,    -1,   169,    -1,   171,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   196,   197,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     6,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    24,    -1,    -1,    -1,    -1,    -1,    -1,
     232,    32,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,    -1,    -1,   271,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   281,
      -1,    -1,   284,   285,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   103,   104,   105,   106,    -1,    -1,   109,    -1,
     111,   313,   314,    -1,   115,    -1,    -1,   319,   320,   120,
      -1,    -1,    -1,    -1,    -1,   126,    -1,    -1,    -1,   130,
     332,    -1,    -1,    -1,   336,   337,    -1,    -1,    -1,    -1,
      -1,   142,    -1,    -1,   346,   347,   147,   349,    -1,   150,
      -1,    -1,    -1,    -1,   155,    -1,   358,   158,    -1,   361,
     161,   162,    -1,    -1,    -1,   166,    -1,    -1,   169,    -1,
     171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   196,   197,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     6,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    24,    -1,    -1,    -1,    -1,    -1,
      -1,   232,    32,    -1,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,    -1,    -1,
     271,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     281,    -1,    -1,   284,   285,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   103,   104,   105,   106,    -1,    -1,   109,
      -1,   111,   313,   314,    -1,   115,    -1,    -1,   319,   320,
     120,    -1,    -1,    -1,    -1,    -1,   126,    -1,    -1,    -1,
     130,   332,    -1,    -1,    -1,   336,   337,    -1,    -1,    -1,
      -1,    -1,   142,    -1,    -1,   346,   347,   147,   349,    -1,
     150,    -1,    -1,    -1,    -1,   155,    -1,   358,   158,    -1,
     361,   161,   162,    -1,    -1,    -1,   166,    -1,    -1,   169,
      -1,   171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   196,   197,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    10,    11,    12,    13,    14,    15,    -1,    -1,    -1,
      -1,    20,    -1,    -1,    -1,    24,    -1,    -1,    -1,    -1,
      -1,    -1,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,    -1,
      -1,   271,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   281,    -1,    -1,   284,   285,    -1,    -1,    -1,    -1,
      -1,    -1,    22,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   313,   314,    -1,   115,    -1,    -1,   319,
     320,   120,    -1,    -1,    -1,    -1,    -1,   126,    -1,    -1,
      -1,   130,   332,    -1,    -1,    -1,   336,   337,    -1,    -1,
      22,    71,    -1,   142,    -1,    -1,   346,   347,   147,   349,
      -1,   150,    -1,    -1,    -1,    -1,   155,    -1,   358,   158,
      -1,   361,   161,   162,    -1,    -1,    -1,   166,    -1,    -1,
     169,    -1,   171,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,    -1,    -1,    -1,   115,    -1,    -1,    -1,    71,
     120,    -1,    -1,    -1,    -1,    -1,   126,   196,   197,    -1,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   142,    -1,    -1,    -1,    -1,   147,    -1,    -1,
     150,   103,   104,   105,   106,   155,    -1,    -1,   158,   111,
      -1,   161,   162,   115,    -1,    -1,   166,    -1,   120,   169,
      -1,   171,    -1,    -1,   126,    -1,    -1,    -1,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     142,    -1,    -1,    -1,    -1,   147,   196,   197,   150,    -1,
      -1,    -1,    -1,   155,    -1,    -1,   158,    -1,    -1,   161,
     162,    -1,   281,    -1,   166,   284,   285,   169,    -1,   171,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   196,   197,    -1,    -1,    -1,    -1,
     319,   320,    -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   346,   347,    -1,
      -1,   281,    -1,    -1,   284,   285,    -1,   356,    -1,   358,
      -1,    -1,   361,    23,    24,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,
     320,    -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,   281,
      -1,    -1,   284,   285,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    -1,    -1,    -1,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   356,    -1,   358,    -1,
      -1,   361,    -1,    -1,    -1,    -1,    -1,   319,   320,    -1,
     322,    -1,    -1,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,
     120,    -1,    -1,    -1,   346,   347,   126,    -1,    -1,    -1,
     130,    -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,   361,
      -1,    -1,   142,    -1,    -1,    -1,    -1,   147,    -1,    -1,
     150,    -1,    -1,    -1,    -1,   155,    -1,    -1,   158,    -1,
      24,   161,   162,    -1,    -1,    -1,   166,    31,    32,   169,
      -1,   171,    36,    37,    38,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    53,
      -1,    -1,    -1,    -1,    -1,    -1,   196,   197,    -1,    63,
      64,    -1,    -1,    -1,    68,    -1,    -1,    71,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,
      84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,   100,    -1,    -1,   103,
     104,   105,   106,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,   115,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,    -1,
      -1,   281,    -1,   147,   284,   285,   150,    -1,    -1,    -1,
      -1,   155,    -1,    -1,   158,    -1,    -1,   161,   162,    -1,
      -1,    -1,   166,    -1,    -1,   169,    -1,   171,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,
     320,    -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   196,   197,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   356,    -1,   358,    -1,
      -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,   232,   233,
     234,   235,    -1,    -1,    -1,    -1,    -1,   241,   242,    -1,
      -1,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,    -1,    -1,   271,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      24,    -1,   286,    -1,    -1,    -1,    -1,    31,    32,    -1,
      -1,    -1,   296,    37,    -1,    -1,    -1,    -1,   302,    -1,
      -1,    -1,    -1,   307,    -1,    -1,    -1,    -1,    -1,   313,
     314,    -1,   316,    -1,    -1,   319,   320,   321,   322,    -1,
      -1,    -1,   326,    -1,    -1,    -1,   330,   331,   332,    -1,
      -1,    -1,   336,   337,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   345,    -1,    -1,   348,   349,    -1,    -1,    -1,    -1,
     354,    -1,   356,    -1,   358,    -1,    -1,   361,    -1,   103,
     104,   105,   106,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,   115,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,    -1,
      -1,    -1,    -1,   147,    -1,    -1,   150,    -1,    -1,    -1,
      -1,   155,    -1,    -1,   158,    -1,    -1,   161,   162,    -1,
      -1,    -1,   166,    -1,    -1,   169,    -1,   171,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    24,
      -1,    -1,   196,   197,    -1,    -1,    31,    32,    -1,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   232,   233,
     234,   235,    -1,    -1,    -1,    -1,    -1,   241,   242,    -1,
      -1,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,    -1,    -1,   271,   103,   104,
     105,   106,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
     115,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,
      -1,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,    -1,   313,
     314,    -1,   147,    -1,    -1,   150,    -1,    -1,    -1,    -1,
     155,    -1,    -1,   158,    -1,    -1,   161,   162,   332,    -1,
      -1,   166,   336,   337,   169,    -1,   171,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   348,   349,    -1,    -1,    -1,    -1,
      -1,    -1,   356,    -1,   358,    -1,    -1,   361,    24,    -1,
      -1,   196,   197,    -1,    -1,    -1,    32,    -1,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   232,   233,   234,
     235,    -1,    -1,    -1,    -1,    71,   241,   242,    -1,    -1,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,    -1,    -1,   271,   103,   104,   105,
     106,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,   115,
      -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,
     126,    -1,    -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   142,    -1,   313,   314,
      -1,   147,    -1,    -1,   150,    -1,    -1,    -1,    -1,   155,
      -1,    -1,   158,    -1,    -1,   161,   162,   332,    -1,    -1,
     166,   336,   337,   169,    -1,   171,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   348,   349,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,    -1,    -1,   361,    -1,    -1,    -1,
     196,   197,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    24,
      -1,    -1,    -1,    -1,    -1,    -1,   232,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,    -1,    -1,   271,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   281,    -1,    -1,   284,   285,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   313,   314,    -1,
     115,    -1,    -1,   319,   320,   120,    -1,    -1,    -1,    -1,
      -1,   126,    -1,    -1,    -1,   130,   332,    -1,    -1,    -1,
     336,   337,    -1,    -1,    -1,    -1,    -1,   142,    -1,    -1,
     346,   347,   147,   349,    -1,   150,    -1,    -1,    -1,    -1,
     155,    -1,   358,   158,    -1,   361,   161,   162,    -1,    -1,
      24,   166,    -1,    -1,   169,    -1,   171,    31,    32,    -1,
      -1,    -1,    -1,    37,    38,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   196,   197,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     104,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,   115,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   281,    -1,   142,   284,
     285,    -1,    -1,   147,    -1,    -1,   150,    -1,    -1,    -1,
      -1,   155,    -1,    -1,   158,    -1,    -1,   161,   162,    -1,
      -1,    -1,   166,    -1,    -1,   169,    -1,   171,    -1,    -1,
      -1,    -1,    -1,    -1,   319,   320,    -1,   322,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   196,   197,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   356,    -1,   358,    -1,    -1,   361,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   232,   233,
     234,   235,    -1,    -1,    -1,    -1,    -1,   241,   242,    -1,
      -1,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,    24,    -1,   271,    -1,    -1,
      -1,    -1,    31,    32,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,   286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,
      -1,    -1,    -1,   307,    -1,   309,    -1,    -1,    -1,   313,
     314,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   326,    -1,    -1,    -1,    -1,    -1,   332,    -1,
      -1,    -1,   336,   337,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   348,   349,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,   115,    -1,    -1,    -1,
      -1,   120,    -1,    -1,    -1,    -1,    -1,   126,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,   147,    -1,
      -1,   150,    -1,    -1,    -1,    -1,   155,    -1,    -1,   158,
      -1,    -1,   161,   162,    -1,    -1,    -1,   166,    -1,    -1,
     169,    -1,   171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   196,   197,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   232,   233,   234,   235,    -1,    -1,    -1,
      -1,    -1,   241,   242,    -1,    -1,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
      -1,    -1,   271,    -1,    -1,    -1,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,    84,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,   104,
     105,   106,    -1,    -1,   313,   314,   111,    -1,    -1,    -1,
     115,    -1,    -1,    -1,    71,   120,    -1,    -1,    -1,    -1,
      -1,   126,    -1,   332,    -1,   130,    -1,   336,   337,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,    -1,   348,
     349,    -1,   147,    -1,    -1,   150,   103,   104,   105,   106,
     155,    -1,    -1,   158,   111,    -1,   161,   162,   115,    -1,
      -1,   166,    71,   120,   169,    -1,   171,    -1,    -1,   126,
      -1,    -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,
     147,   196,   197,   150,   103,   104,   105,   106,   155,    -1,
      -1,   158,   111,    -1,   161,   162,   115,    -1,    -1,   166,
      -1,   120,   169,    -1,   171,    -1,    -1,   126,    -1,    -1,
      -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,   147,   196,
     197,   150,    -1,    -1,    -1,    -1,   155,    -1,    -1,   158,
      -1,    -1,   161,   162,    -1,    -1,    -1,   166,    -1,    -1,
     169,    -1,   171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   104,    -1,    -1,    -1,    -1,   281,    -1,    -1,   284,
     285,    -1,    -1,    -1,    -1,    -1,    -1,   196,   197,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,
      -1,   134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   319,   320,    -1,   322,   151,    -1,
      -1,    -1,    -1,    -1,   281,    -1,    -1,   284,   285,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,    -1,    -1,   361,    -1,    -1,    -1,
      -1,    -1,   319,   320,    -1,   322,    -1,    -1,    -1,    -1,
      -1,    -1,   281,    -1,    -1,   284,   285,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,    -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,
     319,   320,    -1,   322,    -1,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,    -1,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
      -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   309,    -1,    -1,    -1,
     313,   314,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   349
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   365,     0,     1,     5,     7,    27,    28,    29,    30,
      38,    46,    48,    50,    53,    54,    55,    57,    61,    62,
      63,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,   110,   120,   126,   150,   271,   286,
     302,   307,   309,   366,   419,   420,   421,   422,   501,   502,
     503,   505,   520,   366,   105,   104,   497,   497,   497,   503,
     514,   503,   505,   520,   503,   508,   508,   508,   503,   511,
     422,    50,   423,    38,    46,    48,    53,    54,    55,    57,
     271,   286,   302,   307,   309,   424,    50,   425,    38,    46,
      48,    50,    53,    54,    55,    57,   271,   286,   302,   307,
     309,   430,    54,   431,    38,    43,    46,    47,    48,    49,
      52,    53,    55,    56,    57,    59,    98,   100,   101,   102,
     271,   286,   291,   292,   293,   294,   302,   307,   309,   310,
     432,   286,   291,   292,   307,   435,    46,    48,    53,    55,
      59,    98,   100,   436,    48,   437,    24,    31,    32,    37,
     103,   104,   105,   106,   109,   111,   115,   120,   126,   142,
     147,   150,   155,   158,   161,   162,   166,   169,   171,   196,
     197,   232,   233,   234,   235,   241,   242,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   271,   313,   314,   332,   336,   337,   348,   349,   358,
     361,   445,   498,   627,   628,   631,   632,   633,   634,   638,
     701,   704,   706,   710,   715,   716,   718,   720,   730,   732,
     734,   736,   738,   740,   744,   746,   748,   750,   752,   754,
     756,   758,   760,   762,   773,   781,   783,   785,   786,   788,
     790,   792,   794,   796,   798,   800,   802,    59,   342,   343,
     344,   438,   444,    59,   439,   444,   104,   440,   441,   369,
     385,   386,    90,   278,   280,   514,   514,   514,   514,     0,
     366,   497,   497,    58,   339,   340,   517,   518,   519,    36,
      38,    53,    63,    64,    68,    71,    79,    80,    81,    82,
      83,    84,    98,   100,   247,   271,   286,   296,   302,   307,
     316,   319,   320,   321,   322,   326,   330,   331,   345,   354,
     356,   524,   525,   526,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   544,   545,   546,
     549,   550,   557,   561,   569,   570,   573,   574,   575,   576,
     577,   598,   599,   601,   602,   604,   605,   608,   609,   610,
     620,   621,   622,   623,   624,   625,   626,   633,   640,   641,
     642,   643,   644,   645,   649,   650,   651,   685,   699,   704,
     705,   728,   729,   730,   763,   366,   355,   355,   366,   497,
     581,   446,   449,   524,   497,   456,   459,   627,   651,   462,
     497,   470,   505,   521,   514,   503,   505,   508,   508,   508,
     511,    90,   278,   280,   514,   514,   514,   514,   520,   429,
     503,   514,   515,   426,   501,   503,   504,   427,   503,   505,
     506,   521,   428,   503,   508,   509,   508,   428,   503,   511,
     512,    90,   278,   280,   674,   429,   429,   429,   429,   508,
     514,   434,   502,   523,   503,   523,   505,   523,    46,   523,
     508,   508,   523,   511,   523,    46,    47,   508,   523,   523,
      90,   278,   295,   674,   675,   514,    46,   523,    46,   523,
      46,   523,    46,   523,   514,   514,   514,    46,   523,   392,
     514,    46,   523,    46,   523,   514,   404,   503,   505,   508,
     508,   523,    46,   508,   505,   104,   107,   108,   109,   733,
     112,   113,   248,   249,   252,   636,   637,    33,    34,    35,
     248,   707,   133,   639,   167,   168,   784,   112,   113,   114,
     735,   114,   116,   117,   118,   119,   737,   112,   113,   121,
     122,   123,   124,   125,   739,   112,   113,   116,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   176,   741,   114,
     116,   135,   143,   144,   145,   146,   745,   114,   135,   148,
     298,   747,   112,   113,   127,   129,   130,   131,   152,   153,
     154,   749,   114,   116,   135,   143,   144,   146,   156,   157,
     751,   128,   144,   153,   159,   160,   753,   144,   160,   755,
     153,   163,   164,   757,   131,   135,   167,   168,   759,   135,
     167,   168,   170,   761,   135,   144,   159,   163,   167,   168,
     172,   173,   174,   175,   176,   764,   114,   167,   168,   774,
     135,   167,   168,   198,   231,   782,   114,   126,   128,   146,
     150,   153,   236,   269,   270,   349,   717,   719,   789,   237,
     791,   237,   793,   163,   238,   239,   240,   795,   128,   153,
     787,   116,   132,   153,   159,   243,   244,   797,   128,   153,
     799,   114,   128,   135,   153,   159,   801,   104,   131,   134,
     151,   309,   323,   349,   702,   703,   704,   112,   113,   116,
     134,   248,   272,   273,   274,   275,   276,   277,   279,   280,
     281,   282,   283,   284,   285,   288,   289,   290,   309,   721,
     722,   725,   323,   333,   709,   645,   650,   334,   232,   241,
     242,   245,   246,   803,   352,   353,   391,   712,   644,   497,
     410,   444,   343,   390,   444,   379,   396,    47,    49,    51,
      52,    59,    60,    92,   442,   514,   514,   514,   373,   669,
     684,   671,   673,   103,   103,   103,    85,   717,   287,   621,
     171,   497,   627,   700,   700,    63,    99,   497,   104,   702,
      90,   190,   278,   721,   722,   287,   287,   303,   287,   305,
     306,   558,    85,   163,    85,    85,   717,   104,     5,   367,
     652,   653,   341,   522,   535,   418,   449,   373,   288,   289,
     547,   548,   416,   163,   297,   298,   299,   300,   301,   551,
     552,   403,   317,   572,   397,     6,    71,    85,    87,   111,
     115,   120,   126,   130,   150,   232,   281,   284,   285,   297,
     319,   320,   346,   347,   358,   584,   585,   586,   587,   588,
     589,   590,   592,   593,   594,   595,   596,   597,   628,   631,
     638,   694,   695,   696,   701,   706,   710,   716,   717,   718,
     720,   726,   727,   730,   411,   417,    39,    40,   186,   189,
     578,   579,   397,    85,   323,   324,   325,   600,   606,   607,
     397,    85,   603,   606,   376,   382,   402,   327,   328,   329,
     611,   612,   616,   617,    24,   627,   629,   630,    46,    16,
      17,    18,    19,   360,     9,    25,    55,    10,    11,    12,
      13,    14,    15,    20,   111,   115,   120,   126,   142,   147,
     150,   155,   158,   161,   162,   166,   169,   171,   196,   197,
     322,   358,   628,   630,   631,   646,   647,   648,   651,   686,
     687,   688,   689,   690,   691,   692,   693,   695,   696,   697,
     698,    53,    53,    23,   356,   667,   686,   687,   692,   667,
      39,   356,   580,   356,   356,   356,   356,   356,   517,   524,
     581,   446,   449,   456,   459,   462,   470,   514,   514,   514,
     373,   669,   684,   671,   673,   524,   417,    58,    58,    58,
      58,   459,    58,   470,   514,   373,   393,   401,   408,   459,
     417,    44,   433,   503,   508,   523,   514,    46,   373,   503,
     503,   503,   503,   393,   401,   408,   503,   373,   503,   503,
     401,   508,   497,   413,     8,     9,   114,   252,   253,   635,
     301,   409,   104,   127,   287,   413,   412,   378,   412,   387,
     111,   126,   111,   126,   369,   138,   139,   140,   141,   742,
     385,   412,   388,   412,   389,   386,   412,   388,   368,   377,
     371,   414,   415,    24,    39,   103,   174,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
     765,   766,   767,   412,   374,   181,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   775,   780,   406,   412,   385,   386,   391,
     719,   405,   405,   362,   405,   405,   362,   405,   384,   381,
     375,   412,   395,   394,   408,   394,   408,   112,   113,   126,
     134,   150,   272,   273,   274,   723,   724,   725,   372,   334,
     334,   103,   405,   384,   381,   375,   395,   351,   711,   359,
     443,   444,   682,   682,   682,   288,   356,   668,   303,   356,
     683,   356,   558,   670,   356,   498,   672,     6,   126,   150,
     596,    85,   596,   618,   619,   645,   176,    24,    24,    97,
     356,    53,    53,    53,   103,   305,    53,   725,    53,   596,
     596,   305,   306,   562,   596,   103,   613,   614,   615,   627,
     631,   645,   649,   710,   716,   616,   596,   596,    85,   498,
      22,   651,   656,   657,   658,   665,   692,   693,     8,   357,
     498,   356,   103,   103,   548,    78,   111,   126,   171,   255,
     554,   498,   103,   103,   103,   498,   553,   552,   142,   155,
     171,   318,   596,   404,     6,   596,    85,   378,   387,   369,
     385,   386,    85,   397,   397,   589,   628,   696,    16,    17,
      18,    19,   360,    21,    23,     9,    55,     6,   606,    85,
      87,   237,   297,     8,     8,   103,   103,   579,     6,     8,
       6,   596,   614,   627,   631,   612,     8,   497,   356,   497,
     697,   697,   688,   689,   690,   644,   356,   541,   629,   687,
     385,   388,   386,   388,   368,   377,   371,   414,   415,   410,
     374,   406,   397,   692,     8,    21,    16,    17,    18,    19,
     360,     8,    21,    23,     9,   686,   687,   692,   596,   596,
     103,   357,   366,    21,   366,   103,   485,   417,   448,   450,
     458,   467,   471,   580,   356,   356,   356,   356,   356,   682,
     682,   682,   668,   683,   670,   672,   103,   103,   103,   103,
     103,   356,   682,   104,   372,   503,   103,   637,   412,   380,
     103,   399,   399,   378,   385,   378,   385,   114,   131,   136,
     137,   237,   385,   743,   370,    97,   771,   190,   769,   195,
     772,   193,   194,   770,   191,   192,   768,   131,   221,   225,
     226,   227,   779,   216,   217,   218,   219,   777,   220,   221,
     222,   223,   224,   778,   778,   225,   228,   228,   229,   230,
     229,   114,   131,   163,   776,   407,   405,   103,   103,   112,
     113,   112,   113,   372,   372,   103,   103,   335,   708,   103,
     160,   350,   713,   717,   356,   356,   356,   103,   478,   373,
     562,   483,   393,   479,   103,   401,   484,   408,   596,     6,
       6,   596,   417,   629,    90,    93,   522,   659,   660,    39,
     174,   179,   189,   766,   767,   498,   498,   103,   645,   654,
     655,   596,   596,   596,   372,   103,   596,    53,   596,   373,
     393,   103,   564,   566,   567,   401,   104,   289,   559,    23,
     402,    85,   327,    44,   596,   367,     6,   367,   271,   286,
     302,   307,   662,   663,    90,    93,   522,   661,   664,   367,
     653,   451,   378,   149,   144,   149,   555,   556,   104,   114,
     571,   631,   114,   571,   410,   114,   571,   596,     6,   596,
     596,   359,   584,   584,   585,   586,   587,   103,   589,   584,
     591,   629,   651,   596,   596,    85,     9,    85,   628,   696,
     726,   726,   596,   607,   596,   606,   617,   370,   618,   356,
     367,   542,   543,   359,   692,   686,   692,   697,   697,   688,
     689,   690,   692,   103,   686,   692,   648,   692,    21,    21,
     103,    40,   366,   357,   366,   419,   522,   580,    38,    48,
      53,    55,    57,   163,   271,   286,   302,   307,   309,   357,
     366,   419,   447,   522,    94,   114,   163,   357,   366,   419,
     487,   493,   494,   522,   524,    41,    89,    90,    91,    92,
      94,    97,   114,   163,   271,   286,   302,   307,   357,   366,
     419,   457,   468,   522,   527,   534,    41,    90,    91,    92,
     114,   163,   357,   366,   419,   468,   522,   527,    42,    45,
     163,   286,   357,   366,   419,   417,   448,   450,   458,   467,
     471,   356,   356,   356,   373,   393,   401,   408,   471,   372,
     372,     8,   409,   412,   385,   767,   412,   406,   363,   363,
     385,   385,   386,   386,   708,   338,   708,   103,   383,   391,
     112,   113,   714,   481,   482,   480,   289,   357,   366,   419,
     522,   668,   564,   566,   357,   366,   419,   522,   683,   357,
     366,   419,   522,   670,   559,   357,   366,   419,   522,   672,
     596,   596,     6,   104,   499,   499,   660,   410,   370,   370,
     356,   535,   659,   394,   394,   372,   372,   372,   596,   372,
      21,   104,   289,   304,   563,   304,   565,    21,   308,   560,
     613,   627,   631,   615,   614,   596,    44,    82,    83,   666,
     693,   699,   190,   288,   373,   303,   558,   663,   499,   499,
     662,   664,   357,   366,   524,   385,     8,   410,   571,   571,
      71,   571,   596,     6,   596,   165,   596,   606,   606,     6,
     357,   527,   654,   656,     8,   357,   686,   686,   103,    40,
     417,   497,   516,   497,   507,   497,   510,   510,   497,   513,
     104,    90,   278,   280,   516,   516,   516,   516,   366,    79,
      80,   495,   496,   627,   412,    99,   366,   366,   366,   366,
     366,   454,   455,   632,   499,   499,   355,    95,    96,   469,
     103,   104,   129,   130,   248,   268,   269,   475,   476,   486,
      86,    87,    88,    90,   460,   461,   366,   366,   366,   366,
     534,   455,   499,   499,   355,   476,   460,   366,   366,   366,
     104,   355,    99,   373,   357,   357,   357,   357,   357,   481,
     482,   480,   357,   103,   731,     8,   398,   103,   383,   391,
      94,   134,   272,   357,   366,   419,   522,   680,    90,    97,
     134,   168,   272,   357,   366,   419,   522,   681,   114,   272,
     357,   366,   419,   522,   677,   103,   373,   563,   565,   393,
     401,   560,   408,   596,   654,   357,   372,   311,   312,   313,
     314,   315,   568,   103,   393,   103,   567,   393,   568,   103,
     401,   402,   402,   596,   367,   103,   305,   103,   562,   103,
     366,   556,   412,   412,   404,   412,   596,    85,   618,     6,
     357,   535,     6,   367,   543,   189,   582,   103,   477,   449,
     456,   462,   470,   516,   516,   516,   477,   477,   477,   477,
     400,   104,     9,   366,   366,   459,   400,     9,   412,     8,
     366,     6,   366,   366,   459,     6,   366,   151,   488,   356,
     472,   627,   366,   357,   357,   357,   370,   103,   708,   355,
     166,   171,   676,   502,   372,   499,   103,   676,   103,   502,
     372,   105,   502,   372,   535,   288,   104,   559,   372,   103,
     289,   564,   566,   559,   388,   388,   596,   357,   618,   357,
     699,   186,   583,   366,   356,   356,   356,   356,   356,   477,
     477,   477,   356,   356,   356,   356,    42,   454,   475,   461,
      38,    87,   104,   271,   286,   302,   307,   309,   326,   452,
     453,   455,   464,   465,   632,    87,   464,   466,    23,   103,
     104,   353,   489,   490,   491,   627,   366,   104,   105,   473,
     474,   627,   366,   372,   372,   372,     8,   383,   356,   414,
     410,   366,   366,   366,   366,   366,   366,   366,   134,   366,
     357,   372,   103,   563,   565,   560,   357,   367,   582,   485,
     450,   458,   467,   471,   356,   356,   356,   478,   483,   479,
     484,   104,   417,   455,    90,   278,   463,   373,   393,   401,
     408,   366,     9,   366,   366,   476,   103,    23,    26,     8,
     357,   731,   104,   678,   679,   676,   373,   393,   393,   401,
     583,   357,   357,   357,   357,   357,   481,   482,   480,   357,
     357,   357,   357,    44,    45,   492,   372,   632,   412,   366,
     103,   103,   367,   474,     6,     8,   357,   366,   366,   366,
     366,   366,   366,   357,   357,   357,   366,   366,   366,   366,
     498,   627,   355,   488,   412,   103,   499,   500,   679,   366,
     412,   417,   366,   366,   366,   373,   393,   401,   408,   472,
     400,   372,   372,   372
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   364,   365,   365,   366,   366,   367,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,   417,   418,   419,
     419,   419,   419,   419,   420,   420,   420,   420,   421,   421,
     421,   421,   421,   421,   421,   421,   421,   421,   421,   421,
     421,   421,   421,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   423,   424,   424,
     424,   424,   424,   424,   424,   424,   424,   424,   424,   424,
     424,   424,   424,   424,   424,   425,   426,   426,   427,   427,
     428,   428,   429,   429,   430,   430,   430,   430,   430,   430,
     430,   430,   430,   430,   430,   430,   430,   430,   430,   431,
     432,   432,   432,   432,   432,   432,   432,   432,   432,   432,
     432,   432,   432,   432,   432,   432,   432,   432,   432,   432,
     432,   432,   432,   432,   432,   432,   432,   432,   432,   432,
     432,   432,   432,   432,   433,   434,   434,   435,   435,   435,
     435,   435,   435,   436,   436,   436,   436,   436,   436,   436,
     437,   438,   438,   439,   439,   440,   441,   441,   442,   442,
     442,   442,   442,   442,   442,   442,   443,   443,   444,   444,
     444,   445,   446,   447,   447,   448,   448,   448,   448,   448,
     448,   448,   448,   448,   448,   448,   448,   448,   448,   448,
     448,   449,   450,   450,   450,   450,   450,   450,   450,   450,
     451,   451,   451,   452,   452,   453,   453,   453,   453,   454,
     455,   455,   456,   457,   457,   458,   458,   458,   458,   458,
     458,   458,   458,   458,   458,   458,   458,   459,   459,   460,
     460,   461,   461,   461,   461,   462,   463,   463,   464,   464,
     464,   464,   464,   465,   465,   466,   466,   467,   467,   467,
     467,   467,   467,   467,   467,   467,   467,   467,   467,   467,
     467,   468,   468,   469,   469,   470,   471,   471,   471,   471,
     471,   471,   471,   472,   472,   473,   473,   473,   474,   474,
     474,   475,   475,   476,   476,   477,   478,   478,   478,   478,
     478,   479,   479,   479,   479,   479,   480,   480,   480,   480,
     480,   481,   481,   481,   481,   481,   482,   482,   482,   482,
     482,   483,   483,   483,   483,   483,   484,   484,   484,   484,
     484,   485,   485,   485,   485,   485,   486,   486,   486,   486,
     486,   487,   488,   489,   489,   490,   490,   490,   490,   490,
     491,   491,   492,   492,   492,   492,   493,   494,   495,   495,
     496,   496,   497,   498,   498,   498,   499,   500,   500,   501,
     501,   502,   502,   502,   502,   502,   502,   503,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   520,   520,   520,   521,   522,
     523,   523,   524,   524,   525,   526,   526,   527,   527,   528,
     529,   530,   531,   532,   532,   533,   533,   533,   533,   533,
     534,   534,   534,   534,   535,   535,   535,   535,   535,   535,
     535,   535,   535,   535,   535,   535,   535,   535,   535,   535,
     535,   535,   535,   535,   535,   535,   535,   536,   537,   537,
     538,   539,   539,   540,   541,   541,   542,   542,   542,   543,
     544,   544,   545,   545,   546,   547,   547,   548,   548,   549,
     549,   550,   551,   551,   552,   552,   552,   552,   552,   552,
     553,   554,   554,   554,   554,   554,   555,   555,   556,   556,
     557,   557,   558,   558,   558,   559,   559,   560,   560,   561,
     562,   562,   562,   563,   563,   564,   565,   565,   566,   566,
     567,   567,   568,   568,   568,   568,   568,   569,   570,   571,
     571,   572,   572,   572,   572,   572,   572,   572,   572,   573,
     574,   574,   575,   575,   575,   575,   575,   575,   576,   576,
     577,   578,   578,   579,   579,   579,   579,   580,   580,   581,
     582,   582,   583,   583,   584,   584,   584,   584,   584,   584,
     584,   584,   584,   584,   584,   584,   584,   585,   585,   585,
     586,   586,   587,   587,   588,   588,   589,   590,   590,   591,
     591,   592,   592,   593,   594,   595,   595,   596,   596,   596,
     597,   597,   597,   597,   597,   597,   597,   597,   597,   597,
     597,   597,   597,   597,   598,   598,   599,   600,   600,   600,
     601,   601,   602,   603,   603,   603,   603,   603,   604,   604,
     605,   605,   606,   606,   607,   607,   607,   608,   608,   608,
     608,   609,   609,   610,   611,   611,   612,   612,   613,   613,
     614,   614,   614,   615,   615,   615,   615,   616,   616,   617,
     617,   618,   618,   619,   620,   620,   620,   621,   621,   621,
     622,   622,   623,   623,   624,   625,   625,   626,   627,   628,
     628,   629,   629,   630,   631,   632,   632,   632,   632,   632,
     632,   632,   632,   632,   632,   632,   632,   633,   633,   633,
     633,   634,   635,   635,   635,   636,   636,   636,   636,   636,
     637,   637,   638,   638,   639,   639,   640,   640,   640,   641,
     641,   642,   642,   643,   643,   644,   645,   645,   646,   647,
     648,   648,   649,   650,   650,   650,   651,   652,   652,   652,
     653,   653,   653,   654,   654,   655,   656,   656,   656,   657,
     657,   658,   658,   659,   659,   660,   660,   660,   661,   661,
     662,   662,   663,   663,   663,   663,   663,   663,   663,   664,
     664,   664,   665,   666,   666,   667,   667,   667,   667,   668,
     669,   670,   671,   672,   673,   674,   674,   674,   675,   675,
     675,   676,   676,   677,   677,   678,   678,   679,   680,   680,
     680,   681,   681,   681,   681,   681,   682,   683,   683,   684,
     685,   685,   685,   685,   685,   685,   685,   685,   686,   686,
     687,   687,   687,   688,   688,   688,   689,   689,   690,   690,
     691,   691,   692,   693,   693,   693,   693,   694,   694,   695,
     696,   696,   696,   696,   696,   696,   696,   696,   696,   696,
     696,   696,   697,   697,   697,   697,   697,   697,   697,   697,
     697,   697,   697,   697,   697,   697,   697,   697,   697,   698,
     698,   698,   698,   698,   698,   698,   699,   699,   699,   699,
     699,   699,   700,   700,   701,   701,   701,   702,   702,   703,
     703,   703,   703,   703,   704,   704,   704,   704,   704,   704,
     704,   704,   704,   704,   704,   704,   704,   704,   704,   704,
     704,   704,   704,   704,   704,   704,   704,   704,   705,   705,
     705,   705,   705,   705,   706,   706,   707,   707,   707,   708,
     708,   709,   709,   710,   711,   711,   712,   712,   713,   713,
     714,   714,   715,   715,   716,   716,   716,   717,   717,   718,
     718,   719,   719,   719,   719,   720,   720,   720,   721,   721,
     722,   722,   722,   722,   722,   722,   722,   722,   722,   722,
     722,   722,   722,   722,   722,   722,   722,   723,   723,   723,
     723,   723,   723,   723,   724,   724,   724,   724,   725,   725,
     725,   725,   726,   726,   727,   727,   728,   728,   729,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   731,   732,   733,
     733,   733,   733,   734,   735,   735,   735,   736,   737,   737,
     737,   737,   737,   738,   739,   739,   739,   739,   739,   739,
     739,   739,   739,   740,   740,   740,   741,   741,   741,   741,
     741,   741,   741,   741,   741,   741,   741,   741,   742,   742,
     742,   742,   743,   743,   743,   743,   743,   744,   745,   745,
     745,   745,   745,   745,   745,   746,   747,   747,   747,   747,
     748,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     750,   751,   751,   751,   751,   751,   751,   751,   751,   752,
     753,   753,   753,   753,   753,   754,   755,   755,   756,   757,
     757,   757,   758,   759,   759,   759,   759,   760,   761,   761,
     761,   761,   762,   762,   762,   762,   763,   764,   764,   764,
     764,   764,   764,   764,   764,   764,   764,   765,   765,   765,
     765,   765,   765,   766,   766,   766,   766,   766,   767,   767,
     767,   767,   767,   767,   767,   767,   767,   767,   767,   767,
     768,   768,   769,   770,   770,   771,   772,   773,   774,   774,
     774,   775,   775,   775,   775,   775,   775,   775,   775,   775,
     775,   775,   775,   775,   775,   775,   775,   775,   775,   776,
     776,   776,   777,   777,   777,   777,   778,   778,   778,   778,
     778,   779,   779,   779,   779,   780,   780,   780,   780,   780,
     780,   780,   780,   780,   780,   780,   780,   781,   781,   782,
     782,   782,   782,   783,   784,   784,   785,   785,   785,   785,
     785,   785,   785,   785,   786,   787,   787,   788,   789,   789,
     789,   789,   790,   791,   792,   793,   794,   795,   795,   795,
     795,   796,   797,   797,   797,   797,   797,   797,   798,   799,
     799,   800,   801,   801,   801,   801,   801,   802,   803,   803,
     803,   803,   803
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     1,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     3,
       5,     5,     3,     2,     1,     1,     2,     2,     1,     2,
       2,     2,     2,     2,     2,     3,     3,     2,     2,     3,
       3,     3,     2,     2,     6,     2,     6,     3,     2,     6,
       6,     3,     6,     3,     5,     7,     5,     7,     8,     8,
       8,     5,     7,     5,     7,     5,     7,     3,     2,     6,
       2,     6,     6,     6,     3,     6,     3,     5,     5,     8,
       8,     8,     5,     5,     5,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     3,
       2,     2,     6,     3,     3,     5,     3,     3,     3,     3,
       2,     2,     2,     2,     2,     3,     2,     2,     3,     3,
       2,     3,     3,     2,     3,     3,     2,     3,     3,     2,
       3,     3,     2,     3,     3,     2,     2,     2,     2,     2,
       2,     4,     5,     2,     2,     1,     2,     2,     3,     3,
       2,     3,     3,     2,     2,     2,     2,     3,     2,     2,
       3,     2,     1,     2,     1,     3,     0,     1,     0,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     1,
       2,     1,     0,     2,     1,     0,     2,     2,     3,     8,
       8,     8,     8,     9,     9,    10,    10,    10,     9,     9,
       9,     0,     0,     2,     2,     3,     3,     3,     3,     3,
       0,     2,     3,     1,     3,     2,     1,     1,     1,     1,
       1,     3,     0,     2,     3,     0,     2,     2,     3,     4,
       4,     4,     3,     4,     2,     3,     3,     1,     1,     3,
       1,     1,     1,     1,     1,     0,     1,     1,     2,     2,
       2,     2,     2,     1,     3,     1,     0,     0,     2,     2,
       4,     4,     8,     6,     7,     6,     4,     3,     4,     3,
       3,     3,     2,     1,     1,     0,     0,     2,     2,     5,
       5,     3,     4,     3,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     3,     0,     0,     2,     2,     2,
       2,     0,     2,     2,     2,     2,     0,     2,     2,     2,
       2,     0,     2,     2,     2,     2,     0,     2,     2,     2,
       2,     0,     2,     2,     2,     2,     0,     2,     2,     2,
       2,     0,     2,     2,     2,     2,     1,     1,     1,     1,
       1,     7,     2,     1,     1,     1,     1,     1,     3,     3,
       1,     2,     2,     2,     3,     0,     2,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     2,     2,     1,     2,     1,     1,     2,     3,     2,
       3,     1,     2,     3,     1,     2,     3,     1,     2,     3,
       1,     2,     2,     2,     1,     2,     2,     2,     2,     2,
       0,     1,     1,     2,     1,     1,     2,     1,     2,     4,
       4,     4,     4,     5,     5,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     1,     1,     2,     2,     2,     2,
       1,     1,     2,     1,     1,     2,     1,     3,     1,     1,
       5,     1,     1,     3,     3,     1,     1,     3,     3,     5,
       4,     5,     1,     2,     1,     1,     2,     2,     2,     1,
       2,     1,     1,     2,     2,     2,     2,     2,     2,     2,
       1,     3,     3,     1,     2,     1,     3,     1,     1,     1,
       6,     6,     1,     1,     0,     1,     1,     0,     3,     6,
       1,     1,     0,     0,     3,     3,     0,     2,     2,     3,
       2,     2,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     0,     6,     3,     6,     3,     5,     3,     5,     2,
       1,     1,     3,     4,     4,     5,     6,     5,     1,     2,
       1,     1,     2,     2,     2,     1,     1,     6,     8,     0,
       0,     1,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     3,     3,
       1,     3,     1,     3,     1,     3,     1,     1,     3,     1,
       1,     3,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     2,     3,     3,     4,     5,     2,     3,     2,     6,
       4,     3,     4,     3,     2,     1,     1,     3,     4,     1,
       2,     1,     1,     2,     3,     1,     3,     4,     3,     5,
       3,     6,     1,     3,     1,     1,     1,     2,     4,     6,
       6,     1,     2,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     1,     3,     1,
       1,     1,     2,     1,     4,     5,     6,     1,     1,     1,
       7,     8,     7,     1,     1,     6,     8,     1,     2,     1,
       1,     1,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     4,     1,     1,     2,     1,     1,     1,     1,     1,
       3,     1,     4,     4,     0,     2,     1,     3,     3,     1,
       3,     1,     3,     1,     3,     1,     1,     3,     3,     3,
       1,     1,     3,     1,     1,     1,     3,     1,     3,     3,
       3,     3,     5,     1,     2,     1,     1,     2,     3,     1,
       1,     2,     1,     1,     2,     2,     2,     1,     1,     2,
       1,     2,     2,     6,     6,     6,     4,     5,     6,     2,
       2,     1,     1,     1,     1,     1,     1,     2,     2,     4,
       0,     4,     0,     1,     0,     1,     1,     1,     1,     1,
       1,     2,     2,     6,     3,     1,     3,     3,     3,     7,
       3,     3,     3,     3,     3,     3,     0,     4,     4,     0,
       2,     2,     4,     4,     5,     5,     3,     3,     3,     3,
       1,     1,     1,     1,     3,     3,     1,     3,     1,     3,
       1,     3,     1,     1,     1,     3,     3,     1,     1,     1,
       2,     2,     2,     2,     2,     2,     2,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       2,     2,     1,     2,     2,     2,     2,     2,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     3,     1,     3,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     5,     3,
       5,     1,     5,     5,     3,     5,     1,     1,     1,     0,
       2,     1,     1,     6,     2,     0,     1,     1,     1,     1,
       1,     1,     5,     6,     8,     6,     5,     2,     2,     3,
       4,     1,     1,     1,     2,     3,     4,     4,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     3,     3,     1,     1,
       1,     1,     1,     1,     3,     3,     5,     6,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     7,     1,
       1,     2,     1,     3,     1,     1,     2,     3,     1,     1,
       1,     1,     2,     3,     1,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     5,     4,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     3,     2,     1,
       1,     1,     1,     1,     1,     3,     2,     1,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     3,
       1,     1,     1,     1,     1,     3,     1,     1,     3,     1,
       1,     1,     3,     1,     1,     1,     1,     3,     1,     1,
       1,     1,     2,     3,     3,     9,     5,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     3,     5,     1,
       1,     1,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     3,     1,     1,
       2,     1,     3,     4,     3,     1,     3,     1,     1,     1,
       4,     3,     1,     1,     1,     1,     1,     1,     3,     1,
       1,     3,     1,     1,     2,     1,     1,     2,     2,     2,
       2,     2,     2
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, nft, scanner, state, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, nft, scanner, state); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct nft_ctx *nft, void *scanner, struct parser_state *state)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (nft);
  YY_USE (scanner);
  YY_USE (state);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct nft_ctx *nft, void *scanner, struct parser_state *state)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, nft, scanner, state);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, struct nft_ctx *nft, void *scanner, struct parser_state *state)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), nft, scanner, state);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, nft, scanner, state); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, struct nft_ctx *nft, void *scanner, struct parser_state *state)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (nft);
  YY_USE (scanner);
  YY_USE (state);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_STRING: /* "string"  */
#line 378 "parser_bison.y"
            { xfree(((*yyvaluep).string)); }
#line 5988 "parser_bison.c"
        break;

    case YYSYMBOL_QUOTED_STRING: /* "quoted string"  */
#line 378 "parser_bison.y"
            { xfree(((*yyvaluep).string)); }
#line 5994 "parser_bison.c"
        break;

    case YYSYMBOL_ASTERISK_STRING: /* "string with a trailing asterisk"  */
#line 378 "parser_bison.y"
            { xfree(((*yyvaluep).string)); }
#line 6000 "parser_bison.c"
        break;

    case YYSYMBOL_line: /* line  */
#line 690 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6006 "parser_bison.c"
        break;

    case YYSYMBOL_base_cmd: /* base_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6012 "parser_bison.c"
        break;

    case YYSYMBOL_add_cmd: /* add_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6018 "parser_bison.c"
        break;

    case YYSYMBOL_replace_cmd: /* replace_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6024 "parser_bison.c"
        break;

    case YYSYMBOL_create_cmd: /* create_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6030 "parser_bison.c"
        break;

    case YYSYMBOL_insert_cmd: /* insert_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6036 "parser_bison.c"
        break;

    case YYSYMBOL_table_or_id_spec: /* table_or_id_spec  */
#line 696 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6042 "parser_bison.c"
        break;

    case YYSYMBOL_chain_or_id_spec: /* chain_or_id_spec  */
#line 698 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6048 "parser_bison.c"
        break;

    case YYSYMBOL_set_or_id_spec: /* set_or_id_spec  */
#line 703 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6054 "parser_bison.c"
        break;

    case YYSYMBOL_obj_or_id_spec: /* obj_or_id_spec  */
#line 705 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6060 "parser_bison.c"
        break;

    case YYSYMBOL_delete_cmd: /* delete_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6066 "parser_bison.c"
        break;

    case YYSYMBOL_get_cmd: /* get_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6072 "parser_bison.c"
        break;

    case YYSYMBOL_list_cmd: /* list_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6078 "parser_bison.c"
        break;

    case YYSYMBOL_basehook_device_name: /* basehook_device_name  */
#line 719 "parser_bison.y"
            { xfree(((*yyvaluep).string)); }
#line 6084 "parser_bison.c"
        break;

    case YYSYMBOL_basehook_spec: /* basehook_spec  */
#line 711 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6090 "parser_bison.c"
        break;

    case YYSYMBOL_reset_cmd: /* reset_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6096 "parser_bison.c"
        break;

    case YYSYMBOL_flush_cmd: /* flush_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6102 "parser_bison.c"
        break;

    case YYSYMBOL_rename_cmd: /* rename_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6108 "parser_bison.c"
        break;

    case YYSYMBOL_import_cmd: /* import_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6114 "parser_bison.c"
        break;

    case YYSYMBOL_export_cmd: /* export_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6120 "parser_bison.c"
        break;

    case YYSYMBOL_monitor_cmd: /* monitor_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6126 "parser_bison.c"
        break;

    case YYSYMBOL_monitor_event: /* monitor_event  */
#line 943 "parser_bison.y"
            { xfree(((*yyvaluep).string)); }
#line 6132 "parser_bison.c"
        break;

    case YYSYMBOL_describe_cmd: /* describe_cmd  */
#line 693 "parser_bison.y"
            { cmd_free(((*yyvaluep).cmd)); }
#line 6138 "parser_bison.c"
        break;

    case YYSYMBOL_table_block_alloc: /* table_block_alloc  */
#line 725 "parser_bison.y"
            { close_scope(state); table_free(((*yyvaluep).table)); }
#line 6144 "parser_bison.c"
        break;

    case YYSYMBOL_chain_block_alloc: /* chain_block_alloc  */
#line 727 "parser_bison.y"
            { close_scope(state); chain_free(((*yyvaluep).chain)); }
#line 6150 "parser_bison.c"
        break;

    case YYSYMBOL_typeof_verdict_expr: /* typeof_verdict_expr  */
#line 802 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6156 "parser_bison.c"
        break;

    case YYSYMBOL_typeof_data_expr: /* typeof_data_expr  */
#line 802 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6162 "parser_bison.c"
        break;

    case YYSYMBOL_primary_typeof_expr: /* primary_typeof_expr  */
#line 802 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6168 "parser_bison.c"
        break;

    case YYSYMBOL_typeof_expr: /* typeof_expr  */
#line 802 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6174 "parser_bison.c"
        break;

    case YYSYMBOL_set_block_alloc: /* set_block_alloc  */
#line 736 "parser_bison.y"
            { set_free(((*yyvaluep).set)); }
#line 6180 "parser_bison.c"
        break;

    case YYSYMBOL_typeof_key_expr: /* typeof_key_expr  */
#line 802 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6186 "parser_bison.c"
        break;

    case YYSYMBOL_set_block_expr: /* set_block_expr  */
#line 843 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6192 "parser_bison.c"
        break;

    case YYSYMBOL_map_block_alloc: /* map_block_alloc  */
#line 739 "parser_bison.y"
            { set_free(((*yyvaluep).set)); }
#line 6198 "parser_bison.c"
        break;

    case YYSYMBOL_flowtable_block_alloc: /* flowtable_block_alloc  */
#line 743 "parser_bison.y"
            { flowtable_free(((*yyvaluep).flowtable)); }
#line 6204 "parser_bison.c"
        break;

    case YYSYMBOL_flowtable_expr: /* flowtable_expr  */
#line 843 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6210 "parser_bison.c"
        break;

    case YYSYMBOL_flowtable_list_expr: /* flowtable_list_expr  */
#line 843 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6216 "parser_bison.c"
        break;

    case YYSYMBOL_flowtable_expr_member: /* flowtable_expr_member  */
#line 843 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6222 "parser_bison.c"
        break;

    case YYSYMBOL_data_type_atom_expr: /* data_type_atom_expr  */
#line 687 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6228 "parser_bison.c"
        break;

    case YYSYMBOL_data_type_expr: /* data_type_expr  */
#line 687 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6234 "parser_bison.c"
        break;

    case YYSYMBOL_obj_block_alloc: /* obj_block_alloc  */
#line 746 "parser_bison.y"
            { obj_free(((*yyvaluep).obj)); }
#line 6240 "parser_bison.c"
        break;

    case YYSYMBOL_type_identifier: /* type_identifier  */
#line 682 "parser_bison.y"
            { xfree(((*yyvaluep).string)); }
#line 6246 "parser_bison.c"
        break;

    case YYSYMBOL_prio_spec: /* prio_spec  */
#line 716 "parser_bison.y"
            { expr_free(((*yyvaluep).prio_spec).expr); }
#line 6252 "parser_bison.c"
        break;

    case YYSYMBOL_extended_prio_name: /* extended_prio_name  */
#line 719 "parser_bison.y"
            { xfree(((*yyvaluep).string)); }
#line 6258 "parser_bison.c"
        break;

    case YYSYMBOL_extended_prio_spec: /* extended_prio_spec  */
#line 716 "parser_bison.y"
            { expr_free(((*yyvaluep).prio_spec).expr); }
#line 6264 "parser_bison.c"
        break;

    case YYSYMBOL_dev_spec: /* dev_spec  */
#line 722 "parser_bison.y"
            { xfree(((*yyvaluep).expr)); }
#line 6270 "parser_bison.c"
        break;

    case YYSYMBOL_policy_expr: /* policy_expr  */
#line 800 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6276 "parser_bison.c"
        break;

    case YYSYMBOL_identifier: /* identifier  */
#line 682 "parser_bison.y"
            { xfree(((*yyvaluep).string)); }
#line 6282 "parser_bison.c"
        break;

    case YYSYMBOL_string: /* string  */
#line 682 "parser_bison.y"
            { xfree(((*yyvaluep).string)); }
#line 6288 "parser_bison.c"
        break;

    case YYSYMBOL_table_spec: /* table_spec  */
#line 696 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6294 "parser_bison.c"
        break;

    case YYSYMBOL_tableid_spec: /* tableid_spec  */
#line 696 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6300 "parser_bison.c"
        break;

    case YYSYMBOL_chain_spec: /* chain_spec  */
#line 698 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6306 "parser_bison.c"
        break;

    case YYSYMBOL_chainid_spec: /* chainid_spec  */
#line 698 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6312 "parser_bison.c"
        break;

    case YYSYMBOL_chain_identifier: /* chain_identifier  */
#line 701 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6318 "parser_bison.c"
        break;

    case YYSYMBOL_set_spec: /* set_spec  */
#line 703 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6324 "parser_bison.c"
        break;

    case YYSYMBOL_setid_spec: /* setid_spec  */
#line 703 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6330 "parser_bison.c"
        break;

    case YYSYMBOL_set_identifier: /* set_identifier  */
#line 708 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6336 "parser_bison.c"
        break;

    case YYSYMBOL_flowtable_spec: /* flowtable_spec  */
#line 701 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6342 "parser_bison.c"
        break;

    case YYSYMBOL_flowtableid_spec: /* flowtableid_spec  */
#line 708 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6348 "parser_bison.c"
        break;

    case YYSYMBOL_flowtable_identifier: /* flowtable_identifier  */
#line 708 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6354 "parser_bison.c"
        break;

    case YYSYMBOL_obj_spec: /* obj_spec  */
#line 705 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6360 "parser_bison.c"
        break;

    case YYSYMBOL_objid_spec: /* objid_spec  */
#line 705 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6366 "parser_bison.c"
        break;

    case YYSYMBOL_obj_identifier: /* obj_identifier  */
#line 708 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6372 "parser_bison.c"
        break;

    case YYSYMBOL_handle_spec: /* handle_spec  */
#line 701 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6378 "parser_bison.c"
        break;

    case YYSYMBOL_position_spec: /* position_spec  */
#line 701 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6384 "parser_bison.c"
        break;

    case YYSYMBOL_index_spec: /* index_spec  */
#line 701 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6390 "parser_bison.c"
        break;

    case YYSYMBOL_rule_position: /* rule_position  */
#line 701 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6396 "parser_bison.c"
        break;

    case YYSYMBOL_ruleid_spec: /* ruleid_spec  */
#line 701 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6402 "parser_bison.c"
        break;

    case YYSYMBOL_comment_spec: /* comment_spec  */
#line 682 "parser_bison.y"
            { xfree(((*yyvaluep).string)); }
#line 6408 "parser_bison.c"
        break;

    case YYSYMBOL_ruleset_spec: /* ruleset_spec  */
#line 701 "parser_bison.y"
            { handle_free(&((*yyvaluep).handle)); }
#line 6414 "parser_bison.c"
        break;

    case YYSYMBOL_rule: /* rule  */
#line 729 "parser_bison.y"
            { rule_free(((*yyvaluep).rule)); }
#line 6420 "parser_bison.c"
        break;

    case YYSYMBOL_stmt_list: /* stmt_list  */
#line 749 "parser_bison.y"
            { stmt_list_free(((*yyvaluep).list)); xfree(((*yyvaluep).list)); }
#line 6426 "parser_bison.c"
        break;

    case YYSYMBOL_stateful_stmt_list: /* stateful_stmt_list  */
#line 749 "parser_bison.y"
            { stmt_list_free(((*yyvaluep).list)); xfree(((*yyvaluep).list)); }
#line 6432 "parser_bison.c"
        break;

    case YYSYMBOL_objref_stmt_counter: /* objref_stmt_counter  */
#line 755 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6438 "parser_bison.c"
        break;

    case YYSYMBOL_objref_stmt_limit: /* objref_stmt_limit  */
#line 755 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6444 "parser_bison.c"
        break;

    case YYSYMBOL_objref_stmt_quota: /* objref_stmt_quota  */
#line 755 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6450 "parser_bison.c"
        break;

    case YYSYMBOL_objref_stmt_synproxy: /* objref_stmt_synproxy  */
#line 755 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6456 "parser_bison.c"
        break;

    case YYSYMBOL_objref_stmt_ct: /* objref_stmt_ct  */
#line 755 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6462 "parser_bison.c"
        break;

    case YYSYMBOL_objref_stmt: /* objref_stmt  */
#line 755 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6468 "parser_bison.c"
        break;

    case YYSYMBOL_stateful_stmt: /* stateful_stmt  */
#line 753 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6474 "parser_bison.c"
        break;

    case YYSYMBOL_stmt: /* stmt  */
#line 751 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6480 "parser_bison.c"
        break;

    case YYSYMBOL_xt_stmt: /* xt_stmt  */
#line 960 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6486 "parser_bison.c"
        break;

    case YYSYMBOL_chain_stmt: /* chain_stmt  */
#line 779 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6492 "parser_bison.c"
        break;

    case YYSYMBOL_verdict_stmt: /* verdict_stmt  */
#line 751 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6498 "parser_bison.c"
        break;

    case YYSYMBOL_verdict_map_stmt: /* verdict_map_stmt  */
#line 837 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6504 "parser_bison.c"
        break;

    case YYSYMBOL_verdict_map_expr: /* verdict_map_expr  */
#line 840 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6510 "parser_bison.c"
        break;

    case YYSYMBOL_verdict_map_list_expr: /* verdict_map_list_expr  */
#line 840 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6516 "parser_bison.c"
        break;

    case YYSYMBOL_verdict_map_list_member_expr: /* verdict_map_list_member_expr  */
#line 840 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6522 "parser_bison.c"
        break;

    case YYSYMBOL_connlimit_stmt: /* connlimit_stmt  */
#line 767 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6528 "parser_bison.c"
        break;

    case YYSYMBOL_counter_stmt: /* counter_stmt  */
#line 753 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6534 "parser_bison.c"
        break;

    case YYSYMBOL_counter_stmt_alloc: /* counter_stmt_alloc  */
#line 753 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6540 "parser_bison.c"
        break;

    case YYSYMBOL_log_stmt: /* log_stmt  */
#line 764 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6546 "parser_bison.c"
        break;

    case YYSYMBOL_log_stmt_alloc: /* log_stmt_alloc  */
#line 764 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6552 "parser_bison.c"
        break;

    case YYSYMBOL_limit_stmt: /* limit_stmt  */
#line 767 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6558 "parser_bison.c"
        break;

    case YYSYMBOL_quota_unit: /* quota_unit  */
#line 719 "parser_bison.y"
            { xfree(((*yyvaluep).string)); }
#line 6564 "parser_bison.c"
        break;

    case YYSYMBOL_quota_stmt: /* quota_stmt  */
#line 767 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6570 "parser_bison.c"
        break;

    case YYSYMBOL_reject_stmt: /* reject_stmt  */
#line 770 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6576 "parser_bison.c"
        break;

    case YYSYMBOL_reject_stmt_alloc: /* reject_stmt_alloc  */
#line 770 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6582 "parser_bison.c"
        break;

    case YYSYMBOL_reject_with_expr: /* reject_with_expr  */
#line 785 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6588 "parser_bison.c"
        break;

    case YYSYMBOL_nat_stmt: /* nat_stmt  */
#line 772 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6594 "parser_bison.c"
        break;

    case YYSYMBOL_nat_stmt_alloc: /* nat_stmt_alloc  */
#line 772 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6600 "parser_bison.c"
        break;

    case YYSYMBOL_tproxy_stmt: /* tproxy_stmt  */
#line 775 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6606 "parser_bison.c"
        break;

    case YYSYMBOL_synproxy_stmt: /* synproxy_stmt  */
#line 777 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6612 "parser_bison.c"
        break;

    case YYSYMBOL_synproxy_stmt_alloc: /* synproxy_stmt_alloc  */
#line 777 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6618 "parser_bison.c"
        break;

    case YYSYMBOL_synproxy_obj: /* synproxy_obj  */
#line 863 "parser_bison.y"
            { obj_free(((*yyvaluep).obj)); }
#line 6624 "parser_bison.c"
        break;

    case YYSYMBOL_primary_stmt_expr: /* primary_stmt_expr  */
#line 824 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6630 "parser_bison.c"
        break;

    case YYSYMBOL_shift_stmt_expr: /* shift_stmt_expr  */
#line 826 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6636 "parser_bison.c"
        break;

    case YYSYMBOL_and_stmt_expr: /* and_stmt_expr  */
#line 828 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6642 "parser_bison.c"
        break;

    case YYSYMBOL_exclusive_or_stmt_expr: /* exclusive_or_stmt_expr  */
#line 828 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6648 "parser_bison.c"
        break;

    case YYSYMBOL_inclusive_or_stmt_expr: /* inclusive_or_stmt_expr  */
#line 828 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6654 "parser_bison.c"
        break;

    case YYSYMBOL_basic_stmt_expr: /* basic_stmt_expr  */
#line 824 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6660 "parser_bison.c"
        break;

    case YYSYMBOL_concat_stmt_expr: /* concat_stmt_expr  */
#line 816 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6666 "parser_bison.c"
        break;

    case YYSYMBOL_map_stmt_expr_set: /* map_stmt_expr_set  */
#line 816 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6672 "parser_bison.c"
        break;

    case YYSYMBOL_map_stmt_expr: /* map_stmt_expr  */
#line 816 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6678 "parser_bison.c"
        break;

    case YYSYMBOL_prefix_stmt_expr: /* prefix_stmt_expr  */
#line 821 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6684 "parser_bison.c"
        break;

    case YYSYMBOL_range_stmt_expr: /* range_stmt_expr  */
#line 821 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6690 "parser_bison.c"
        break;

    case YYSYMBOL_multiton_stmt_expr: /* multiton_stmt_expr  */
#line 819 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6696 "parser_bison.c"
        break;

    case YYSYMBOL_stmt_expr: /* stmt_expr  */
#line 816 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6702 "parser_bison.c"
        break;

    case YYSYMBOL_masq_stmt: /* masq_stmt  */
#line 772 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6708 "parser_bison.c"
        break;

    case YYSYMBOL_masq_stmt_alloc: /* masq_stmt_alloc  */
#line 772 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6714 "parser_bison.c"
        break;

    case YYSYMBOL_redir_stmt: /* redir_stmt  */
#line 772 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6720 "parser_bison.c"
        break;

    case YYSYMBOL_redir_stmt_alloc: /* redir_stmt_alloc  */
#line 772 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6726 "parser_bison.c"
        break;

    case YYSYMBOL_dup_stmt: /* dup_stmt  */
#line 788 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6732 "parser_bison.c"
        break;

    case YYSYMBOL_fwd_stmt: /* fwd_stmt  */
#line 790 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6738 "parser_bison.c"
        break;

    case YYSYMBOL_queue_stmt: /* queue_stmt  */
#line 783 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6744 "parser_bison.c"
        break;

    case YYSYMBOL_queue_stmt_compat: /* queue_stmt_compat  */
#line 783 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6750 "parser_bison.c"
        break;

    case YYSYMBOL_queue_stmt_alloc: /* queue_stmt_alloc  */
#line 783 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6756 "parser_bison.c"
        break;

    case YYSYMBOL_queue_expr: /* queue_expr  */
#line 785 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6762 "parser_bison.c"
        break;

    case YYSYMBOL_queue_stmt_expr_simple: /* queue_stmt_expr_simple  */
#line 785 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6768 "parser_bison.c"
        break;

    case YYSYMBOL_queue_stmt_expr: /* queue_stmt_expr  */
#line 785 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6774 "parser_bison.c"
        break;

    case YYSYMBOL_set_elem_expr_stmt: /* set_elem_expr_stmt  */
#line 847 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6780 "parser_bison.c"
        break;

    case YYSYMBOL_set_elem_expr_stmt_alloc: /* set_elem_expr_stmt_alloc  */
#line 847 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6786 "parser_bison.c"
        break;

    case YYSYMBOL_set_stmt: /* set_stmt  */
#line 792 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6792 "parser_bison.c"
        break;

    case YYSYMBOL_map_stmt: /* map_stmt  */
#line 795 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6798 "parser_bison.c"
        break;

    case YYSYMBOL_meter_stmt: /* meter_stmt  */
#line 797 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6804 "parser_bison.c"
        break;

    case YYSYMBOL_flow_stmt_legacy_alloc: /* flow_stmt_legacy_alloc  */
#line 797 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6810 "parser_bison.c"
        break;

    case YYSYMBOL_meter_stmt_alloc: /* meter_stmt_alloc  */
#line 797 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6816 "parser_bison.c"
        break;

    case YYSYMBOL_match_stmt: /* match_stmt  */
#line 751 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 6822 "parser_bison.c"
        break;

    case YYSYMBOL_variable_expr: /* variable_expr  */
#line 800 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6828 "parser_bison.c"
        break;

    case YYSYMBOL_symbol_expr: /* symbol_expr  */
#line 800 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6834 "parser_bison.c"
        break;

    case YYSYMBOL_set_ref_expr: /* set_ref_expr  */
#line 808 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6840 "parser_bison.c"
        break;

    case YYSYMBOL_set_ref_symbol_expr: /* set_ref_symbol_expr  */
#line 808 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6846 "parser_bison.c"
        break;

    case YYSYMBOL_integer_expr: /* integer_expr  */
#line 800 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6852 "parser_bison.c"
        break;

    case YYSYMBOL_selector_expr: /* selector_expr  */
#line 802 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6858 "parser_bison.c"
        break;

    case YYSYMBOL_primary_expr: /* primary_expr  */
#line 802 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6864 "parser_bison.c"
        break;

    case YYSYMBOL_fib_expr: /* fib_expr  */
#line 934 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6870 "parser_bison.c"
        break;

    case YYSYMBOL_osf_expr: /* osf_expr  */
#line 939 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6876 "parser_bison.c"
        break;

    case YYSYMBOL_shift_expr: /* shift_expr  */
#line 802 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6882 "parser_bison.c"
        break;

    case YYSYMBOL_and_expr: /* and_expr  */
#line 802 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6888 "parser_bison.c"
        break;

    case YYSYMBOL_exclusive_or_expr: /* exclusive_or_expr  */
#line 804 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6894 "parser_bison.c"
        break;

    case YYSYMBOL_inclusive_or_expr: /* inclusive_or_expr  */
#line 804 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6900 "parser_bison.c"
        break;

    case YYSYMBOL_basic_expr: /* basic_expr  */
#line 806 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6906 "parser_bison.c"
        break;

    case YYSYMBOL_concat_expr: /* concat_expr  */
#line 831 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6912 "parser_bison.c"
        break;

    case YYSYMBOL_prefix_rhs_expr: /* prefix_rhs_expr  */
#line 813 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6918 "parser_bison.c"
        break;

    case YYSYMBOL_range_rhs_expr: /* range_rhs_expr  */
#line 813 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6924 "parser_bison.c"
        break;

    case YYSYMBOL_multiton_rhs_expr: /* multiton_rhs_expr  */
#line 811 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6930 "parser_bison.c"
        break;

    case YYSYMBOL_map_expr: /* map_expr  */
#line 834 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6936 "parser_bison.c"
        break;

    case YYSYMBOL_expr: /* expr  */
#line 853 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6942 "parser_bison.c"
        break;

    case YYSYMBOL_set_expr: /* set_expr  */
#line 843 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6948 "parser_bison.c"
        break;

    case YYSYMBOL_set_list_expr: /* set_list_expr  */
#line 843 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6954 "parser_bison.c"
        break;

    case YYSYMBOL_set_list_member_expr: /* set_list_member_expr  */
#line 843 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6960 "parser_bison.c"
        break;

    case YYSYMBOL_meter_key_expr: /* meter_key_expr  */
#line 850 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6966 "parser_bison.c"
        break;

    case YYSYMBOL_meter_key_expr_alloc: /* meter_key_expr_alloc  */
#line 850 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6972 "parser_bison.c"
        break;

    case YYSYMBOL_set_elem_expr: /* set_elem_expr  */
#line 845 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6978 "parser_bison.c"
        break;

    case YYSYMBOL_set_elem_key_expr: /* set_elem_key_expr  */
#line 983 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6984 "parser_bison.c"
        break;

    case YYSYMBOL_set_elem_expr_alloc: /* set_elem_expr_alloc  */
#line 845 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 6990 "parser_bison.c"
        break;

    case YYSYMBOL_set_elem_stmt_list: /* set_elem_stmt_list  */
#line 749 "parser_bison.y"
            { stmt_list_free(((*yyvaluep).list)); xfree(((*yyvaluep).list)); }
#line 6996 "parser_bison.c"
        break;

    case YYSYMBOL_set_elem_stmt: /* set_elem_stmt  */
#line 751 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 7002 "parser_bison.c"
        break;

    case YYSYMBOL_set_lhs_expr: /* set_lhs_expr  */
#line 845 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7008 "parser_bison.c"
        break;

    case YYSYMBOL_set_rhs_expr: /* set_rhs_expr  */
#line 845 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7014 "parser_bison.c"
        break;

    case YYSYMBOL_initializer_expr: /* initializer_expr  */
#line 853 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7020 "parser_bison.c"
        break;

    case YYSYMBOL_counter_obj: /* counter_obj  */
#line 863 "parser_bison.y"
            { obj_free(((*yyvaluep).obj)); }
#line 7026 "parser_bison.c"
        break;

    case YYSYMBOL_quota_obj: /* quota_obj  */
#line 863 "parser_bison.y"
            { obj_free(((*yyvaluep).obj)); }
#line 7032 "parser_bison.c"
        break;

    case YYSYMBOL_secmark_obj: /* secmark_obj  */
#line 863 "parser_bison.y"
            { obj_free(((*yyvaluep).obj)); }
#line 7038 "parser_bison.c"
        break;

    case YYSYMBOL_timeout_states: /* timeout_states  */
#line 976 "parser_bison.y"
            { timeout_states_free(((*yyvaluep).list)); }
#line 7044 "parser_bison.c"
        break;

    case YYSYMBOL_timeout_state: /* timeout_state  */
#line 973 "parser_bison.y"
            { timeout_state_free(((*yyvaluep).timeout_state)); }
#line 7050 "parser_bison.c"
        break;

    case YYSYMBOL_ct_obj_alloc: /* ct_obj_alloc  */
#line 863 "parser_bison.y"
            { obj_free(((*yyvaluep).obj)); }
#line 7056 "parser_bison.c"
        break;

    case YYSYMBOL_limit_obj: /* limit_obj  */
#line 863 "parser_bison.y"
            { obj_free(((*yyvaluep).obj)); }
#line 7062 "parser_bison.c"
        break;

    case YYSYMBOL_relational_expr: /* relational_expr  */
#line 866 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7068 "parser_bison.c"
        break;

    case YYSYMBOL_list_rhs_expr: /* list_rhs_expr  */
#line 858 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7074 "parser_bison.c"
        break;

    case YYSYMBOL_rhs_expr: /* rhs_expr  */
#line 856 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7080 "parser_bison.c"
        break;

    case YYSYMBOL_shift_rhs_expr: /* shift_rhs_expr  */
#line 858 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7086 "parser_bison.c"
        break;

    case YYSYMBOL_and_rhs_expr: /* and_rhs_expr  */
#line 860 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7092 "parser_bison.c"
        break;

    case YYSYMBOL_exclusive_or_rhs_expr: /* exclusive_or_rhs_expr  */
#line 860 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7098 "parser_bison.c"
        break;

    case YYSYMBOL_inclusive_or_rhs_expr: /* inclusive_or_rhs_expr  */
#line 860 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7104 "parser_bison.c"
        break;

    case YYSYMBOL_basic_rhs_expr: /* basic_rhs_expr  */
#line 856 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7110 "parser_bison.c"
        break;

    case YYSYMBOL_concat_rhs_expr: /* concat_rhs_expr  */
#line 856 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7116 "parser_bison.c"
        break;

    case YYSYMBOL_boolean_expr: /* boolean_expr  */
#line 963 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7122 "parser_bison.c"
        break;

    case YYSYMBOL_keyword_expr: /* keyword_expr  */
#line 853 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7128 "parser_bison.c"
        break;

    case YYSYMBOL_primary_rhs_expr: /* primary_rhs_expr  */
#line 858 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7134 "parser_bison.c"
        break;

    case YYSYMBOL_verdict_expr: /* verdict_expr  */
#line 800 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7140 "parser_bison.c"
        break;

    case YYSYMBOL_chain_expr: /* chain_expr  */
#line 800 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7146 "parser_bison.c"
        break;

    case YYSYMBOL_meta_expr: /* meta_expr  */
#line 916 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7152 "parser_bison.c"
        break;

    case YYSYMBOL_meta_stmt: /* meta_stmt  */
#line 762 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 7158 "parser_bison.c"
        break;

    case YYSYMBOL_socket_expr: /* socket_expr  */
#line 920 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7164 "parser_bison.c"
        break;

    case YYSYMBOL_numgen_expr: /* numgen_expr  */
#line 881 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7170 "parser_bison.c"
        break;

    case YYSYMBOL_xfrm_expr: /* xfrm_expr  */
#line 980 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7176 "parser_bison.c"
        break;

    case YYSYMBOL_hash_expr: /* hash_expr  */
#line 881 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7182 "parser_bison.c"
        break;

    case YYSYMBOL_rt_expr: /* rt_expr  */
#line 926 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7188 "parser_bison.c"
        break;

    case YYSYMBOL_ct_expr: /* ct_expr  */
#line 930 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7194 "parser_bison.c"
        break;

    case YYSYMBOL_symbol_stmt_expr: /* symbol_stmt_expr  */
#line 858 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7200 "parser_bison.c"
        break;

    case YYSYMBOL_list_stmt_expr: /* list_stmt_expr  */
#line 826 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7206 "parser_bison.c"
        break;

    case YYSYMBOL_ct_stmt: /* ct_stmt  */
#line 760 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 7212 "parser_bison.c"
        break;

    case YYSYMBOL_payload_stmt: /* payload_stmt  */
#line 758 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 7218 "parser_bison.c"
        break;

    case YYSYMBOL_payload_expr: /* payload_expr  */
#line 870 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7224 "parser_bison.c"
        break;

    case YYSYMBOL_payload_raw_expr: /* payload_raw_expr  */
#line 870 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7230 "parser_bison.c"
        break;

    case YYSYMBOL_eth_hdr_expr: /* eth_hdr_expr  */
#line 875 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7236 "parser_bison.c"
        break;

    case YYSYMBOL_vlan_hdr_expr: /* vlan_hdr_expr  */
#line 875 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7242 "parser_bison.c"
        break;

    case YYSYMBOL_arp_hdr_expr: /* arp_hdr_expr  */
#line 878 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7248 "parser_bison.c"
        break;

    case YYSYMBOL_ip_hdr_expr: /* ip_hdr_expr  */
#line 881 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7254 "parser_bison.c"
        break;

    case YYSYMBOL_icmp_hdr_expr: /* icmp_hdr_expr  */
#line 881 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7260 "parser_bison.c"
        break;

    case YYSYMBOL_igmp_hdr_expr: /* igmp_hdr_expr  */
#line 881 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7266 "parser_bison.c"
        break;

    case YYSYMBOL_ip6_hdr_expr: /* ip6_hdr_expr  */
#line 885 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7272 "parser_bison.c"
        break;

    case YYSYMBOL_icmp6_hdr_expr: /* icmp6_hdr_expr  */
#line 885 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7278 "parser_bison.c"
        break;

    case YYSYMBOL_auth_hdr_expr: /* auth_hdr_expr  */
#line 888 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7284 "parser_bison.c"
        break;

    case YYSYMBOL_esp_hdr_expr: /* esp_hdr_expr  */
#line 888 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7290 "parser_bison.c"
        break;

    case YYSYMBOL_comp_hdr_expr: /* comp_hdr_expr  */
#line 888 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7296 "parser_bison.c"
        break;

    case YYSYMBOL_udp_hdr_expr: /* udp_hdr_expr  */
#line 891 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7302 "parser_bison.c"
        break;

    case YYSYMBOL_udplite_hdr_expr: /* udplite_hdr_expr  */
#line 891 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7308 "parser_bison.c"
        break;

    case YYSYMBOL_tcp_hdr_expr: /* tcp_hdr_expr  */
#line 949 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7314 "parser_bison.c"
        break;

    case YYSYMBOL_optstrip_stmt: /* optstrip_stmt  */
#line 957 "parser_bison.y"
            { stmt_free(((*yyvaluep).stmt)); }
#line 7320 "parser_bison.c"
        break;

    case YYSYMBOL_dccp_hdr_expr: /* dccp_hdr_expr  */
#line 894 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7326 "parser_bison.c"
        break;

    case YYSYMBOL_sctp_chunk_alloc: /* sctp_chunk_alloc  */
#line 894 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7332 "parser_bison.c"
        break;

    case YYSYMBOL_sctp_hdr_expr: /* sctp_hdr_expr  */
#line 894 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7338 "parser_bison.c"
        break;

    case YYSYMBOL_th_hdr_expr: /* th_hdr_expr  */
#line 900 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7344 "parser_bison.c"
        break;

    case YYSYMBOL_exthdr_expr: /* exthdr_expr  */
#line 904 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7350 "parser_bison.c"
        break;

    case YYSYMBOL_hbh_hdr_expr: /* hbh_hdr_expr  */
#line 906 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7356 "parser_bison.c"
        break;

    case YYSYMBOL_rt_hdr_expr: /* rt_hdr_expr  */
#line 909 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7362 "parser_bison.c"
        break;

    case YYSYMBOL_rt0_hdr_expr: /* rt0_hdr_expr  */
#line 909 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7368 "parser_bison.c"
        break;

    case YYSYMBOL_rt2_hdr_expr: /* rt2_hdr_expr  */
#line 909 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7374 "parser_bison.c"
        break;

    case YYSYMBOL_rt4_hdr_expr: /* rt4_hdr_expr  */
#line 909 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7380 "parser_bison.c"
        break;

    case YYSYMBOL_frag_hdr_expr: /* frag_hdr_expr  */
#line 906 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7386 "parser_bison.c"
        break;

    case YYSYMBOL_dst_hdr_expr: /* dst_hdr_expr  */
#line 906 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7392 "parser_bison.c"
        break;

    case YYSYMBOL_mh_hdr_expr: /* mh_hdr_expr  */
#line 912 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7398 "parser_bison.c"
        break;

    case YYSYMBOL_exthdr_exists_expr: /* exthdr_exists_expr  */
#line 967 "parser_bison.y"
            { expr_free(((*yyvaluep).expr)); }
#line 7404 "parser_bison.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (struct nft_ctx *nft, void *scanner, struct parser_state *state)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */


/* User initialization code.  */
#line 215 "parser_bison.y"
{
	location_init(scanner, state, &yylloc);
	if (nft->debug_mask & NFT_DEBUG_SCANNER)
		nft_set_debug(1, scanner);
	if (nft->debug_mask & NFT_DEBUG_PARSER)
		yydebug = 1;
}

#line 7510 "parser_bison.c"

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, scanner);
    }

  if (yychar <= TOKEN_EOF)
    {
      yychar = TOKEN_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 3: /* input: input line  */
#line 989 "parser_bison.y"
                        {
				if ((yyvsp[0].cmd) != NULL) {
					(yyvsp[0].cmd)->location = (yylsp[0]);
					list_add_tail(&(yyvsp[0].cmd)->list, state->cmds);
				}
			}
#line 7728 "parser_bison.c"
    break;

  case 8: /* close_scope_ah: %empty  */
#line 1005 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_AH); }
#line 7734 "parser_bison.c"
    break;

  case 9: /* close_scope_arp: %empty  */
#line 1006 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_ARP); }
#line 7740 "parser_bison.c"
    break;

  case 10: /* close_scope_at: %empty  */
#line 1007 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_AT); }
#line 7746 "parser_bison.c"
    break;

  case 11: /* close_scope_comp: %empty  */
#line 1008 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_COMP); }
#line 7752 "parser_bison.c"
    break;

  case 12: /* close_scope_ct: %empty  */
#line 1009 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_CT); }
#line 7758 "parser_bison.c"
    break;

  case 13: /* close_scope_counter: %empty  */
#line 1010 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_COUNTER); }
#line 7764 "parser_bison.c"
    break;

  case 14: /* close_scope_dccp: %empty  */
#line 1011 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_DCCP); }
#line 7770 "parser_bison.c"
    break;

  case 15: /* close_scope_dst: %empty  */
#line 1012 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_DST); }
#line 7776 "parser_bison.c"
    break;

  case 16: /* close_scope_dup: %empty  */
#line 1013 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_STMT_DUP); }
#line 7782 "parser_bison.c"
    break;

  case 17: /* close_scope_esp: %empty  */
#line 1014 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_ESP); }
#line 7788 "parser_bison.c"
    break;

  case 18: /* close_scope_eth: %empty  */
#line 1015 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_ETH); }
#line 7794 "parser_bison.c"
    break;

  case 19: /* close_scope_export: %empty  */
#line 1016 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_CMD_EXPORT); }
#line 7800 "parser_bison.c"
    break;

  case 20: /* close_scope_fib: %empty  */
#line 1017 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_FIB); }
#line 7806 "parser_bison.c"
    break;

  case 21: /* close_scope_frag: %empty  */
#line 1018 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_FRAG); }
#line 7812 "parser_bison.c"
    break;

  case 22: /* close_scope_fwd: %empty  */
#line 1019 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_STMT_FWD); }
#line 7818 "parser_bison.c"
    break;

  case 23: /* close_scope_hash: %empty  */
#line 1020 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_HASH); }
#line 7824 "parser_bison.c"
    break;

  case 24: /* close_scope_hbh: %empty  */
#line 1021 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_HBH); }
#line 7830 "parser_bison.c"
    break;

  case 25: /* close_scope_ip: %empty  */
#line 1022 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_IP); }
#line 7836 "parser_bison.c"
    break;

  case 26: /* close_scope_ip6: %empty  */
#line 1023 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_IP6); }
#line 7842 "parser_bison.c"
    break;

  case 27: /* close_scope_vlan: %empty  */
#line 1024 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_VLAN); }
#line 7848 "parser_bison.c"
    break;

  case 28: /* close_scope_icmp: %empty  */
#line 1025 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_ICMP); }
#line 7854 "parser_bison.c"
    break;

  case 29: /* close_scope_igmp: %empty  */
#line 1026 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_IGMP); }
#line 7860 "parser_bison.c"
    break;

  case 30: /* close_scope_import: %empty  */
#line 1027 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_CMD_IMPORT); }
#line 7866 "parser_bison.c"
    break;

  case 31: /* close_scope_ipsec: %empty  */
#line 1028 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_IPSEC); }
#line 7872 "parser_bison.c"
    break;

  case 32: /* close_scope_list: %empty  */
#line 1029 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_CMD_LIST); }
#line 7878 "parser_bison.c"
    break;

  case 33: /* close_scope_limit: %empty  */
#line 1030 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_LIMIT); }
#line 7884 "parser_bison.c"
    break;

  case 34: /* close_scope_meta: %empty  */
#line 1031 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_META); }
#line 7890 "parser_bison.c"
    break;

  case 35: /* close_scope_mh: %empty  */
#line 1032 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_MH); }
#line 7896 "parser_bison.c"
    break;

  case 36: /* close_scope_monitor: %empty  */
#line 1033 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_CMD_MONITOR); }
#line 7902 "parser_bison.c"
    break;

  case 37: /* close_scope_nat: %empty  */
#line 1034 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_STMT_NAT); }
#line 7908 "parser_bison.c"
    break;

  case 38: /* close_scope_numgen: %empty  */
#line 1035 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_NUMGEN); }
#line 7914 "parser_bison.c"
    break;

  case 39: /* close_scope_osf: %empty  */
#line 1036 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_OSF); }
#line 7920 "parser_bison.c"
    break;

  case 40: /* close_scope_policy: %empty  */
#line 1037 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_POLICY); }
#line 7926 "parser_bison.c"
    break;

  case 41: /* close_scope_quota: %empty  */
#line 1038 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_QUOTA); }
#line 7932 "parser_bison.c"
    break;

  case 42: /* close_scope_queue: %empty  */
#line 1039 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_QUEUE); }
#line 7938 "parser_bison.c"
    break;

  case 43: /* close_scope_reject: %empty  */
#line 1040 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_STMT_REJECT); }
#line 7944 "parser_bison.c"
    break;

  case 44: /* close_scope_reset: %empty  */
#line 1041 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_CMD_RESET); }
#line 7950 "parser_bison.c"
    break;

  case 45: /* close_scope_rt: %empty  */
#line 1042 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_RT); }
#line 7956 "parser_bison.c"
    break;

  case 46: /* close_scope_sctp: %empty  */
#line 1043 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_SCTP); }
#line 7962 "parser_bison.c"
    break;

  case 47: /* close_scope_sctp_chunk: %empty  */
#line 1044 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_SCTP_CHUNK); }
#line 7968 "parser_bison.c"
    break;

  case 48: /* close_scope_secmark: %empty  */
#line 1045 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_SECMARK); }
#line 7974 "parser_bison.c"
    break;

  case 49: /* close_scope_socket: %empty  */
#line 1046 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_SOCKET); }
#line 7980 "parser_bison.c"
    break;

  case 50: /* close_scope_tcp: %empty  */
#line 1047 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_TCP); }
#line 7986 "parser_bison.c"
    break;

  case 51: /* close_scope_tproxy: %empty  */
#line 1048 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_STMT_TPROXY); }
#line 7992 "parser_bison.c"
    break;

  case 52: /* close_scope_type: %empty  */
#line 1049 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_TYPE); }
#line 7998 "parser_bison.c"
    break;

  case 53: /* close_scope_th: %empty  */
#line 1050 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_TH); }
#line 8004 "parser_bison.c"
    break;

  case 54: /* close_scope_udp: %empty  */
#line 1051 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_UDP); }
#line 8010 "parser_bison.c"
    break;

  case 55: /* close_scope_udplite: %empty  */
#line 1052 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_EXPR_UDPLITE); }
#line 8016 "parser_bison.c"
    break;

  case 56: /* close_scope_log: %empty  */
#line 1054 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_STMT_LOG); }
#line 8022 "parser_bison.c"
    break;

  case 57: /* close_scope_synproxy: %empty  */
#line 1055 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_STMT_SYNPROXY); }
#line 8028 "parser_bison.c"
    break;

  case 58: /* close_scope_xt: %empty  */
#line 1056 "parser_bison.y"
                          { scanner_pop_start_cond(nft->scanner, PARSER_SC_XT); }
#line 8034 "parser_bison.c"
    break;

  case 59: /* common_block: "include" "quoted string" stmt_separator  */
#line 1059 "parser_bison.y"
                        {
				if (scanner_include_file(nft, scanner, (yyvsp[-1].string), &(yyloc)) < 0) {
					xfree((yyvsp[-1].string));
					YYERROR;
				}
				xfree((yyvsp[-1].string));
			}
#line 8046 "parser_bison.c"
    break;

  case 60: /* common_block: "define" identifier '=' initializer_expr stmt_separator  */
#line 1067 "parser_bison.y"
                        {
				struct scope *scope = current_scope(state);

				if (symbol_lookup(scope, (yyvsp[-3].string)) != NULL) {
					erec_queue(error(&(yylsp[-3]), "redefinition of symbol '%s'", (yyvsp[-3].string)),
						   state->msgs);
					expr_free((yyvsp[-1].expr));
					xfree((yyvsp[-3].string));
					YYERROR;
				}

				symbol_bind(scope, (yyvsp[-3].string), (yyvsp[-1].expr));
				xfree((yyvsp[-3].string));
			}
#line 8065 "parser_bison.c"
    break;

  case 61: /* common_block: "redefine" identifier '=' initializer_expr stmt_separator  */
#line 1082 "parser_bison.y"
                        {
				struct scope *scope = current_scope(state);

				symbol_bind(scope, (yyvsp[-3].string), (yyvsp[-1].expr));
				xfree((yyvsp[-3].string));
			}
#line 8076 "parser_bison.c"
    break;

  case 62: /* common_block: "undefine" identifier stmt_separator  */
#line 1089 "parser_bison.y"
                        {
				struct scope *scope = current_scope(state);

				if (symbol_unbind(scope, (yyvsp[-1].string)) < 0) {
					erec_queue(error(&(yylsp[-1]), "undefined symbol '%s'", (yyvsp[-1].string)),
						   state->msgs);
					xfree((yyvsp[-1].string));
					YYERROR;
				}
				xfree((yyvsp[-1].string));
			}
#line 8092 "parser_bison.c"
    break;

  case 63: /* common_block: error stmt_separator  */
#line 1101 "parser_bison.y"
                        {
				if (++state->nerrs == nft->parser_max_errors)
					YYABORT;
				yyerrok;
			}
#line 8102 "parser_bison.c"
    break;

  case 64: /* line: common_block  */
#line 1108 "parser_bison.y"
                                                                { (yyval.cmd) = NULL; }
#line 8108 "parser_bison.c"
    break;

  case 65: /* line: stmt_separator  */
#line 1109 "parser_bison.y"
                                                                { (yyval.cmd) = NULL; }
#line 8114 "parser_bison.c"
    break;

  case 66: /* line: base_cmd stmt_separator  */
#line 1110 "parser_bison.y"
                                                                { (yyval.cmd) = (yyvsp[-1].cmd); }
#line 8120 "parser_bison.c"
    break;

  case 67: /* line: base_cmd "end of file"  */
#line 1112 "parser_bison.y"
                        {
				/*
				 * Very hackish workaround for bison >= 2.4: previous versions
				 * terminated parsing after EOF, 2.4+ tries to get further input
				 * in 'input' and calls the scanner again, causing a crash when
				 * the final input buffer has been popped. Terminate manually to
				 * avoid this. The correct fix should be to adjust the grammar
				 * to accept EOF in input, but for unknown reasons it does not
				 * work.
				 */
				if ((yyvsp[-1].cmd) != NULL) {
					(yyvsp[-1].cmd)->location = (yylsp[-1]);
					list_add_tail(&(yyvsp[-1].cmd)->list, state->cmds);
				}
				(yyval.cmd) = NULL;
				YYACCEPT;
			}
#line 8142 "parser_bison.c"
    break;

  case 68: /* base_cmd: add_cmd  */
#line 1131 "parser_bison.y"
                                                                { (yyval.cmd) = (yyvsp[0].cmd); }
#line 8148 "parser_bison.c"
    break;

  case 69: /* base_cmd: "add" add_cmd  */
#line 1132 "parser_bison.y"
                                                                { (yyval.cmd) = (yyvsp[0].cmd); }
#line 8154 "parser_bison.c"
    break;

  case 70: /* base_cmd: "replace" replace_cmd  */
#line 1133 "parser_bison.y"
                                                                { (yyval.cmd) = (yyvsp[0].cmd); }
#line 8160 "parser_bison.c"
    break;

  case 71: /* base_cmd: "create" create_cmd  */
#line 1134 "parser_bison.y"
                                                                { (yyval.cmd) = (yyvsp[0].cmd); }
#line 8166 "parser_bison.c"
    break;

  case 72: /* base_cmd: "insert" insert_cmd  */
#line 1135 "parser_bison.y"
                                                                { (yyval.cmd) = (yyvsp[0].cmd); }
#line 8172 "parser_bison.c"
    break;

  case 73: /* base_cmd: "delete" delete_cmd  */
#line 1136 "parser_bison.y"
                                                                { (yyval.cmd) = (yyvsp[0].cmd); }
#line 8178 "parser_bison.c"
    break;

  case 74: /* base_cmd: "get" get_cmd  */
#line 1137 "parser_bison.y"
                                                                { (yyval.cmd) = (yyvsp[0].cmd); }
#line 8184 "parser_bison.c"
    break;

  case 75: /* base_cmd: "list" list_cmd close_scope_list  */
#line 1138 "parser_bison.y"
                                                                                        { (yyval.cmd) = (yyvsp[-1].cmd); }
#line 8190 "parser_bison.c"
    break;

  case 76: /* base_cmd: "reset" reset_cmd close_scope_reset  */
#line 1139 "parser_bison.y"
                                                                                        { (yyval.cmd) = (yyvsp[-1].cmd); }
#line 8196 "parser_bison.c"
    break;

  case 77: /* base_cmd: "flush" flush_cmd  */
#line 1140 "parser_bison.y"
                                                                { (yyval.cmd) = (yyvsp[0].cmd); }
#line 8202 "parser_bison.c"
    break;

  case 78: /* base_cmd: "rename" rename_cmd  */
#line 1141 "parser_bison.y"
                                                                { (yyval.cmd) = (yyvsp[0].cmd); }
#line 8208 "parser_bison.c"
    break;

  case 79: /* base_cmd: "import" import_cmd close_scope_import  */
#line 1142 "parser_bison.y"
                                                                                        { (yyval.cmd) = (yyvsp[-1].cmd); }
#line 8214 "parser_bison.c"
    break;

  case 80: /* base_cmd: "export" export_cmd close_scope_export  */
#line 1143 "parser_bison.y"
                                                                                        { (yyval.cmd) = (yyvsp[-1].cmd); }
#line 8220 "parser_bison.c"
    break;

  case 81: /* base_cmd: "monitor" monitor_cmd close_scope_monitor  */
#line 1144 "parser_bison.y"
                                                                                        { (yyval.cmd) = (yyvsp[-1].cmd); }
#line 8226 "parser_bison.c"
    break;

  case 82: /* base_cmd: "describe" describe_cmd  */
#line 1145 "parser_bison.y"
                                                                { (yyval.cmd) = (yyvsp[0].cmd); }
#line 8232 "parser_bison.c"
    break;

  case 83: /* add_cmd: "table" table_spec  */
#line 1149 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_TABLE, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8240 "parser_bison.c"
    break;

  case 84: /* add_cmd: "table" table_spec table_block_alloc '{' table_block '}'  */
#line 1154 "parser_bison.y"
                        {
				handle_merge(&(yyvsp[-3].table)->handle, &(yyvsp[-4].handle));
				close_scope(state);
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_TABLE, &(yyvsp[-4].handle), &(yyloc), (yyvsp[-1].table));
			}
#line 8250 "parser_bison.c"
    break;

  case 85: /* add_cmd: "chain" chain_spec  */
#line 1160 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_CHAIN, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8258 "parser_bison.c"
    break;

  case 86: /* add_cmd: "chain" chain_spec chain_block_alloc '{' chain_block '}'  */
#line 1165 "parser_bison.y"
                        {
				(yyvsp[-1].chain)->location = (yylsp[-1]);
				handle_merge(&(yyvsp[-3].chain)->handle, &(yyvsp[-4].handle));
				close_scope(state);
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_CHAIN, &(yyvsp[-4].handle), &(yyloc), (yyvsp[-1].chain));
			}
#line 8269 "parser_bison.c"
    break;

  case 87: /* add_cmd: "rule" rule_position rule  */
#line 1172 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_RULE, &(yyvsp[-1].handle), &(yyloc), (yyvsp[0].rule));
			}
#line 8277 "parser_bison.c"
    break;

  case 88: /* add_cmd: rule_position rule  */
#line 1176 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_RULE, &(yyvsp[-1].handle), &(yyloc), (yyvsp[0].rule));
			}
#line 8285 "parser_bison.c"
    break;

  case 89: /* add_cmd: "set" set_spec set_block_alloc '{' set_block '}'  */
#line 1181 "parser_bison.y"
                        {
				(yyvsp[-1].set)->location = (yylsp[-1]);
				handle_merge(&(yyvsp[-3].set)->handle, &(yyvsp[-4].handle));
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_SET, &(yyvsp[-4].handle), &(yyloc), (yyvsp[-1].set));
			}
#line 8295 "parser_bison.c"
    break;

  case 90: /* add_cmd: "map" set_spec map_block_alloc '{' map_block '}'  */
#line 1188 "parser_bison.y"
                        {
				(yyvsp[-1].set)->location = (yylsp[-1]);
				handle_merge(&(yyvsp[-3].set)->handle, &(yyvsp[-4].handle));
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_SET, &(yyvsp[-4].handle), &(yyloc), (yyvsp[-1].set));
			}
#line 8305 "parser_bison.c"
    break;

  case 91: /* add_cmd: "element" set_spec set_block_expr  */
#line 1194 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_ELEMENTS, &(yyvsp[-1].handle), &(yyloc), (yyvsp[0].expr));
			}
#line 8313 "parser_bison.c"
    break;

  case 92: /* add_cmd: "flowtable" flowtable_spec flowtable_block_alloc '{' flowtable_block '}'  */
#line 1199 "parser_bison.y"
                        {
				(yyvsp[-1].flowtable)->location = (yylsp[-1]);
				handle_merge(&(yyvsp[-3].flowtable)->handle, &(yyvsp[-4].handle));
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_FLOWTABLE, &(yyvsp[-4].handle), &(yyloc), (yyvsp[-1].flowtable));
			}
#line 8323 "parser_bison.c"
    break;

  case 93: /* add_cmd: "counter" obj_spec close_scope_counter  */
#line 1205 "parser_bison.y"
                        {
				struct obj *obj;

				obj = obj_alloc(&(yyloc));
				obj->type = NFT_OBJECT_COUNTER;
				handle_merge(&obj->handle, &(yyvsp[-1].handle));
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_COUNTER, &(yyvsp[-1].handle), &(yyloc), obj);
			}
#line 8336 "parser_bison.c"
    break;

  case 94: /* add_cmd: "counter" obj_spec counter_obj counter_config close_scope_counter  */
#line 1214 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_COUNTER, &(yyvsp[-3].handle), &(yyloc), (yyvsp[-2].obj));
			}
#line 8344 "parser_bison.c"
    break;

  case 95: /* add_cmd: "counter" obj_spec counter_obj '{' counter_block '}' close_scope_counter  */
#line 1218 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_COUNTER, &(yyvsp[-5].handle), &(yyloc), (yyvsp[-4].obj));
			}
#line 8352 "parser_bison.c"
    break;

  case 96: /* add_cmd: "quota" obj_spec quota_obj quota_config close_scope_quota  */
#line 1222 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_QUOTA, &(yyvsp[-3].handle), &(yyloc), (yyvsp[-2].obj));
			}
#line 8360 "parser_bison.c"
    break;

  case 97: /* add_cmd: "quota" obj_spec quota_obj '{' quota_block '}' close_scope_quota  */
#line 1226 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_QUOTA, &(yyvsp[-5].handle), &(yyloc), (yyvsp[-4].obj));
			}
#line 8368 "parser_bison.c"
    break;

  case 98: /* add_cmd: "ct" "helper" obj_spec ct_obj_alloc '{' ct_helper_block '}' close_scope_ct  */
#line 1230 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc_obj_ct(CMD_ADD, NFT_OBJECT_CT_HELPER, &(yyvsp[-5].handle), &(yyloc), (yyvsp[-4].obj));
			}
#line 8376 "parser_bison.c"
    break;

  case 99: /* add_cmd: "ct" "timeout" obj_spec ct_obj_alloc '{' ct_timeout_block '}' close_scope_ct  */
#line 1234 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc_obj_ct(CMD_ADD, NFT_OBJECT_CT_TIMEOUT, &(yyvsp[-5].handle), &(yyloc), (yyvsp[-4].obj));
			}
#line 8384 "parser_bison.c"
    break;

  case 100: /* add_cmd: "ct" "expectation" obj_spec ct_obj_alloc '{' ct_expect_block '}' close_scope_ct  */
#line 1238 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc_obj_ct(CMD_ADD, NFT_OBJECT_CT_EXPECT, &(yyvsp[-5].handle), &(yyloc), (yyvsp[-4].obj));
			}
#line 8392 "parser_bison.c"
    break;

  case 101: /* add_cmd: "limit" obj_spec limit_obj limit_config close_scope_limit  */
#line 1242 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_LIMIT, &(yyvsp[-3].handle), &(yyloc), (yyvsp[-2].obj));
			}
#line 8400 "parser_bison.c"
    break;

  case 102: /* add_cmd: "limit" obj_spec limit_obj '{' limit_block '}' close_scope_limit  */
#line 1246 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_LIMIT, &(yyvsp[-5].handle), &(yyloc), (yyvsp[-4].obj));
			}
#line 8408 "parser_bison.c"
    break;

  case 103: /* add_cmd: "secmark" obj_spec secmark_obj secmark_config close_scope_secmark  */
#line 1250 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_SECMARK, &(yyvsp[-3].handle), &(yyloc), (yyvsp[-2].obj));
			}
#line 8416 "parser_bison.c"
    break;

  case 104: /* add_cmd: "secmark" obj_spec secmark_obj '{' secmark_block '}' close_scope_secmark  */
#line 1254 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_SECMARK, &(yyvsp[-5].handle), &(yyloc), (yyvsp[-4].obj));
			}
#line 8424 "parser_bison.c"
    break;

  case 105: /* add_cmd: "synproxy" obj_spec synproxy_obj synproxy_config close_scope_synproxy  */
#line 1258 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_SYNPROXY, &(yyvsp[-3].handle), &(yyloc), (yyvsp[-2].obj));
			}
#line 8432 "parser_bison.c"
    break;

  case 106: /* add_cmd: "synproxy" obj_spec synproxy_obj '{' synproxy_block '}' close_scope_synproxy  */
#line 1262 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_ADD, CMD_OBJ_SYNPROXY, &(yyvsp[-5].handle), &(yyloc), (yyvsp[-4].obj));
			}
#line 8440 "parser_bison.c"
    break;

  case 107: /* replace_cmd: "rule" ruleid_spec rule  */
#line 1268 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_REPLACE, CMD_OBJ_RULE, &(yyvsp[-1].handle), &(yyloc), (yyvsp[0].rule));
			}
#line 8448 "parser_bison.c"
    break;

  case 108: /* create_cmd: "table" table_spec  */
#line 1274 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_TABLE, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8456 "parser_bison.c"
    break;

  case 109: /* create_cmd: "table" table_spec table_block_alloc '{' table_block '}'  */
#line 1279 "parser_bison.y"
                        {
				handle_merge(&(yyvsp[-3].table)->handle, &(yyvsp[-4].handle));
				close_scope(state);
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_TABLE, &(yyvsp[-4].handle), &(yyloc), (yyvsp[-1].table));
			}
#line 8466 "parser_bison.c"
    break;

  case 110: /* create_cmd: "chain" chain_spec  */
#line 1285 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_CHAIN, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8474 "parser_bison.c"
    break;

  case 111: /* create_cmd: "chain" chain_spec chain_block_alloc '{' chain_block '}'  */
#line 1290 "parser_bison.y"
                        {
				(yyvsp[-1].chain)->location = (yylsp[-1]);
				handle_merge(&(yyvsp[-3].chain)->handle, &(yyvsp[-4].handle));
				close_scope(state);
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_CHAIN, &(yyvsp[-4].handle), &(yyloc), (yyvsp[-1].chain));
			}
#line 8485 "parser_bison.c"
    break;

  case 112: /* create_cmd: "set" set_spec set_block_alloc '{' set_block '}'  */
#line 1298 "parser_bison.y"
                        {
				(yyvsp[-1].set)->location = (yylsp[-1]);
				handle_merge(&(yyvsp[-3].set)->handle, &(yyvsp[-4].handle));
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_SET, &(yyvsp[-4].handle), &(yyloc), (yyvsp[-1].set));
			}
#line 8495 "parser_bison.c"
    break;

  case 113: /* create_cmd: "map" set_spec map_block_alloc '{' map_block '}'  */
#line 1305 "parser_bison.y"
                        {
				(yyvsp[-1].set)->location = (yylsp[-1]);
				handle_merge(&(yyvsp[-3].set)->handle, &(yyvsp[-4].handle));
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_SET, &(yyvsp[-4].handle), &(yyloc), (yyvsp[-1].set));
			}
#line 8505 "parser_bison.c"
    break;

  case 114: /* create_cmd: "element" set_spec set_block_expr  */
#line 1311 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_ELEMENTS, &(yyvsp[-1].handle), &(yyloc), (yyvsp[0].expr));
			}
#line 8513 "parser_bison.c"
    break;

  case 115: /* create_cmd: "flowtable" flowtable_spec flowtable_block_alloc '{' flowtable_block '}'  */
#line 1316 "parser_bison.y"
                        {
				(yyvsp[-1].flowtable)->location = (yylsp[-1]);
				handle_merge(&(yyvsp[-3].flowtable)->handle, &(yyvsp[-4].handle));
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_FLOWTABLE, &(yyvsp[-4].handle), &(yyloc), (yyvsp[-1].flowtable));
			}
#line 8523 "parser_bison.c"
    break;

  case 116: /* create_cmd: "counter" obj_spec close_scope_counter  */
#line 1322 "parser_bison.y"
                        {
				struct obj *obj;

				obj = obj_alloc(&(yyloc));
				obj->type = NFT_OBJECT_COUNTER;
				handle_merge(&obj->handle, &(yyvsp[-1].handle));
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_COUNTER, &(yyvsp[-1].handle), &(yyloc), obj);
			}
#line 8536 "parser_bison.c"
    break;

  case 117: /* create_cmd: "counter" obj_spec counter_obj counter_config close_scope_counter  */
#line 1331 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_COUNTER, &(yyvsp[-3].handle), &(yyloc), (yyvsp[-2].obj));
			}
#line 8544 "parser_bison.c"
    break;

  case 118: /* create_cmd: "quota" obj_spec quota_obj quota_config close_scope_quota  */
#line 1335 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_QUOTA, &(yyvsp[-3].handle), &(yyloc), (yyvsp[-2].obj));
			}
#line 8552 "parser_bison.c"
    break;

  case 119: /* create_cmd: "ct" "helper" obj_spec ct_obj_alloc '{' ct_helper_block '}' close_scope_ct  */
#line 1339 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc_obj_ct(CMD_CREATE, NFT_OBJECT_CT_HELPER, &(yyvsp[-5].handle), &(yyloc), (yyvsp[-4].obj));
			}
#line 8560 "parser_bison.c"
    break;

  case 120: /* create_cmd: "ct" "timeout" obj_spec ct_obj_alloc '{' ct_timeout_block '}' close_scope_ct  */
#line 1343 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc_obj_ct(CMD_CREATE, NFT_OBJECT_CT_TIMEOUT, &(yyvsp[-5].handle), &(yyloc), (yyvsp[-4].obj));
			}
#line 8568 "parser_bison.c"
    break;

  case 121: /* create_cmd: "ct" "expectation" obj_spec ct_obj_alloc '{' ct_expect_block '}' close_scope_ct  */
#line 1347 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc_obj_ct(CMD_CREATE, NFT_OBJECT_CT_EXPECT, &(yyvsp[-5].handle), &(yyloc), (yyvsp[-4].obj));
			}
#line 8576 "parser_bison.c"
    break;

  case 122: /* create_cmd: "limit" obj_spec limit_obj limit_config close_scope_limit  */
#line 1351 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_LIMIT, &(yyvsp[-3].handle), &(yyloc), (yyvsp[-2].obj));
			}
#line 8584 "parser_bison.c"
    break;

  case 123: /* create_cmd: "secmark" obj_spec secmark_obj secmark_config close_scope_secmark  */
#line 1355 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_SECMARK, &(yyvsp[-3].handle), &(yyloc), (yyvsp[-2].obj));
			}
#line 8592 "parser_bison.c"
    break;

  case 124: /* create_cmd: "synproxy" obj_spec synproxy_obj synproxy_config close_scope_synproxy  */
#line 1359 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_CREATE, CMD_OBJ_SYNPROXY, &(yyvsp[-3].handle), &(yyloc), (yyvsp[-2].obj));
			}
#line 8600 "parser_bison.c"
    break;

  case 125: /* insert_cmd: "rule" rule_position rule  */
#line 1365 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_INSERT, CMD_OBJ_RULE, &(yyvsp[-1].handle), &(yyloc), (yyvsp[0].rule));
			}
#line 8608 "parser_bison.c"
    break;

  case 134: /* delete_cmd: "table" table_or_id_spec  */
#line 1387 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_TABLE, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8616 "parser_bison.c"
    break;

  case 135: /* delete_cmd: "chain" chain_or_id_spec  */
#line 1391 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_CHAIN, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8624 "parser_bison.c"
    break;

  case 136: /* delete_cmd: "rule" ruleid_spec  */
#line 1395 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_RULE, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8632 "parser_bison.c"
    break;

  case 137: /* delete_cmd: "set" set_or_id_spec  */
#line 1399 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_SET, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8640 "parser_bison.c"
    break;

  case 138: /* delete_cmd: "map" set_or_id_spec  */
#line 1403 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_SET, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8648 "parser_bison.c"
    break;

  case 139: /* delete_cmd: "element" set_spec set_block_expr  */
#line 1407 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_ELEMENTS, &(yyvsp[-1].handle), &(yyloc), (yyvsp[0].expr));
			}
#line 8656 "parser_bison.c"
    break;

  case 140: /* delete_cmd: "flowtable" flowtable_spec  */
#line 1411 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_FLOWTABLE, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8664 "parser_bison.c"
    break;

  case 141: /* delete_cmd: "flowtable" flowtableid_spec  */
#line 1415 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_FLOWTABLE, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8672 "parser_bison.c"
    break;

  case 142: /* delete_cmd: "flowtable" flowtable_spec flowtable_block_alloc '{' flowtable_block '}'  */
#line 1420 "parser_bison.y"
                        {
				(yyvsp[-1].flowtable)->location = (yylsp[-1]);
				handle_merge(&(yyvsp[-3].flowtable)->handle, &(yyvsp[-4].handle));
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_FLOWTABLE, &(yyvsp[-4].handle), &(yyloc), (yyvsp[-1].flowtable));
			}
#line 8682 "parser_bison.c"
    break;

  case 143: /* delete_cmd: "counter" obj_or_id_spec close_scope_counter  */
#line 1426 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_COUNTER, &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 8690 "parser_bison.c"
    break;

  case 144: /* delete_cmd: "quota" obj_or_id_spec close_scope_quota  */
#line 1430 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_QUOTA, &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 8698 "parser_bison.c"
    break;

  case 145: /* delete_cmd: "ct" ct_obj_type obj_spec ct_obj_alloc close_scope_ct  */
#line 1434 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc_obj_ct(CMD_DELETE, (yyvsp[-3].val), &(yyvsp[-2].handle), &(yyloc), (yyvsp[-1].obj));
				if ((yyvsp[-3].val) == NFT_OBJECT_CT_TIMEOUT)
					init_list_head(&(yyvsp[-1].obj)->ct_timeout.timeout_list);
			}
#line 8708 "parser_bison.c"
    break;

  case 146: /* delete_cmd: "limit" obj_or_id_spec close_scope_limit  */
#line 1440 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_LIMIT, &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 8716 "parser_bison.c"
    break;

  case 147: /* delete_cmd: "secmark" obj_or_id_spec close_scope_secmark  */
#line 1444 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_SECMARK, &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 8724 "parser_bison.c"
    break;

  case 148: /* delete_cmd: "synproxy" obj_or_id_spec close_scope_synproxy  */
#line 1448 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_DELETE, CMD_OBJ_SYNPROXY, &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 8732 "parser_bison.c"
    break;

  case 149: /* get_cmd: "element" set_spec set_block_expr  */
#line 1454 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_GET, CMD_OBJ_ELEMENTS, &(yyvsp[-1].handle), &(yyloc), (yyvsp[0].expr));
			}
#line 8740 "parser_bison.c"
    break;

  case 150: /* list_cmd: "table" table_spec  */
#line 1460 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_TABLE, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8748 "parser_bison.c"
    break;

  case 151: /* list_cmd: "tables" ruleset_spec  */
#line 1464 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_TABLE, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8756 "parser_bison.c"
    break;

  case 152: /* list_cmd: "chain" chain_spec  */
#line 1468 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_CHAIN, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8764 "parser_bison.c"
    break;

  case 153: /* list_cmd: "chains" ruleset_spec  */
#line 1472 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_CHAINS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8772 "parser_bison.c"
    break;

  case 154: /* list_cmd: "sets" ruleset_spec  */
#line 1476 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_SETS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8780 "parser_bison.c"
    break;

  case 155: /* list_cmd: "sets" "table" table_spec  */
#line 1480 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_SETS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8788 "parser_bison.c"
    break;

  case 156: /* list_cmd: "set" set_spec  */
#line 1484 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_SET, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8796 "parser_bison.c"
    break;

  case 157: /* list_cmd: "counters" ruleset_spec  */
#line 1488 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_COUNTERS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8804 "parser_bison.c"
    break;

  case 158: /* list_cmd: "counters" "table" table_spec  */
#line 1492 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_COUNTERS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8812 "parser_bison.c"
    break;

  case 159: /* list_cmd: "counter" obj_spec close_scope_counter  */
#line 1496 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_COUNTER, &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 8820 "parser_bison.c"
    break;

  case 160: /* list_cmd: "quotas" ruleset_spec  */
#line 1500 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_QUOTAS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8828 "parser_bison.c"
    break;

  case 161: /* list_cmd: "quotas" "table" table_spec  */
#line 1504 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_QUOTAS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8836 "parser_bison.c"
    break;

  case 162: /* list_cmd: "quota" obj_spec close_scope_quota  */
#line 1508 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_QUOTA, &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 8844 "parser_bison.c"
    break;

  case 163: /* list_cmd: "limits" ruleset_spec  */
#line 1512 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_LIMITS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8852 "parser_bison.c"
    break;

  case 164: /* list_cmd: "limits" "table" table_spec  */
#line 1516 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_LIMITS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8860 "parser_bison.c"
    break;

  case 165: /* list_cmd: "limit" obj_spec close_scope_limit  */
#line 1520 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_LIMIT, &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 8868 "parser_bison.c"
    break;

  case 166: /* list_cmd: "secmarks" ruleset_spec  */
#line 1524 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_SECMARKS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8876 "parser_bison.c"
    break;

  case 167: /* list_cmd: "secmarks" "table" table_spec  */
#line 1528 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_SECMARKS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8884 "parser_bison.c"
    break;

  case 168: /* list_cmd: "secmark" obj_spec close_scope_secmark  */
#line 1532 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_SECMARK, &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 8892 "parser_bison.c"
    break;

  case 169: /* list_cmd: "synproxys" ruleset_spec  */
#line 1536 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_SYNPROXYS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8900 "parser_bison.c"
    break;

  case 170: /* list_cmd: "synproxys" "table" table_spec  */
#line 1540 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_SYNPROXYS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8908 "parser_bison.c"
    break;

  case 171: /* list_cmd: "synproxy" obj_spec close_scope_synproxy  */
#line 1544 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_SYNPROXY, &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 8916 "parser_bison.c"
    break;

  case 172: /* list_cmd: "ruleset" ruleset_spec  */
#line 1548 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_RULESET, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8924 "parser_bison.c"
    break;

  case 173: /* list_cmd: "flow" "tables" ruleset_spec  */
#line 1552 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_METERS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8932 "parser_bison.c"
    break;

  case 174: /* list_cmd: "flow" "table" set_spec  */
#line 1556 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_METER, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8940 "parser_bison.c"
    break;

  case 175: /* list_cmd: "meters" ruleset_spec  */
#line 1560 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_METERS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8948 "parser_bison.c"
    break;

  case 176: /* list_cmd: "meter" set_spec  */
#line 1564 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_METER, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8956 "parser_bison.c"
    break;

  case 177: /* list_cmd: "flowtables" ruleset_spec  */
#line 1568 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_FLOWTABLES, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8964 "parser_bison.c"
    break;

  case 178: /* list_cmd: "flowtable" flowtable_spec  */
#line 1572 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_FLOWTABLE, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8972 "parser_bison.c"
    break;

  case 179: /* list_cmd: "maps" ruleset_spec  */
#line 1576 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_MAPS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8980 "parser_bison.c"
    break;

  case 180: /* list_cmd: "map" set_spec  */
#line 1580 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_MAP, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 8988 "parser_bison.c"
    break;

  case 181: /* list_cmd: "ct" ct_obj_type obj_spec close_scope_ct  */
#line 1584 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc_obj_ct(CMD_LIST, (yyvsp[-2].val), &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 8996 "parser_bison.c"
    break;

  case 182: /* list_cmd: "ct" ct_cmd_type "table" table_spec close_scope_ct  */
#line 1588 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, (yyvsp[-3].val), &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 9004 "parser_bison.c"
    break;

  case 183: /* list_cmd: "hooks" basehook_spec  */
#line 1592 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_LIST, CMD_OBJ_HOOKS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9012 "parser_bison.c"
    break;

  case 184: /* basehook_device_name: "device" "string"  */
#line 1598 "parser_bison.y"
                        {
				(yyval.string) = (yyvsp[0].string);
			}
#line 9020 "parser_bison.c"
    break;

  case 185: /* basehook_spec: ruleset_spec  */
#line 1604 "parser_bison.y"
                        {
				(yyval.handle) = (yyvsp[0].handle);
			}
#line 9028 "parser_bison.c"
    break;

  case 186: /* basehook_spec: ruleset_spec basehook_device_name  */
#line 1608 "parser_bison.y"
                        {
				if ((yyvsp[0].string)) {
					(yyvsp[-1].handle).obj.name = (yyvsp[0].string);
					(yyvsp[-1].handle).obj.location = (yylsp[0]);
				}
				(yyval.handle) = (yyvsp[-1].handle);
			}
#line 9040 "parser_bison.c"
    break;

  case 187: /* reset_cmd: "counters" ruleset_spec  */
#line 1618 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_RESET, CMD_OBJ_COUNTERS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9048 "parser_bison.c"
    break;

  case 188: /* reset_cmd: "counters" "table" table_spec  */
#line 1622 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_RESET, CMD_OBJ_COUNTERS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9056 "parser_bison.c"
    break;

  case 189: /* reset_cmd: "counter" obj_spec close_scope_counter  */
#line 1626 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_RESET, CMD_OBJ_COUNTER, &(yyvsp[-1].handle),&(yyloc), NULL);
			}
#line 9064 "parser_bison.c"
    break;

  case 190: /* reset_cmd: "quotas" ruleset_spec  */
#line 1630 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_RESET, CMD_OBJ_QUOTAS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9072 "parser_bison.c"
    break;

  case 191: /* reset_cmd: "quotas" "table" table_spec  */
#line 1634 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_RESET, CMD_OBJ_QUOTAS, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9080 "parser_bison.c"
    break;

  case 192: /* reset_cmd: "quota" obj_spec close_scope_quota  */
#line 1638 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_RESET, CMD_OBJ_QUOTA, &(yyvsp[-1].handle), &(yyloc), NULL);
			}
#line 9088 "parser_bison.c"
    break;

  case 193: /* flush_cmd: "table" table_spec  */
#line 1644 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_FLUSH, CMD_OBJ_TABLE, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9096 "parser_bison.c"
    break;

  case 194: /* flush_cmd: "chain" chain_spec  */
#line 1648 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_FLUSH, CMD_OBJ_CHAIN, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9104 "parser_bison.c"
    break;

  case 195: /* flush_cmd: "set" set_spec  */
#line 1652 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_FLUSH, CMD_OBJ_SET, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9112 "parser_bison.c"
    break;

  case 196: /* flush_cmd: "map" set_spec  */
#line 1656 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_FLUSH, CMD_OBJ_MAP, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9120 "parser_bison.c"
    break;

  case 197: /* flush_cmd: "flow" "table" set_spec  */
#line 1660 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_FLUSH, CMD_OBJ_METER, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9128 "parser_bison.c"
    break;

  case 198: /* flush_cmd: "meter" set_spec  */
#line 1664 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_FLUSH, CMD_OBJ_METER, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9136 "parser_bison.c"
    break;

  case 199: /* flush_cmd: "ruleset" ruleset_spec  */
#line 1668 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_FLUSH, CMD_OBJ_RULESET, &(yyvsp[0].handle), &(yyloc), NULL);
			}
#line 9144 "parser_bison.c"
    break;

  case 200: /* rename_cmd: "chain" chain_spec identifier  */
#line 1674 "parser_bison.y"
                        {
				(yyval.cmd) = cmd_alloc(CMD_RENAME, CMD_OBJ_CHAIN, &(yyvsp[-1].handle), &(yyloc), NULL);
				(yyval.cmd)->arg = (yyvsp[0].string);
			}
#line 9153 "parser_bison.c"
    break;

  case 201: /* import_cmd: "ruleset" markup_format  */
#line 1681 "parser_bison.y"
                        {
				struct handle h = { .family = NFPROTO_UNSPEC };
				struct markup *markup = markup_alloc((yyvsp[0].val));
				(yyval.cmd) = cmd_alloc(CMD_IMPORT, CMD_OBJ_MARKUP, &h, &(yyloc), markup);
			}
#line 9163 "parser_bison.c"
    break;

  case 202: /* import_cmd: markup_format  */
#line 1687 "parser_bison.y"
                        {
				struct handle h = { .family = NFPROTO_UNSPEC };
				struct markup *markup = markup_alloc((yyvsp[0].val));
				(yyval.cmd) = cmd_alloc(CMD_IMPORT, CMD_OBJ_MARKUP, &h, &(yyloc), markup);
			}
#line 9173 "parser_bison.c"
    break;

  case 203: /* export_cmd: "ruleset" markup_format  */
#line 1695 "parser_bison.y"
                        {
				struct handle h = { .family = NFPROTO_UNSPEC };
				struct markup *markup = markup_alloc((yyvsp[0].val));
				(yyval.cmd) = cmd_alloc(CMD_EXPORT, CMD_OBJ_MARKUP, &h, &(yyloc), markup);
			}
#line 9183 "parser_bison.c"
    break;

  case 204: /* export_cmd: markup_format  */
#line 1701 "parser_bison.y"
                        {
				struct handle h = { .family = NFPROTO_UNSPEC };
				struct markup *markup = markup_alloc((yyvsp[0].val));
				(yyval.cmd) = cmd_alloc(CMD_EXPORT, CMD_OBJ_MARKUP, &h, &(yyloc), markup);
			}
#line 9193 "parser_bison.c"
    break;

  case 205: /* monitor_cmd: monitor_event monitor_object monitor_format  */
#line 1709 "parser_bison.y"
                        {
				struct handle h = { .family = NFPROTO_UNSPEC };
				struct monitor *m = monitor_alloc((yyvsp[0].val), (yyvsp[-1].val), (yyvsp[-2].string));
				m->location = (yylsp[-2]);
				(yyval.cmd) = cmd_alloc(CMD_MONITOR, CMD_OBJ_MONITOR, &h, &(yyloc), m);
			}
#line 9204 "parser_bison.c"
    break;

  case 206: /* monitor_event: %empty  */
#line 1717 "parser_bison.y"
                                                { (yyval.string) = NULL; }
#line 9210 "parser_bison.c"
    break;

  case 207: /* monitor_event: "string"  */
#line 1718 "parser_bison.y"
                                                { (yyval.string) = (yyvsp[0].string); }
#line 9216 "parser_bison.c"
    break;

  case 208: /* monitor_object: %empty  */
#line 1721 "parser_bison.y"
                                                { (yyval.val) = CMD_MONITOR_OBJ_ANY; }
#line 9222 "parser_bison.c"
    break;

  case 209: /* monitor_object: "tables"  */
#line 1722 "parser_bison.y"
                                                { (yyval.val) = CMD_MONITOR_OBJ_TABLES; }
#line 9228 "parser_bison.c"
    break;

  case 210: /* monitor_object: "chains"  */
#line 1723 "parser_bison.y"
                                                { (yyval.val) = CMD_MONITOR_OBJ_CHAINS; }
#line 9234 "parser_bison.c"
    break;

  case 211: /* monitor_object: "sets"  */
#line 1724 "parser_bison.y"
                                                { (yyval.val) = CMD_MONITOR_OBJ_SETS; }
#line 9240 "parser_bison.c"
    break;

  case 212: /* monitor_object: "rules"  */
#line 1725 "parser_bison.y"
                                                { (yyval.val) = CMD_MONITOR_OBJ_RULES; }
#line 9246 "parser_bison.c"
    break;

  case 213: /* monitor_object: "elements"  */
#line 1726 "parser_bison.y"
                                                { (yyval.val) = CMD_MONITOR_OBJ_ELEMS; }
#line 9252 "parser_bison.c"
    break;

  case 214: /* monitor_object: "ruleset"  */
#line 1727 "parser_bison.y"
                                                { (yyval.val) = CMD_MONITOR_OBJ_RULESET; }
#line 9258 "parser_bison.c"
    break;

  case 215: /* monitor_object: "trace"  */
#line 1728 "parser_bison.y"
                                                { (yyval.val) = CMD_MONITOR_OBJ_TRACE; }
#line 9264 "parser_bison.c"
    break;

  case 216: /* monitor_format: %empty  */
#line 1731 "parser_bison.y"
                                                { (yyval.val) = NFTNL_OUTPUT_DEFAULT; }
#line 9270 "parser_bison.c"
    break;

  case 218: /* markup_format: "xml"  */
#line 1735 "parser_bison.y"
                                                { (yyval.val) = __NFT_OUTPUT_NOTSUPP; }
#line 9276 "parser_bison.c"
    break;

  case 219: /* markup_format: "json"  */
#line 1736 "parser_bison.y"
                                                { (yyval.val) = NFTNL_OUTPUT_JSON; }
#line 9282 "parser_bison.c"
    break;

  case 220: /* markup_format: "vm" "json"  */
#line 1737 "parser_bison.y"
                                                { (yyval.val) = NFTNL_OUTPUT_JSON; }
#line 9288 "parser_bison.c"
    break;

  case 221: /* describe_cmd: primary_expr  */
#line 1741 "parser_bison.y"
                        {
				struct handle h = { .family = NFPROTO_UNSPEC };
				(yyval.cmd) = cmd_alloc(CMD_DESCRIBE, CMD_OBJ_EXPR, &h, &(yyloc), NULL);
				(yyval.cmd)->expr = (yyvsp[0].expr);
			}
#line 9298 "parser_bison.c"
    break;

  case 222: /* table_block_alloc: %empty  */
#line 1749 "parser_bison.y"
                        {
				(yyval.table) = table_alloc();
				if (open_scope(state, &(yyval.table)->scope) < 0) {
					erec_queue(error(&(yyloc), "too many levels of nesting"),
						   state->msgs);
					state->nerrs++;
				}
			}
#line 9311 "parser_bison.c"
    break;

  case 223: /* table_options: "flags" "string"  */
#line 1760 "parser_bison.y"
                        {
				if (strcmp((yyvsp[0].string), "dormant") == 0) {
					(yyvsp[-2].table)->flags |= TABLE_F_DORMANT;
					xfree((yyvsp[0].string));
				} else if (strcmp((yyvsp[0].string), "owner") == 0) {
					(yyvsp[-2].table)->flags |= TABLE_F_OWNER;
					xfree((yyvsp[0].string));
				} else {
					erec_queue(error(&(yylsp[0]), "unknown table option %s", (yyvsp[0].string)),
						   state->msgs);
					xfree((yyvsp[0].string));
					YYERROR;
				}
			}
#line 9330 "parser_bison.c"
    break;

  case 224: /* table_options: comment_spec  */
#line 1775 "parser_bison.y"
                        {
				if (already_set((yyvsp[-1].table)->comment, &(yyloc), state)) {
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyvsp[-1].table)->comment = (yyvsp[0].string);
			}
#line 9342 "parser_bison.c"
    break;

  case 225: /* table_block: %empty  */
#line 1784 "parser_bison.y"
                                                { (yyval.table) = (yyvsp[(-1) - (0)].table); }
#line 9348 "parser_bison.c"
    break;

  case 229: /* table_block: table_block "chain" chain_identifier chain_block_alloc '{' chain_block '}' stmt_separator  */
#line 1791 "parser_bison.y"
                        {
				(yyvsp[-4].chain)->location = (yylsp[-5]);
				handle_merge(&(yyvsp[-4].chain)->handle, &(yyvsp[-5].handle));
				handle_free(&(yyvsp[-5].handle));
				close_scope(state);
				list_add_tail(&(yyvsp[-4].chain)->list, &(yyvsp[-7].table)->chains);
				(yyval.table) = (yyvsp[-7].table);
			}
#line 9361 "parser_bison.c"
    break;

  case 230: /* table_block: table_block "set" set_identifier set_block_alloc '{' set_block '}' stmt_separator  */
#line 1802 "parser_bison.y"
                        {
				(yyvsp[-4].set)->location = (yylsp[-5]);
				handle_merge(&(yyvsp[-4].set)->handle, &(yyvsp[-5].handle));
				handle_free(&(yyvsp[-5].handle));
				list_add_tail(&(yyvsp[-4].set)->list, &(yyvsp[-7].table)->sets);
				(yyval.table) = (yyvsp[-7].table);
			}
#line 9373 "parser_bison.c"
    break;

  case 231: /* table_block: table_block "map" set_identifier map_block_alloc '{' map_block '}' stmt_separator  */
#line 1812 "parser_bison.y"
                        {
				(yyvsp[-4].set)->location = (yylsp[-5]);
				handle_merge(&(yyvsp[-4].set)->handle, &(yyvsp[-5].handle));
				handle_free(&(yyvsp[-5].handle));
				list_add_tail(&(yyvsp[-4].set)->list, &(yyvsp[-7].table)->sets);
				(yyval.table) = (yyvsp[-7].table);
			}
#line 9385 "parser_bison.c"
    break;

  case 232: /* table_block: table_block "flowtable" flowtable_identifier flowtable_block_alloc '{' flowtable_block '}' stmt_separator  */
#line 1823 "parser_bison.y"
                        {
				(yyvsp[-4].flowtable)->location = (yylsp[-5]);
				handle_merge(&(yyvsp[-4].flowtable)->handle, &(yyvsp[-5].handle));
				handle_free(&(yyvsp[-5].handle));
				list_add_tail(&(yyvsp[-4].flowtable)->list, &(yyvsp[-7].table)->flowtables);
				(yyval.table) = (yyvsp[-7].table);
			}
#line 9397 "parser_bison.c"
    break;

  case 233: /* table_block: table_block "counter" obj_identifier obj_block_alloc '{' counter_block '}' stmt_separator close_scope_counter  */
#line 1833 "parser_bison.y"
                        {
				(yyvsp[-5].obj)->location = (yylsp[-6]);
				(yyvsp[-5].obj)->type = NFT_OBJECT_COUNTER;
				handle_merge(&(yyvsp[-5].obj)->handle, &(yyvsp[-6].handle));
				handle_free(&(yyvsp[-6].handle));
				list_add_tail(&(yyvsp[-5].obj)->list, &(yyvsp[-8].table)->objs);
				(yyval.table) = (yyvsp[-8].table);
			}
#line 9410 "parser_bison.c"
    break;

  case 234: /* table_block: table_block "quota" obj_identifier obj_block_alloc '{' quota_block '}' stmt_separator close_scope_quota  */
#line 1844 "parser_bison.y"
                        {
				(yyvsp[-5].obj)->location = (yylsp[-6]);
				(yyvsp[-5].obj)->type = NFT_OBJECT_QUOTA;
				handle_merge(&(yyvsp[-5].obj)->handle, &(yyvsp[-6].handle));
				handle_free(&(yyvsp[-6].handle));
				list_add_tail(&(yyvsp[-5].obj)->list, &(yyvsp[-8].table)->objs);
				(yyval.table) = (yyvsp[-8].table);
			}
#line 9423 "parser_bison.c"
    break;

  case 235: /* table_block: table_block "ct" "helper" obj_identifier obj_block_alloc '{' ct_helper_block '}' stmt_separator close_scope_ct  */
#line 1853 "parser_bison.y"
                        {
				(yyvsp[-5].obj)->location = (yylsp[-6]);
				(yyvsp[-5].obj)->type = NFT_OBJECT_CT_HELPER;
				handle_merge(&(yyvsp[-5].obj)->handle, &(yyvsp[-6].handle));
				handle_free(&(yyvsp[-6].handle));
				list_add_tail(&(yyvsp[-5].obj)->list, &(yyvsp[-9].table)->objs);
				(yyval.table) = (yyvsp[-9].table);
			}
#line 9436 "parser_bison.c"
    break;

  case 236: /* table_block: table_block "ct" "timeout" obj_identifier obj_block_alloc '{' ct_timeout_block '}' stmt_separator close_scope_ct  */
#line 1862 "parser_bison.y"
                        {
				(yyvsp[-5].obj)->location = (yylsp[-6]);
				(yyvsp[-5].obj)->type = NFT_OBJECT_CT_TIMEOUT;
				handle_merge(&(yyvsp[-5].obj)->handle, &(yyvsp[-6].handle));
				handle_free(&(yyvsp[-6].handle));
				list_add_tail(&(yyvsp[-5].obj)->list, &(yyvsp[-9].table)->objs);
				(yyval.table) = (yyvsp[-9].table);
			}
#line 9449 "parser_bison.c"
    break;

  case 237: /* table_block: table_block "ct" "expectation" obj_identifier obj_block_alloc '{' ct_expect_block '}' stmt_separator close_scope_ct  */
#line 1871 "parser_bison.y"
                        {
				(yyvsp[-5].obj)->location = (yylsp[-6]);
				(yyvsp[-5].obj)->type = NFT_OBJECT_CT_EXPECT;
				handle_merge(&(yyvsp[-5].obj)->handle, &(yyvsp[-6].handle));
				handle_free(&(yyvsp[-6].handle));
				list_add_tail(&(yyvsp[-5].obj)->list, &(yyvsp[-9].table)->objs);
				(yyval.table) = (yyvsp[-9].table);
			}
#line 9462 "parser_bison.c"
    break;

  case 238: /* table_block: table_block "limit" obj_identifier obj_block_alloc '{' limit_block '}' stmt_separator close_scope_limit  */
#line 1882 "parser_bison.y"
                        {
				(yyvsp[-5].obj)->location = (yylsp[-6]);
				(yyvsp[-5].obj)->type = NFT_OBJECT_LIMIT;
				handle_merge(&(yyvsp[-5].obj)->handle, &(yyvsp[-6].handle));
				handle_free(&(yyvsp[-6].handle));
				list_add_tail(&(yyvsp[-5].obj)->list, &(yyvsp[-8].table)->objs);
				(yyval.table) = (yyvsp[-8].table);
			}
#line 9475 "parser_bison.c"
    break;

  case 239: /* table_block: table_block "secmark" obj_identifier obj_block_alloc '{' secmark_block '}' stmt_separator close_scope_secmark  */
#line 1893 "parser_bison.y"
                        {
				(yyvsp[-5].obj)->location = (yylsp[-6]);
				(yyvsp[-5].obj)->type = NFT_OBJECT_SECMARK;
				handle_merge(&(yyvsp[-5].obj)->handle, &(yyvsp[-6].handle));
				handle_free(&(yyvsp[-6].handle));
				list_add_tail(&(yyvsp[-5].obj)->list, &(yyvsp[-8].table)->objs);
				(yyval.table) = (yyvsp[-8].table);
			}
#line 9488 "parser_bison.c"
    break;

  case 240: /* table_block: table_block "synproxy" obj_identifier obj_block_alloc '{' synproxy_block '}' stmt_separator close_scope_synproxy  */
#line 1904 "parser_bison.y"
                        {
				(yyvsp[-5].obj)->location = (yylsp[-6]);
				(yyvsp[-5].obj)->type = NFT_OBJECT_SYNPROXY;
				handle_merge(&(yyvsp[-5].obj)->handle, &(yyvsp[-6].handle));
				handle_free(&(yyvsp[-6].handle));
				list_add_tail(&(yyvsp[-5].obj)->list, &(yyvsp[-8].table)->objs);
				(yyval.table) = (yyvsp[-8].table);
			}
#line 9501 "parser_bison.c"
    break;

  case 241: /* chain_block_alloc: %empty  */
#line 1915 "parser_bison.y"
                        {
				(yyval.chain) = chain_alloc(NULL);
				if (open_scope(state, &(yyval.chain)->scope) < 0) {
					erec_queue(error(&(yyloc), "too many levels of nesting"),
						   state->msgs);
					state->nerrs++;
				}
			}
#line 9514 "parser_bison.c"
    break;

  case 242: /* chain_block: %empty  */
#line 1925 "parser_bison.y"
                                                { (yyval.chain) = (yyvsp[(-1) - (0)].chain); }
#line 9520 "parser_bison.c"
    break;

  case 248: /* chain_block: chain_block rule stmt_separator  */
#line 1932 "parser_bison.y"
                        {
				list_add_tail(&(yyvsp[-1].rule)->list, &(yyvsp[-2].chain)->rules);
				(yyval.chain) = (yyvsp[-2].chain);
			}
#line 9529 "parser_bison.c"
    break;

  case 249: /* chain_block: chain_block comment_spec stmt_separator  */
#line 1937 "parser_bison.y"
                        {
				if (already_set((yyvsp[-2].chain)->comment, &(yylsp[-1]), state)) {
					xfree((yyvsp[-1].string));
					YYERROR;
				}
				(yyvsp[-2].chain)->comment = (yyvsp[-1].string);
			}
#line 9541 "parser_bison.c"
    break;

  case 250: /* subchain_block: %empty  */
#line 1946 "parser_bison.y"
                                                { (yyval.chain) = (yyvsp[(-1) - (0)].chain); }
#line 9547 "parser_bison.c"
    break;

  case 252: /* subchain_block: subchain_block rule stmt_separator  */
#line 1949 "parser_bison.y"
                        {
				list_add_tail(&(yyvsp[-1].rule)->list, &(yyvsp[-2].chain)->rules);
				(yyval.chain) = (yyvsp[-2].chain);
			}
#line 9556 "parser_bison.c"
    break;

  case 253: /* typeof_verdict_expr: selector_expr  */
#line 1956 "parser_bison.y"
                        {
				struct expr *e = (yyvsp[0].expr);

				if (expr_ops(e)->build_udata == NULL) {
					erec_queue(error(&(yylsp[0]), "map data type '%s' lacks typeof serialization", expr_ops(e)->name),
						   state->msgs);
					expr_free(e);
					YYERROR;
				}
				(yyval.expr) = e;
			}
#line 9572 "parser_bison.c"
    break;

  case 254: /* typeof_verdict_expr: typeof_expr "." selector_expr  */
#line 1968 "parser_bison.y"
                        {
				struct location rhs[] = {
					[1]	= (yylsp[-1]),
					[2]	= (yylsp[0]),
				};

				(yyval.expr) = handle_concat_expr(&(yyloc), (yyval.expr), (yyvsp[-2].expr), (yyvsp[0].expr), rhs);
			}
#line 9585 "parser_bison.c"
    break;

  case 255: /* typeof_data_expr: "interval" typeof_expr  */
#line 1979 "parser_bison.y"
                        {
				(yyvsp[0].expr)->flags |= EXPR_F_INTERVAL;
				(yyval.expr) = (yyvsp[0].expr);
			}
#line 9594 "parser_bison.c"
    break;

  case 256: /* typeof_data_expr: typeof_verdict_expr  */
#line 1984 "parser_bison.y"
                        {
				(yyval.expr) = (yyvsp[0].expr);
			}
#line 9602 "parser_bison.c"
    break;

  case 257: /* typeof_data_expr: "queue"  */
#line 1988 "parser_bison.y"
                        {
				(yyval.expr) = constant_expr_alloc(&(yyloc), &queue_type, BYTEORDER_HOST_ENDIAN, 16, NULL);
			}
#line 9610 "parser_bison.c"
    break;

  case 258: /* typeof_data_expr: "string"  */
#line 1992 "parser_bison.y"
                        {
				struct expr *verdict;

				if (strcmp("verdict", (yyvsp[0].string)) != 0) {
					erec_queue(error(&(yylsp[0]), "map data type '%s' lacks typeof serialization", (yyvsp[0].string)),
						   state->msgs);
					xfree((yyvsp[0].string));
					YYERROR;
				}
				verdict = verdict_expr_alloc(&(yylsp[0]), NF_ACCEPT, NULL);
				verdict->flags &= ~EXPR_F_CONSTANT;
				(yyval.expr) = verdict;
				xfree((yyvsp[0].string));
			}
#line 9629 "parser_bison.c"
    break;

  case 259: /* primary_typeof_expr: selector_expr  */
#line 2009 "parser_bison.y"
                        {
				if (expr_ops((yyvsp[0].expr))->build_udata == NULL) {
					erec_queue(error(&(yylsp[0]), "primary expression type '%s' lacks typeof serialization", expr_ops((yyvsp[0].expr))->name),
						   state->msgs);
					expr_free((yyvsp[0].expr));
					YYERROR;
				}

				(yyval.expr) = (yyvsp[0].expr);
			}
#line 9644 "parser_bison.c"
    break;

  case 260: /* typeof_expr: primary_typeof_expr  */
#line 2022 "parser_bison.y"
                        {
				(yyval.expr) = (yyvsp[0].expr);
			}
#line 9652 "parser_bison.c"
    break;

  case 261: /* typeof_expr: typeof_expr "." primary_typeof_expr  */
#line 2026 "parser_bison.y"
                        {
				struct location rhs[] = {
					[1]	= (yylsp[-1]),
					[2]	= (yylsp[0]),
				};

				(yyval.expr) = handle_concat_expr(&(yyloc), (yyval.expr), (yyvsp[-2].expr), (yyvsp[0].expr), rhs);
			}
#line 9665 "parser_bison.c"
    break;

  case 262: /* set_block_alloc: %empty  */
#line 2038 "parser_bison.y"
                        {
				(yyval.set) = set_alloc(NULL);
			}
#line 9673 "parser_bison.c"
    break;

  case 263: /* typeof_key_expr: "typeof" typeof_expr  */
#line 2043 "parser_bison.y"
                                                    { (yyval.expr) = (yyvsp[0].expr); }
#line 9679 "parser_bison.c"
    break;

  case 264: /* typeof_key_expr: "type" data_type_expr close_scope_type  */
#line 2044 "parser_bison.y"
                                                                        { (yyval.expr) = (yyvsp[-1].expr); }
#line 9685 "parser_bison.c"
    break;

  case 265: /* set_block: %empty  */
#line 2047 "parser_bison.y"
                                                { (yyval.set) = (yyvsp[(-1) - (0)].set); }
#line 9691 "parser_bison.c"
    break;

  case 268: /* set_block: set_block typeof_key_expr stmt_separator  */
#line 2051 "parser_bison.y"
                        {
				if (already_set((yyvsp[-2].set)->key, &(yylsp[-1]), state)) {
					expr_free((yyvsp[-1].expr));
					YYERROR;
				}

				(yyvsp[-2].set)->key = (yyvsp[-1].expr);
				(yyval.set) = (yyvsp[-2].set);
			}
#line 9705 "parser_bison.c"
    break;

  case 269: /* set_block: set_block "flags" set_flag_list stmt_separator  */
#line 2061 "parser_bison.y"
                        {
				(yyvsp[-3].set)->flags = (yyvsp[-1].val);
				(yyval.set) = (yyvsp[-3].set);
			}
#line 9714 "parser_bison.c"
    break;

  case 270: /* set_block: set_block "timeout" time_spec stmt_separator  */
#line 2066 "parser_bison.y"
                        {
				(yyvsp[-3].set)->timeout = (yyvsp[-1].val);
				(yyval.set) = (yyvsp[-3].set);
			}
#line 9723 "parser_bison.c"
    break;

  case 271: /* set_block: set_block "gc-interval" time_spec stmt_separator  */
#line 2071 "parser_bison.y"
                        {
				(yyvsp[-3].set)->gc_int = (yyvsp[-1].val);
				(yyval.set) = (yyvsp[-3].set);
			}
#line 9732 "parser_bison.c"
    break;

  case 272: /* set_block: set_block stateful_stmt_list stmt_separator  */
#line 2076 "parser_bison.y"
                        {
				list_splice_tail((yyvsp[-1].list), &(yyvsp[-2].set)->stmt_list);
				(yyval.set) = (yyvsp[-2].set);
				free((yyvsp[-1].list));
			}
#line 9742 "parser_bison.c"
    break;

  case 273: /* set_block: set_block "elements" '=' set_block_expr  */
#line 2082 "parser_bison.y"
                        {
				if (already_set((yyvsp[-3].set)->init, &(yylsp[-2]), state)) {
					expr_free((yyvsp[0].expr));
					YYERROR;
				}
				(yyvsp[-3].set)->init = (yyvsp[0].expr);
				(yyval.set) = (yyvsp[-3].set);
			}
#line 9755 "parser_bison.c"
    break;

  case 274: /* set_block: set_block "auto-merge"  */
#line 2091 "parser_bison.y"
                        {
				(yyvsp[-1].set)->automerge = true;
				(yyval.set) = (yyvsp[-1].set);
			}
#line 9764 "parser_bison.c"
    break;

  case 276: /* set_block: set_block comment_spec stmt_separator  */
#line 2097 "parser_bison.y"
                        {
				if (already_set((yyvsp[-2].set)->comment, &(yylsp[-1]), state)) {
					xfree((yyvsp[-1].string));
					YYERROR;
				}
				(yyvsp[-2].set)->comment = (yyvsp[-1].string);
				(yyval.set) = (yyvsp[-2].set);
			}
#line 9777 "parser_bison.c"
    break;

  case 279: /* set_flag_list: set_flag_list "comma" set_flag  */
#line 2112 "parser_bison.y"
                        {
				(yyval.val) = (yyvsp[-2].val) | (yyvsp[0].val);
			}
#line 9785 "parser_bison.c"
    break;

  case 281: /* set_flag: "constant"  */
#line 2118 "parser_bison.y"
                                                { (yyval.val) = NFT_SET_CONSTANT; }
#line 9791 "parser_bison.c"
    break;

  case 282: /* set_flag: "interval"  */
#line 2119 "parser_bison.y"
                                                { (yyval.val) = NFT_SET_INTERVAL; }
#line 9797 "parser_bison.c"
    break;

  case 283: /* set_flag: "timeout"  */
#line 2120 "parser_bison.y"
                                                { (yyval.val) = NFT_SET_TIMEOUT; }
#line 9803 "parser_bison.c"
    break;

  case 284: /* set_flag: "dynamic"  */
#line 2121 "parser_bison.y"
                                                { (yyval.val) = NFT_SET_EVAL; }
#line 9809 "parser_bison.c"
    break;

  case 285: /* map_block_alloc: %empty  */
#line 2125 "parser_bison.y"
                        {
				(yyval.set) = set_alloc(NULL);
			}
#line 9817 "parser_bison.c"
    break;

  case 286: /* ct_obj_type_map: "timeout"  */
#line 2130 "parser_bison.y"
                                                { (yyval.val) = NFT_OBJECT_CT_TIMEOUT; }
#line 9823 "parser_bison.c"
    break;

  case 287: /* ct_obj_type_map: "expectation"  */
#line 2131 "parser_bison.y"
                                                { (yyval.val) = NFT_OBJECT_CT_EXPECT; }
#line 9829 "parser_bison.c"
    break;

  case 288: /* map_block_obj_type: "counter" close_scope_counter  */
#line 2134 "parser_bison.y"
                                                            { (yyval.val) = NFT_OBJECT_COUNTER; }
#line 9835 "parser_bison.c"
    break;

  case 289: /* map_block_obj_type: "quota" close_scope_quota  */
#line 2135 "parser_bison.y"
                                                          { (yyval.val) = NFT_OBJECT_QUOTA; }
#line 9841 "parser_bison.c"
    break;

  case 290: /* map_block_obj_type: "limit" close_scope_limit  */
#line 2136 "parser_bison.y"
                                                          { (yyval.val) = NFT_OBJECT_LIMIT; }
#line 9847 "parser_bison.c"
    break;

  case 291: /* map_block_obj_type: "secmark" close_scope_secmark  */
#line 2137 "parser_bison.y"
                                                            { (yyval.val) = NFT_OBJECT_SECMARK; }
#line 9853 "parser_bison.c"
    break;

  case 292: /* map_block_obj_type: "synproxy" close_scope_synproxy  */
#line 2138 "parser_bison.y"
                                                              { (yyval.val) = NFT_OBJECT_SYNPROXY; }
#line 9859 "parser_bison.c"
    break;

  case 294: /* map_block_obj_typeof: "ct" ct_obj_type_map close_scope_ct  */
#line 2142 "parser_bison.y"
                                                                        { (yyval.val) = (yyvsp[-1].val); }
#line 9865 "parser_bison.c"
    break;

  case 295: /* map_block_data_interval: "interval"  */
#line 2145 "parser_bison.y"
                                         { (yyval.val) = EXPR_F_INTERVAL; }
#line 9871 "parser_bison.c"
    break;

  case 296: /* map_block_data_interval: %empty  */
#line 2146 "parser_bison.y"
                                { (yyval.val) = 0; }
#line 9877 "parser_bison.c"
    break;

  case 297: /* map_block: %empty  */
#line 2149 "parser_bison.y"
                                                { (yyval.set) = (yyvsp[(-1) - (0)].set); }
#line 9883 "parser_bison.c"
    break;

  case 300: /* map_block: map_block "timeout" time_spec stmt_separator  */
#line 2153 "parser_bison.y"
                        {
				(yyvsp[-3].set)->timeout = (yyvsp[-1].val);
				(yyval.set) = (yyvsp[-3].set);
			}
#line 9892 "parser_bison.c"
    break;

  case 301: /* map_block: map_block "gc-interval" time_spec stmt_separator  */
#line 2158 "parser_bison.y"
                        {
				(yyvsp[-3].set)->gc_int = (yyvsp[-1].val);
				(yyval.set) = (yyvsp[-3].set);
			}
#line 9901 "parser_bison.c"
    break;

  case 302: /* map_block: map_block "type" data_type_expr "colon" map_block_data_interval data_type_expr stmt_separator close_scope_type  */
#line 2165 "parser_bison.y"
                        {
				if (already_set((yyvsp[-7].set)->key, &(yylsp[-6]), state)) {
					expr_free((yyvsp[-5].expr));
					expr_free((yyvsp[-2].expr));
					YYERROR;
				}

				(yyvsp[-7].set)->key = (yyvsp[-5].expr);
				(yyvsp[-7].set)->data = (yyvsp[-2].expr);
				(yyvsp[-7].set)->data->flags |= (yyvsp[-3].val);

				(yyvsp[-7].set)->flags |= NFT_SET_MAP;
				(yyval.set) = (yyvsp[-7].set);
			}
#line 9920 "parser_bison.c"
    break;

  case 303: /* map_block: map_block "typeof" typeof_expr "colon" typeof_data_expr stmt_separator  */
#line 2182 "parser_bison.y"
                        {
				if (already_set((yyvsp[-5].set)->key, &(yylsp[-4]), state)) {
					expr_free((yyvsp[-3].expr));
					expr_free((yyvsp[-1].expr));
					YYERROR;
				}

				(yyvsp[-5].set)->key = (yyvsp[-3].expr);

				if ((yyvsp[-1].expr)->etype == EXPR_CT && (yyvsp[-1].expr)->ct.key == NFT_CT_HELPER) {
					(yyvsp[-5].set)->objtype = NFT_OBJECT_CT_HELPER;
					(yyvsp[-5].set)->flags  |= NFT_SET_OBJECT;
					expr_free((yyvsp[-1].expr));
				} else {
					(yyvsp[-5].set)->data = (yyvsp[-1].expr);
					(yyvsp[-5].set)->flags |= NFT_SET_MAP;
				}

				(yyval.set) = (yyvsp[-5].set);
			}
#line 9945 "parser_bison.c"
    break;

  case 304: /* map_block: map_block "type" data_type_expr "colon" map_block_obj_type stmt_separator close_scope_type  */
#line 2205 "parser_bison.y"
                        {
				if (already_set((yyvsp[-6].set)->key, &(yylsp[-5]), state)) {
					expr_free((yyvsp[-4].expr));
					YYERROR;
				}

				(yyvsp[-6].set)->key = (yyvsp[-4].expr);
				(yyvsp[-6].set)->objtype = (yyvsp[-2].val);
				(yyvsp[-6].set)->flags  |= NFT_SET_OBJECT;
				(yyval.set) = (yyvsp[-6].set);
			}
#line 9961 "parser_bison.c"
    break;

  case 305: /* map_block: map_block "typeof" typeof_expr "colon" map_block_obj_typeof stmt_separator  */
#line 2219 "parser_bison.y"
                        {
				(yyvsp[-5].set)->key = (yyvsp[-3].expr);
				(yyvsp[-5].set)->objtype = (yyvsp[-1].val);
				(yyvsp[-5].set)->flags  |= NFT_SET_OBJECT;
				(yyval.set) = (yyvsp[-5].set);
			}
#line 9972 "parser_bison.c"
    break;

  case 306: /* map_block: map_block "flags" set_flag_list stmt_separator  */
#line 2226 "parser_bison.y"
                        {
				(yyvsp[-3].set)->flags |= (yyvsp[-1].val);
				(yyval.set) = (yyvsp[-3].set);
			}
#line 9981 "parser_bison.c"
    break;

  case 307: /* map_block: map_block stateful_stmt_list stmt_separator  */
#line 2231 "parser_bison.y"
                        {
				list_splice_tail((yyvsp[-1].list), &(yyvsp[-2].set)->stmt_list);
				(yyval.set) = (yyvsp[-2].set);
				free((yyvsp[-1].list));
			}
#line 9991 "parser_bison.c"
    break;

  case 308: /* map_block: map_block "elements" '=' set_block_expr  */
#line 2237 "parser_bison.y"
                        {
				(yyvsp[-3].set)->init = (yyvsp[0].expr);
				(yyval.set) = (yyvsp[-3].set);
			}
#line 10000 "parser_bison.c"
    break;

  case 309: /* map_block: map_block comment_spec stmt_separator  */
#line 2242 "parser_bison.y"
                        {
				if (already_set((yyvsp[-2].set)->comment, &(yylsp[-1]), state)) {
					xfree((yyvsp[-1].string));
					YYERROR;
				}
				(yyvsp[-2].set)->comment = (yyvsp[-1].string);
				(yyval.set) = (yyvsp[-2].set);
			}
#line 10013 "parser_bison.c"
    break;

  case 311: /* set_mechanism: "policy" set_policy_spec close_scope_policy  */
#line 2254 "parser_bison.y"
                        {
				(yyvsp[-3].set)->policy = (yyvsp[-1].val);
			}
#line 10021 "parser_bison.c"
    break;

  case 312: /* set_mechanism: "size" "number"  */
#line 2258 "parser_bison.y"
                        {
				(yyvsp[-2].set)->desc.size = (yyvsp[0].val);
			}
#line 10029 "parser_bison.c"
    break;

  case 313: /* set_policy_spec: "performance"  */
#line 2263 "parser_bison.y"
                                                { (yyval.val) = NFT_SET_POL_PERFORMANCE; }
#line 10035 "parser_bison.c"
    break;

  case 314: /* set_policy_spec: "memory"  */
#line 2264 "parser_bison.y"
                                                { (yyval.val) = NFT_SET_POL_MEMORY; }
#line 10041 "parser_bison.c"
    break;

  case 315: /* flowtable_block_alloc: %empty  */
#line 2268 "parser_bison.y"
                        {
				(yyval.flowtable) = flowtable_alloc(NULL);
			}
#line 10049 "parser_bison.c"
    break;

  case 316: /* flowtable_block: %empty  */
#line 2273 "parser_bison.y"
                                                { (yyval.flowtable) = (yyvsp[(-1) - (0)].flowtable); }
#line 10055 "parser_bison.c"
    break;

  case 319: /* flowtable_block: flowtable_block "hook" "string" prio_spec stmt_separator  */
#line 2277 "parser_bison.y"
                        {
				(yyval.flowtable)->hook.loc = (yylsp[-2]);
				(yyval.flowtable)->hook.name = chain_hookname_lookup((yyvsp[-2].string));
				if ((yyval.flowtable)->hook.name == NULL) {
					erec_queue(error(&(yylsp[-2]), "unknown chain hook"),
						   state->msgs);
					xfree((yyvsp[-2].string));
					expr_free((yyvsp[-1].prio_spec).expr);
					YYERROR;
				}
				xfree((yyvsp[-2].string));

				(yyval.flowtable)->priority = (yyvsp[-1].prio_spec);
			}
#line 10074 "parser_bison.c"
    break;

  case 320: /* flowtable_block: flowtable_block "devices" '=' flowtable_expr stmt_separator  */
#line 2292 "parser_bison.y"
                        {
				(yyval.flowtable)->dev_expr = (yyvsp[-1].expr);
			}
#line 10082 "parser_bison.c"
    break;

  case 321: /* flowtable_block: flowtable_block "counter" close_scope_counter  */
#line 2296 "parser_bison.y"
                        {
				(yyval.flowtable)->flags |= NFT_FLOWTABLE_COUNTER;
			}
#line 10090 "parser_bison.c"
    break;

  case 322: /* flowtable_block: flowtable_block "flags" "offload" stmt_separator  */
#line 2300 "parser_bison.y"
                        {
				(yyval.flowtable)->flags |= FLOWTABLE_F_HW_OFFLOAD;
			}
#line 10098 "parser_bison.c"
    break;

  case 323: /* flowtable_expr: '{' flowtable_list_expr '}'  */
#line 2306 "parser_bison.y"
                        {
				(yyvsp[-1].expr)->location = (yyloc);
				(yyval.expr) = (yyvsp[-1].expr);
			}
#line 10107 "parser_bison.c"
    break;

  case 324: /* flowtable_expr: variable_expr  */
#line 2311 "parser_bison.y"
                        {
				(yyvsp[0].expr)->location = (yyloc);
				(yyval.expr) = (yyvsp[0].expr);
			}
#line 10116 "parser_bison.c"
    break;

  case 325: /* flowtable_list_expr: flowtable_expr_member  */
#line 2318 "parser_bison.y"
                        {
				(yyval.expr) = compound_expr_alloc(&(yyloc), EXPR_LIST);
				compound_expr_add((yyval.expr), (yyvsp[0].expr));
			}
#line 10125 "parser_bison.c"
    break;

  case 326: /* flowtable_list_expr: flowtable_list_expr "comma" flowtable_expr_member  */
#line 2323 "parser_bison.y"
                        {
				compound_expr_add((yyvsp[-2].expr), (yyvsp[0].expr));
				(yyval.expr) = (yyvsp[-2].expr);
			}
#line 10134 "parser_bison.c"
    break;

  case 328: /* flowtable_expr_member: "quoted string"  */
#line 2331 "parser_bison.y"
                        {
				struct expr *expr = ifname_expr_alloc(&(yyloc), state->msgs, (yyvsp[0].string));

				if (!expr)
					YYERROR;

				(yyval.expr) = expr;
			}
#line 10147 "parser_bison.c"
    break;

  case 329: /* flowtable_expr_member: "string"  */
#line 2340 "parser_bison.y"
                        {
				struct expr *expr = ifname_expr_alloc(&(yyloc), state->msgs, (yyvsp[0].string));

				if (!expr)
					YYERROR;

				(yyval.expr) = expr;
			}
#line 10160 "parser_bison.c"
    break;

  case 330: /* flowtable_expr_member: variable_expr  */
#line 2349 "parser_bison.y"
                        {
				datatype_set((yyvsp[0].expr)->sym->expr, &ifname_type);
				(yyval.expr) = (yyvsp[0].expr);
			}
#line 10169 "parser_bison.c"
    break;

  case 331: /* data_type_atom_expr: type_identifier  */
#line 2356 "parser_bison.y"
                        {
				const struct datatype *dtype = datatype_lookup_byname((yyvsp[0].string));
				if (dtype == NULL) {
					erec_queue(error(&(yylsp[0]), "unknown datatype %s", (yyvsp[0].string)),
						   state->msgs);
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyval.expr) = constant_expr_alloc(&(yylsp[0]), dtype, dtype->byteorder,
							 dtype->size, NULL);
				xfree((yyvsp[0].string));
			}
#line 10186 "parser_bison.c"
    break;

  case 332: /* data_type_atom_expr: "time"  */
#line 2369 "parser_bison.y"
                        {
				(yyval.expr) = constant_expr_alloc(&(yylsp[0]), &time_type, time_type.byteorder,
							 time_type.size, NULL);
			}
#line 10195 "parser_bison.c"
    break;

  case 334: /* data_type_expr: data_type_expr "." data_type_atom_expr  */
#line 2377 "parser_bison.y"
                        {
				struct location rhs[] = {
					[1]	= (yylsp[-1]),
					[2]	= (yylsp[0]),
				};

				(yyval.expr) = handle_concat_expr(&(yyloc), (yyval.expr), (yyvsp[-2].expr), (yyvsp[0].expr), rhs);
			}
#line 10208 "parser_bison.c"
    break;

  case 335: /* obj_block_alloc: %empty  */
#line 2388 "parser_bison.y"
                        {
				(yyval.obj) = obj_alloc(NULL);
			}
#line 10216 "parser_bison.c"
    break;

  case 336: /* counter_block: %empty  */
#line 2393 "parser_bison.y"
                                                { (yyval.obj) = (yyvsp[(-1) - (0)].obj); }
#line 10222 "parser_bison.c"
    break;

  case 339: /* counter_block: counter_block counter_config  */
#line 2397 "parser_bison.y"
                        {
				(yyval.obj) = (yyvsp[-1].obj);
			}
#line 10230 "parser_bison.c"
    break;

  case 340: /* counter_block: counter_block comment_spec  */
#line 2401 "parser_bison.y"
                        {
				if (already_set((yyvsp[-1].obj)->comment, &(yylsp[0]), state)) {
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyvsp[-1].obj)->comment = (yyvsp[0].string);
			}
#line 10242 "parser_bison.c"
    break;

  case 341: /* quota_block: %empty  */
#line 2410 "parser_bison.y"
                                                { (yyval.obj) = (yyvsp[(-1) - (0)].obj); }
#line 10248 "parser_bison.c"
    break;

  case 344: /* quota_block: quota_block quota_config  */
#line 2414 "parser_bison.y"
                        {
				(yyval.obj) = (yyvsp[-1].obj);
			}
#line 10256 "parser_bison.c"
    break;

  case 345: /* quota_block: quota_block comment_spec  */
#line 2418 "parser_bison.y"
                        {
				if (already_set((yyvsp[-1].obj)->comment, &(yylsp[0]), state)) {
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyvsp[-1].obj)->comment = (yyvsp[0].string);
			}
#line 10268 "parser_bison.c"
    break;

  case 346: /* ct_helper_block: %empty  */
#line 2427 "parser_bison.y"
                                                { (yyval.obj) = (yyvsp[(-1) - (0)].obj); }
#line 10274 "parser_bison.c"
    break;

  case 349: /* ct_helper_block: ct_helper_block ct_helper_config  */
#line 2431 "parser_bison.y"
                        {
				(yyval.obj) = (yyvsp[-1].obj);
			}
#line 10282 "parser_bison.c"
    break;

  case 350: /* ct_helper_block: ct_helper_block comment_spec  */
#line 2435 "parser_bison.y"
                        {
				if (already_set((yyvsp[-1].obj)->comment, &(yylsp[0]), state)) {
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyvsp[-1].obj)->comment = (yyvsp[0].string);
			}
#line 10294 "parser_bison.c"
    break;

  case 351: /* ct_timeout_block: %empty  */
#line 2445 "parser_bison.y"
                        {
				(yyval.obj) = (yyvsp[(-1) - (0)].obj);
				init_list_head(&(yyval.obj)->ct_timeout.timeout_list);
				(yyval.obj)->type = NFT_OBJECT_CT_TIMEOUT;
			}
#line 10304 "parser_bison.c"
    break;

  case 354: /* ct_timeout_block: ct_timeout_block ct_timeout_config  */
#line 2453 "parser_bison.y"
                        {
				(yyval.obj) = (yyvsp[-1].obj);
			}
#line 10312 "parser_bison.c"
    break;

  case 355: /* ct_timeout_block: ct_timeout_block comment_spec  */
#line 2457 "parser_bison.y"
                        {
				if (already_set((yyvsp[-1].obj)->comment, &(yylsp[0]), state)) {
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyvsp[-1].obj)->comment = (yyvsp[0].string);
			}
#line 10324 "parser_bison.c"
    break;

  case 356: /* ct_expect_block: %empty  */
#line 2466 "parser_bison.y"
                                                { (yyval.obj) = (yyvsp[(-1) - (0)].obj); }
#line 10330 "parser_bison.c"
    break;

  case 359: /* ct_expect_block: ct_expect_block ct_expect_config  */
#line 2470 "parser_bison.y"
                        {
				(yyval.obj) = (yyvsp[-1].obj);
			}
#line 10338 "parser_bison.c"
    break;

  case 360: /* ct_expect_block: ct_expect_block comment_spec  */
#line 2474 "parser_bison.y"
                        {
				if (already_set((yyvsp[-1].obj)->comment, &(yylsp[0]), state)) {
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyvsp[-1].obj)->comment = (yyvsp[0].string);
			}
#line 10350 "parser_bison.c"
    break;

  case 361: /* limit_block: %empty  */
#line 2483 "parser_bison.y"
                                                { (yyval.obj) = (yyvsp[(-1) - (0)].obj); }
#line 10356 "parser_bison.c"
    break;

  case 364: /* limit_block: limit_block limit_config  */
#line 2487 "parser_bison.y"
                        {
				(yyval.obj) = (yyvsp[-1].obj);
			}
#line 10364 "parser_bison.c"
    break;

  case 365: /* limit_block: limit_block comment_spec  */
#line 2491 "parser_bison.y"
                        {
				if (already_set((yyvsp[-1].obj)->comment, &(yylsp[0]), state)) {
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyvsp[-1].obj)->comment = (yyvsp[0].string);
			}
#line 10376 "parser_bison.c"
    break;

  case 366: /* secmark_block: %empty  */
#line 2500 "parser_bison.y"
                                                { (yyval.obj) = (yyvsp[(-1) - (0)].obj); }
#line 10382 "parser_bison.c"
    break;

  case 369: /* secmark_block: secmark_block secmark_config  */
#line 2504 "parser_bison.y"
                        {
				(yyval.obj) = (yyvsp[-1].obj);
			}
#line 10390 "parser_bison.c"
    break;

  case 370: /* secmark_block: secmark_block comment_spec  */
#line 2508 "parser_bison.y"
                        {
				if (already_set((yyvsp[-1].obj)->comment, &(yylsp[0]), state)) {
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyvsp[-1].obj)->comment = (yyvsp[0].string);
			}
#line 10402 "parser_bison.c"
    break;

  case 371: /* synproxy_block: %empty  */
#line 2517 "parser_bison.y"
                                                { (yyval.obj) = (yyvsp[(-1) - (0)].obj); }
#line 10408 "parser_bison.c"
    break;

  case 374: /* synproxy_block: synproxy_block synproxy_config  */
#line 2521 "parser_bison.y"
                        {
				(yyval.obj) = (yyvsp[-1].obj);
			}
#line 10416 "parser_bison.c"
    break;

  case 375: /* synproxy_block: synproxy_block comment_spec  */
#line 2525 "parser_bison.y"
                        {
				if (already_set((yyvsp[-1].obj)->comment, &(yylsp[0]), state)) {
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyvsp[-1].obj)->comment = (yyvsp[0].string);
			}
#line 10428 "parser_bison.c"
    break;

  case 376: /* type_identifier: "string"  */
#line 2534 "parser_bison.y"
                                        { (yyval.string) = (yyvsp[0].string); }
#line 10434 "parser_bison.c"
    break;

  case 377: /* type_identifier: "mark"  */
#line 2535 "parser_bison.y"
                                        { (yyval.string) = xstrdup("mark"); }
#line 10440 "parser_bison.c"
    break;

  case 378: /* type_identifier: "dscp"  */
#line 2536 "parser_bison.y"
                                        { (yyval.string) = xstrdup("dscp"); }
#line 10446 "parser_bison.c"
    break;

  case 379: /* type_identifier: "ecn"  */
#line 2537 "parser_bison.y"
                                        { (yyval.string) = xstrdup("ecn"); }
#line 10452 "parser_bison.c"
    break;

  case 380: /* type_identifier: "classid"  */
#line 2538 "parser_bison.y"
                                        { (yyval.string) = xstrdup("classid"); }
#line 10458 "parser_bison.c"
    break;

  case 381: /* hook_spec: "type" close_scope_type "string" "hook" "string" dev_spec prio_spec  */
#line 2542 "parser_bison.y"
                        {
				const char *chain_type = chain_type_name_lookup((yyvsp[-4].string));

				if (chain_type == NULL) {
					erec_queue(error(&(yylsp[-4]), "unknown chain type"),
						   state->msgs);
					xfree((yyvsp[-4].string));
					xfree((yyvsp[-2].string));
					expr_free((yyvsp[-1].expr));
					expr_free((yyvsp[0].prio_spec).expr);
					YYERROR;
				}
				(yyvsp[-7].chain)->type.loc = (yylsp[-4]);
				(yyvsp[-7].chain)->type.str = xstrdup(chain_type);
				xfree((yyvsp[-4].string));

				(yyvsp[-7].chain)->loc = (yyloc);
				(yyvsp[-7].chain)->hook.loc = (yylsp[-2]);
				(yyvsp[-7].chain)->hook.name = chain_hookname_lookup((yyvsp[-2].string));
				if ((yyvsp[-7].chain)->hook.name == NULL) {
					erec_queue(error(&(yylsp[-2]), "unknown chain hook"),
						   state->msgs);
					xfree((yyvsp[-2].string));
					expr_free((yyvsp[-1].expr));
					expr_free((yyvsp[0].prio_spec).expr);
					YYERROR;
				}
				xfree((yyvsp[-2].string));

				(yyvsp[-7].chain)->dev_expr	= (yyvsp[-1].expr);
				(yyvsp[-7].chain)->priority	= (yyvsp[0].prio_spec);
				(yyvsp[-7].chain)->flags	|= CHAIN_F_BASECHAIN;
			}
#line 10496 "parser_bison.c"
    break;

  case 382: /* prio_spec: "priority" extended_prio_spec  */
#line 2578 "parser_bison.y"
                        {
				(yyval.prio_spec) = (yyvsp[0].prio_spec);
				(yyval.prio_spec).loc = (yyloc);
			}
#line 10505 "parser_bison.c"
    break;

  case 383: /* extended_prio_name: "out"  */
#line 2585 "parser_bison.y"
                        {
				(yyval.string) = strdup("out");
			}
#line 10513 "parser_bison.c"
    break;

  case 385: /* extended_prio_spec: int_num  */
#line 2592 "parser_bison.y"
                        {
				struct prio_spec spec = {0};

				spec.expr = constant_expr_alloc(&(yyloc), &integer_type,
								BYTEORDER_HOST_ENDIAN,
								sizeof(int) *
								BITS_PER_BYTE, &(yyvsp[0].val32));
				(yyval.prio_spec) = spec;
			}
#line 10527 "parser_bison.c"
    break;

  case 386: /* extended_prio_spec: variable_expr  */
#line 2602 "parser_bison.y"
                        {
				struct prio_spec spec = {0};

				spec.expr = (yyvsp[0].expr);
				(yyval.prio_spec) = spec;
			}
#line 10538 "parser_bison.c"
    break;

  case 387: /* extended_prio_spec: extended_prio_name  */
#line 2609 "parser_bison.y"
                        {
				struct prio_spec spec = {0};

				spec.expr = constant_expr_alloc(&(yyloc), &string_type,
								BYTEORDER_HOST_ENDIAN,
								strlen((yyvsp[0].string)) * BITS_PER_BYTE,
								(yyvsp[0].string));
				xfree((yyvsp[0].string));
				(yyval.prio_spec) = spec;
			}
#line 10553 "parser_bison.c"
    break;

  case 388: /* extended_prio_spec: extended_prio_name "+" "number"  */
#line 2620 "parser_bison.y"
                        {
				struct prio_spec spec = {0};

				char str[NFT_NAME_MAXLEN];
				snprintf(str, sizeof(str), "%s + %" PRIu64, (yyvsp[-2].string), (yyvsp[0].val));
				spec.expr = constant_expr_alloc(&(yyloc), &string_type,
								BYTEORDER_HOST_ENDIAN,
								strlen(str) * BITS_PER_BYTE,
								str);
				xfree((yyvsp[-2].string));
				(yyval.prio_spec) = spec;
			}
#line 10570 "parser_bison.c"
    break;

  case 389: /* extended_prio_spec: extended_prio_name "-" "number"  */
#line 2633 "parser_bison.y"
                        {
				struct prio_spec spec = {0};
				char str[NFT_NAME_MAXLEN];

				snprintf(str, sizeof(str), "%s - %" PRIu64, (yyvsp[-2].string), (yyvsp[0].val));
				spec.expr = constant_expr_alloc(&(yyloc), &string_type,
								BYTEORDER_HOST_ENDIAN,
								strlen(str) * BITS_PER_BYTE,
								str);
				xfree((yyvsp[-2].string));
				(yyval.prio_spec) = spec;
			}
#line 10587 "parser_bison.c"
    break;

  case 390: /* int_num: "number"  */
#line 2647 "parser_bison.y"
                                                        { (yyval.val32) = (yyvsp[0].val); }
#line 10593 "parser_bison.c"
    break;

  case 391: /* int_num: "-" "number"  */
#line 2648 "parser_bison.y"
                                                        { (yyval.val32) = -(yyvsp[0].val); }
#line 10599 "parser_bison.c"
    break;

  case 392: /* dev_spec: "device" string  */
#line 2652 "parser_bison.y"
                        {
				struct expr *expr = ifname_expr_alloc(&(yyloc), state->msgs, (yyvsp[0].string));

				if (!expr)
					YYERROR;

				(yyval.expr) = compound_expr_alloc(&(yyloc), EXPR_LIST);
				compound_expr_add((yyval.expr), expr);

			}
#line 10614 "parser_bison.c"
    break;

  case 393: /* dev_spec: "device" variable_expr  */
#line 2663 "parser_bison.y"
                        {
				datatype_set((yyvsp[0].expr)->sym->expr, &ifname_type);
				(yyval.expr) = compound_expr_alloc(&(yyloc), EXPR_LIST);
				compound_expr_add((yyval.expr), (yyvsp[0].expr));
			}
#line 10624 "parser_bison.c"
    break;

  case 394: /* dev_spec: "devices" '=' flowtable_expr  */
#line 2669 "parser_bison.y"
                        {
				(yyval.expr) = (yyvsp[0].expr);
			}
#line 10632 "parser_bison.c"
    break;

  case 395: /* dev_spec: %empty  */
#line 2672 "parser_bison.y"
                                                        { (yyval.expr) = NULL; }
#line 10638 "parser_bison.c"
    break;

  case 396: /* flags_spec: "flags" "offload"  */
#line 2676 "parser_bison.y"
                        {
				(yyvsp[-2].chain)->flags |= CHAIN_F_HW_OFFLOAD;
			}
#line 10646 "parser_bison.c"
    break;

  case 397: /* policy_spec: "policy" policy_expr close_scope_policy  */
#line 2682 "parser_bison.y"
                        {
				if ((yyvsp[-3].chain)->policy) {
					erec_queue(error(&(yyloc), "you cannot set chain policy twice"),
						   state->msgs);
					expr_free((yyvsp[-1].expr));
					YYERROR;
				}
				(yyvsp[-3].chain)->policy		= (yyvsp[-1].expr);
				(yyvsp[-3].chain)->policy->location	= (yyloc);
			}
#line 10661 "parser_bison.c"
    break;

  case 398: /* policy_expr: variable_expr  */
#line 2695 "parser_bison.y"
                        {
				datatype_set((yyvsp[0].expr)->sym->expr, &policy_type);
				(yyval.expr) = (yyvsp[0].expr);
			}
#line 10670 "parser_bison.c"
    break;

  case 399: /* policy_expr: chain_policy  */
#line 2700 "parser_bison.y"
                        {
				(yyval.expr) = constant_expr_alloc(&(yyloc), &integer_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(int) *
							 BITS_PER_BYTE, &(yyvsp[0].val32));
			}
#line 10681 "parser_bison.c"
    break;

  case 400: /* chain_policy: "accept"  */
#line 2708 "parser_bison.y"
                                                { (yyval.val32) = NF_ACCEPT; }
#line 10687 "parser_bison.c"
    break;

  case 401: /* chain_policy: "drop"  */
#line 2709 "parser_bison.y"
                                                { (yyval.val32) = NF_DROP;   }
#line 10693 "parser_bison.c"
    break;

  case 406: /* time_spec: "string"  */
#line 2721 "parser_bison.y"
                        {
				struct error_record *erec;
				uint64_t res;

				erec = time_parse(&(yylsp[0]), (yyvsp[0].string), &res);
				xfree((yyvsp[0].string));
				if (erec != NULL) {
					erec_queue(erec, state->msgs);
					YYERROR;
				}
				(yyval.val) = res;
			}
#line 10710 "parser_bison.c"
    break;

  case 408: /* time_spec_or_num_s: time_spec  */
#line 2737 "parser_bison.y"
                                          { (yyval.val) = (yyvsp[0].val) / 1000u; }
#line 10716 "parser_bison.c"
    break;

  case 409: /* family_spec: %empty  */
#line 2740 "parser_bison.y"
                                                        { (yyval.val) = NFPROTO_IPV4; }
#line 10722 "parser_bison.c"
    break;

  case 411: /* family_spec_explicit: "ip" close_scope_ip  */
#line 2744 "parser_bison.y"
                                                        { (yyval.val) = NFPROTO_IPV4; }
#line 10728 "parser_bison.c"
    break;

  case 412: /* family_spec_explicit: "ip6" close_scope_ip6  */
#line 2745 "parser_bison.y"
                                                        { (yyval.val) = NFPROTO_IPV6; }
#line 10734 "parser_bison.c"
    break;

  case 413: /* family_spec_explicit: "inet"  */
#line 2746 "parser_bison.y"
                                                        { (yyval.val) = NFPROTO_INET; }
#line 10740 "parser_bison.c"
    break;

  case 414: /* family_spec_explicit: "arp" close_scope_arp  */
#line 2747 "parser_bison.y"
                                                        { (yyval.val) = NFPROTO_ARP; }
#line 10746 "parser_bison.c"
    break;

  case 415: /* family_spec_explicit: "bridge"  */
#line 2748 "parser_bison.y"
                                                        { (yyval.val) = NFPROTO_BRIDGE; }
#line 10752 "parser_bison.c"
    break;

  case 416: /* family_spec_explicit: "netdev"  */
#line 2749 "parser_bison.y"
                                                        { (yyval.val) = NFPROTO_NETDEV; }
#line 10758 "parser_bison.c"
    break;

  case 417: /* table_spec: family_spec identifier  */
#line 2753 "parser_bison.y"
                        {
				memset(&(yyval.handle), 0, sizeof((yyval.handle)));
				(yyval.handle).family	= (yyvsp[-1].val);
				(yyval.handle).table.location = (yylsp[0]);
				(yyval.handle).table.name	= (yyvsp[0].string);
			}
#line 10769 "parser_bison.c"
    break;

  case 418: /* tableid_spec: family_spec "handle" "number"  */
#line 2762 "parser_bison.y"
                        {
				memset(&(yyval.handle), 0, sizeof((yyval.handle)));
				(yyval.handle).family 		= (yyvsp[-2].val);
				(yyval.handle).handle.id 		= (yyvsp[0].val);
				(yyval.handle).handle.location	= (yylsp[0]);
			}
#line 10780 "parser_bison.c"
    break;

  case 419: /* chain_spec: table_spec identifier  */
#line 2771 "parser_bison.y"
                        {
				(yyval.handle)		= (yyvsp[-1].handle);
				(yyval.handle).chain.name	= (yyvsp[0].string);
				(yyval.handle).chain.location = (yylsp[0]);
			}
#line 10790 "parser_bison.c"
    break;

  case 420: /* chainid_spec: table_spec "handle" "number"  */
#line 2779 "parser_bison.y"
                        {
				(yyval.handle) 			= (yyvsp[-2].handle);
				(yyval.handle).handle.location 	= (yylsp[0]);
				(yyval.handle).handle.id 		= (yyvsp[0].val);
			}
#line 10800 "parser_bison.c"
    break;

  case 421: /* chain_identifier: identifier  */
#line 2787 "parser_bison.y"
                        {
				memset(&(yyval.handle), 0, sizeof((yyval.handle)));
				(yyval.handle).chain.name		= (yyvsp[0].string);
				(yyval.handle).chain.location	= (yylsp[0]);
			}
#line 10810 "parser_bison.c"
    break;

  case 422: /* set_spec: table_spec identifier  */
#line 2795 "parser_bison.y"
                        {
				(yyval.handle)		= (yyvsp[-1].handle);
				(yyval.handle).set.name	= (yyvsp[0].string);
				(yyval.handle).set.location	= (yylsp[0]);
			}
#line 10820 "parser_bison.c"
    break;

  case 423: /* setid_spec: table_spec "handle" "number"  */
#line 2803 "parser_bison.y"
                        {
				(yyval.handle) 			= (yyvsp[-2].handle);
				(yyval.handle).handle.location 	= (yylsp[0]);
				(yyval.handle).handle.id 		= (yyvsp[0].val);
			}
#line 10830 "parser_bison.c"
    break;

  case 424: /* set_identifier: identifier  */
#line 2811 "parser_bison.y"
                        {
				memset(&(yyval.handle), 0, sizeof((yyval.handle)));
				(yyval.handle).set.name	= (yyvsp[0].string);
				(yyval.handle).set.location	= (yylsp[0]);
			}
#line 10840 "parser_bison.c"
    break;

  case 425: /* flowtable_spec: table_spec identifier  */
#line 2819 "parser_bison.y"
                        {
				(yyval.handle)			= (yyvsp[-1].handle);
				(yyval.handle).flowtable.name	= (yyvsp[0].string);
				(yyval.handle).flowtable.location	= (yylsp[0]);
			}
#line 10850 "parser_bison.c"
    break;

  case 426: /* flowtableid_spec: table_spec "handle" "number"  */
#line 2827 "parser_bison.y"
                        {
				(yyval.handle)			= (yyvsp[-2].handle);
				(yyval.handle).handle.location	= (yylsp[0]);
				(yyval.handle).handle.id		= (yyvsp[0].val);
			}
#line 10860 "parser_bison.c"
    break;

  case 427: /* flowtable_identifier: identifier  */
#line 2835 "parser_bison.y"
                        {
				memset(&(yyval.handle), 0, sizeof((yyval.handle)));
				(yyval.handle).flowtable.name	= (yyvsp[0].string);
				(yyval.handle).flowtable.location	= (yylsp[0]);
			}
#line 10870 "parser_bison.c"
    break;

  case 428: /* obj_spec: table_spec identifier  */
#line 2843 "parser_bison.y"
                        {
				(yyval.handle)		= (yyvsp[-1].handle);
				(yyval.handle).obj.name	= (yyvsp[0].string);
				(yyval.handle).obj.location	= (yylsp[0]);
			}
#line 10880 "parser_bison.c"
    break;

  case 429: /* objid_spec: table_spec "handle" "number"  */
#line 2851 "parser_bison.y"
                        {
				(yyval.handle) 			= (yyvsp[-2].handle);
				(yyval.handle).handle.location	= (yylsp[0]);
				(yyval.handle).handle.id		= (yyvsp[0].val);
			}
#line 10890 "parser_bison.c"
    break;

  case 430: /* obj_identifier: identifier  */
#line 2859 "parser_bison.y"
                        {
				memset(&(yyval.handle), 0, sizeof((yyval.handle)));
				(yyval.handle).obj.name		= (yyvsp[0].string);
				(yyval.handle).obj.location		= (yylsp[0]);
			}
#line 10900 "parser_bison.c"
    break;

  case 431: /* handle_spec: "handle" "number"  */
#line 2867 "parser_bison.y"
                        {
				memset(&(yyval.handle), 0, sizeof((yyval.handle)));
				(yyval.handle).handle.location	= (yylsp[0]);
				(yyval.handle).handle.id		= (yyvsp[0].val);
			}
#line 10910 "parser_bison.c"
    break;

  case 432: /* position_spec: "position" "number"  */
#line 2875 "parser_bison.y"
                        {
				memset(&(yyval.handle), 0, sizeof((yyval.handle)));
				(yyval.handle).position.location	= (yyloc);
				(yyval.handle).position.id		= (yyvsp[0].val);
			}
#line 10920 "parser_bison.c"
    break;

  case 433: /* index_spec: "index" "number"  */
#line 2883 "parser_bison.y"
                        {
				memset(&(yyval.handle), 0, sizeof((yyval.handle)));
				(yyval.handle).index.location	= (yyloc);
				(yyval.handle).index.id		= (yyvsp[0].val) + 1;
			}
#line 10930 "parser_bison.c"
    break;

  case 434: /* rule_position: chain_spec  */
#line 2891 "parser_bison.y"
                        {
				(yyval.handle) = (yyvsp[0].handle);
			}
#line 10938 "parser_bison.c"
    break;

  case 435: /* rule_position: chain_spec position_spec  */
#line 2895 "parser_bison.y"
                        {
				handle_merge(&(yyvsp[-1].handle), &(yyvsp[0].handle));
				(yyval.handle) = (yyvsp[-1].handle);
			}
#line 10947 "parser_bison.c"
    break;

  case 436: /* rule_position: chain_spec handle_spec  */
#line 2900 "parser_bison.y"
                        {
				(yyvsp[0].handle).position.location = (yyvsp[0].handle).handle.location;
				(yyvsp[0].handle).position.id = (yyvsp[0].handle).handle.id;
				(yyvsp[0].handle).handle.id = 0;
				handle_merge(&(yyvsp[-1].handle), &(yyvsp[0].handle));
				(yyval.handle) = (yyvsp[-1].handle);
			}
#line 10959 "parser_bison.c"
    break;

  case 437: /* rule_position: chain_spec index_spec  */
#line 2908 "parser_bison.y"
                        {
				handle_merge(&(yyvsp[-1].handle), &(yyvsp[0].handle));
				(yyval.handle) = (yyvsp[-1].handle);
			}
#line 10968 "parser_bison.c"
    break;

  case 438: /* ruleid_spec: chain_spec handle_spec  */
#line 2915 "parser_bison.y"
                        {
				handle_merge(&(yyvsp[-1].handle), &(yyvsp[0].handle));
				(yyval.handle) = (yyvsp[-1].handle);
			}
#line 10977 "parser_bison.c"
    break;

  case 439: /* comment_spec: "comment" string  */
#line 2922 "parser_bison.y"
                        {
				if (strlen((yyvsp[0].string)) > NFTNL_UDATA_COMMENT_MAXLEN) {
					erec_queue(error(&(yylsp[0]), "comment too long, %d characters maximum allowed",
							 NFTNL_UDATA_COMMENT_MAXLEN),
						   state->msgs);
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyval.string) = (yyvsp[0].string);
			}
#line 10992 "parser_bison.c"
    break;

  case 440: /* ruleset_spec: %empty  */
#line 2935 "parser_bison.y"
                        {
				memset(&(yyval.handle), 0, sizeof((yyval.handle)));
				(yyval.handle).family	= NFPROTO_UNSPEC;
			}
#line 11001 "parser_bison.c"
    break;

  case 441: /* ruleset_spec: family_spec_explicit  */
#line 2940 "parser_bison.y"
                        {
				memset(&(yyval.handle), 0, sizeof((yyval.handle)));
				(yyval.handle).family	= (yyvsp[0].val);
			}
#line 11010 "parser_bison.c"
    break;

  case 442: /* rule: rule_alloc  */
#line 2947 "parser_bison.y"
                        {
				(yyval.rule)->comment = NULL;
			}
#line 11018 "parser_bison.c"
    break;

  case 443: /* rule: rule_alloc comment_spec  */
#line 2951 "parser_bison.y"
                        {
				(yyval.rule)->comment = (yyvsp[0].string);
			}
#line 11026 "parser_bison.c"
    break;

  case 444: /* rule_alloc: stmt_list  */
#line 2957 "parser_bison.y"
                        {
				struct stmt *i;

				(yyval.rule) = rule_alloc(&(yyloc), NULL);
				list_for_each_entry(i, (yyvsp[0].list), list)
					(yyval.rule)->num_stmts++;
				list_splice_tail((yyvsp[0].list), &(yyval.rule)->stmts);
				xfree((yyvsp[0].list));
			}
#line 11040 "parser_bison.c"
    break;

  case 445: /* stmt_list: stmt  */
#line 2969 "parser_bison.y"
                        {
				(yyval.list) = xmalloc(sizeof(*(yyval.list)));
				init_list_head((yyval.list));
				list_add_tail(&(yyvsp[0].stmt)->list, (yyval.list));
			}
#line 11050 "parser_bison.c"
    break;

  case 446: /* stmt_list: stmt_list stmt  */
#line 2975 "parser_bison.y"
                        {
				(yyval.list) = (yyvsp[-1].list);
				list_add_tail(&(yyvsp[0].stmt)->list, (yyvsp[-1].list));
			}
#line 11059 "parser_bison.c"
    break;

  case 447: /* stateful_stmt_list: stateful_stmt  */
#line 2982 "parser_bison.y"
                        {
				(yyval.list) = xmalloc(sizeof(*(yyval.list)));
				init_list_head((yyval.list));
				list_add_tail(&(yyvsp[0].stmt)->list, (yyval.list));
			}
#line 11069 "parser_bison.c"
    break;

  case 448: /* stateful_stmt_list: stateful_stmt_list stateful_stmt  */
#line 2988 "parser_bison.y"
                        {
				(yyval.list) = (yyvsp[-1].list);
				list_add_tail(&(yyvsp[0].stmt)->list, (yyvsp[-1].list));
			}
#line 11078 "parser_bison.c"
    break;

  case 449: /* objref_stmt_counter: "counter" "name" stmt_expr close_scope_counter  */
#line 2995 "parser_bison.y"
                        {
				(yyval.stmt) = objref_stmt_alloc(&(yyloc));
				(yyval.stmt)->objref.type = NFT_OBJECT_COUNTER;
				(yyval.stmt)->objref.expr = (yyvsp[-1].expr);
			}
#line 11088 "parser_bison.c"
    break;

  case 450: /* objref_stmt_limit: "limit" "name" stmt_expr close_scope_limit  */
#line 3003 "parser_bison.y"
                        {
				(yyval.stmt) = objref_stmt_alloc(&(yyloc));
				(yyval.stmt)->objref.type = NFT_OBJECT_LIMIT;
				(yyval.stmt)->objref.expr = (yyvsp[-1].expr);
			}
#line 11098 "parser_bison.c"
    break;

  case 451: /* objref_stmt_quota: "quota" "name" stmt_expr close_scope_quota  */
#line 3011 "parser_bison.y"
                        {
				(yyval.stmt) = objref_stmt_alloc(&(yyloc));
				(yyval.stmt)->objref.type = NFT_OBJECT_QUOTA;
				(yyval.stmt)->objref.expr = (yyvsp[-1].expr);
			}
#line 11108 "parser_bison.c"
    break;

  case 452: /* objref_stmt_synproxy: "synproxy" "name" stmt_expr close_scope_synproxy  */
#line 3019 "parser_bison.y"
                        {
				(yyval.stmt) = objref_stmt_alloc(&(yyloc));
				(yyval.stmt)->objref.type = NFT_OBJECT_SYNPROXY;
				(yyval.stmt)->objref.expr = (yyvsp[-1].expr);
			}
#line 11118 "parser_bison.c"
    break;

  case 453: /* objref_stmt_ct: "ct" "timeout" "set" stmt_expr close_scope_ct  */
#line 3027 "parser_bison.y"
                        {
				(yyval.stmt) = objref_stmt_alloc(&(yyloc));
				(yyval.stmt)->objref.type = NFT_OBJECT_CT_TIMEOUT;
				(yyval.stmt)->objref.expr = (yyvsp[-1].expr);

			}
#line 11129 "parser_bison.c"
    break;

  case 454: /* objref_stmt_ct: "ct" "expectation" "set" stmt_expr close_scope_ct  */
#line 3034 "parser_bison.y"
                        {
				(yyval.stmt) = objref_stmt_alloc(&(yyloc));
				(yyval.stmt)->objref.type = NFT_OBJECT_CT_EXPECT;
				(yyval.stmt)->objref.expr = (yyvsp[-1].expr);
			}
#line 11139 "parser_bison.c"
    break;

  case 487: /* xt_stmt: "xt" "string" string  */
#line 3080 "parser_bison.y"
                        {
				(yyval.stmt) = NULL;
				xfree((yyvsp[-1].string));
				xfree((yyvsp[0].string));
				erec_queue(error(&(yyloc), "unsupported xtables compat expression, use iptables-nft with this ruleset"),
					   state->msgs);
				YYERROR;
			}
#line 11152 "parser_bison.c"
    break;

  case 488: /* chain_stmt_type: "jump"  */
#line 3090 "parser_bison.y"
                                        { (yyval.val) = NFT_JUMP; }
#line 11158 "parser_bison.c"
    break;

  case 489: /* chain_stmt_type: "goto"  */
#line 3091 "parser_bison.y"
                                        { (yyval.val) = NFT_GOTO; }
#line 11164 "parser_bison.c"
    break;

  case 490: /* chain_stmt: chain_stmt_type chain_block_alloc '{' subchain_block '}'  */
#line 3095 "parser_bison.y"
                        {
				(yyvsp[-3].chain)->location = (yylsp[-3]);
				close_scope(state);
				(yyvsp[-1].chain)->location = (yylsp[-1]);
				(yyval.stmt) = chain_stmt_alloc(&(yyloc), (yyvsp[-1].chain), (yyvsp[-4].val));
			}
#line 11175 "parser_bison.c"
    break;

  case 491: /* verdict_stmt: verdict_expr  */
#line 3104 "parser_bison.y"
                        {
				(yyval.stmt) = verdict_stmt_alloc(&(yyloc), (yyvsp[0].expr));
			}
#line 11183 "parser_bison.c"
    break;

  case 492: /* verdict_stmt: verdict_map_stmt  */
#line 3108 "parser_bison.y"
                        {
				(yyval.stmt) = verdict_stmt_alloc(&(yyloc), (yyvsp[0].expr));
			}
#line 11191 "parser_bison.c"
    break;

  case 493: /* verdict_map_stmt: concat_expr "vmap" verdict_map_expr  */
#line 3114 "parser_bison.y"
                        {
				(yyval.expr) = map_expr_alloc(&(yyloc), (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 11199 "parser_bison.c"
    break;

  case 494: /* verdict_map_expr: '{' verdict_map_list_expr '}'  */
#line 3120 "parser_bison.y"
                        {
				(yyvsp[-1].expr)->location = (yyloc);
				(yyval.expr) = (yyvsp[-1].expr);
			}
#line 11208 "parser_bison.c"
    break;

  case 496: /* verdict_map_list_expr: verdict_map_list_member_expr  */
#line 3128 "parser_bison.y"
                        {
				(yyval.expr) = set_expr_alloc(&(yyloc), NULL);
				compound_expr_add((yyval.expr), (yyvsp[0].expr));
			}
#line 11217 "parser_bison.c"
    break;

  case 497: /* verdict_map_list_expr: verdict_map_list_expr "comma" verdict_map_list_member_expr  */
#line 3133 "parser_bison.y"
                        {
				compound_expr_add((yyvsp[-2].expr), (yyvsp[0].expr));
				(yyval.expr) = (yyvsp[-2].expr);
			}
#line 11226 "parser_bison.c"
    break;

  case 499: /* verdict_map_list_member_expr: opt_newline set_elem_expr "colon" verdict_expr opt_newline  */
#line 3141 "parser_bison.y"
                        {
				(yyval.expr) = mapping_expr_alloc(&(yylsp[-3]), (yyvsp[-3].expr), (yyvsp[-1].expr));
			}
#line 11234 "parser_bison.c"
    break;

  case 500: /* connlimit_stmt: "ct" "count" "number" close_scope_ct  */
#line 3147 "parser_bison.y"
                        {
				(yyval.stmt) = connlimit_stmt_alloc(&(yyloc));
				(yyval.stmt)->connlimit.count	= (yyvsp[-1].val);
			}
#line 11243 "parser_bison.c"
    break;

  case 501: /* connlimit_stmt: "ct" "count" "over" "number" close_scope_ct  */
#line 3152 "parser_bison.y"
                        {
				(yyval.stmt) = connlimit_stmt_alloc(&(yyloc));
				(yyval.stmt)->connlimit.count = (yyvsp[-1].val);
				(yyval.stmt)->connlimit.flags = NFT_CONNLIMIT_F_INV;
			}
#line 11253 "parser_bison.c"
    break;

  case 504: /* counter_stmt_alloc: "counter"  */
#line 3163 "parser_bison.y"
                        {
				(yyval.stmt) = counter_stmt_alloc(&(yyloc));
			}
#line 11261 "parser_bison.c"
    break;

  case 505: /* counter_args: counter_arg  */
#line 3169 "parser_bison.y"
                        {
				(yyval.stmt)	= (yyvsp[-1].stmt);
			}
#line 11269 "parser_bison.c"
    break;

  case 507: /* counter_arg: "packets" "number"  */
#line 3176 "parser_bison.y"
                        {
				assert((yyvsp[-2].stmt)->ops->type == STMT_COUNTER);
				(yyvsp[-2].stmt)->counter.packets = (yyvsp[0].val);
			}
#line 11278 "parser_bison.c"
    break;

  case 508: /* counter_arg: "bytes" "number"  */
#line 3181 "parser_bison.y"
                        {
				assert((yyvsp[-2].stmt)->ops->type == STMT_COUNTER);
				(yyvsp[-2].stmt)->counter.bytes	 = (yyvsp[0].val);
			}
#line 11287 "parser_bison.c"
    break;

  case 511: /* log_stmt_alloc: "log"  */
#line 3192 "parser_bison.y"
                        {
				(yyval.stmt) = log_stmt_alloc(&(yyloc));
			}
#line 11295 "parser_bison.c"
    break;

  case 512: /* log_args: log_arg  */
#line 3198 "parser_bison.y"
                        {
				(yyval.stmt)	= (yyvsp[-1].stmt);
			}
#line 11303 "parser_bison.c"
    break;

  case 514: /* log_arg: "prefix" string  */
#line 3205 "parser_bison.y"
                        {
				struct scope *scope = current_scope(state);
				bool done = false, another_var = false;
				char *start, *end, scratch = '\0';
				struct expr *expr, *item;
				struct symbol *sym;
				enum {
					PARSE_TEXT,
					PARSE_VAR,
				} prefix_state;

				/* No variables in log prefix, skip. */
				if (!strchr((yyvsp[0].string), '$')) {
					expr = constant_expr_alloc(&(yyloc), &string_type,
								   BYTEORDER_HOST_ENDIAN,
								   (strlen((yyvsp[0].string)) + 1) * BITS_PER_BYTE, (yyvsp[0].string));
					xfree((yyvsp[0].string));
					(yyvsp[-2].stmt)->log.prefix = expr;
					(yyvsp[-2].stmt)->log.flags |= STMT_LOG_PREFIX;
					break;
				}

				/* Parse variables in log prefix string using a
				 * state machine parser with two states. This
				 * parser creates list of expressions composed
				 * of constant and variable expressions.
				 */
				expr = compound_expr_alloc(&(yyloc), EXPR_LIST);

				start = (char *)(yyvsp[0].string);

				if (*start != '$') {
					prefix_state = PARSE_TEXT;
				} else {
					prefix_state = PARSE_VAR;
					start++;
				}
				end = start;

				/* Not nice, but works. */
				while (!done) {
					switch (prefix_state) {
					case PARSE_TEXT:
						while (*end != '\0' && *end != '$')
							end++;

						if (*end == '\0')
							done = true;

						*end = '\0';
						item = constant_expr_alloc(&(yyloc), &string_type,
									   BYTEORDER_HOST_ENDIAN,
									   (strlen(start) + 1) * BITS_PER_BYTE,
									   start);
						compound_expr_add(expr, item);

						if (done)
							break;

						start = end + 1;
						end = start;

						/* fall through */
					case PARSE_VAR:
						while (isalnum(*end) || *end == '_')
							end++;

						if (*end == '\0')
							done = true;
						else if (*end == '$')
							another_var = true;
						else
							scratch = *end;

						*end = '\0';

						sym = symbol_get(scope, start);
						if (!sym) {
							sym = symbol_lookup_fuzzy(scope, start);
							if (sym) {
								erec_queue(error(&(yylsp[0]), "unknown identifier '%s'; "
										 "did you mean identifier ‘%s’?",
										 start, sym->identifier),
									   state->msgs);
							} else {
								erec_queue(error(&(yylsp[0]), "unknown identifier '%s'",
										 start),
									   state->msgs);
							}
							expr_free(expr);
							xfree((yyvsp[0].string));
							YYERROR;
						}
						item = variable_expr_alloc(&(yyloc), scope, sym);
						compound_expr_add(expr, item);

						if (done)
							break;

						/* Restore original byte after
						 * symbol lookup.
						 */
						if (scratch) {
							*end = scratch;
							scratch = '\0';
						}

						start = end;
						if (another_var) {
							another_var = false;
							start++;
							prefix_state = PARSE_VAR;
						} else {
							prefix_state = PARSE_TEXT;
						}
						end = start;
						break;
					}
				}

				xfree((yyvsp[0].string));
				(yyvsp[-2].stmt)->log.prefix	 = expr;
				(yyvsp[-2].stmt)->log.flags 	|= STMT_LOG_PREFIX;
			}
#line 11432 "parser_bison.c"
    break;

  case 515: /* log_arg: "group" "number"  */
#line 3330 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->log.group	 = (yyvsp[0].val);
				(yyvsp[-2].stmt)->log.flags 	|= STMT_LOG_GROUP;
			}
#line 11441 "parser_bison.c"
    break;

  case 516: /* log_arg: "snaplen" "number"  */
#line 3335 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->log.snaplen	 = (yyvsp[0].val);
				(yyvsp[-2].stmt)->log.flags 	|= STMT_LOG_SNAPLEN;
			}
#line 11450 "parser_bison.c"
    break;

  case 517: /* log_arg: "queue-threshold" "number"  */
#line 3340 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->log.qthreshold = (yyvsp[0].val);
				(yyvsp[-2].stmt)->log.flags 	|= STMT_LOG_QTHRESHOLD;
			}
#line 11459 "parser_bison.c"
    break;

  case 518: /* log_arg: "level" level_type  */
#line 3345 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->log.level	= (yyvsp[0].val);
				(yyvsp[-2].stmt)->log.flags 	|= STMT_LOG_LEVEL;
			}
#line 11468 "parser_bison.c"
    break;

  case 519: /* log_arg: "flags" log_flags  */
#line 3350 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->log.logflags	|= (yyvsp[0].val);
			}
#line 11476 "parser_bison.c"
    break;

  case 520: /* level_type: string  */
#line 3356 "parser_bison.y"
                        {
				if (!strcmp("emerg", (yyvsp[0].string)))
					(yyval.val) = NFT_LOGLEVEL_EMERG;
				else if (!strcmp("alert", (yyvsp[0].string)))
					(yyval.val) = NFT_LOGLEVEL_ALERT;
				else if (!strcmp("crit", (yyvsp[0].string)))
					(yyval.val) = NFT_LOGLEVEL_CRIT;
				else if (!strcmp("err", (yyvsp[0].string)))
					(yyval.val) = NFT_LOGLEVEL_ERR;
				else if (!strcmp("warn", (yyvsp[0].string)))
					(yyval.val) = NFT_LOGLEVEL_WARNING;
				else if (!strcmp("notice", (yyvsp[0].string)))
					(yyval.val) = NFT_LOGLEVEL_NOTICE;
				else if (!strcmp("info", (yyvsp[0].string)))
					(yyval.val) = NFT_LOGLEVEL_INFO;
				else if (!strcmp("debug", (yyvsp[0].string)))
					(yyval.val) = NFT_LOGLEVEL_DEBUG;
				else if (!strcmp("audit", (yyvsp[0].string)))
					(yyval.val) = NFT_LOGLEVEL_AUDIT;
				else {
					erec_queue(error(&(yylsp[0]), "invalid log level"),
						   state->msgs);
					xfree((yyvsp[0].string));
					YYERROR;
				}
				xfree((yyvsp[0].string));
			}
#line 11508 "parser_bison.c"
    break;

  case 521: /* log_flags: "tcp" log_flags_tcp close_scope_tcp  */
#line 3386 "parser_bison.y"
                        {
				(yyval.val) = (yyvsp[-1].val);
			}
#line 11516 "parser_bison.c"
    break;

  case 522: /* log_flags: "ip" "options" close_scope_ip  */
#line 3390 "parser_bison.y"
                        {
				(yyval.val) = NF_LOG_IPOPT;
			}
#line 11524 "parser_bison.c"
    break;

  case 523: /* log_flags: "skuid"  */
#line 3394 "parser_bison.y"
                        {
				(yyval.val) = NF_LOG_UID;
			}
#line 11532 "parser_bison.c"
    break;

  case 524: /* log_flags: "ether" close_scope_eth  */
#line 3398 "parser_bison.y"
                        {
				(yyval.val) = NF_LOG_MACDECODE;
			}
#line 11540 "parser_bison.c"
    break;

  case 525: /* log_flags: "all"  */
#line 3402 "parser_bison.y"
                        {
				(yyval.val) = NF_LOG_MASK;
			}
#line 11548 "parser_bison.c"
    break;

  case 526: /* log_flags_tcp: log_flags_tcp "comma" log_flag_tcp  */
#line 3408 "parser_bison.y"
                        {
				(yyval.val) = (yyvsp[-2].val) | (yyvsp[0].val);
			}
#line 11556 "parser_bison.c"
    break;

  case 528: /* log_flag_tcp: "seq"  */
#line 3415 "parser_bison.y"
                        {
				(yyval.val) = NF_LOG_TCPSEQ;
			}
#line 11564 "parser_bison.c"
    break;

  case 529: /* log_flag_tcp: "options"  */
#line 3419 "parser_bison.y"
                        {
				(yyval.val) = NF_LOG_TCPOPT;
			}
#line 11572 "parser_bison.c"
    break;

  case 530: /* limit_stmt: "limit" "rate" limit_mode limit_rate_pkts limit_burst_pkts close_scope_limit  */
#line 3425 "parser_bison.y"
                        {
				if ((yyvsp[-1].val) == 0) {
					erec_queue(error(&(yylsp[-1]), "packet limit burst must be > 0"),
						   state->msgs);
					YYERROR;
				}
				(yyval.stmt) = limit_stmt_alloc(&(yyloc));
				(yyval.stmt)->limit.rate	= (yyvsp[-2].limit_rate).rate;
				(yyval.stmt)->limit.unit	= (yyvsp[-2].limit_rate).unit;
				(yyval.stmt)->limit.burst	= (yyvsp[-1].val);
				(yyval.stmt)->limit.type	= NFT_LIMIT_PKTS;
				(yyval.stmt)->limit.flags = (yyvsp[-3].val);
			}
#line 11590 "parser_bison.c"
    break;

  case 531: /* limit_stmt: "limit" "rate" limit_mode limit_rate_bytes limit_burst_bytes close_scope_limit  */
#line 3439 "parser_bison.y"
                        {
				(yyval.stmt) = limit_stmt_alloc(&(yyloc));
				(yyval.stmt)->limit.rate	= (yyvsp[-2].limit_rate).rate;
				(yyval.stmt)->limit.unit	= (yyvsp[-2].limit_rate).unit;
				(yyval.stmt)->limit.burst	= (yyvsp[-1].val);
				(yyval.stmt)->limit.type	= NFT_LIMIT_PKT_BYTES;
				(yyval.stmt)->limit.flags = (yyvsp[-3].val);
			}
#line 11603 "parser_bison.c"
    break;

  case 532: /* quota_mode: "over"  */
#line 3449 "parser_bison.y"
                                                { (yyval.val) = NFT_QUOTA_F_INV; }
#line 11609 "parser_bison.c"
    break;

  case 533: /* quota_mode: "until"  */
#line 3450 "parser_bison.y"
                                                { (yyval.val) = 0; }
#line 11615 "parser_bison.c"
    break;

  case 534: /* quota_mode: %empty  */
#line 3451 "parser_bison.y"
                                                { (yyval.val) = 0; }
#line 11621 "parser_bison.c"
    break;

  case 535: /* quota_unit: "bytes"  */
#line 3454 "parser_bison.y"
                                                { (yyval.string) = xstrdup("bytes"); }
#line 11627 "parser_bison.c"
    break;

  case 536: /* quota_unit: "string"  */
#line 3455 "parser_bison.y"
                                                { (yyval.string) = (yyvsp[0].string); }
#line 11633 "parser_bison.c"
    break;

  case 537: /* quota_used: %empty  */
#line 3458 "parser_bison.y"
                                                { (yyval.val) = 0; }
#line 11639 "parser_bison.c"
    break;

  case 538: /* quota_used: "used" "number" quota_unit  */
#line 3460 "parser_bison.y"
                        {
				struct error_record *erec;
				uint64_t rate;

				erec = data_unit_parse(&(yyloc), (yyvsp[0].string), &rate);
				xfree((yyvsp[0].string));
				if (erec != NULL) {
					erec_queue(erec, state->msgs);
					YYERROR;
				}
				(yyval.val) = (yyvsp[-1].val) * rate;
			}
#line 11656 "parser_bison.c"
    break;

  case 539: /* quota_stmt: "quota" quota_mode "number" quota_unit quota_used close_scope_quota  */
#line 3475 "parser_bison.y"
                        {
				struct error_record *erec;
				uint64_t rate;

				erec = data_unit_parse(&(yyloc), (yyvsp[-2].string), &rate);
				xfree((yyvsp[-2].string));
				if (erec != NULL) {
					erec_queue(erec, state->msgs);
					YYERROR;
				}
				(yyval.stmt) = quota_stmt_alloc(&(yyloc));
				(yyval.stmt)->quota.bytes	= (yyvsp[-3].val) * rate;
				(yyval.stmt)->quota.used = (yyvsp[-1].val);
				(yyval.stmt)->quota.flags	= (yyvsp[-4].val);
			}
#line 11676 "parser_bison.c"
    break;

  case 540: /* limit_mode: "over"  */
#line 3492 "parser_bison.y"
                                                                { (yyval.val) = NFT_LIMIT_F_INV; }
#line 11682 "parser_bison.c"
    break;

  case 541: /* limit_mode: "until"  */
#line 3493 "parser_bison.y"
                                                                { (yyval.val) = 0; }
#line 11688 "parser_bison.c"
    break;

  case 542: /* limit_mode: %empty  */
#line 3494 "parser_bison.y"
                                                                { (yyval.val) = 0; }
#line 11694 "parser_bison.c"
    break;

  case 543: /* limit_burst_pkts: %empty  */
#line 3497 "parser_bison.y"
                                                                { (yyval.val) = 5; }
#line 11700 "parser_bison.c"
    break;

  case 544: /* limit_burst_pkts: "burst" "number" "packets"  */
#line 3498 "parser_bison.y"
                                                                { (yyval.val) = (yyvsp[-1].val); }
#line 11706 "parser_bison.c"
    break;

  case 545: /* limit_rate_pkts: "number" "/" time_unit  */
#line 3502 "parser_bison.y"
                        {
				(yyval.limit_rate).rate = (yyvsp[-2].val);
				(yyval.limit_rate).unit = (yyvsp[0].val);
			}
#line 11715 "parser_bison.c"
    break;

  case 546: /* limit_burst_bytes: %empty  */
#line 3508 "parser_bison.y"
                                                                { (yyval.val) = 0; }
#line 11721 "parser_bison.c"
    break;

  case 547: /* limit_burst_bytes: "burst" limit_bytes  */
#line 3509 "parser_bison.y"
                                                                { (yyval.val) = (yyvsp[0].val); }
#line 11727 "parser_bison.c"
    break;

  case 548: /* limit_rate_bytes: "number" "string"  */
#line 3513 "parser_bison.y"
                        {
				struct error_record *erec;
				uint64_t rate, unit;

				erec = rate_parse(&(yyloc), (yyvsp[0].string), &rate, &unit);
				xfree((yyvsp[0].string));
				if (erec != NULL) {
					erec_queue(erec, state->msgs);
					YYERROR;
				}
				(yyval.limit_rate).rate = rate * (yyvsp[-1].val);
				(yyval.limit_rate).unit = unit;
			}
#line 11745 "parser_bison.c"
    break;

  case 549: /* limit_rate_bytes: limit_bytes "/" time_unit  */
#line 3527 "parser_bison.y"
                        {
				(yyval.limit_rate).rate = (yyvsp[-2].val);
				(yyval.limit_rate).unit = (yyvsp[0].val);
			}
#line 11754 "parser_bison.c"
    break;

  case 550: /* limit_bytes: "number" "bytes"  */
#line 3533 "parser_bison.y"
                                                        { (yyval.val) = (yyvsp[-1].val); }
#line 11760 "parser_bison.c"
    break;

  case 551: /* limit_bytes: "number" "string"  */
#line 3535 "parser_bison.y"
                        {
				struct error_record *erec;
				uint64_t rate;

				erec = data_unit_parse(&(yyloc), (yyvsp[0].string), &rate);
				xfree((yyvsp[0].string));
				if (erec != NULL) {
					erec_queue(erec, state->msgs);
					YYERROR;
				}
				(yyval.val) = (yyvsp[-1].val) * rate;
			}
#line 11777 "parser_bison.c"
    break;

  case 552: /* time_unit: "second"  */
#line 3549 "parser_bison.y"
                                                { (yyval.val) = 1ULL; }
#line 11783 "parser_bison.c"
    break;

  case 553: /* time_unit: "minute"  */
#line 3550 "parser_bison.y"
                                                { (yyval.val) = 1ULL * 60; }
#line 11789 "parser_bison.c"
    break;

  case 554: /* time_unit: "hour"  */
#line 3551 "parser_bison.y"
                                                { (yyval.val) = 1ULL * 60 * 60; }
#line 11795 "parser_bison.c"
    break;

  case 555: /* time_unit: "day"  */
#line 3552 "parser_bison.y"
                                                { (yyval.val) = 1ULL * 60 * 60 * 24; }
#line 11801 "parser_bison.c"
    break;

  case 556: /* time_unit: "week"  */
#line 3553 "parser_bison.y"
                                                { (yyval.val) = 1ULL * 60 * 60 * 24 * 7; }
#line 11807 "parser_bison.c"
    break;

  case 558: /* reject_stmt_alloc: "reject"  */
#line 3560 "parser_bison.y"
                        {
				(yyval.stmt) = reject_stmt_alloc(&(yyloc));
			}
#line 11815 "parser_bison.c"
    break;

  case 559: /* reject_with_expr: "string"  */
#line 3566 "parser_bison.y"
                        {
				(yyval.expr) = symbol_expr_alloc(&(yyloc), SYMBOL_VALUE,
						       current_scope(state), (yyvsp[0].string));
				xfree((yyvsp[0].string));
			}
#line 11825 "parser_bison.c"
    break;

  case 560: /* reject_with_expr: integer_expr  */
#line 3571 "parser_bison.y"
                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 11831 "parser_bison.c"
    break;

  case 561: /* reject_opts: %empty  */
#line 3575 "parser_bison.y"
                        {
				(yyvsp[0].stmt)->reject.type = -1;
				(yyvsp[0].stmt)->reject.icmp_code = -1;
			}
#line 11840 "parser_bison.c"
    break;

  case 562: /* reject_opts: "with" "icmp" "type" reject_with_expr close_scope_type close_scope_icmp  */
#line 3580 "parser_bison.y"
                        {
				(yyvsp[-6].stmt)->reject.family = NFPROTO_IPV4;
				(yyvsp[-6].stmt)->reject.type = NFT_REJECT_ICMP_UNREACH;
				(yyvsp[-6].stmt)->reject.expr = (yyvsp[-2].expr);
				datatype_set((yyvsp[-6].stmt)->reject.expr, &reject_icmp_code_type);
			}
#line 11851 "parser_bison.c"
    break;

  case 563: /* reject_opts: "with" "icmp" reject_with_expr  */
#line 3587 "parser_bison.y"
                        {
				(yyvsp[-3].stmt)->reject.family = NFPROTO_IPV4;
				(yyvsp[-3].stmt)->reject.type = NFT_REJECT_ICMP_UNREACH;
				(yyvsp[-3].stmt)->reject.expr = (yyvsp[0].expr);
				datatype_set((yyvsp[-3].stmt)->reject.expr, &reject_icmp_code_type);
			}
#line 11862 "parser_bison.c"
    break;

  case 564: /* reject_opts: "with" "icmpv6" "type" reject_with_expr close_scope_type close_scope_icmp  */
#line 3594 "parser_bison.y"
                        {
				(yyvsp[-6].stmt)->reject.family = NFPROTO_IPV6;
				(yyvsp[-6].stmt)->reject.type = NFT_REJECT_ICMP_UNREACH;
				(yyvsp[-6].stmt)->reject.expr = (yyvsp[-2].expr);
				datatype_set((yyvsp[-6].stmt)->reject.expr, &reject_icmpv6_code_type);
			}
#line 11873 "parser_bison.c"
    break;

  case 565: /* reject_opts: "with" "icmpv6" reject_with_expr  */
#line 3601 "parser_bison.y"
                        {
				(yyvsp[-3].stmt)->reject.family = NFPROTO_IPV6;
				(yyvsp[-3].stmt)->reject.type = NFT_REJECT_ICMP_UNREACH;
				(yyvsp[-3].stmt)->reject.expr = (yyvsp[0].expr);
				datatype_set((yyvsp[-3].stmt)->reject.expr, &reject_icmpv6_code_type);
			}
#line 11884 "parser_bison.c"
    break;

  case 566: /* reject_opts: "with" "icmpx" "type" reject_with_expr close_scope_type  */
#line 3608 "parser_bison.y"
                        {
				(yyvsp[-5].stmt)->reject.type = NFT_REJECT_ICMPX_UNREACH;
				(yyvsp[-5].stmt)->reject.expr = (yyvsp[-1].expr);
				datatype_set((yyvsp[-5].stmt)->reject.expr, &reject_icmpx_code_type);
			}
#line 11894 "parser_bison.c"
    break;

  case 567: /* reject_opts: "with" "icmpx" reject_with_expr  */
#line 3614 "parser_bison.y"
                        {
				(yyvsp[-3].stmt)->reject.type = NFT_REJECT_ICMPX_UNREACH;
				(yyvsp[-3].stmt)->reject.expr = (yyvsp[0].expr);
				datatype_set((yyvsp[-3].stmt)->reject.expr, &reject_icmpx_code_type);
			}
#line 11904 "parser_bison.c"
    break;

  case 568: /* reject_opts: "with" "tcp" close_scope_tcp "reset" close_scope_reset  */
#line 3620 "parser_bison.y"
                        {
				(yyvsp[-5].stmt)->reject.type = NFT_REJECT_TCP_RST;
			}
#line 11912 "parser_bison.c"
    break;

  case 570: /* nat_stmt_alloc: "snat"  */
#line 3628 "parser_bison.y"
                                        { (yyval.stmt) = nat_stmt_alloc(&(yyloc), NFT_NAT_SNAT); }
#line 11918 "parser_bison.c"
    break;

  case 571: /* nat_stmt_alloc: "dnat"  */
#line 3629 "parser_bison.y"
                                        { (yyval.stmt) = nat_stmt_alloc(&(yyloc), NFT_NAT_DNAT); }
#line 11924 "parser_bison.c"
    break;

  case 572: /* tproxy_stmt: "tproxy" "to" stmt_expr  */
#line 3633 "parser_bison.y"
                        {
				(yyval.stmt) = tproxy_stmt_alloc(&(yyloc));
				(yyval.stmt)->tproxy.family = NFPROTO_UNSPEC;
				(yyval.stmt)->tproxy.addr = (yyvsp[0].expr);
			}
#line 11934 "parser_bison.c"
    break;

  case 573: /* tproxy_stmt: "tproxy" nf_key_proto "to" stmt_expr  */
#line 3639 "parser_bison.y"
                        {
				(yyval.stmt) = tproxy_stmt_alloc(&(yyloc));
				(yyval.stmt)->tproxy.family = (yyvsp[-2].val);
				(yyval.stmt)->tproxy.addr = (yyvsp[0].expr);
			}
#line 11944 "parser_bison.c"
    break;

  case 574: /* tproxy_stmt: "tproxy" "to" "colon" stmt_expr  */
#line 3645 "parser_bison.y"
                        {
				(yyval.stmt) = tproxy_stmt_alloc(&(yyloc));
				(yyval.stmt)->tproxy.family = NFPROTO_UNSPEC;
				(yyval.stmt)->tproxy.port = (yyvsp[0].expr);
			}
#line 11954 "parser_bison.c"
    break;

  case 575: /* tproxy_stmt: "tproxy" "to" stmt_expr "colon" stmt_expr  */
#line 3651 "parser_bison.y"
                        {
				(yyval.stmt) = tproxy_stmt_alloc(&(yyloc));
				(yyval.stmt)->tproxy.family = NFPROTO_UNSPEC;
				(yyval.stmt)->tproxy.addr = (yyvsp[-2].expr);
				(yyval.stmt)->tproxy.port = (yyvsp[0].expr);
			}
#line 11965 "parser_bison.c"
    break;

  case 576: /* tproxy_stmt: "tproxy" nf_key_proto "to" stmt_expr "colon" stmt_expr  */
#line 3658 "parser_bison.y"
                        {
				(yyval.stmt) = tproxy_stmt_alloc(&(yyloc));
				(yyval.stmt)->tproxy.family = (yyvsp[-4].val);
				(yyval.stmt)->tproxy.addr = (yyvsp[-2].expr);
				(yyval.stmt)->tproxy.port = (yyvsp[0].expr);
			}
#line 11976 "parser_bison.c"
    break;

  case 577: /* tproxy_stmt: "tproxy" nf_key_proto "to" "colon" stmt_expr  */
#line 3665 "parser_bison.y"
                        {
				(yyval.stmt) = tproxy_stmt_alloc(&(yyloc));
				(yyval.stmt)->tproxy.family = (yyvsp[-3].val);
				(yyval.stmt)->tproxy.port = (yyvsp[0].expr);
			}
#line 11986 "parser_bison.c"
    break;

  case 580: /* synproxy_stmt_alloc: "synproxy"  */
#line 3677 "parser_bison.y"
                        {
				(yyval.stmt) = synproxy_stmt_alloc(&(yyloc));
			}
#line 11994 "parser_bison.c"
    break;

  case 581: /* synproxy_args: synproxy_arg  */
#line 3683 "parser_bison.y"
                        {
				(yyval.stmt)	= (yyvsp[-1].stmt);
			}
#line 12002 "parser_bison.c"
    break;

  case 583: /* synproxy_arg: "mss" "number"  */
#line 3690 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->synproxy.mss = (yyvsp[0].val);
				(yyvsp[-2].stmt)->synproxy.flags |= NF_SYNPROXY_OPT_MSS;
			}
#line 12011 "parser_bison.c"
    break;

  case 584: /* synproxy_arg: "wscale" "number"  */
#line 3695 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->synproxy.wscale = (yyvsp[0].val);
				(yyvsp[-2].stmt)->synproxy.flags |= NF_SYNPROXY_OPT_WSCALE;
			}
#line 12020 "parser_bison.c"
    break;

  case 585: /* synproxy_arg: "timestamp"  */
#line 3700 "parser_bison.y"
                        {
				(yyvsp[-1].stmt)->synproxy.flags |= NF_SYNPROXY_OPT_TIMESTAMP;
			}
#line 12028 "parser_bison.c"
    break;

  case 586: /* synproxy_arg: "sack-permitted"  */
#line 3704 "parser_bison.y"
                        {
				(yyvsp[-1].stmt)->synproxy.flags |= NF_SYNPROXY_OPT_SACK_PERM;
			}
#line 12036 "parser_bison.c"
    break;

  case 587: /* synproxy_config: "mss" "number" "wscale" "number" synproxy_ts synproxy_sack  */
#line 3710 "parser_bison.y"
                        {
				struct synproxy *synproxy;
				uint32_t flags = 0;

				synproxy = &(yyvsp[-6].obj)->synproxy;
				synproxy->mss = (yyvsp[-4].val);
				flags |= NF_SYNPROXY_OPT_MSS;
				synproxy->wscale = (yyvsp[-2].val);
				flags |= NF_SYNPROXY_OPT_WSCALE;
				if ((yyvsp[-1].val))
					flags |= (yyvsp[-1].val);
				if ((yyvsp[0].val))
					flags |= (yyvsp[0].val);
				synproxy->flags = flags;
			}
#line 12056 "parser_bison.c"
    break;

  case 588: /* synproxy_config: "mss" "number" stmt_separator "wscale" "number" stmt_separator synproxy_ts synproxy_sack  */
#line 3726 "parser_bison.y"
                        {
				struct synproxy *synproxy;
				uint32_t flags = 0;

				synproxy = &(yyvsp[-8].obj)->synproxy;
				synproxy->mss = (yyvsp[-6].val);
				flags |= NF_SYNPROXY_OPT_MSS;
				synproxy->wscale = (yyvsp[-3].val);
				flags |= NF_SYNPROXY_OPT_WSCALE;
				if ((yyvsp[-1].val))
					flags |= (yyvsp[-1].val);
				if ((yyvsp[0].val))
					flags |= (yyvsp[0].val);
				synproxy->flags = flags;
			}
#line 12076 "parser_bison.c"
    break;

  case 589: /* synproxy_obj: %empty  */
#line 3744 "parser_bison.y"
                        {
				(yyval.obj) = obj_alloc(&(yyloc));
				(yyval.obj)->type = NFT_OBJECT_SYNPROXY;
			}
#line 12085 "parser_bison.c"
    break;

  case 590: /* synproxy_ts: %empty  */
#line 3750 "parser_bison.y"
                                                { (yyval.val) = 0; }
#line 12091 "parser_bison.c"
    break;

  case 591: /* synproxy_ts: "timestamp"  */
#line 3752 "parser_bison.y"
                        {
				(yyval.val) = NF_SYNPROXY_OPT_TIMESTAMP;
			}
#line 12099 "parser_bison.c"
    break;

  case 592: /* synproxy_sack: %empty  */
#line 3757 "parser_bison.y"
                                                { (yyval.val) = 0; }
#line 12105 "parser_bison.c"
    break;

  case 593: /* synproxy_sack: "sack-permitted"  */
#line 3759 "parser_bison.y"
                        {
				(yyval.val) = NF_SYNPROXY_OPT_SACK_PERM;
			}
#line 12113 "parser_bison.c"
    break;

  case 594: /* primary_stmt_expr: symbol_expr  */
#line 3764 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12119 "parser_bison.c"
    break;

  case 595: /* primary_stmt_expr: integer_expr  */
#line 3765 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12125 "parser_bison.c"
    break;

  case 596: /* primary_stmt_expr: boolean_expr  */
#line 3766 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12131 "parser_bison.c"
    break;

  case 597: /* primary_stmt_expr: meta_expr  */
#line 3767 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12137 "parser_bison.c"
    break;

  case 598: /* primary_stmt_expr: rt_expr  */
#line 3768 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12143 "parser_bison.c"
    break;

  case 599: /* primary_stmt_expr: ct_expr  */
#line 3769 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12149 "parser_bison.c"
    break;

  case 600: /* primary_stmt_expr: numgen_expr  */
#line 3770 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12155 "parser_bison.c"
    break;

  case 601: /* primary_stmt_expr: hash_expr  */
#line 3771 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12161 "parser_bison.c"
    break;

  case 602: /* primary_stmt_expr: payload_expr  */
#line 3772 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12167 "parser_bison.c"
    break;

  case 603: /* primary_stmt_expr: keyword_expr  */
#line 3773 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12173 "parser_bison.c"
    break;

  case 604: /* primary_stmt_expr: socket_expr  */
#line 3774 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12179 "parser_bison.c"
    break;

  case 605: /* primary_stmt_expr: osf_expr  */
#line 3775 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12185 "parser_bison.c"
    break;

  case 606: /* primary_stmt_expr: '(' basic_stmt_expr ')'  */
#line 3776 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[-1].expr); }
#line 12191 "parser_bison.c"
    break;

  case 608: /* shift_stmt_expr: shift_stmt_expr "<<" primary_stmt_expr  */
#line 3781 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_LSHIFT, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 12199 "parser_bison.c"
    break;

  case 609: /* shift_stmt_expr: shift_stmt_expr ">>" primary_stmt_expr  */
#line 3785 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_RSHIFT, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 12207 "parser_bison.c"
    break;

  case 611: /* and_stmt_expr: and_stmt_expr "&" shift_stmt_expr  */
#line 3792 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_AND, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 12215 "parser_bison.c"
    break;

  case 613: /* exclusive_or_stmt_expr: exclusive_or_stmt_expr "^" and_stmt_expr  */
#line 3799 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_XOR, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 12223 "parser_bison.c"
    break;

  case 615: /* inclusive_or_stmt_expr: inclusive_or_stmt_expr '|' exclusive_or_stmt_expr  */
#line 3806 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_OR, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 12231 "parser_bison.c"
    break;

  case 618: /* concat_stmt_expr: concat_stmt_expr "." primary_stmt_expr  */
#line 3816 "parser_bison.y"
                        {
				struct location rhs[] = {
					[1]	= (yylsp[-1]),
					[2]	= (yylsp[0]),
				};

				(yyval.expr) = handle_concat_expr(&(yyloc), (yyval.expr), (yyvsp[-2].expr), (yyvsp[0].expr), rhs);
			}
#line 12244 "parser_bison.c"
    break;

  case 621: /* map_stmt_expr: concat_stmt_expr "map" map_stmt_expr_set  */
#line 3831 "parser_bison.y"
                        {
				(yyval.expr) = map_expr_alloc(&(yyloc), (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 12252 "parser_bison.c"
    break;

  case 622: /* map_stmt_expr: concat_stmt_expr  */
#line 3834 "parser_bison.y"
                                                        { (yyval.expr) = (yyvsp[0].expr); }
#line 12258 "parser_bison.c"
    break;

  case 623: /* prefix_stmt_expr: basic_stmt_expr "/" "number"  */
#line 3838 "parser_bison.y"
                        {
				(yyval.expr) = prefix_expr_alloc(&(yyloc), (yyvsp[-2].expr), (yyvsp[0].val));
			}
#line 12266 "parser_bison.c"
    break;

  case 624: /* range_stmt_expr: basic_stmt_expr "-" basic_stmt_expr  */
#line 3844 "parser_bison.y"
                        {
				(yyval.expr) = range_expr_alloc(&(yyloc), (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 12274 "parser_bison.c"
    break;

  case 630: /* nat_stmt_args: stmt_expr  */
#line 3859 "parser_bison.y"
                        {
				(yyvsp[-1].stmt)->nat.addr = (yyvsp[0].expr);
			}
#line 12282 "parser_bison.c"
    break;

  case 631: /* nat_stmt_args: "to" stmt_expr  */
#line 3863 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->nat.addr = (yyvsp[0].expr);
			}
#line 12290 "parser_bison.c"
    break;

  case 632: /* nat_stmt_args: nf_key_proto "to" stmt_expr  */
#line 3867 "parser_bison.y"
                        {
				(yyvsp[-3].stmt)->nat.family = (yyvsp[-2].val);
				(yyvsp[-3].stmt)->nat.addr = (yyvsp[0].expr);
			}
#line 12299 "parser_bison.c"
    break;

  case 633: /* nat_stmt_args: stmt_expr "colon" stmt_expr  */
#line 3872 "parser_bison.y"
                        {
				(yyvsp[-3].stmt)->nat.addr = (yyvsp[-2].expr);
				(yyvsp[-3].stmt)->nat.proto = (yyvsp[0].expr);
			}
#line 12308 "parser_bison.c"
    break;

  case 634: /* nat_stmt_args: "to" stmt_expr "colon" stmt_expr  */
#line 3877 "parser_bison.y"
                        {
				(yyvsp[-4].stmt)->nat.addr = (yyvsp[-2].expr);
				(yyvsp[-4].stmt)->nat.proto = (yyvsp[0].expr);
			}
#line 12317 "parser_bison.c"
    break;

  case 635: /* nat_stmt_args: nf_key_proto "to" stmt_expr "colon" stmt_expr  */
#line 3882 "parser_bison.y"
                        {
				(yyvsp[-5].stmt)->nat.family = (yyvsp[-4].val);
				(yyvsp[-5].stmt)->nat.addr = (yyvsp[-2].expr);
				(yyvsp[-5].stmt)->nat.proto = (yyvsp[0].expr);
			}
#line 12327 "parser_bison.c"
    break;

  case 636: /* nat_stmt_args: "colon" stmt_expr  */
#line 3888 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->nat.proto = (yyvsp[0].expr);
			}
#line 12335 "parser_bison.c"
    break;

  case 637: /* nat_stmt_args: "to" "colon" stmt_expr  */
#line 3892 "parser_bison.y"
                        {
				(yyvsp[-3].stmt)->nat.proto = (yyvsp[0].expr);
			}
#line 12343 "parser_bison.c"
    break;

  case 638: /* nat_stmt_args: nat_stmt_args nf_nat_flags  */
#line 3896 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->nat.flags = (yyvsp[0].val);
			}
#line 12351 "parser_bison.c"
    break;

  case 639: /* nat_stmt_args: nf_key_proto "addr" "." "port" "to" stmt_expr  */
#line 3900 "parser_bison.y"
                        {
				(yyvsp[-6].stmt)->nat.family = (yyvsp[-5].val);
				(yyvsp[-6].stmt)->nat.addr = (yyvsp[0].expr);
				(yyvsp[-6].stmt)->nat.type_flags = STMT_NAT_F_CONCAT;
			}
#line 12361 "parser_bison.c"
    break;

  case 640: /* nat_stmt_args: nf_key_proto "interval" "to" stmt_expr  */
#line 3906 "parser_bison.y"
                        {
				(yyvsp[-4].stmt)->nat.family = (yyvsp[-3].val);
				(yyvsp[-4].stmt)->nat.addr = (yyvsp[0].expr);
			}
#line 12370 "parser_bison.c"
    break;

  case 641: /* nat_stmt_args: "interval" "to" stmt_expr  */
#line 3911 "parser_bison.y"
                        {
				(yyvsp[-3].stmt)->nat.addr = (yyvsp[0].expr);
			}
#line 12378 "parser_bison.c"
    break;

  case 642: /* nat_stmt_args: nf_key_proto "prefix" "to" stmt_expr  */
#line 3915 "parser_bison.y"
                        {
				(yyvsp[-4].stmt)->nat.family = (yyvsp[-3].val);
				(yyvsp[-4].stmt)->nat.addr = (yyvsp[0].expr);
				(yyvsp[-4].stmt)->nat.type_flags =
						STMT_NAT_F_PREFIX;
				(yyvsp[-4].stmt)->nat.flags |= NF_NAT_RANGE_NETMAP;
			}
#line 12390 "parser_bison.c"
    break;

  case 643: /* nat_stmt_args: "prefix" "to" stmt_expr  */
#line 3923 "parser_bison.y"
                        {
				(yyvsp[-3].stmt)->nat.addr = (yyvsp[0].expr);
				(yyvsp[-3].stmt)->nat.type_flags =
						STMT_NAT_F_PREFIX;
				(yyvsp[-3].stmt)->nat.flags |= NF_NAT_RANGE_NETMAP;
			}
#line 12401 "parser_bison.c"
    break;

  case 646: /* masq_stmt_alloc: "masquerade"  */
#line 3935 "parser_bison.y"
                                                { (yyval.stmt) = nat_stmt_alloc(&(yyloc), NFT_NAT_MASQ); }
#line 12407 "parser_bison.c"
    break;

  case 647: /* masq_stmt_args: "to" "colon" stmt_expr  */
#line 3939 "parser_bison.y"
                        {
				(yyvsp[-3].stmt)->nat.proto = (yyvsp[0].expr);
			}
#line 12415 "parser_bison.c"
    break;

  case 648: /* masq_stmt_args: "to" "colon" stmt_expr nf_nat_flags  */
#line 3943 "parser_bison.y"
                        {
				(yyvsp[-4].stmt)->nat.proto = (yyvsp[-1].expr);
				(yyvsp[-4].stmt)->nat.flags = (yyvsp[0].val);
			}
#line 12424 "parser_bison.c"
    break;

  case 649: /* masq_stmt_args: nf_nat_flags  */
#line 3948 "parser_bison.y"
                        {
				(yyvsp[-1].stmt)->nat.flags = (yyvsp[0].val);
			}
#line 12432 "parser_bison.c"
    break;

  case 652: /* redir_stmt_alloc: "redirect"  */
#line 3957 "parser_bison.y"
                                                { (yyval.stmt) = nat_stmt_alloc(&(yyloc), NFT_NAT_REDIR); }
#line 12438 "parser_bison.c"
    break;

  case 653: /* redir_stmt_arg: "to" stmt_expr  */
#line 3961 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->nat.proto = (yyvsp[0].expr);
			}
#line 12446 "parser_bison.c"
    break;

  case 654: /* redir_stmt_arg: "to" "colon" stmt_expr  */
#line 3965 "parser_bison.y"
                        {
				(yyvsp[-3].stmt)->nat.proto = (yyvsp[0].expr);
			}
#line 12454 "parser_bison.c"
    break;

  case 655: /* redir_stmt_arg: nf_nat_flags  */
#line 3969 "parser_bison.y"
                        {
				(yyvsp[-1].stmt)->nat.flags = (yyvsp[0].val);
			}
#line 12462 "parser_bison.c"
    break;

  case 656: /* redir_stmt_arg: "to" stmt_expr nf_nat_flags  */
#line 3973 "parser_bison.y"
                        {
				(yyvsp[-3].stmt)->nat.proto = (yyvsp[-1].expr);
				(yyvsp[-3].stmt)->nat.flags = (yyvsp[0].val);
			}
#line 12471 "parser_bison.c"
    break;

  case 657: /* redir_stmt_arg: "to" "colon" stmt_expr nf_nat_flags  */
#line 3978 "parser_bison.y"
                        {
				(yyvsp[-4].stmt)->nat.proto = (yyvsp[-1].expr);
				(yyvsp[-4].stmt)->nat.flags = (yyvsp[0].val);
			}
#line 12480 "parser_bison.c"
    break;

  case 658: /* dup_stmt: "dup" "to" stmt_expr  */
#line 3985 "parser_bison.y"
                        {
				(yyval.stmt) = dup_stmt_alloc(&(yyloc));
				(yyval.stmt)->dup.to = (yyvsp[0].expr);
			}
#line 12489 "parser_bison.c"
    break;

  case 659: /* dup_stmt: "dup" "to" stmt_expr "device" stmt_expr  */
#line 3990 "parser_bison.y"
                        {
				(yyval.stmt) = dup_stmt_alloc(&(yyloc));
				(yyval.stmt)->dup.to = (yyvsp[-2].expr);
				(yyval.stmt)->dup.dev = (yyvsp[0].expr);
			}
#line 12499 "parser_bison.c"
    break;

  case 660: /* fwd_stmt: "fwd" "to" stmt_expr  */
#line 3998 "parser_bison.y"
                        {
				(yyval.stmt) = fwd_stmt_alloc(&(yyloc));
				(yyval.stmt)->fwd.dev = (yyvsp[0].expr);
			}
#line 12508 "parser_bison.c"
    break;

  case 661: /* fwd_stmt: "fwd" nf_key_proto "to" stmt_expr "device" stmt_expr  */
#line 4003 "parser_bison.y"
                        {
				(yyval.stmt) = fwd_stmt_alloc(&(yyloc));
				(yyval.stmt)->fwd.family = (yyvsp[-4].val);
				(yyval.stmt)->fwd.addr = (yyvsp[-2].expr);
				(yyval.stmt)->fwd.dev = (yyvsp[0].expr);
			}
#line 12519 "parser_bison.c"
    break;

  case 663: /* nf_nat_flags: nf_nat_flags "comma" nf_nat_flag  */
#line 4013 "parser_bison.y"
                        {
				(yyval.val) = (yyvsp[-2].val) | (yyvsp[0].val);
			}
#line 12527 "parser_bison.c"
    break;

  case 664: /* nf_nat_flag: "random"  */
#line 4018 "parser_bison.y"
                                                { (yyval.val) = NF_NAT_RANGE_PROTO_RANDOM; }
#line 12533 "parser_bison.c"
    break;

  case 665: /* nf_nat_flag: "fully-random"  */
#line 4019 "parser_bison.y"
                                                { (yyval.val) = NF_NAT_RANGE_PROTO_RANDOM_FULLY; }
#line 12539 "parser_bison.c"
    break;

  case 666: /* nf_nat_flag: "persistent"  */
#line 4020 "parser_bison.y"
                                                { (yyval.val) = NF_NAT_RANGE_PERSISTENT; }
#line 12545 "parser_bison.c"
    break;

  case 668: /* queue_stmt: "queue" "to" queue_stmt_expr close_scope_queue  */
#line 4025 "parser_bison.y"
                        {
				(yyval.stmt) = queue_stmt_alloc(&(yyloc), (yyvsp[-1].expr), 0);
			}
#line 12553 "parser_bison.c"
    break;

  case 669: /* queue_stmt: "queue" "flags" queue_stmt_flags "to" queue_stmt_expr close_scope_queue  */
#line 4029 "parser_bison.y"
                        {
				(yyval.stmt) = queue_stmt_alloc(&(yyloc), (yyvsp[-1].expr), (yyvsp[-3].val));
			}
#line 12561 "parser_bison.c"
    break;

  case 670: /* queue_stmt: "queue" "flags" queue_stmt_flags "num" queue_stmt_expr_simple close_scope_queue  */
#line 4033 "parser_bison.y"
                        {
				(yyval.stmt) = queue_stmt_alloc(&(yyloc), (yyvsp[-1].expr), (yyvsp[-3].val));
			}
#line 12569 "parser_bison.c"
    break;

  case 673: /* queue_stmt_alloc: "queue"  */
#line 4043 "parser_bison.y"
                        {
				(yyval.stmt) = queue_stmt_alloc(&(yyloc), NULL, 0);
			}
#line 12577 "parser_bison.c"
    break;

  case 674: /* queue_stmt_args: queue_stmt_arg  */
#line 4049 "parser_bison.y"
                        {
				(yyval.stmt)	= (yyvsp[-1].stmt);
			}
#line 12585 "parser_bison.c"
    break;

  case 676: /* queue_stmt_arg: "num" queue_stmt_expr_simple  */
#line 4056 "parser_bison.y"
                        {
				(yyvsp[-2].stmt)->queue.queue = (yyvsp[0].expr);
				(yyvsp[-2].stmt)->queue.queue->location = (yyloc);
			}
#line 12594 "parser_bison.c"
    break;

  case 677: /* queue_stmt_arg: queue_stmt_flags  */
#line 4061 "parser_bison.y"
                        {
				(yyvsp[-1].stmt)->queue.flags |= (yyvsp[0].val);
			}
#line 12602 "parser_bison.c"
    break;

  case 682: /* queue_stmt_expr_simple: queue_expr "-" queue_expr  */
#line 4073 "parser_bison.y"
                        {
				(yyval.expr) = range_expr_alloc(&(yyloc), (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 12610 "parser_bison.c"
    break;

  case 688: /* queue_stmt_flags: queue_stmt_flags "comma" queue_stmt_flag  */
#line 4086 "parser_bison.y"
                        {
				(yyval.val) = (yyvsp[-2].val) | (yyvsp[0].val);
			}
#line 12618 "parser_bison.c"
    break;

  case 689: /* queue_stmt_flag: "bypass"  */
#line 4091 "parser_bison.y"
                                        { (yyval.val) = NFT_QUEUE_FLAG_BYPASS; }
#line 12624 "parser_bison.c"
    break;

  case 690: /* queue_stmt_flag: "fanout"  */
#line 4092 "parser_bison.y"
                                        { (yyval.val) = NFT_QUEUE_FLAG_CPU_FANOUT; }
#line 12630 "parser_bison.c"
    break;

  case 693: /* set_elem_expr_stmt_alloc: concat_expr  */
#line 4100 "parser_bison.y"
                        {
				(yyval.expr) = set_elem_expr_alloc(&(yylsp[0]), (yyvsp[0].expr));
			}
#line 12638 "parser_bison.c"
    break;

  case 694: /* set_stmt: "set" set_stmt_op set_elem_expr_stmt set_ref_expr  */
#line 4106 "parser_bison.y"
                        {
				(yyval.stmt) = set_stmt_alloc(&(yyloc));
				(yyval.stmt)->set.op  = (yyvsp[-2].val);
				(yyval.stmt)->set.key = (yyvsp[-1].expr);
				(yyval.stmt)->set.set = (yyvsp[0].expr);
			}
#line 12649 "parser_bison.c"
    break;

  case 695: /* set_stmt: set_stmt_op set_ref_expr '{' set_elem_expr_stmt '}'  */
#line 4113 "parser_bison.y"
                        {
				(yyval.stmt) = set_stmt_alloc(&(yyloc));
				(yyval.stmt)->set.op  = (yyvsp[-4].val);
				(yyval.stmt)->set.key = (yyvsp[-1].expr);
				(yyval.stmt)->set.set = (yyvsp[-3].expr);
			}
#line 12660 "parser_bison.c"
    break;

  case 696: /* set_stmt: set_stmt_op set_ref_expr '{' set_elem_expr_stmt stateful_stmt_list '}'  */
#line 4120 "parser_bison.y"
                        {
				(yyval.stmt) = set_stmt_alloc(&(yyloc));
				(yyval.stmt)->set.op  = (yyvsp[-5].val);
				(yyval.stmt)->set.key = (yyvsp[-2].expr);
				(yyval.stmt)->set.set = (yyvsp[-4].expr);
				list_splice_tail((yyvsp[-1].list), &(yyval.stmt)->set.stmt_list);
				free((yyvsp[-1].list));
			}
#line 12673 "parser_bison.c"
    break;

  case 697: /* set_stmt_op: "add"  */
#line 4130 "parser_bison.y"
                                        { (yyval.val) = NFT_DYNSET_OP_ADD; }
#line 12679 "parser_bison.c"
    break;

  case 698: /* set_stmt_op: "update"  */
#line 4131 "parser_bison.y"
                                        { (yyval.val) = NFT_DYNSET_OP_UPDATE; }
#line 12685 "parser_bison.c"
    break;

  case 699: /* set_stmt_op: "delete"  */
#line 4132 "parser_bison.y"
                                        { (yyval.val) = NFT_DYNSET_OP_DELETE; }
#line 12691 "parser_bison.c"
    break;

  case 700: /* map_stmt: set_stmt_op set_ref_expr '{' set_elem_expr_stmt "colon" set_elem_expr_stmt '}'  */
#line 4136 "parser_bison.y"
                        {
				(yyval.stmt) = map_stmt_alloc(&(yyloc));
				(yyval.stmt)->map.op  = (yyvsp[-6].val);
				(yyval.stmt)->map.key = (yyvsp[-3].expr);
				(yyval.stmt)->map.data = (yyvsp[-1].expr);
				(yyval.stmt)->map.set = (yyvsp[-5].expr);
			}
#line 12703 "parser_bison.c"
    break;

  case 701: /* map_stmt: set_stmt_op set_ref_expr '{' set_elem_expr_stmt stateful_stmt_list "colon" set_elem_expr_stmt '}'  */
#line 4144 "parser_bison.y"
                        {
				(yyval.stmt) = map_stmt_alloc(&(yyloc));
				(yyval.stmt)->map.op  = (yyvsp[-7].val);
				(yyval.stmt)->map.key = (yyvsp[-4].expr);
				(yyval.stmt)->map.data = (yyvsp[-1].expr);
				(yyval.stmt)->map.set = (yyvsp[-6].expr);
				list_splice_tail((yyvsp[-3].list), &(yyval.stmt)->map.stmt_list);
				free((yyvsp[-3].list));
			}
#line 12717 "parser_bison.c"
    break;

  case 702: /* meter_stmt: flow_stmt_legacy_alloc "table" identifier '{' meter_key_expr stmt '}'  */
#line 4156 "parser_bison.y"
                        {
				(yyvsp[-6].stmt)->meter.name = (yyvsp[-4].string);
				(yyvsp[-6].stmt)->meter.key  = (yyvsp[-2].expr);
				(yyvsp[-6].stmt)->meter.stmt = (yyvsp[-1].stmt);
				(yyval.stmt)->location  = (yyloc);
				(yyval.stmt) = (yyvsp[-6].stmt);
			}
#line 12729 "parser_bison.c"
    break;

  case 703: /* meter_stmt: meter_stmt_alloc  */
#line 4163 "parser_bison.y"
                                                                { (yyval.stmt) = (yyvsp[0].stmt); }
#line 12735 "parser_bison.c"
    break;

  case 704: /* flow_stmt_legacy_alloc: "flow"  */
#line 4167 "parser_bison.y"
                        {
				(yyval.stmt) = meter_stmt_alloc(&(yyloc));
			}
#line 12743 "parser_bison.c"
    break;

  case 705: /* meter_stmt_alloc: "meter" identifier '{' meter_key_expr stmt '}'  */
#line 4173 "parser_bison.y"
                        {
				(yyval.stmt) = meter_stmt_alloc(&(yyloc));
				(yyval.stmt)->meter.name = (yyvsp[-4].string);
				(yyval.stmt)->meter.size = 0;
				(yyval.stmt)->meter.key  = (yyvsp[-2].expr);
				(yyval.stmt)->meter.stmt = (yyvsp[-1].stmt);
				(yyval.stmt)->location  = (yyloc);
			}
#line 12756 "parser_bison.c"
    break;

  case 706: /* meter_stmt_alloc: "meter" identifier "size" "number" '{' meter_key_expr stmt '}'  */
#line 4182 "parser_bison.y"
                        {
				(yyval.stmt) = meter_stmt_alloc(&(yyloc));
				(yyval.stmt)->meter.name = (yyvsp[-6].string);
				(yyval.stmt)->meter.size = (yyvsp[-4].val);
				(yyval.stmt)->meter.key  = (yyvsp[-2].expr);
				(yyval.stmt)->meter.stmt = (yyvsp[-1].stmt);
				(yyval.stmt)->location  = (yyloc);
			}
#line 12769 "parser_bison.c"
    break;

  case 707: /* match_stmt: relational_expr  */
#line 4193 "parser_bison.y"
                        {
				(yyval.stmt) = expr_stmt_alloc(&(yyloc), (yyvsp[0].expr));
			}
#line 12777 "parser_bison.c"
    break;

  case 708: /* variable_expr: '$' identifier  */
#line 4199 "parser_bison.y"
                        {
				struct scope *scope = current_scope(state);
				struct symbol *sym;

				sym = symbol_get(scope, (yyvsp[0].string));
				if (!sym) {
					sym = symbol_lookup_fuzzy(scope, (yyvsp[0].string));
					if (sym) {
						erec_queue(error(&(yylsp[0]), "unknown identifier '%s'; "
								      "did you mean identifier ‘%s’?",
								      (yyvsp[0].string), sym->identifier),
							   state->msgs);
					} else {
						erec_queue(error(&(yylsp[0]), "unknown identifier '%s'", (yyvsp[0].string)),
							   state->msgs);
					}
					xfree((yyvsp[0].string));
					YYERROR;
				}

				(yyval.expr) = variable_expr_alloc(&(yyloc), scope, sym);
				xfree((yyvsp[0].string));
			}
#line 12805 "parser_bison.c"
    break;

  case 710: /* symbol_expr: string  */
#line 4226 "parser_bison.y"
                        {
				(yyval.expr) = symbol_expr_alloc(&(yyloc), SYMBOL_VALUE,
						       current_scope(state),
						       (yyvsp[0].string));
				xfree((yyvsp[0].string));
			}
#line 12816 "parser_bison.c"
    break;

  case 713: /* set_ref_symbol_expr: "@" identifier close_scope_at  */
#line 4239 "parser_bison.y"
                        {
				(yyval.expr) = symbol_expr_alloc(&(yyloc), SYMBOL_SET,
						       current_scope(state),
						       (yyvsp[-1].string));
				xfree((yyvsp[-1].string));
			}
#line 12827 "parser_bison.c"
    break;

  case 714: /* integer_expr: "number"  */
#line 4248 "parser_bison.y"
                        {
				char str[64];

				snprintf(str, sizeof(str), "%" PRIu64, (yyvsp[0].val));
				(yyval.expr) = symbol_expr_alloc(&(yyloc), SYMBOL_VALUE,
						       current_scope(state),
						       str);
			}
#line 12840 "parser_bison.c"
    break;

  case 715: /* selector_expr: payload_expr  */
#line 4258 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12846 "parser_bison.c"
    break;

  case 716: /* selector_expr: exthdr_expr  */
#line 4259 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12852 "parser_bison.c"
    break;

  case 717: /* selector_expr: exthdr_exists_expr  */
#line 4260 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12858 "parser_bison.c"
    break;

  case 718: /* selector_expr: meta_expr  */
#line 4261 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12864 "parser_bison.c"
    break;

  case 719: /* selector_expr: socket_expr  */
#line 4262 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12870 "parser_bison.c"
    break;

  case 720: /* selector_expr: rt_expr  */
#line 4263 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12876 "parser_bison.c"
    break;

  case 721: /* selector_expr: ct_expr  */
#line 4264 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12882 "parser_bison.c"
    break;

  case 722: /* selector_expr: numgen_expr  */
#line 4265 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12888 "parser_bison.c"
    break;

  case 723: /* selector_expr: hash_expr  */
#line 4266 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12894 "parser_bison.c"
    break;

  case 724: /* selector_expr: fib_expr  */
#line 4267 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12900 "parser_bison.c"
    break;

  case 725: /* selector_expr: osf_expr  */
#line 4268 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12906 "parser_bison.c"
    break;

  case 726: /* selector_expr: xfrm_expr  */
#line 4269 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12912 "parser_bison.c"
    break;

  case 727: /* primary_expr: symbol_expr  */
#line 4272 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12918 "parser_bison.c"
    break;

  case 728: /* primary_expr: integer_expr  */
#line 4273 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12924 "parser_bison.c"
    break;

  case 729: /* primary_expr: selector_expr  */
#line 4274 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[0].expr); }
#line 12930 "parser_bison.c"
    break;

  case 730: /* primary_expr: '(' basic_expr ')'  */
#line 4275 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[-1].expr); }
#line 12936 "parser_bison.c"
    break;

  case 731: /* fib_expr: "fib" fib_tuple fib_result close_scope_fib  */
#line 4279 "parser_bison.y"
                        {
				if (((yyvsp[-2].val) & (NFTA_FIB_F_SADDR|NFTA_FIB_F_DADDR)) == 0) {
					erec_queue(error(&(yylsp[-2]), "fib: need either saddr or daddr"), state->msgs);
					YYERROR;
				}

				if (((yyvsp[-2].val) & (NFTA_FIB_F_SADDR|NFTA_FIB_F_DADDR)) ==
					  (NFTA_FIB_F_SADDR|NFTA_FIB_F_DADDR)) {
					erec_queue(error(&(yylsp[-2]), "fib: saddr and daddr are mutually exclusive"), state->msgs);
					YYERROR;
				}

				if (((yyvsp[-2].val) & (NFTA_FIB_F_IIF|NFTA_FIB_F_OIF)) ==
					  (NFTA_FIB_F_IIF|NFTA_FIB_F_OIF)) {
					erec_queue(error(&(yylsp[-2]), "fib: iif and oif are mutually exclusive"), state->msgs);
					YYERROR;
				}

				(yyval.expr) = fib_expr_alloc(&(yyloc), (yyvsp[-2].val), (yyvsp[-1].val));
			}
#line 12961 "parser_bison.c"
    break;

  case 732: /* fib_result: "oif"  */
#line 4301 "parser_bison.y"
                                        { (yyval.val) =NFT_FIB_RESULT_OIF; }
#line 12967 "parser_bison.c"
    break;

  case 733: /* fib_result: "oifname"  */
#line 4302 "parser_bison.y"
                                        { (yyval.val) =NFT_FIB_RESULT_OIFNAME; }
#line 12973 "parser_bison.c"
    break;

  case 734: /* fib_result: "type" close_scope_type  */
#line 4303 "parser_bison.y"
                                                                { (yyval.val) =NFT_FIB_RESULT_ADDRTYPE; }
#line 12979 "parser_bison.c"
    break;

  case 735: /* fib_flag: "saddr"  */
#line 4306 "parser_bison.y"
                                        { (yyval.val) = NFTA_FIB_F_SADDR; }
#line 12985 "parser_bison.c"
    break;

  case 736: /* fib_flag: "daddr"  */
#line 4307 "parser_bison.y"
                                        { (yyval.val) = NFTA_FIB_F_DADDR; }
#line 12991 "parser_bison.c"
    break;

  case 737: /* fib_flag: "mark"  */
#line 4308 "parser_bison.y"
                                        { (yyval.val) = NFTA_FIB_F_MARK; }
#line 12997 "parser_bison.c"
    break;

  case 738: /* fib_flag: "iif"  */
#line 4309 "parser_bison.y"
                                        { (yyval.val) = NFTA_FIB_F_IIF; }
#line 13003 "parser_bison.c"
    break;

  case 739: /* fib_flag: "oif"  */
#line 4310 "parser_bison.y"
                                        { (yyval.val) = NFTA_FIB_F_OIF; }
#line 13009 "parser_bison.c"
    break;

  case 740: /* fib_tuple: fib_flag "." fib_tuple  */
#line 4314 "parser_bison.y"
                        {
				(yyval.val) = (yyvsp[-2].val) | (yyvsp[0].val);
			}
#line 13017 "parser_bison.c"
    break;

  case 742: /* osf_expr: "osf" osf_ttl "version" close_scope_osf  */
#line 4321 "parser_bison.y"
                        {
				(yyval.expr) = osf_expr_alloc(&(yyloc), (yyvsp[-2].val), NFT_OSF_F_VERSION);
			}
#line 13025 "parser_bison.c"
    break;

  case 743: /* osf_expr: "osf" osf_ttl "name" close_scope_osf  */
#line 4325 "parser_bison.y"
                        {
				(yyval.expr) = osf_expr_alloc(&(yyloc), (yyvsp[-2].val), 0);
			}
#line 13033 "parser_bison.c"
    break;

  case 744: /* osf_ttl: %empty  */
#line 4331 "parser_bison.y"
                        {
				(yyval.val) = NF_OSF_TTL_TRUE;
			}
#line 13041 "parser_bison.c"
    break;

  case 745: /* osf_ttl: "ttl" "string"  */
#line 4335 "parser_bison.y"
                        {
				if (!strcmp((yyvsp[0].string), "loose"))
					(yyval.val) = NF_OSF_TTL_LESS;
				else if (!strcmp((yyvsp[0].string), "skip"))
					(yyval.val) = NF_OSF_TTL_NOCHECK;
				else {
					erec_queue(error(&(yylsp[0]), "invalid ttl option"),
						   state->msgs);
					xfree((yyvsp[0].string));
					YYERROR;
				}
				xfree((yyvsp[0].string));
			}
#line 13059 "parser_bison.c"
    break;

  case 747: /* shift_expr: shift_expr "<<" primary_rhs_expr  */
#line 4352 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_LSHIFT, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13067 "parser_bison.c"
    break;

  case 748: /* shift_expr: shift_expr ">>" primary_rhs_expr  */
#line 4356 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_RSHIFT, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13075 "parser_bison.c"
    break;

  case 750: /* and_expr: and_expr "&" shift_rhs_expr  */
#line 4363 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_AND, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13083 "parser_bison.c"
    break;

  case 752: /* exclusive_or_expr: exclusive_or_expr "^" and_rhs_expr  */
#line 4370 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_XOR, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13091 "parser_bison.c"
    break;

  case 754: /* inclusive_or_expr: inclusive_or_expr '|' exclusive_or_rhs_expr  */
#line 4377 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_OR, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13099 "parser_bison.c"
    break;

  case 757: /* concat_expr: concat_expr "." basic_expr  */
#line 4387 "parser_bison.y"
                        {
				struct location rhs[] = {
					[1]	= (yylsp[-1]),
					[2]	= (yylsp[0]),
				};

				(yyval.expr) = handle_concat_expr(&(yyloc), (yyval.expr), (yyvsp[-2].expr), (yyvsp[0].expr), rhs);
			}
#line 13112 "parser_bison.c"
    break;

  case 758: /* prefix_rhs_expr: basic_rhs_expr "/" "number"  */
#line 4398 "parser_bison.y"
                        {
				(yyval.expr) = prefix_expr_alloc(&(yyloc), (yyvsp[-2].expr), (yyvsp[0].val));
			}
#line 13120 "parser_bison.c"
    break;

  case 759: /* range_rhs_expr: basic_rhs_expr "-" basic_rhs_expr  */
#line 4404 "parser_bison.y"
                        {
				(yyval.expr) = range_expr_alloc(&(yyloc), (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13128 "parser_bison.c"
    break;

  case 762: /* map_expr: concat_expr "map" rhs_expr  */
#line 4414 "parser_bison.y"
                        {
				(yyval.expr) = map_expr_alloc(&(yyloc), (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13136 "parser_bison.c"
    break;

  case 766: /* set_expr: '{' set_list_expr '}'  */
#line 4425 "parser_bison.y"
                        {
				(yyvsp[-1].expr)->location = (yyloc);
				(yyval.expr) = (yyvsp[-1].expr);
			}
#line 13145 "parser_bison.c"
    break;

  case 767: /* set_list_expr: set_list_member_expr  */
#line 4432 "parser_bison.y"
                        {
				(yyval.expr) = set_expr_alloc(&(yyloc), NULL);
				compound_expr_add((yyval.expr), (yyvsp[0].expr));
			}
#line 13154 "parser_bison.c"
    break;

  case 768: /* set_list_expr: set_list_expr "comma" set_list_member_expr  */
#line 4437 "parser_bison.y"
                        {
				compound_expr_add((yyvsp[-2].expr), (yyvsp[0].expr));
				(yyval.expr) = (yyvsp[-2].expr);
			}
#line 13163 "parser_bison.c"
    break;

  case 770: /* set_list_member_expr: opt_newline set_expr opt_newline  */
#line 4445 "parser_bison.y"
                        {
				(yyval.expr) = (yyvsp[-1].expr);
			}
#line 13171 "parser_bison.c"
    break;

  case 771: /* set_list_member_expr: opt_newline set_elem_expr opt_newline  */
#line 4449 "parser_bison.y"
                        {
				(yyval.expr) = (yyvsp[-1].expr);
			}
#line 13179 "parser_bison.c"
    break;

  case 772: /* set_list_member_expr: opt_newline set_elem_expr "colon" set_rhs_expr opt_newline  */
#line 4453 "parser_bison.y"
                        {
				(yyval.expr) = mapping_expr_alloc(&(yylsp[-3]), (yyvsp[-3].expr), (yyvsp[-1].expr));
			}
#line 13187 "parser_bison.c"
    break;

  case 774: /* meter_key_expr: meter_key_expr_alloc set_elem_options  */
#line 4460 "parser_bison.y"
                        {
				(yyval.expr)->location = (yyloc);
				(yyval.expr) = (yyvsp[-1].expr);
			}
#line 13196 "parser_bison.c"
    break;

  case 775: /* meter_key_expr_alloc: concat_expr  */
#line 4467 "parser_bison.y"
                        {
				(yyval.expr) = set_elem_expr_alloc(&(yylsp[0]), (yyvsp[0].expr));
			}
#line 13204 "parser_bison.c"
    break;

  case 778: /* set_elem_expr: set_elem_expr_alloc set_elem_expr_options set_elem_stmt_list  */
#line 4475 "parser_bison.y"
                        {
				(yyval.expr) = (yyvsp[-2].expr);
				list_splice_tail((yyvsp[0].list), &(yyval.expr)->stmt_list);
				xfree((yyvsp[0].list));
			}
#line 13214 "parser_bison.c"
    break;

  case 779: /* set_elem_key_expr: set_lhs_expr  */
#line 4482 "parser_bison.y"
                                                        { (yyval.expr) = (yyvsp[0].expr); }
#line 13220 "parser_bison.c"
    break;

  case 780: /* set_elem_key_expr: "*"  */
#line 4483 "parser_bison.y"
                                                        { (yyval.expr) = set_elem_catchall_expr_alloc(&(yylsp[0])); }
#line 13226 "parser_bison.c"
    break;

  case 781: /* set_elem_expr_alloc: set_elem_key_expr set_elem_stmt_list  */
#line 4487 "parser_bison.y"
                        {
				(yyval.expr) = set_elem_expr_alloc(&(yylsp[-1]), (yyvsp[-1].expr));
				list_splice_tail((yyvsp[0].list), &(yyval.expr)->stmt_list);
				xfree((yyvsp[0].list));
			}
#line 13236 "parser_bison.c"
    break;

  case 782: /* set_elem_expr_alloc: set_elem_key_expr  */
#line 4493 "parser_bison.y"
                        {
				(yyval.expr) = set_elem_expr_alloc(&(yylsp[0]), (yyvsp[0].expr));
			}
#line 13244 "parser_bison.c"
    break;

  case 783: /* set_elem_options: set_elem_option  */
#line 4499 "parser_bison.y"
                        {
				(yyval.expr)	= (yyvsp[-1].expr);
			}
#line 13252 "parser_bison.c"
    break;

  case 785: /* set_elem_option: "timeout" time_spec  */
#line 4506 "parser_bison.y"
                        {
				(yyvsp[-2].expr)->timeout = (yyvsp[0].val);
			}
#line 13260 "parser_bison.c"
    break;

  case 786: /* set_elem_option: "expires" time_spec  */
#line 4510 "parser_bison.y"
                        {
				(yyvsp[-2].expr)->expiration = (yyvsp[0].val);
			}
#line 13268 "parser_bison.c"
    break;

  case 787: /* set_elem_option: comment_spec  */
#line 4514 "parser_bison.y"
                        {
				if (already_set((yyvsp[-1].expr)->comment, &(yylsp[0]), state)) {
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyvsp[-1].expr)->comment = (yyvsp[0].string);
			}
#line 13280 "parser_bison.c"
    break;

  case 788: /* set_elem_expr_options: set_elem_expr_option  */
#line 4524 "parser_bison.y"
                        {
				(yyval.expr)	= (yyvsp[-1].expr);
			}
#line 13288 "parser_bison.c"
    break;

  case 790: /* set_elem_stmt_list: set_elem_stmt  */
#line 4531 "parser_bison.y"
                        {
				(yyval.list) = xmalloc(sizeof(*(yyval.list)));
				init_list_head((yyval.list));
				list_add_tail(&(yyvsp[0].stmt)->list, (yyval.list));
			}
#line 13298 "parser_bison.c"
    break;

  case 791: /* set_elem_stmt_list: set_elem_stmt_list set_elem_stmt  */
#line 4537 "parser_bison.y"
                        {
				(yyval.list) = (yyvsp[-1].list);
				list_add_tail(&(yyvsp[0].stmt)->list, (yyvsp[-1].list));
			}
#line 13307 "parser_bison.c"
    break;

  case 792: /* set_elem_stmt: "counter" close_scope_counter  */
#line 4544 "parser_bison.y"
                        {
				(yyval.stmt) = counter_stmt_alloc(&(yyloc));
			}
#line 13315 "parser_bison.c"
    break;

  case 793: /* set_elem_stmt: "counter" "packets" "number" "bytes" "number" close_scope_counter  */
#line 4548 "parser_bison.y"
                        {
				(yyval.stmt) = counter_stmt_alloc(&(yyloc));
				(yyval.stmt)->counter.packets = (yyvsp[-3].val);
				(yyval.stmt)->counter.bytes = (yyvsp[-1].val);
			}
#line 13325 "parser_bison.c"
    break;

  case 794: /* set_elem_stmt: "limit" "rate" limit_mode limit_rate_pkts limit_burst_pkts close_scope_limit  */
#line 4554 "parser_bison.y"
                        {
				if ((yyvsp[-1].val) == 0) {
					erec_queue(error(&(yylsp[-1]), "limit burst must be > 0"),
						   state->msgs);
					YYERROR;
				}
				(yyval.stmt) = limit_stmt_alloc(&(yyloc));
				(yyval.stmt)->limit.rate  = (yyvsp[-2].limit_rate).rate;
				(yyval.stmt)->limit.unit  = (yyvsp[-2].limit_rate).unit;
				(yyval.stmt)->limit.burst = (yyvsp[-1].val);
				(yyval.stmt)->limit.type  = NFT_LIMIT_PKTS;
				(yyval.stmt)->limit.flags = (yyvsp[-3].val);
			}
#line 13343 "parser_bison.c"
    break;

  case 795: /* set_elem_stmt: "limit" "rate" limit_mode limit_rate_bytes limit_burst_bytes close_scope_limit  */
#line 4568 "parser_bison.y"
                        {
				(yyval.stmt) = limit_stmt_alloc(&(yyloc));
				(yyval.stmt)->limit.rate  = (yyvsp[-2].limit_rate).rate;
				(yyval.stmt)->limit.unit  = (yyvsp[-2].limit_rate).unit;
				(yyval.stmt)->limit.burst = (yyvsp[-1].val);
				(yyval.stmt)->limit.type  = NFT_LIMIT_PKT_BYTES;
				(yyval.stmt)->limit.flags = (yyvsp[-3].val);
			}
#line 13356 "parser_bison.c"
    break;

  case 796: /* set_elem_stmt: "ct" "count" "number" close_scope_ct  */
#line 4577 "parser_bison.y"
                        {
				(yyval.stmt) = connlimit_stmt_alloc(&(yyloc));
				(yyval.stmt)->connlimit.count	= (yyvsp[-1].val);
			}
#line 13365 "parser_bison.c"
    break;

  case 797: /* set_elem_stmt: "ct" "count" "over" "number" close_scope_ct  */
#line 4582 "parser_bison.y"
                        {
				(yyval.stmt) = connlimit_stmt_alloc(&(yyloc));
				(yyval.stmt)->connlimit.count = (yyvsp[-1].val);
				(yyval.stmt)->connlimit.flags = NFT_CONNLIMIT_F_INV;
			}
#line 13375 "parser_bison.c"
    break;

  case 798: /* set_elem_stmt: "quota" quota_mode "number" quota_unit quota_used close_scope_quota  */
#line 4588 "parser_bison.y"
                        {
				struct error_record *erec;
				uint64_t rate;

				erec = data_unit_parse(&(yyloc), (yyvsp[-2].string), &rate);
				xfree((yyvsp[-2].string));
				if (erec != NULL) {
					erec_queue(erec, state->msgs);
					YYERROR;
				}
				(yyval.stmt) = quota_stmt_alloc(&(yyloc));
				(yyval.stmt)->quota.bytes	= (yyvsp[-3].val) * rate;
				(yyval.stmt)->quota.used = (yyvsp[-1].val);
				(yyval.stmt)->quota.flags	= (yyvsp[-4].val);
			}
#line 13395 "parser_bison.c"
    break;

  case 799: /* set_elem_expr_option: "timeout" time_spec  */
#line 4606 "parser_bison.y"
                        {
				(yyvsp[-2].expr)->timeout = (yyvsp[0].val);
			}
#line 13403 "parser_bison.c"
    break;

  case 800: /* set_elem_expr_option: "expires" time_spec  */
#line 4610 "parser_bison.y"
                        {
				(yyvsp[-2].expr)->expiration = (yyvsp[0].val);
			}
#line 13411 "parser_bison.c"
    break;

  case 801: /* set_elem_expr_option: comment_spec  */
#line 4614 "parser_bison.y"
                        {
				if (already_set((yyvsp[-1].expr)->comment, &(yylsp[0]), state)) {
					xfree((yyvsp[0].string));
					YYERROR;
				}
				(yyvsp[-1].expr)->comment = (yyvsp[0].string);
			}
#line 13423 "parser_bison.c"
    break;

  case 807: /* initializer_expr: '{' '}'  */
#line 4632 "parser_bison.y"
                                                { (yyval.expr) = compound_expr_alloc(&(yyloc), EXPR_SET); }
#line 13429 "parser_bison.c"
    break;

  case 808: /* initializer_expr: "-" "number"  */
#line 4634 "parser_bison.y"
                        {
				int32_t num = -(yyvsp[0].val);

				(yyval.expr) = constant_expr_alloc(&(yyloc), &integer_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(num) * BITS_PER_BYTE,
							 &num);
			}
#line 13442 "parser_bison.c"
    break;

  case 809: /* counter_config: "packets" "number" "bytes" "number"  */
#line 4645 "parser_bison.y"
                        {
				struct counter *counter;

				counter = &(yyvsp[-4].obj)->counter;
				counter->packets = (yyvsp[-2].val);
				counter->bytes = (yyvsp[0].val);
			}
#line 13454 "parser_bison.c"
    break;

  case 810: /* counter_obj: %empty  */
#line 4655 "parser_bison.y"
                        {
				(yyval.obj) = obj_alloc(&(yyloc));
				(yyval.obj)->type = NFT_OBJECT_COUNTER;
			}
#line 13463 "parser_bison.c"
    break;

  case 811: /* quota_config: quota_mode "number" quota_unit quota_used  */
#line 4662 "parser_bison.y"
                        {
				struct error_record *erec;
				struct quota *quota;
				uint64_t rate;

				erec = data_unit_parse(&(yyloc), (yyvsp[-1].string), &rate);
				xfree((yyvsp[-1].string));
				if (erec != NULL) {
					erec_queue(erec, state->msgs);
					YYERROR;
				}

				quota = &(yyvsp[-4].obj)->quota;
				quota->bytes	= (yyvsp[-2].val) * rate;
				quota->used	= (yyvsp[0].val);
				quota->flags	= (yyvsp[-3].val);
			}
#line 13485 "parser_bison.c"
    break;

  case 812: /* quota_obj: %empty  */
#line 4682 "parser_bison.y"
                        {
				(yyval.obj) = obj_alloc(&(yyloc));
				(yyval.obj)->type = NFT_OBJECT_QUOTA;
			}
#line 13494 "parser_bison.c"
    break;

  case 813: /* secmark_config: string  */
#line 4689 "parser_bison.y"
                        {
				int ret;
				struct secmark *secmark;

				secmark = &(yyvsp[-1].obj)->secmark;
				ret = snprintf(secmark->ctx, sizeof(secmark->ctx), "%s", (yyvsp[0].string));
				if (ret <= 0 || ret >= (int)sizeof(secmark->ctx)) {
					erec_queue(error(&(yylsp[0]), "invalid context '%s', max length is %u\n", (yyvsp[0].string), (int)sizeof(secmark->ctx)), state->msgs);
					xfree((yyvsp[0].string));
					YYERROR;
				}
				xfree((yyvsp[0].string));
			}
#line 13512 "parser_bison.c"
    break;

  case 814: /* secmark_obj: %empty  */
#line 4705 "parser_bison.y"
                        {
				(yyval.obj) = obj_alloc(&(yyloc));
				(yyval.obj)->type = NFT_OBJECT_SECMARK;
			}
#line 13521 "parser_bison.c"
    break;

  case 815: /* ct_obj_type: "helper"  */
#line 4711 "parser_bison.y"
                                                { (yyval.val) = NFT_OBJECT_CT_HELPER; }
#line 13527 "parser_bison.c"
    break;

  case 816: /* ct_obj_type: "timeout"  */
#line 4712 "parser_bison.y"
                                                { (yyval.val) = NFT_OBJECT_CT_TIMEOUT; }
#line 13533 "parser_bison.c"
    break;

  case 817: /* ct_obj_type: "expectation"  */
#line 4713 "parser_bison.y"
                                                { (yyval.val) = NFT_OBJECT_CT_EXPECT; }
#line 13539 "parser_bison.c"
    break;

  case 818: /* ct_cmd_type: "helpers"  */
#line 4716 "parser_bison.y"
                                                { (yyval.val) = CMD_OBJ_CT_HELPERS; }
#line 13545 "parser_bison.c"
    break;

  case 819: /* ct_cmd_type: "timeout"  */
#line 4717 "parser_bison.y"
                                                { (yyval.val) = CMD_OBJ_CT_TIMEOUTS; }
#line 13551 "parser_bison.c"
    break;

  case 820: /* ct_cmd_type: "expectation"  */
#line 4718 "parser_bison.y"
                                                { (yyval.val) = CMD_OBJ_CT_EXPECTATIONS; }
#line 13557 "parser_bison.c"
    break;

  case 821: /* ct_l4protoname: "tcp" close_scope_tcp  */
#line 4721 "parser_bison.y"
                                                        { (yyval.val) = IPPROTO_TCP; }
#line 13563 "parser_bison.c"
    break;

  case 822: /* ct_l4protoname: "udp" close_scope_udp  */
#line 4722 "parser_bison.y"
                                                        { (yyval.val) = IPPROTO_UDP; }
#line 13569 "parser_bison.c"
    break;

  case 823: /* ct_helper_config: "type" "quoted string" "protocol" ct_l4protoname stmt_separator close_scope_type  */
#line 4726 "parser_bison.y"
                        {
				struct ct_helper *ct;
				int ret;

				ct = &(yyvsp[-6].obj)->ct_helper;

				if (ct->l4proto) {
					erec_queue(error(&(yylsp[-4]), "You can only specify this once. This statement is already set for %s.", ct->name), state->msgs);
					xfree((yyvsp[-4].string));
					YYERROR;
				}

				ret = snprintf(ct->name, sizeof(ct->name), "%s", (yyvsp[-4].string));
				if (ret <= 0 || ret >= (int)sizeof(ct->name)) {
					erec_queue(error(&(yylsp[-4]), "invalid name '%s', max length is %u\n", (yyvsp[-4].string), (int)sizeof(ct->name)), state->msgs);
					xfree((yyvsp[-4].string));
					YYERROR;
				}
				xfree((yyvsp[-4].string));

				ct->l4proto = (yyvsp[-2].val);
			}
#line 13596 "parser_bison.c"
    break;

  case 824: /* ct_helper_config: "l3proto" family_spec_explicit stmt_separator  */
#line 4749 "parser_bison.y"
                        {
				(yyvsp[-3].obj)->ct_helper.l3proto = (yyvsp[-1].val);
			}
#line 13604 "parser_bison.c"
    break;

  case 825: /* timeout_states: timeout_state  */
#line 4755 "parser_bison.y"
                        {
				(yyval.list) = xmalloc(sizeof(*(yyval.list)));
				init_list_head((yyval.list));
				list_add_tail(&(yyvsp[0].timeout_state)->head, (yyval.list));
			}
#line 13614 "parser_bison.c"
    break;

  case 826: /* timeout_states: timeout_states "comma" timeout_state  */
#line 4761 "parser_bison.y"
                        {
				list_add_tail(&(yyvsp[0].timeout_state)->head, (yyvsp[-2].list));
				(yyval.list) = (yyvsp[-2].list);
			}
#line 13623 "parser_bison.c"
    break;

  case 827: /* timeout_state: "string" "colon" time_spec_or_num_s  */
#line 4768 "parser_bison.y"
                        {
				struct timeout_state *ts;

				ts = xzalloc(sizeof(*ts));
				ts->timeout_str = (yyvsp[-2].string);
				ts->timeout_value = (yyvsp[0].val);
				ts->location = (yylsp[-2]);
				init_list_head(&ts->head);
				(yyval.timeout_state) = ts;
			}
#line 13638 "parser_bison.c"
    break;

  case 828: /* ct_timeout_config: "protocol" ct_l4protoname stmt_separator  */
#line 4781 "parser_bison.y"
                        {
				struct ct_timeout *ct;
				int l4proto = (yyvsp[-1].val);

				ct = &(yyvsp[-3].obj)->ct_timeout;
				ct->l4proto = l4proto;
			}
#line 13650 "parser_bison.c"
    break;

  case 829: /* ct_timeout_config: "policy" '=' '{' timeout_states '}' stmt_separator close_scope_policy  */
#line 4789 "parser_bison.y"
                        {
				struct ct_timeout *ct;

				ct = &(yyvsp[-7].obj)->ct_timeout;
				list_splice_tail((yyvsp[-3].list), &ct->timeout_list);
				xfree((yyvsp[-3].list));
			}
#line 13662 "parser_bison.c"
    break;

  case 830: /* ct_timeout_config: "l3proto" family_spec_explicit stmt_separator  */
#line 4797 "parser_bison.y"
                        {
				(yyvsp[-3].obj)->ct_timeout.l3proto = (yyvsp[-1].val);
			}
#line 13670 "parser_bison.c"
    break;

  case 831: /* ct_expect_config: "protocol" ct_l4protoname stmt_separator  */
#line 4803 "parser_bison.y"
                        {
				(yyvsp[-3].obj)->ct_expect.l4proto = (yyvsp[-1].val);
			}
#line 13678 "parser_bison.c"
    break;

  case 832: /* ct_expect_config: "dport" "number" stmt_separator  */
#line 4807 "parser_bison.y"
                        {
				(yyvsp[-3].obj)->ct_expect.dport = (yyvsp[-1].val);
			}
#line 13686 "parser_bison.c"
    break;

  case 833: /* ct_expect_config: "timeout" time_spec stmt_separator  */
#line 4811 "parser_bison.y"
                        {
				(yyvsp[-3].obj)->ct_expect.timeout = (yyvsp[-1].val);
			}
#line 13694 "parser_bison.c"
    break;

  case 834: /* ct_expect_config: "size" "number" stmt_separator  */
#line 4815 "parser_bison.y"
                        {
				(yyvsp[-3].obj)->ct_expect.size = (yyvsp[-1].val);
			}
#line 13702 "parser_bison.c"
    break;

  case 835: /* ct_expect_config: "l3proto" family_spec_explicit stmt_separator  */
#line 4819 "parser_bison.y"
                        {
				(yyvsp[-3].obj)->ct_expect.l3proto = (yyvsp[-1].val);
			}
#line 13710 "parser_bison.c"
    break;

  case 836: /* ct_obj_alloc: %empty  */
#line 4825 "parser_bison.y"
                        {
				(yyval.obj) = obj_alloc(&(yyloc));
			}
#line 13718 "parser_bison.c"
    break;

  case 837: /* limit_config: "rate" limit_mode limit_rate_pkts limit_burst_pkts  */
#line 4831 "parser_bison.y"
                        {
				struct limit *limit;

				limit = &(yyvsp[-4].obj)->limit;
				limit->rate	= (yyvsp[-1].limit_rate).rate;
				limit->unit	= (yyvsp[-1].limit_rate).unit;
				limit->burst	= (yyvsp[0].val);
				limit->type	= NFT_LIMIT_PKTS;
				limit->flags	= (yyvsp[-2].val);
			}
#line 13733 "parser_bison.c"
    break;

  case 838: /* limit_config: "rate" limit_mode limit_rate_bytes limit_burst_bytes  */
#line 4842 "parser_bison.y"
                        {
				struct limit *limit;

				limit = &(yyvsp[-4].obj)->limit;
				limit->rate	= (yyvsp[-1].limit_rate).rate;
				limit->unit	= (yyvsp[-1].limit_rate).unit;
				limit->burst	= (yyvsp[0].val);
				limit->type	= NFT_LIMIT_PKT_BYTES;
				limit->flags	= (yyvsp[-2].val);
			}
#line 13748 "parser_bison.c"
    break;

  case 839: /* limit_obj: %empty  */
#line 4855 "parser_bison.y"
                        {
				(yyval.obj) = obj_alloc(&(yyloc));
				(yyval.obj)->type = NFT_OBJECT_LIMIT;
			}
#line 13757 "parser_bison.c"
    break;

  case 840: /* relational_expr: expr rhs_expr  */
#line 4862 "parser_bison.y"
                        {
				(yyval.expr) = relational_expr_alloc(&(yyloc), OP_IMPLICIT, (yyvsp[-1].expr), (yyvsp[0].expr));
			}
#line 13765 "parser_bison.c"
    break;

  case 841: /* relational_expr: expr list_rhs_expr  */
#line 4866 "parser_bison.y"
                        {
				(yyval.expr) = relational_expr_alloc(&(yyloc), OP_IMPLICIT, (yyvsp[-1].expr), (yyvsp[0].expr));
			}
#line 13773 "parser_bison.c"
    break;

  case 842: /* relational_expr: expr basic_rhs_expr "/" list_rhs_expr  */
#line 4870 "parser_bison.y"
                        {
				(yyval.expr) = flagcmp_expr_alloc(&(yyloc), OP_EQ, (yyvsp[-3].expr), (yyvsp[0].expr), (yyvsp[-2].expr));
			}
#line 13781 "parser_bison.c"
    break;

  case 843: /* relational_expr: expr list_rhs_expr "/" list_rhs_expr  */
#line 4874 "parser_bison.y"
                        {
				(yyval.expr) = flagcmp_expr_alloc(&(yyloc), OP_EQ, (yyvsp[-3].expr), (yyvsp[0].expr), (yyvsp[-2].expr));
			}
#line 13789 "parser_bison.c"
    break;

  case 844: /* relational_expr: expr relational_op basic_rhs_expr "/" list_rhs_expr  */
#line 4878 "parser_bison.y"
                        {
				(yyval.expr) = flagcmp_expr_alloc(&(yyloc), (yyvsp[-3].val), (yyvsp[-4].expr), (yyvsp[0].expr), (yyvsp[-2].expr));
			}
#line 13797 "parser_bison.c"
    break;

  case 845: /* relational_expr: expr relational_op list_rhs_expr "/" list_rhs_expr  */
#line 4882 "parser_bison.y"
                        {
				(yyval.expr) = flagcmp_expr_alloc(&(yyloc), (yyvsp[-3].val), (yyvsp[-4].expr), (yyvsp[0].expr), (yyvsp[-2].expr));
			}
#line 13805 "parser_bison.c"
    break;

  case 846: /* relational_expr: expr relational_op rhs_expr  */
#line 4886 "parser_bison.y"
                        {
				(yyval.expr) = relational_expr_alloc(&(yylsp[-1]), (yyvsp[-1].val), (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13813 "parser_bison.c"
    break;

  case 847: /* relational_expr: expr relational_op list_rhs_expr  */
#line 4890 "parser_bison.y"
                        {
				(yyval.expr) = relational_expr_alloc(&(yylsp[-1]), (yyvsp[-1].val), (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13821 "parser_bison.c"
    break;

  case 848: /* list_rhs_expr: basic_rhs_expr "comma" basic_rhs_expr  */
#line 4896 "parser_bison.y"
                        {
				(yyval.expr) = list_expr_alloc(&(yyloc));
				compound_expr_add((yyval.expr), (yyvsp[-2].expr));
				compound_expr_add((yyval.expr), (yyvsp[0].expr));
			}
#line 13831 "parser_bison.c"
    break;

  case 849: /* list_rhs_expr: list_rhs_expr "comma" basic_rhs_expr  */
#line 4902 "parser_bison.y"
                        {
				(yyvsp[-2].expr)->location = (yyloc);
				compound_expr_add((yyvsp[-2].expr), (yyvsp[0].expr));
				(yyval.expr) = (yyvsp[-2].expr);
			}
#line 13841 "parser_bison.c"
    break;

  case 850: /* rhs_expr: concat_rhs_expr  */
#line 4909 "parser_bison.y"
                                                        { (yyval.expr) = (yyvsp[0].expr); }
#line 13847 "parser_bison.c"
    break;

  case 851: /* rhs_expr: set_expr  */
#line 4910 "parser_bison.y"
                                                        { (yyval.expr) = (yyvsp[0].expr); }
#line 13853 "parser_bison.c"
    break;

  case 852: /* rhs_expr: set_ref_symbol_expr  */
#line 4911 "parser_bison.y"
                                                        { (yyval.expr) = (yyvsp[0].expr); }
#line 13859 "parser_bison.c"
    break;

  case 854: /* shift_rhs_expr: shift_rhs_expr "<<" primary_rhs_expr  */
#line 4916 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_LSHIFT, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13867 "parser_bison.c"
    break;

  case 855: /* shift_rhs_expr: shift_rhs_expr ">>" primary_rhs_expr  */
#line 4920 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_RSHIFT, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13875 "parser_bison.c"
    break;

  case 857: /* and_rhs_expr: and_rhs_expr "&" shift_rhs_expr  */
#line 4927 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_AND, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13883 "parser_bison.c"
    break;

  case 859: /* exclusive_or_rhs_expr: exclusive_or_rhs_expr "^" and_rhs_expr  */
#line 4934 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_XOR, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13891 "parser_bison.c"
    break;

  case 861: /* inclusive_or_rhs_expr: inclusive_or_rhs_expr '|' exclusive_or_rhs_expr  */
#line 4941 "parser_bison.y"
                        {
				(yyval.expr) = binop_expr_alloc(&(yyloc), OP_OR, (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 13899 "parser_bison.c"
    break;

  case 865: /* concat_rhs_expr: concat_rhs_expr "." multiton_rhs_expr  */
#line 4952 "parser_bison.y"
                        {
				struct location rhs[] = {
					[1]	= (yylsp[-1]),
					[2]	= (yylsp[0]),
				};

				(yyval.expr) = handle_concat_expr(&(yyloc), (yyval.expr), (yyvsp[-2].expr), (yyvsp[0].expr), rhs);
			}
#line 13912 "parser_bison.c"
    break;

  case 866: /* concat_rhs_expr: concat_rhs_expr "." basic_rhs_expr  */
#line 4961 "parser_bison.y"
                        {
				struct location rhs[] = {
					[1]	= (yylsp[-1]),
					[2]	= (yylsp[0]),
				};

				(yyval.expr) = handle_concat_expr(&(yyloc), (yyval.expr), (yyvsp[-2].expr), (yyvsp[0].expr), rhs);
			}
#line 13925 "parser_bison.c"
    break;

  case 867: /* boolean_keys: "exists"  */
#line 4971 "parser_bison.y"
                                                { (yyval.val8) = true; }
#line 13931 "parser_bison.c"
    break;

  case 868: /* boolean_keys: "missing"  */
#line 4972 "parser_bison.y"
                                                { (yyval.val8) = false; }
#line 13937 "parser_bison.c"
    break;

  case 869: /* boolean_expr: boolean_keys  */
#line 4976 "parser_bison.y"
                        {
				(yyval.expr) = constant_expr_alloc(&(yyloc), &boolean_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof((yyvsp[0].val8)) * BITS_PER_BYTE, &(yyvsp[0].val8));
			}
#line 13947 "parser_bison.c"
    break;

  case 870: /* keyword_expr: "ether" close_scope_eth  */
#line 4983 "parser_bison.y"
                                                        { (yyval.expr) = symbol_value(&(yyloc), "ether"); }
#line 13953 "parser_bison.c"
    break;

  case 871: /* keyword_expr: "ip" close_scope_ip  */
#line 4984 "parser_bison.y"
                                                        { (yyval.expr) = symbol_value(&(yyloc), "ip"); }
#line 13959 "parser_bison.c"
    break;

  case 872: /* keyword_expr: "ip6" close_scope_ip6  */
#line 4985 "parser_bison.y"
                                                        { (yyval.expr) = symbol_value(&(yyloc), "ip6"); }
#line 13965 "parser_bison.c"
    break;

  case 873: /* keyword_expr: "vlan" close_scope_vlan  */
#line 4986 "parser_bison.y"
                                                         { (yyval.expr) = symbol_value(&(yyloc), "vlan"); }
#line 13971 "parser_bison.c"
    break;

  case 874: /* keyword_expr: "arp" close_scope_arp  */
#line 4987 "parser_bison.y"
                                                        { (yyval.expr) = symbol_value(&(yyloc), "arp"); }
#line 13977 "parser_bison.c"
    break;

  case 875: /* keyword_expr: "dnat" close_scope_nat  */
#line 4988 "parser_bison.y"
                                                        { (yyval.expr) = symbol_value(&(yyloc), "dnat"); }
#line 13983 "parser_bison.c"
    break;

  case 876: /* keyword_expr: "snat" close_scope_nat  */
#line 4989 "parser_bison.y"
                                                        { (yyval.expr) = symbol_value(&(yyloc), "snat"); }
#line 13989 "parser_bison.c"
    break;

  case 877: /* keyword_expr: "ecn"  */
#line 4990 "parser_bison.y"
                                                        { (yyval.expr) = symbol_value(&(yyloc), "ecn"); }
#line 13995 "parser_bison.c"
    break;

  case 878: /* keyword_expr: "reset" close_scope_reset  */
#line 4991 "parser_bison.y"
                                                                { (yyval.expr) = symbol_value(&(yyloc), "reset"); }
#line 14001 "parser_bison.c"
    break;

  case 879: /* keyword_expr: "original"  */
#line 4992 "parser_bison.y"
                                                        { (yyval.expr) = symbol_value(&(yyloc), "original"); }
#line 14007 "parser_bison.c"
    break;

  case 880: /* keyword_expr: "reply"  */
#line 4993 "parser_bison.y"
                                                        { (yyval.expr) = symbol_value(&(yyloc), "reply"); }
#line 14013 "parser_bison.c"
    break;

  case 881: /* keyword_expr: "label"  */
#line 4994 "parser_bison.y"
                                                        { (yyval.expr) = symbol_value(&(yyloc), "label"); }
#line 14019 "parser_bison.c"
    break;

  case 882: /* primary_rhs_expr: symbol_expr  */
#line 4997 "parser_bison.y"
                                                        { (yyval.expr) = (yyvsp[0].expr); }
#line 14025 "parser_bison.c"
    break;

  case 883: /* primary_rhs_expr: integer_expr  */
#line 4998 "parser_bison.y"
                                                        { (yyval.expr) = (yyvsp[0].expr); }
#line 14031 "parser_bison.c"
    break;

  case 884: /* primary_rhs_expr: boolean_expr  */
#line 4999 "parser_bison.y"
                                                        { (yyval.expr) = (yyvsp[0].expr); }
#line 14037 "parser_bison.c"
    break;

  case 885: /* primary_rhs_expr: keyword_expr  */
#line 5000 "parser_bison.y"
                                                        { (yyval.expr) = (yyvsp[0].expr); }
#line 14043 "parser_bison.c"
    break;

  case 886: /* primary_rhs_expr: "tcp" close_scope_tcp  */
#line 5002 "parser_bison.y"
                        {
				uint8_t data = IPPROTO_TCP;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &inet_protocol_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14054 "parser_bison.c"
    break;

  case 887: /* primary_rhs_expr: "udp" close_scope_udp  */
#line 5009 "parser_bison.y"
                        {
				uint8_t data = IPPROTO_UDP;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &inet_protocol_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14065 "parser_bison.c"
    break;

  case 888: /* primary_rhs_expr: "udplite" close_scope_udplite  */
#line 5016 "parser_bison.y"
                        {
				uint8_t data = IPPROTO_UDPLITE;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &inet_protocol_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14076 "parser_bison.c"
    break;

  case 889: /* primary_rhs_expr: "esp" close_scope_esp  */
#line 5023 "parser_bison.y"
                        {
				uint8_t data = IPPROTO_ESP;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &inet_protocol_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14087 "parser_bison.c"
    break;

  case 890: /* primary_rhs_expr: "ah" close_scope_ah  */
#line 5030 "parser_bison.y"
                        {
				uint8_t data = IPPROTO_AH;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &inet_protocol_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14098 "parser_bison.c"
    break;

  case 891: /* primary_rhs_expr: "icmp" close_scope_icmp  */
#line 5037 "parser_bison.y"
                        {
				uint8_t data = IPPROTO_ICMP;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &inet_protocol_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14109 "parser_bison.c"
    break;

  case 892: /* primary_rhs_expr: "igmp"  */
#line 5044 "parser_bison.y"
                        {
				uint8_t data = IPPROTO_IGMP;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &inet_protocol_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14120 "parser_bison.c"
    break;

  case 893: /* primary_rhs_expr: "icmpv6" close_scope_icmp  */
#line 5051 "parser_bison.y"
                        {
				uint8_t data = IPPROTO_ICMPV6;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &inet_protocol_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14131 "parser_bison.c"
    break;

  case 894: /* primary_rhs_expr: "comp" close_scope_comp  */
#line 5058 "parser_bison.y"
                        {
				uint8_t data = IPPROTO_COMP;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &inet_protocol_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14142 "parser_bison.c"
    break;

  case 895: /* primary_rhs_expr: "dccp" close_scope_dccp  */
#line 5065 "parser_bison.y"
                        {
				uint8_t data = IPPROTO_DCCP;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &inet_protocol_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14153 "parser_bison.c"
    break;

  case 896: /* primary_rhs_expr: "sctp" close_scope_sctp  */
#line 5072 "parser_bison.y"
                        {
				uint8_t data = IPPROTO_SCTP;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &inet_protocol_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14164 "parser_bison.c"
    break;

  case 897: /* primary_rhs_expr: "redirect" close_scope_nat  */
#line 5079 "parser_bison.y"
                        {
				uint8_t data = ICMP_REDIRECT;
				(yyval.expr) = constant_expr_alloc(&(yyloc), &icmp_type_type,
							 BYTEORDER_HOST_ENDIAN,
							 sizeof(data) * BITS_PER_BYTE, &data);
			}
#line 14175 "parser_bison.c"
    break;

  case 898: /* primary_rhs_expr: '(' basic_rhs_expr ')'  */
#line 5085 "parser_bison.y"
                                                                { (yyval.expr) = (yyvsp[-1].expr); }
#line 14181 "parser_bison.c"
    break;

  case 899: /* relational_op: "=="  */
#line 5088 "parser_bison.y"
                                                { (yyval.val) = OP_EQ; }
#line 14187 "parser_bison.c"
    break;

  case 900: /* relational_op: "!="  */
#line 5089 "parser_bison.y"
                                                { (yyval.val) = OP_NEQ; }
#line 14193 "parser_bison.c"
    break;

  case 901: /* relational_op: "<"  */
#line 5090 "parser_bison.y"
                                                { (yyval.val) = OP_LT; }
#line 14199 "parser_bison.c"
    break;

  case 902: /* relational_op: ">"  */
#line 5091 "parser_bison.y"
                                                { (yyval.val) = OP_GT; }
#line 14205 "parser_bison.c"
    break;

  case 903: /* relational_op: ">="  */
#line 5092 "parser_bison.y"
                                                { (yyval.val) = OP_GTE; }
#line 14211 "parser_bison.c"
    break;

  case 904: /* relational_op: "<="  */
#line 5093 "parser_bison.y"
                                                { (yyval.val) = OP_LTE; }
#line 14217 "parser_bison.c"
    break;

  case 905: /* relational_op: "!"  */
#line 5094 "parser_bison.y"
                                                { (yyval.val) = OP_NEG; }
#line 14223 "parser_bison.c"
    break;

  case 906: /* verdict_expr: "accept"  */
#line 5098 "parser_bison.y"
                        {
				(yyval.expr) = verdict_expr_alloc(&(yyloc), NF_ACCEPT, NULL);
			}
#line 14231 "parser_bison.c"
    break;

  case 907: /* verdict_expr: "drop"  */
#line 5102 "parser_bison.y"
                        {
				(yyval.expr) = verdict_expr_alloc(&(yyloc), NF_DROP, NULL);
			}
#line 14239 "parser_bison.c"
    break;

  case 908: /* verdict_expr: "continue"  */
#line 5106 "parser_bison.y"
                        {
				(yyval.expr) = verdict_expr_alloc(&(yyloc), NFT_CONTINUE, NULL);
			}
#line 14247 "parser_bison.c"
    break;

  case 909: /* verdict_expr: "jump" chain_expr  */
#line 5110 "parser_bison.y"
                        {
				(yyval.expr) = verdict_expr_alloc(&(yyloc), NFT_JUMP, (yyvsp[0].expr));
			}
#line 14255 "parser_bison.c"
    break;

  case 910: /* verdict_expr: "goto" chain_expr  */
#line 5114 "parser_bison.y"
                        {
				(yyval.expr) = verdict_expr_alloc(&(yyloc), NFT_GOTO, (yyvsp[0].expr));
			}
#line 14263 "parser_bison.c"
    break;

  case 911: /* verdict_expr: "return"  */
#line 5118 "parser_bison.y"
                        {
				(yyval.expr) = verdict_expr_alloc(&(yyloc), NFT_RETURN, NULL);
			}
#line 14271 "parser_bison.c"
    break;

  case 913: /* chain_expr: identifier  */
#line 5125 "parser_bison.y"
                        {
				(yyval.expr) = constant_expr_alloc(&(yyloc), &string_type,
							 BYTEORDER_HOST_ENDIAN,
							 strlen((yyvsp[0].string)) * BITS_PER_BYTE,
							 (yyvsp[0].string));
				xfree((yyvsp[0].string));
			}
#line 14283 "parser_bison.c"
    break;

  case 914: /* meta_expr: "meta" meta_key close_scope_meta  */
#line 5135 "parser_bison.y"
                        {
				(yyval.expr) = meta_expr_alloc(&(yyloc), (yyvsp[-1].val));
			}
#line 14291 "parser_bison.c"
    break;

  case 915: /* meta_expr: meta_key_unqualified  */
#line 5139 "parser_bison.y"
                        {
				(yyval.expr) = meta_expr_alloc(&(yyloc), (yyvsp[0].val));
			}
#line 14299 "parser_bison.c"
    break;

  case 916: /* meta_expr: "meta" "string" close_scope_meta  */
#line 5143 "parser_bison.y"
                        {
				struct error_record *erec;
				unsigned int key;

				erec = meta_key_parse(&(yyloc), (yyvsp[-1].string), &key);
				xfree((yyvsp[-1].string));
				if (erec != NULL) {
					erec_queue(erec, state->msgs);
					YYERROR;
				}

				(yyval.expr) = meta_expr_alloc(&(yyloc), key);
			}
#line 14317 "parser_bison.c"
    break;

  case 919: /* meta_key_qualified: "length"  */
#line 5162 "parser_bison.y"
                                                { (yyval.val) = NFT_META_LEN; }
#line 14323 "parser_bison.c"
    break;

  case 920: /* meta_key_qualified: "protocol"  */
#line 5163 "parser_bison.y"
                                                { (yyval.val) = NFT_META_PROTOCOL; }
#line 14329 "parser_bison.c"
    break;

  case 921: /* meta_key_qualified: "priority"  */
#line 5164 "parser_bison.y"
                                                { (yyval.val) = NFT_META_PRIORITY; }
#line 14335 "parser_bison.c"
    break;

  case 922: /* meta_key_qualified: "random"  */
#line 5165 "parser_bison.y"
                                                { (yyval.val) = NFT_META_PRANDOM; }
#line 14341 "parser_bison.c"
    break;

  case 923: /* meta_key_qualified: "secmark" close_scope_secmark  */
#line 5166 "parser_bison.y"
                                                            { (yyval.val) = NFT_META_SECMARK; }
#line 14347 "parser_bison.c"
    break;

  case 924: /* meta_key_unqualified: "mark"  */
#line 5169 "parser_bison.y"
                                                { (yyval.val) = NFT_META_MARK; }
#line 14353 "parser_bison.c"
    break;

  case 925: /* meta_key_unqualified: "iif"  */
#line 5170 "parser_bison.y"
                                                { (yyval.val) = NFT_META_IIF; }
#line 14359 "parser_bison.c"
    break;

  case 926: /* meta_key_unqualified: "iifname"  */
#line 5171 "parser_bison.y"
                                                { (yyval.val) = NFT_META_IIFNAME; }
#line 14365 "parser_bison.c"
    break;

  case 927: /* meta_key_unqualified: "iiftype"  */
#line 5172 "parser_bison.y"
                                                { (yyval.val) = NFT_META_IIFTYPE; }
#line 14371 "parser_bison.c"
    break;

  case 928: /* meta_key_unqualified: "oif"  */
#line 5173 "parser_bison.y"
                                                { (yyval.val) = NFT_META_OIF; }
#line 14377 "parser_bison.c"
    break;

  case 929: /* meta_key_unqualified: "oifname"  */
#line 5174 "parser_bison.y"
                                                { (yyval.val) = NFT_META_OIFNAME; }
#line 14383 "parser_bison.c"
    break;

  case 930: /* meta_key_unqualified: "oiftype"  */
#line 5175 "parser_bison.y"
                                                { (yyval.val) = NFT_META_OIFTYPE; }
#line 14389 "parser_bison.c"
    break;

  case 931: /* meta_key_unqualified: "skuid"  */
#line 5176 "parser_bison.y"
                                                { (yyval.val) = NFT_META_SKUID; }
#line 14395 "parser_bison.c"
    break;

  case 932: /* meta_key_unqualified: "skgid"  */
#line 5177 "parser_bison.y"
                                                { (yyval.val) = NFT_META_SKGID; }
#line 14401 "parser_bison.c"
    break;

  case 933: /* meta_key_unqualified: "nftrace"  */
#line 5178 "parser_bison.y"
                                                { (yyval.val) = NFT_META_NFTRACE; }
#line 14407 "parser_bison.c"
    break;

  case 934: /* meta_key_unqualified: "rtclassid"  */
#line 5179 "parser_bison.y"
                                                { (yyval.val) = NFT_META_RTCLASSID; }
#line 14413 "parser_bison.c"
    break;

  case 935: /* meta_key_unqualified: "ibriport"  */
#line 5180 "parser_bison.y"
                                                { (yyval.val) = NFT_META_BRI_IIFNAME; }
#line 14419 "parser_bison.c"
    break;

  case 936: /* meta_key_unqualified: "obriport"  */
#line 5181 "parser_bison.y"
                                                { (yyval.val) = NFT_META_BRI_OIFNAME; }
#line 14425 "parser_bison.c"
    break;

  case 937: /* meta_key_unqualified: "ibrname"  */
#line 5182 "parser_bison.y"
                                                { (yyval.val) = NFT_META_BRI_IIFNAME; }
#line 14431 "parser_bison.c"
    break;

  case 938: /* meta_key_unqualified: "obrname"  */
#line 5183 "parser_bison.y"
                                                { (yyval.val) = NFT_META_BRI_OIFNAME; }
#line 14437 "parser_bison.c"
    break;

  case 939: /* meta_key_unqualified: "pkttype"  */
#line 5184 "parser_bison.y"
                                                { (yyval.val) = NFT_META_PKTTYPE; }
#line 14443 "parser_bison.c"
    break;

  case 940: /* meta_key_unqualified: "cpu"  */
#line 5185 "parser_bison.y"
                                                { (yyval.val) = NFT_META_CPU; }
#line 14449 "parser_bison.c"
    break;

  case 941: /* meta_key_unqualified: "iifgroup"  */
#line 5186 "parser_bison.y"
                                                { (yyval.val) = NFT_META_IIFGROUP; }
#line 14455 "parser_bison.c"
    break;

  case 942: /* meta_key_unqualified: "oifgroup"  */
#line 5187 "parser_bison.y"
                                                { (yyval.val) = NFT_META_OIFGROUP; }
#line 14461 "parser_bison.c"
    break;

  case 943: /* meta_key_unqualified: "cgroup"  */
#line 5188 "parser_bison.y"
                                                { (yyval.val) = NFT_META_CGROUP; }
#line 14467 "parser_bison.c"
    break;

  case 944: /* meta_key_unqualified: "ipsec" close_scope_ipsec  */
#line 5189 "parser_bison.y"
                                                          { (yyval.val) = NFT_META_SECPATH; }
#line 14473 "parser_bison.c"
    break;

  case 945: /* meta_key_unqualified: "time"  */
#line 5190 "parser_bison.y"
                                                { (yyval.val) = NFT_META_TIME_NS; }
#line 14479 "parser_bison.c"
    break;

  case 946: /* meta_key_unqualified: "day"  */
#line 5191 "parser_bison.y"
                                                { (yyval.val) = NFT_META_TIME_DAY; }
#line 14485 "parser_bison.c"
    break;

  case 947: /* meta_key_unqualified: "hour"  */
#line 5192 "parser_bison.y"
                                                { (yyval.val) = NFT_META_TIME_HOUR; }
#line 14491 "parser_bison.c"
    break;

  case 948: /* meta_stmt: "meta" meta_key "set" stmt_expr close_scope_meta  */
#line 5196 "parser_bison.y"
                        {
				switch ((yyvsp[-3].val)) {
				case NFT_META_SECMARK:
					switch ((yyvsp[-1].expr)->etype) {
					case EXPR_CT:
						(yyval.stmt) = meta_stmt_alloc(&(yyloc), (yyvsp[-3].val), (yyvsp[-1].expr));
						break;
					default:
						(yyval.stmt) = objref_stmt_alloc(&(yyloc));
						(yyval.stmt)->objref.type = NFT_OBJECT_SECMARK;
						(yyval.stmt)->objref.expr = (yyvsp[-1].expr);
						break;
					}
					break;
				default:
					(yyval.stmt) = meta_stmt_alloc(&(yyloc), (yyvsp[-3].val), (yyvsp[-1].expr));
					break;
				}
			}
#line 14515 "parser_bison.c"
    break;

  case 949: /* meta_stmt: meta_key_unqualified "set" stmt_expr  */
#line 5216 "parser_bison.y"
                        {
				(yyval.stmt) = meta_stmt_alloc(&(yyloc), (yyvsp[-2].val), (yyvsp[0].expr));
			}
#line 14523 "parser_bison.c"
    break;

  case 950: /* meta_stmt: "meta" "string" "set" stmt_expr close_scope_meta  */
#line 5220 "parser_bison.y"
                        {
				struct error_record *erec;
				unsigned int key;

				erec = meta_key_parse(&(yyloc), (yyvsp[-3].string), &key);
				xfree((yyvsp[-3].string));
				if (erec != NULL) {
					erec_queue(erec, state->msgs);
					expr_free((yyvsp[-1].expr));
					YYERROR;
				}

				(yyval.stmt) = meta_stmt_alloc(&(yyloc), key, (yyvsp[-1].expr));
			}
#line 14542 "parser_bison.c"
    break;

  case 951: /* meta_stmt: "notrack"  */
#line 5235 "parser_bison.y"
                        {
				(yyval.stmt) = notrack_stmt_alloc(&(yyloc));
			}
#line 14550 "parser_bison.c"
    break;

  case 952: /* meta_stmt: "flow" "offload" "@" string close_scope_at  */
#line 5239 "parser_bison.y"
                        {
				(yyval.stmt) = flow_offload_stmt_alloc(&(yyloc), (yyvsp[-1].string));
			}
#line 14558 "parser_bison.c"
    break;

  case 953: /* meta_stmt: "flow" "add" "@" string close_scope_at  */
#line 5243 "parser_bison.y"
                        {
				(yyval.stmt) = flow_offload_stmt_alloc(&(yyloc), (yyvsp[-1].string));
			}
#line 14566 "parser_bison.c"
    break;

  case 954: /* socket_expr: "socket" socket_key close_scope_socket  */
#line 5249 "parser_bison.y"
                        {
				(yyval.expr) = socket_expr_alloc(&(yyloc), (yyvsp[-1].val), 0);
			}
#line 14574 "parser_bison.c"
    break;

  case 955: /* socket_expr: "socket" "cgroupv2" "level" "number" close_scope_socket  */
#line 5253 "parser_bison.y"
                        {
				(yyval.expr) = socket_expr_alloc(&(yyloc), NFT_SOCKET_CGROUPV2, (yyvsp[-1].val));
			}
#line 14582 "parser_bison.c"
    break;

  case 956: /* socket_key: "transparent"  */
#line 5258 "parser_bison.y"
                                                { (yyval.val) = NFT_SOCKET_TRANSPARENT; }
#line 14588 "parser_bison.c"
    break;

  case 957: /* socket_key: "mark"  */
#line 5259 "parser_bison.y"
                                                { (yyval.val) = NFT_SOCKET_MARK; }
#line 14594 "parser_bison.c"
    break;

  case 958: /* socket_key: "wildcard"  */
#line 5260 "parser_bison.y"
                                                { (yyval.val) = NFT_SOCKET_WILDCARD; }
#line 14600 "parser_bison.c"
    break;

  case 959: /* offset_opt: %empty  */
#line 5263 "parser_bison.y"
                                                { (yyval.val) = 0; }
#line 14606 "parser_bison.c"
    break;

  case 960: /* offset_opt: "offset" "number"  */
#line 5264 "parser_bison.y"
                                                { (yyval.val) = (yyvsp[0].val); }
#line 14612 "parser_bison.c"
    break;

  case 961: /* numgen_type: "inc"  */
#line 5267 "parser_bison.y"
                                                { (yyval.val) = NFT_NG_INCREMENTAL; }
#line 14618 "parser_bison.c"
    break;

  case 962: /* numgen_type: "random"  */
#line 5268 "parser_bison.y"
                                                { (yyval.val) = NFT_NG_RANDOM; }
#line 14624 "parser_bison.c"
    break;

  case 963: /* numgen_expr: "numgen" numgen_type "mod" "number" offset_opt close_scope_numgen  */
#line 5272 "parser_bison.y"
                        {
				(yyval.expr) = numgen_expr_alloc(&(yyloc), (yyvsp[-4].val), (yyvsp[-2].val), (yyvsp[-1].val));
			}
#line 14632 "parser_bison.c"
    break;

  case 964: /* xfrm_spnum: "spnum" "number"  */
#line 5277 "parser_bison.y"
                                            { (yyval.val) = (yyvsp[0].val); }
#line 14638 "parser_bison.c"
    break;

  case 965: /* xfrm_spnum: %empty  */
#line 5278 "parser_bison.y"
                                            { (yyval.val) = 0; }
#line 14644 "parser_bison.c"
    break;

  case 966: /* xfrm_dir: "in"  */
#line 5281 "parser_bison.y"
                                        { (yyval.val) = XFRM_POLICY_IN; }
#line 14650 "parser_bison.c"
    break;

  case 967: /* xfrm_dir: "out"  */
#line 5282 "parser_bison.y"
                                        { (yyval.val) = XFRM_POLICY_OUT; }
#line 14656 "parser_bison.c"
    break;

  case 968: /* xfrm_state_key: "spi"  */
#line 5285 "parser_bison.y"
                                    { (yyval.val) = NFT_XFRM_KEY_SPI; }
#line 14662 "parser_bison.c"
    break;

  case 969: /* xfrm_state_key: "reqid"  */
#line 5286 "parser_bison.y"
                                      { (yyval.val) = NFT_XFRM_KEY_REQID; }
#line 14668 "parser_bison.c"
    break;

  case 970: /* xfrm_state_proto_key: "daddr"  */
#line 5289 "parser_bison.y"
                                                { (yyval.val) = NFT_XFRM_KEY_DADDR_IP4; }
#line 14674 "parser_bison.c"
    break;

  case 971: /* xfrm_state_proto_key: "saddr"  */
#line 5290 "parser_bison.y"
                                                { (yyval.val) = NFT_XFRM_KEY_SADDR_IP4; }
#line 14680 "parser_bison.c"
    break;

  case 972: /* xfrm_expr: "ipsec" xfrm_dir xfrm_spnum xfrm_state_key close_scope_ipsec  */
#line 5294 "parser_bison.y"
                        {
				if ((yyvsp[-2].val) > 255) {
					erec_queue(error(&(yylsp[-2]), "value too large"), state->msgs);
					YYERROR;
				}
				(yyval.expr) = xfrm_expr_alloc(&(yyloc), (yyvsp[-3].val), (yyvsp[-2].val), (yyvsp[-1].val));
			}
#line 14692 "parser_bison.c"
    break;

  case 973: /* xfrm_expr: "ipsec" xfrm_dir xfrm_spnum nf_key_proto xfrm_state_proto_key close_scope_ipsec  */
#line 5302 "parser_bison.y"
                        {
				enum nft_xfrm_keys xfrmk = (yyvsp[-1].val);

				switch ((yyvsp[-2].val)) {
				case NFPROTO_IPV4:
					break;
				case NFPROTO_IPV6:
					if ((yyvsp[-1].val) == NFT_XFRM_KEY_SADDR_IP4)
						xfrmk = NFT_XFRM_KEY_SADDR_IP6;
					else if ((yyvsp[-1].val) == NFT_XFRM_KEY_DADDR_IP4)
						xfrmk = NFT_XFRM_KEY_DADDR_IP6;
					break;
				default:
					YYERROR;
					break;
				}

				if ((yyvsp[-3].val) > 255) {
					erec_queue(error(&(yylsp[-3]), "value too large"), state->msgs);
					YYERROR;
				}

				(yyval.expr) = xfrm_expr_alloc(&(yyloc), (yyvsp[-4].val), (yyvsp[-3].val), xfrmk);
			}
#line 14721 "parser_bison.c"
    break;

  case 974: /* hash_expr: "jhash" expr "mod" "number" "seed" "number" offset_opt close_scope_hash  */
#line 5329 "parser_bison.y"
                        {
				(yyval.expr) = hash_expr_alloc(&(yyloc), (yyvsp[-4].val), true, (yyvsp[-2].val), (yyvsp[-1].val), NFT_HASH_JENKINS);
				(yyval.expr)->hash.expr = (yyvsp[-6].expr);
			}
#line 14730 "parser_bison.c"
    break;

  case 975: /* hash_expr: "jhash" expr "mod" "number" offset_opt close_scope_hash  */
#line 5334 "parser_bison.y"
                        {
				(yyval.expr) = hash_expr_alloc(&(yyloc), (yyvsp[-2].val), false, 0, (yyvsp[-1].val), NFT_HASH_JENKINS);
				(yyval.expr)->hash.expr = (yyvsp[-4].expr);
			}
#line 14739 "parser_bison.c"
    break;

  case 976: /* hash_expr: "symhash" "mod" "number" offset_opt close_scope_hash  */
#line 5339 "parser_bison.y"
                        {
				(yyval.expr) = hash_expr_alloc(&(yyloc), (yyvsp[-2].val), false, 0, (yyvsp[-1].val), NFT_HASH_SYM);
			}
#line 14747 "parser_bison.c"
    break;

  case 977: /* nf_key_proto: "ip" close_scope_ip  */
#line 5344 "parser_bison.y"
                                                       { (yyval.val) = NFPROTO_IPV4; }
#line 14753 "parser_bison.c"
    break;

  case 978: /* nf_key_proto: "ip6" close_scope_ip6  */
#line 5345 "parser_bison.y"
                                                        { (yyval.val) = NFPROTO_IPV6; }
#line 14759 "parser_bison.c"
    break;

  case 979: /* rt_expr: "rt" rt_key close_scope_rt  */
#line 5349 "parser_bison.y"
                        {
				(yyval.expr) = rt_expr_alloc(&(yyloc), (yyvsp[-1].val), true);
			}
#line 14767 "parser_bison.c"
    break;

  case 980: /* rt_expr: "rt" nf_key_proto rt_key close_scope_rt  */
#line 5353 "parser_bison.y"
                        {
				enum nft_rt_keys rtk = (yyvsp[-1].val);

				switch ((yyvsp[-2].val)) {
				case NFPROTO_IPV4:
					break;
				case NFPROTO_IPV6:
					if ((yyvsp[-1].val) == NFT_RT_NEXTHOP4)
						rtk = NFT_RT_NEXTHOP6;
					break;
				default:
					YYERROR;
					break;
				}

				(yyval.expr) = rt_expr_alloc(&(yyloc), rtk, false);
			}
#line 14789 "parser_bison.c"
    break;

  case 981: /* rt_key: "classid"  */
#line 5372 "parser_bison.y"
                                                { (yyval.val) = NFT_RT_CLASSID; }
#line 14795 "parser_bison.c"
    break;

  case 982: /* rt_key: "nexthop"  */
#line 5373 "parser_bison.y"
                                                { (yyval.val) = NFT_RT_NEXTHOP4; }
#line 14801 "parser_bison.c"
    break;

  case 983: /* rt_key: "mtu"  */
#line 5374 "parser_bison.y"
                                                { (yyval.val) = NFT_RT_TCPMSS; }
#line 14807 "parser_bison.c"
    break;

  case 984: /* rt_key: "ipsec" close_scope_ipsec  */
#line 5375 "parser_bison.y"
                                                          { (yyval.val) = NFT_RT_XFRM; }
#line 14813 "parser_bison.c"
    break;

  case 985: /* ct_expr: "ct" ct_key close_scope_ct  */
#line 5379 "parser_bison.y"
                        {
				(yyval.expr) = ct_expr_alloc(&(yyloc), (yyvsp[-1].val), -1);
			}
#line 14821 "parser_bison.c"
    break;

  case 986: /* ct_expr: "ct" ct_dir ct_key_dir close_scope_ct  */
#line 5383 "parser_bison.y"
                        {
				(yyval.expr) = ct_expr_alloc(&(yyloc), (yyvsp[-1].val), (yyvsp[-2].val));
			}
#line 14829 "parser_bison.c"
    break;

  case 987: /* ct_expr: "ct" ct_dir ct_key_proto_field close_scope_ct  */
#line 5387 "parser_bison.y"
                        {
				(yyval.expr) = ct_expr_alloc(&(yyloc), (yyvsp[-1].val), (yyvsp[-2].val));
			}
#line 14837 "parser_bison.c"
    break;

  case 988: /* ct_dir: "original"  */
#line 5392 "parser_bison.y"
                                                { (yyval.val) = IP_CT_DIR_ORIGINAL; }
#line 14843 "parser_bison.c"
    break;

  case 989: /* ct_dir: "reply"  */
#line 5393 "parser_bison.y"
                                                { (yyval.val) = IP_CT_DIR_REPLY; }
#line 14849 "parser_bison.c"
    break;

  case 990: /* ct_key: "l3proto"  */
#line 5396 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_L3PROTOCOL; }
#line 14855 "parser_bison.c"
    break;

  case 991: /* ct_key: "protocol"  */
#line 5397 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_PROTOCOL; }
#line 14861 "parser_bison.c"
    break;

  case 992: /* ct_key: "mark"  */
#line 5398 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_MARK; }
#line 14867 "parser_bison.c"
    break;

  case 993: /* ct_key: "state"  */
#line 5399 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_STATE; }
#line 14873 "parser_bison.c"
    break;

  case 994: /* ct_key: "direction"  */
#line 5400 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_DIRECTION; }
#line 14879 "parser_bison.c"
    break;

  case 995: /* ct_key: "status"  */
#line 5401 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_STATUS; }
#line 14885 "parser_bison.c"
    break;

  case 996: /* ct_key: "expiration"  */
#line 5402 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_EXPIRATION; }
#line 14891 "parser_bison.c"
    break;

  case 997: /* ct_key: "helper"  */
#line 5403 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_HELPER; }
#line 14897 "parser_bison.c"
    break;

  case 998: /* ct_key: "saddr"  */
#line 5404 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_SRC; }
#line 14903 "parser_bison.c"
    break;

  case 999: /* ct_key: "daddr"  */
#line 5405 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_DST; }
#line 14909 "parser_bison.c"
    break;

  case 1000: /* ct_key: "proto-src"  */
#line 5406 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_PROTO_SRC; }
#line 14915 "parser_bison.c"
    break;

  case 1001: /* ct_key: "proto-dst"  */
#line 5407 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_PROTO_DST; }
#line 14921 "parser_bison.c"
    break;

  case 1002: /* ct_key: "label"  */
#line 5408 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_LABELS; }
#line 14927 "parser_bison.c"
    break;

  case 1003: /* ct_key: "event"  */
#line 5409 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_EVENTMASK; }
#line 14933 "parser_bison.c"
    break;

  case 1004: /* ct_key: "secmark" close_scope_secmark  */
#line 5410 "parser_bison.y"
                                                            { (yyval.val) = NFT_CT_SECMARK; }
#line 14939 "parser_bison.c"
    break;

  case 1005: /* ct_key: "id"  */
#line 5411 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_ID; }
#line 14945 "parser_bison.c"
    break;

  case 1007: /* ct_key_dir: "saddr"  */
#line 5415 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_SRC; }
#line 14951 "parser_bison.c"
    break;

  case 1008: /* ct_key_dir: "daddr"  */
#line 5416 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_DST; }
#line 14957 "parser_bison.c"
    break;

  case 1009: /* ct_key_dir: "l3proto"  */
#line 5417 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_L3PROTOCOL; }
#line 14963 "parser_bison.c"
    break;

  case 1010: /* ct_key_dir: "protocol"  */
#line 5418 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_PROTOCOL; }
#line 14969 "parser_bison.c"
    break;

  case 1011: /* ct_key_dir: "proto-src"  */
#line 5419 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_PROTO_SRC; }
#line 14975 "parser_bison.c"
    break;

  case 1012: /* ct_key_dir: "proto-dst"  */
#line 5420 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_PROTO_DST; }
#line 14981 "parser_bison.c"
    break;

  case 1014: /* ct_key_proto_field: "ip" "saddr" close_scope_ip  */
#line 5424 "parser_bison.y"
                                                               { (yyval.val) = NFT_CT_SRC_IP; }
#line 14987 "parser_bison.c"
    break;

  case 1015: /* ct_key_proto_field: "ip" "daddr" close_scope_ip  */
#line 5425 "parser_bison.y"
                                                               { (yyval.val) = NFT_CT_DST_IP; }
#line 14993 "parser_bison.c"
    break;

  case 1016: /* ct_key_proto_field: "ip6" "saddr" close_scope_ip6  */
#line 5426 "parser_bison.y"
                                                                { (yyval.val) = NFT_CT_SRC_IP6; }
#line 14999 "parser_bison.c"
    break;

  case 1017: /* ct_key_proto_field: "ip6" "daddr" close_scope_ip6  */
#line 5427 "parser_bison.y"
                                                                { (yyval.val) = NFT_CT_DST_IP6; }
#line 15005 "parser_bison.c"
    break;

  case 1018: /* ct_key_dir_optional: "bytes"  */
#line 5430 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_BYTES; }
#line 15011 "parser_bison.c"
    break;

  case 1019: /* ct_key_dir_optional: "packets"  */
#line 5431 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_PKTS; }
#line 15017 "parser_bison.c"
    break;

  case 1020: /* ct_key_dir_optional: "avgpkt"  */
#line 5432 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_AVGPKT; }
#line 15023 "parser_bison.c"
    break;

  case 1021: /* ct_key_dir_optional: "zone"  */
#line 5433 "parser_bison.y"
                                                { (yyval.val) = NFT_CT_ZONE; }
#line 15029 "parser_bison.c"
    break;

  case 1024: /* list_stmt_expr: symbol_stmt_expr "comma" symbol_stmt_expr  */
#line 5441 "parser_bison.y"
                        {
				(yyval.expr) = list_expr_alloc(&(yyloc));
				compound_expr_add((yyval.expr), (yyvsp[-2].expr));
				compound_expr_add((yyval.expr), (yyvsp[0].expr));
			}
#line 15039 "parser_bison.c"
    break;

  case 1025: /* list_stmt_expr: list_stmt_expr "comma" symbol_stmt_expr  */
#line 5447 "parser_bison.y"
                        {
				(yyvsp[-2].expr)->location = (yyloc);
				compound_expr_add((yyvsp[-2].expr), (yyvsp[0].expr));
				(yyval.expr) = (yyvsp[-2].expr);
			}
#line 15049 "parser_bison.c"
    break;

  case 1026: /* ct_stmt: "ct" ct_key "set" stmt_expr close_scope_ct  */
#line 5455 "parser_bison.y"
                        {
				switch ((yyvsp[-3].val)) {
				case NFT_CT_HELPER:
					(yyval.stmt) = objref_stmt_alloc(&(yyloc));
					(yyval.stmt)->objref.type = NFT_OBJECT_CT_HELPER;
					(yyval.stmt)->objref.expr = (yyvsp[-1].expr);
					break;
				default:
					(yyval.stmt) = ct_stmt_alloc(&(yyloc), (yyvsp[-3].val), -1, (yyvsp[-1].expr));
					break;
				}
			}
#line 15066 "parser_bison.c"
    break;

  case 1027: /* ct_stmt: "ct" ct_dir ct_key_dir_optional "set" stmt_expr close_scope_ct  */
#line 5468 "parser_bison.y"
                        {
				(yyval.stmt) = ct_stmt_alloc(&(yyloc), (yyvsp[-3].val), (yyvsp[-4].val), (yyvsp[-1].expr));
			}
#line 15074 "parser_bison.c"
    break;

  case 1028: /* payload_stmt: payload_expr "set" stmt_expr  */
#line 5474 "parser_bison.y"
                        {
				if ((yyvsp[-2].expr)->etype == EXPR_EXTHDR)
					(yyval.stmt) = exthdr_stmt_alloc(&(yyloc), (yyvsp[-2].expr), (yyvsp[0].expr));
				else
					(yyval.stmt) = payload_stmt_alloc(&(yyloc), (yyvsp[-2].expr), (yyvsp[0].expr));
			}
#line 15085 "parser_bison.c"
    break;

  case 1047: /* payload_raw_len: "number"  */
#line 5503 "parser_bison.y"
                        {
				if ((yyvsp[0].val) > NFT_MAX_EXPR_LEN_BITS) {
					erec_queue(error(&(yylsp[0]), "raw payload length %u exceeds upper limit of %u",
							 (yyvsp[0].val), NFT_MAX_EXPR_LEN_BITS),
						 state->msgs);
					YYERROR;
				}

				if ((yyvsp[0].val) == 0) {
					erec_queue(error(&(yylsp[0]), "raw payload length cannot be 0"), state->msgs);
					YYERROR;
				}

				(yyval.val) = (yyvsp[0].val);
			}
#line 15105 "parser_bison.c"
    break;

  case 1048: /* payload_raw_expr: "@" payload_base_spec "comma" "number" "comma" payload_raw_len close_scope_at  */
#line 5521 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), NULL, 0);
				payload_init_raw((yyval.expr), (yyvsp[-5].val), (yyvsp[-3].val), (yyvsp[-1].val));
				(yyval.expr)->byteorder		= BYTEORDER_BIG_ENDIAN;
				(yyval.expr)->payload.is_raw	= true;
			}
#line 15116 "parser_bison.c"
    break;

  case 1049: /* payload_base_spec: "ll"  */
#line 5529 "parser_bison.y"
                                                { (yyval.val) = PROTO_BASE_LL_HDR; }
#line 15122 "parser_bison.c"
    break;

  case 1050: /* payload_base_spec: "nh"  */
#line 5530 "parser_bison.y"
                                                { (yyval.val) = PROTO_BASE_NETWORK_HDR; }
#line 15128 "parser_bison.c"
    break;

  case 1051: /* payload_base_spec: "th" close_scope_th  */
#line 5531 "parser_bison.y"
                                                                { (yyval.val) = PROTO_BASE_TRANSPORT_HDR; }
#line 15134 "parser_bison.c"
    break;

  case 1052: /* payload_base_spec: "string"  */
#line 5533 "parser_bison.y"
                        {
				if (!strcmp((yyvsp[0].string), "ih")) {
					(yyval.val) = PROTO_BASE_INNER_HDR;
				} else {
					erec_queue(error(&(yylsp[0]), "unknown raw payload base"), state->msgs);
					xfree((yyvsp[0].string));
					YYERROR;
				}
				xfree((yyvsp[0].string));
			}
#line 15149 "parser_bison.c"
    break;

  case 1053: /* eth_hdr_expr: "ether" eth_hdr_field close_scope_eth  */
#line 5546 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_eth, (yyvsp[-1].val));
			}
#line 15157 "parser_bison.c"
    break;

  case 1054: /* eth_hdr_field: "saddr"  */
#line 5551 "parser_bison.y"
                                                { (yyval.val) = ETHHDR_SADDR; }
#line 15163 "parser_bison.c"
    break;

  case 1055: /* eth_hdr_field: "daddr"  */
#line 5552 "parser_bison.y"
                                                { (yyval.val) = ETHHDR_DADDR; }
#line 15169 "parser_bison.c"
    break;

  case 1056: /* eth_hdr_field: "type" close_scope_type  */
#line 5553 "parser_bison.y"
                                                                        { (yyval.val) = ETHHDR_TYPE; }
#line 15175 "parser_bison.c"
    break;

  case 1057: /* vlan_hdr_expr: "vlan" vlan_hdr_field close_scope_vlan  */
#line 5557 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_vlan, (yyvsp[-1].val));
			}
#line 15183 "parser_bison.c"
    break;

  case 1058: /* vlan_hdr_field: "id"  */
#line 5562 "parser_bison.y"
                                                { (yyval.val) = VLANHDR_VID; }
#line 15189 "parser_bison.c"
    break;

  case 1059: /* vlan_hdr_field: "cfi"  */
#line 5563 "parser_bison.y"
                                                { (yyval.val) = VLANHDR_CFI; }
#line 15195 "parser_bison.c"
    break;

  case 1060: /* vlan_hdr_field: "dei"  */
#line 5564 "parser_bison.y"
                                                { (yyval.val) = VLANHDR_DEI; }
#line 15201 "parser_bison.c"
    break;

  case 1061: /* vlan_hdr_field: "pcp"  */
#line 5565 "parser_bison.y"
                                                { (yyval.val) = VLANHDR_PCP; }
#line 15207 "parser_bison.c"
    break;

  case 1062: /* vlan_hdr_field: "type" close_scope_type  */
#line 5566 "parser_bison.y"
                                                                        { (yyval.val) = VLANHDR_TYPE; }
#line 15213 "parser_bison.c"
    break;

  case 1063: /* arp_hdr_expr: "arp" arp_hdr_field close_scope_arp  */
#line 5570 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_arp, (yyvsp[-1].val));
			}
#line 15221 "parser_bison.c"
    break;

  case 1064: /* arp_hdr_field: "htype"  */
#line 5575 "parser_bison.y"
                                                { (yyval.val) = ARPHDR_HRD; }
#line 15227 "parser_bison.c"
    break;

  case 1065: /* arp_hdr_field: "ptype"  */
#line 5576 "parser_bison.y"
                                                { (yyval.val) = ARPHDR_PRO; }
#line 15233 "parser_bison.c"
    break;

  case 1066: /* arp_hdr_field: "hlen"  */
#line 5577 "parser_bison.y"
                                                { (yyval.val) = ARPHDR_HLN; }
#line 15239 "parser_bison.c"
    break;

  case 1067: /* arp_hdr_field: "plen"  */
#line 5578 "parser_bison.y"
                                                { (yyval.val) = ARPHDR_PLN; }
#line 15245 "parser_bison.c"
    break;

  case 1068: /* arp_hdr_field: "operation"  */
#line 5579 "parser_bison.y"
                                                { (yyval.val) = ARPHDR_OP; }
#line 15251 "parser_bison.c"
    break;

  case 1069: /* arp_hdr_field: "saddr" "ether" close_scope_eth  */
#line 5580 "parser_bison.y"
                                                                { (yyval.val) = ARPHDR_SADDR_ETHER; }
#line 15257 "parser_bison.c"
    break;

  case 1070: /* arp_hdr_field: "daddr" "ether" close_scope_eth  */
#line 5581 "parser_bison.y"
                                                                { (yyval.val) = ARPHDR_DADDR_ETHER; }
#line 15263 "parser_bison.c"
    break;

  case 1071: /* arp_hdr_field: "saddr" "ip" close_scope_ip  */
#line 5582 "parser_bison.y"
                                                                { (yyval.val) = ARPHDR_SADDR_IP; }
#line 15269 "parser_bison.c"
    break;

  case 1072: /* arp_hdr_field: "daddr" "ip" close_scope_ip  */
#line 5583 "parser_bison.y"
                                                                { (yyval.val) = ARPHDR_DADDR_IP; }
#line 15275 "parser_bison.c"
    break;

  case 1073: /* ip_hdr_expr: "ip" ip_hdr_field close_scope_ip  */
#line 5587 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_ip, (yyvsp[-1].val));
			}
#line 15283 "parser_bison.c"
    break;

  case 1074: /* ip_hdr_expr: "ip" "option" ip_option_type ip_option_field close_scope_ip  */
#line 5591 "parser_bison.y"
                        {
				(yyval.expr) = ipopt_expr_alloc(&(yyloc), (yyvsp[-2].val), (yyvsp[-1].val));
				if (!(yyval.expr)) {
					erec_queue(error(&(yylsp[-4]), "unknown ip option type/field"), state->msgs);
					YYERROR;
				}

				if ((yyvsp[-1].val) == IPOPT_FIELD_TYPE)
					(yyval.expr)->exthdr.flags = NFT_EXTHDR_F_PRESENT;
			}
#line 15298 "parser_bison.c"
    break;

  case 1075: /* ip_hdr_expr: "ip" "option" ip_option_type close_scope_ip  */
#line 5602 "parser_bison.y"
                        {
				(yyval.expr) = ipopt_expr_alloc(&(yyloc), (yyvsp[-1].val), IPOPT_FIELD_TYPE);
				(yyval.expr)->exthdr.flags = NFT_EXTHDR_F_PRESENT;
			}
#line 15307 "parser_bison.c"
    break;

  case 1076: /* ip_hdr_field: "version"  */
#line 5608 "parser_bison.y"
                                                { (yyval.val) = IPHDR_VERSION; }
#line 15313 "parser_bison.c"
    break;

  case 1077: /* ip_hdr_field: "hdrlength"  */
#line 5609 "parser_bison.y"
                                                { (yyval.val) = IPHDR_HDRLENGTH; }
#line 15319 "parser_bison.c"
    break;

  case 1078: /* ip_hdr_field: "dscp"  */
#line 5610 "parser_bison.y"
                                                { (yyval.val) = IPHDR_DSCP; }
#line 15325 "parser_bison.c"
    break;

  case 1079: /* ip_hdr_field: "ecn"  */
#line 5611 "parser_bison.y"
                                                { (yyval.val) = IPHDR_ECN; }
#line 15331 "parser_bison.c"
    break;

  case 1080: /* ip_hdr_field: "length"  */
#line 5612 "parser_bison.y"
                                                { (yyval.val) = IPHDR_LENGTH; }
#line 15337 "parser_bison.c"
    break;

  case 1081: /* ip_hdr_field: "id"  */
#line 5613 "parser_bison.y"
                                                { (yyval.val) = IPHDR_ID; }
#line 15343 "parser_bison.c"
    break;

  case 1082: /* ip_hdr_field: "frag-off"  */
#line 5614 "parser_bison.y"
                                                { (yyval.val) = IPHDR_FRAG_OFF; }
#line 15349 "parser_bison.c"
    break;

  case 1083: /* ip_hdr_field: "ttl"  */
#line 5615 "parser_bison.y"
                                                { (yyval.val) = IPHDR_TTL; }
#line 15355 "parser_bison.c"
    break;

  case 1084: /* ip_hdr_field: "protocol"  */
#line 5616 "parser_bison.y"
                                                { (yyval.val) = IPHDR_PROTOCOL; }
#line 15361 "parser_bison.c"
    break;

  case 1085: /* ip_hdr_field: "checksum"  */
#line 5617 "parser_bison.y"
                                                { (yyval.val) = IPHDR_CHECKSUM; }
#line 15367 "parser_bison.c"
    break;

  case 1086: /* ip_hdr_field: "saddr"  */
#line 5618 "parser_bison.y"
                                                { (yyval.val) = IPHDR_SADDR; }
#line 15373 "parser_bison.c"
    break;

  case 1087: /* ip_hdr_field: "daddr"  */
#line 5619 "parser_bison.y"
                                                { (yyval.val) = IPHDR_DADDR; }
#line 15379 "parser_bison.c"
    break;

  case 1088: /* ip_option_type: "lsrr"  */
#line 5622 "parser_bison.y"
                                                { (yyval.val) = IPOPT_LSRR; }
#line 15385 "parser_bison.c"
    break;

  case 1089: /* ip_option_type: "rr"  */
#line 5623 "parser_bison.y"
                                                { (yyval.val) = IPOPT_RR; }
#line 15391 "parser_bison.c"
    break;

  case 1090: /* ip_option_type: "ssrr"  */
#line 5624 "parser_bison.y"
                                                { (yyval.val) = IPOPT_SSRR; }
#line 15397 "parser_bison.c"
    break;

  case 1091: /* ip_option_type: "ra"  */
#line 5625 "parser_bison.y"
                                                { (yyval.val) = IPOPT_RA; }
#line 15403 "parser_bison.c"
    break;

  case 1092: /* ip_option_field: "type" close_scope_type  */
#line 5628 "parser_bison.y"
                                                                        { (yyval.val) = IPOPT_FIELD_TYPE; }
#line 15409 "parser_bison.c"
    break;

  case 1093: /* ip_option_field: "length"  */
#line 5629 "parser_bison.y"
                                                { (yyval.val) = IPOPT_FIELD_LENGTH; }
#line 15415 "parser_bison.c"
    break;

  case 1094: /* ip_option_field: "value"  */
#line 5630 "parser_bison.y"
                                                { (yyval.val) = IPOPT_FIELD_VALUE; }
#line 15421 "parser_bison.c"
    break;

  case 1095: /* ip_option_field: "ptr"  */
#line 5631 "parser_bison.y"
                                                { (yyval.val) = IPOPT_FIELD_PTR; }
#line 15427 "parser_bison.c"
    break;

  case 1096: /* ip_option_field: "addr"  */
#line 5632 "parser_bison.y"
                                                { (yyval.val) = IPOPT_FIELD_ADDR_0; }
#line 15433 "parser_bison.c"
    break;

  case 1097: /* icmp_hdr_expr: "icmp" icmp_hdr_field close_scope_icmp  */
#line 5636 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_icmp, (yyvsp[-1].val));
			}
#line 15441 "parser_bison.c"
    break;

  case 1098: /* icmp_hdr_field: "type" close_scope_type  */
#line 5641 "parser_bison.y"
                                                                        { (yyval.val) = ICMPHDR_TYPE; }
#line 15447 "parser_bison.c"
    break;

  case 1099: /* icmp_hdr_field: "code"  */
#line 5642 "parser_bison.y"
                                                { (yyval.val) = ICMPHDR_CODE; }
#line 15453 "parser_bison.c"
    break;

  case 1100: /* icmp_hdr_field: "checksum"  */
#line 5643 "parser_bison.y"
                                                { (yyval.val) = ICMPHDR_CHECKSUM; }
#line 15459 "parser_bison.c"
    break;

  case 1101: /* icmp_hdr_field: "id"  */
#line 5644 "parser_bison.y"
                                                { (yyval.val) = ICMPHDR_ID; }
#line 15465 "parser_bison.c"
    break;

  case 1102: /* icmp_hdr_field: "seq"  */
#line 5645 "parser_bison.y"
                                                { (yyval.val) = ICMPHDR_SEQ; }
#line 15471 "parser_bison.c"
    break;

  case 1103: /* icmp_hdr_field: "gateway"  */
#line 5646 "parser_bison.y"
                                                { (yyval.val) = ICMPHDR_GATEWAY; }
#line 15477 "parser_bison.c"
    break;

  case 1104: /* icmp_hdr_field: "mtu"  */
#line 5647 "parser_bison.y"
                                                { (yyval.val) = ICMPHDR_MTU; }
#line 15483 "parser_bison.c"
    break;

  case 1105: /* igmp_hdr_expr: "igmp" igmp_hdr_field close_scope_igmp  */
#line 5651 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_igmp, (yyvsp[-1].val));
			}
#line 15491 "parser_bison.c"
    break;

  case 1106: /* igmp_hdr_field: "type" close_scope_type  */
#line 5656 "parser_bison.y"
                                                                        { (yyval.val) = IGMPHDR_TYPE; }
#line 15497 "parser_bison.c"
    break;

  case 1107: /* igmp_hdr_field: "checksum"  */
#line 5657 "parser_bison.y"
                                                { (yyval.val) = IGMPHDR_CHECKSUM; }
#line 15503 "parser_bison.c"
    break;

  case 1108: /* igmp_hdr_field: "mrt"  */
#line 5658 "parser_bison.y"
                                                { (yyval.val) = IGMPHDR_MRT; }
#line 15509 "parser_bison.c"
    break;

  case 1109: /* igmp_hdr_field: "group"  */
#line 5659 "parser_bison.y"
                                                { (yyval.val) = IGMPHDR_GROUP; }
#line 15515 "parser_bison.c"
    break;

  case 1110: /* ip6_hdr_expr: "ip6" ip6_hdr_field close_scope_ip6  */
#line 5663 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_ip6, (yyvsp[-1].val));
			}
#line 15523 "parser_bison.c"
    break;

  case 1111: /* ip6_hdr_field: "version"  */
#line 5668 "parser_bison.y"
                                                { (yyval.val) = IP6HDR_VERSION; }
#line 15529 "parser_bison.c"
    break;

  case 1112: /* ip6_hdr_field: "dscp"  */
#line 5669 "parser_bison.y"
                                                { (yyval.val) = IP6HDR_DSCP; }
#line 15535 "parser_bison.c"
    break;

  case 1113: /* ip6_hdr_field: "ecn"  */
#line 5670 "parser_bison.y"
                                                { (yyval.val) = IP6HDR_ECN; }
#line 15541 "parser_bison.c"
    break;

  case 1114: /* ip6_hdr_field: "flowlabel"  */
#line 5671 "parser_bison.y"
                                                { (yyval.val) = IP6HDR_FLOWLABEL; }
#line 15547 "parser_bison.c"
    break;

  case 1115: /* ip6_hdr_field: "length"  */
#line 5672 "parser_bison.y"
                                                { (yyval.val) = IP6HDR_LENGTH; }
#line 15553 "parser_bison.c"
    break;

  case 1116: /* ip6_hdr_field: "nexthdr"  */
#line 5673 "parser_bison.y"
                                                { (yyval.val) = IP6HDR_NEXTHDR; }
#line 15559 "parser_bison.c"
    break;

  case 1117: /* ip6_hdr_field: "hoplimit"  */
#line 5674 "parser_bison.y"
                                                { (yyval.val) = IP6HDR_HOPLIMIT; }
#line 15565 "parser_bison.c"
    break;

  case 1118: /* ip6_hdr_field: "saddr"  */
#line 5675 "parser_bison.y"
                                                { (yyval.val) = IP6HDR_SADDR; }
#line 15571 "parser_bison.c"
    break;

  case 1119: /* ip6_hdr_field: "daddr"  */
#line 5676 "parser_bison.y"
                                                { (yyval.val) = IP6HDR_DADDR; }
#line 15577 "parser_bison.c"
    break;

  case 1120: /* icmp6_hdr_expr: "icmpv6" icmp6_hdr_field close_scope_icmp  */
#line 5679 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_icmp6, (yyvsp[-1].val));
			}
#line 15585 "parser_bison.c"
    break;

  case 1121: /* icmp6_hdr_field: "type" close_scope_type  */
#line 5684 "parser_bison.y"
                                                                        { (yyval.val) = ICMP6HDR_TYPE; }
#line 15591 "parser_bison.c"
    break;

  case 1122: /* icmp6_hdr_field: "code"  */
#line 5685 "parser_bison.y"
                                                { (yyval.val) = ICMP6HDR_CODE; }
#line 15597 "parser_bison.c"
    break;

  case 1123: /* icmp6_hdr_field: "checksum"  */
#line 5686 "parser_bison.y"
                                                { (yyval.val) = ICMP6HDR_CHECKSUM; }
#line 15603 "parser_bison.c"
    break;

  case 1124: /* icmp6_hdr_field: "param-problem"  */
#line 5687 "parser_bison.y"
                                                { (yyval.val) = ICMP6HDR_PPTR; }
#line 15609 "parser_bison.c"
    break;

  case 1125: /* icmp6_hdr_field: "mtu"  */
#line 5688 "parser_bison.y"
                                                { (yyval.val) = ICMP6HDR_MTU; }
#line 15615 "parser_bison.c"
    break;

  case 1126: /* icmp6_hdr_field: "id"  */
#line 5689 "parser_bison.y"
                                                { (yyval.val) = ICMP6HDR_ID; }
#line 15621 "parser_bison.c"
    break;

  case 1127: /* icmp6_hdr_field: "seq"  */
#line 5690 "parser_bison.y"
                                                { (yyval.val) = ICMP6HDR_SEQ; }
#line 15627 "parser_bison.c"
    break;

  case 1128: /* icmp6_hdr_field: "max-delay"  */
#line 5691 "parser_bison.y"
                                                { (yyval.val) = ICMP6HDR_MAXDELAY; }
#line 15633 "parser_bison.c"
    break;

  case 1129: /* auth_hdr_expr: "ah" auth_hdr_field close_scope_ah  */
#line 5695 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_ah, (yyvsp[-1].val));
			}
#line 15641 "parser_bison.c"
    break;

  case 1130: /* auth_hdr_field: "nexthdr"  */
#line 5700 "parser_bison.y"
                                                { (yyval.val) = AHHDR_NEXTHDR; }
#line 15647 "parser_bison.c"
    break;

  case 1131: /* auth_hdr_field: "hdrlength"  */
#line 5701 "parser_bison.y"
                                                { (yyval.val) = AHHDR_HDRLENGTH; }
#line 15653 "parser_bison.c"
    break;

  case 1132: /* auth_hdr_field: "reserved"  */
#line 5702 "parser_bison.y"
                                                { (yyval.val) = AHHDR_RESERVED; }
#line 15659 "parser_bison.c"
    break;

  case 1133: /* auth_hdr_field: "spi"  */
#line 5703 "parser_bison.y"
                                                { (yyval.val) = AHHDR_SPI; }
#line 15665 "parser_bison.c"
    break;

  case 1134: /* auth_hdr_field: "seq"  */
#line 5704 "parser_bison.y"
                                                { (yyval.val) = AHHDR_SEQUENCE; }
#line 15671 "parser_bison.c"
    break;

  case 1135: /* esp_hdr_expr: "esp" esp_hdr_field close_scope_esp  */
#line 5708 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_esp, (yyvsp[-1].val));
			}
#line 15679 "parser_bison.c"
    break;

  case 1136: /* esp_hdr_field: "spi"  */
#line 5713 "parser_bison.y"
                                                { (yyval.val) = ESPHDR_SPI; }
#line 15685 "parser_bison.c"
    break;

  case 1137: /* esp_hdr_field: "seq"  */
#line 5714 "parser_bison.y"
                                                { (yyval.val) = ESPHDR_SEQUENCE; }
#line 15691 "parser_bison.c"
    break;

  case 1138: /* comp_hdr_expr: "comp" comp_hdr_field close_scope_comp  */
#line 5718 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_comp, (yyvsp[-1].val));
			}
#line 15699 "parser_bison.c"
    break;

  case 1139: /* comp_hdr_field: "nexthdr"  */
#line 5723 "parser_bison.y"
                                                { (yyval.val) = COMPHDR_NEXTHDR; }
#line 15705 "parser_bison.c"
    break;

  case 1140: /* comp_hdr_field: "flags"  */
#line 5724 "parser_bison.y"
                                                { (yyval.val) = COMPHDR_FLAGS; }
#line 15711 "parser_bison.c"
    break;

  case 1141: /* comp_hdr_field: "cpi"  */
#line 5725 "parser_bison.y"
                                                { (yyval.val) = COMPHDR_CPI; }
#line 15717 "parser_bison.c"
    break;

  case 1142: /* udp_hdr_expr: "udp" udp_hdr_field close_scope_udp  */
#line 5729 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_udp, (yyvsp[-1].val));
			}
#line 15725 "parser_bison.c"
    break;

  case 1143: /* udp_hdr_field: "sport"  */
#line 5734 "parser_bison.y"
                                                { (yyval.val) = UDPHDR_SPORT; }
#line 15731 "parser_bison.c"
    break;

  case 1144: /* udp_hdr_field: "dport"  */
#line 5735 "parser_bison.y"
                                                { (yyval.val) = UDPHDR_DPORT; }
#line 15737 "parser_bison.c"
    break;

  case 1145: /* udp_hdr_field: "length"  */
#line 5736 "parser_bison.y"
                                                { (yyval.val) = UDPHDR_LENGTH; }
#line 15743 "parser_bison.c"
    break;

  case 1146: /* udp_hdr_field: "checksum"  */
#line 5737 "parser_bison.y"
                                                { (yyval.val) = UDPHDR_CHECKSUM; }
#line 15749 "parser_bison.c"
    break;

  case 1147: /* udplite_hdr_expr: "udplite" udplite_hdr_field close_scope_udplite  */
#line 5741 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_udplite, (yyvsp[-1].val));
			}
#line 15757 "parser_bison.c"
    break;

  case 1148: /* udplite_hdr_field: "sport"  */
#line 5746 "parser_bison.y"
                                                { (yyval.val) = UDPHDR_SPORT; }
#line 15763 "parser_bison.c"
    break;

  case 1149: /* udplite_hdr_field: "dport"  */
#line 5747 "parser_bison.y"
                                                { (yyval.val) = UDPHDR_DPORT; }
#line 15769 "parser_bison.c"
    break;

  case 1150: /* udplite_hdr_field: "csumcov"  */
#line 5748 "parser_bison.y"
                                                { (yyval.val) = UDPHDR_LENGTH; }
#line 15775 "parser_bison.c"
    break;

  case 1151: /* udplite_hdr_field: "checksum"  */
#line 5749 "parser_bison.y"
                                                { (yyval.val) = UDPHDR_CHECKSUM; }
#line 15781 "parser_bison.c"
    break;

  case 1152: /* tcp_hdr_expr: "tcp" tcp_hdr_field  */
#line 5753 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_tcp, (yyvsp[0].val));
			}
#line 15789 "parser_bison.c"
    break;

  case 1153: /* tcp_hdr_expr: "tcp" "option" tcp_hdr_option_type  */
#line 5757 "parser_bison.y"
                        {
				(yyval.expr) = tcpopt_expr_alloc(&(yyloc), (yyvsp[0].val), TCPOPT_COMMON_KIND);
				(yyval.expr)->exthdr.flags = NFT_EXTHDR_F_PRESENT;
			}
#line 15798 "parser_bison.c"
    break;

  case 1154: /* tcp_hdr_expr: "tcp" "option" tcp_hdr_option_kind_and_field  */
#line 5762 "parser_bison.y"
                        {
				(yyval.expr) = tcpopt_expr_alloc(&(yyloc), (yyvsp[0].tcp_kind_field).kind, (yyvsp[0].tcp_kind_field).field);
				if ((yyval.expr) == NULL) {
					erec_queue(error(&(yylsp[-2]), "Could not find a tcp option template"), state->msgs);
					YYERROR;
				}
			}
#line 15810 "parser_bison.c"
    break;

  case 1155: /* tcp_hdr_expr: "tcp" "option" "@" close_scope_at tcp_hdr_option_type "comma" "number" "comma" payload_raw_len  */
#line 5770 "parser_bison.y"
                        {
				(yyval.expr) = tcpopt_expr_alloc(&(yyloc), (yyvsp[-4].val), 0);
				tcpopt_init_raw((yyval.expr), (yyvsp[-4].val), (yyvsp[-2].val), (yyvsp[0].val), 0);
			}
#line 15819 "parser_bison.c"
    break;

  case 1156: /* optstrip_stmt: "reset" "tcp" "option" tcp_hdr_option_type close_scope_tcp  */
#line 5777 "parser_bison.y"
                        {
				(yyval.stmt) = optstrip_stmt_alloc(&(yyloc), tcpopt_expr_alloc(&(yyloc),
										(yyvsp[-1].val), TCPOPT_COMMON_KIND));
			}
#line 15828 "parser_bison.c"
    break;

  case 1157: /* tcp_hdr_field: "sport"  */
#line 5783 "parser_bison.y"
                                                { (yyval.val) = TCPHDR_SPORT; }
#line 15834 "parser_bison.c"
    break;

  case 1158: /* tcp_hdr_field: "dport"  */
#line 5784 "parser_bison.y"
                                                { (yyval.val) = TCPHDR_DPORT; }
#line 15840 "parser_bison.c"
    break;

  case 1159: /* tcp_hdr_field: "seq"  */
#line 5785 "parser_bison.y"
                                                { (yyval.val) = TCPHDR_SEQ; }
#line 15846 "parser_bison.c"
    break;

  case 1160: /* tcp_hdr_field: "ackseq"  */
#line 5786 "parser_bison.y"
                                                { (yyval.val) = TCPHDR_ACKSEQ; }
#line 15852 "parser_bison.c"
    break;

  case 1161: /* tcp_hdr_field: "doff"  */
#line 5787 "parser_bison.y"
                                                { (yyval.val) = TCPHDR_DOFF; }
#line 15858 "parser_bison.c"
    break;

  case 1162: /* tcp_hdr_field: "reserved"  */
#line 5788 "parser_bison.y"
                                                { (yyval.val) = TCPHDR_RESERVED; }
#line 15864 "parser_bison.c"
    break;

  case 1163: /* tcp_hdr_field: "flags"  */
#line 5789 "parser_bison.y"
                                                { (yyval.val) = TCPHDR_FLAGS; }
#line 15870 "parser_bison.c"
    break;

  case 1164: /* tcp_hdr_field: "window"  */
#line 5790 "parser_bison.y"
                                                { (yyval.val) = TCPHDR_WINDOW; }
#line 15876 "parser_bison.c"
    break;

  case 1165: /* tcp_hdr_field: "checksum"  */
#line 5791 "parser_bison.y"
                                                { (yyval.val) = TCPHDR_CHECKSUM; }
#line 15882 "parser_bison.c"
    break;

  case 1166: /* tcp_hdr_field: "urgptr"  */
#line 5792 "parser_bison.y"
                                                { (yyval.val) = TCPHDR_URGPTR; }
#line 15888 "parser_bison.c"
    break;

  case 1167: /* tcp_hdr_option_kind_and_field: "mss" tcpopt_field_maxseg  */
#line 5796 "parser_bison.y"
                                {
					struct tcp_kind_field kind_field = { .kind = TCPOPT_KIND_MAXSEG, .field = (yyvsp[0].val) };
					(yyval.tcp_kind_field) = kind_field;
				}
#line 15897 "parser_bison.c"
    break;

  case 1168: /* tcp_hdr_option_kind_and_field: tcp_hdr_option_sack tcpopt_field_sack  */
#line 5801 "parser_bison.y"
                                {
					struct tcp_kind_field kind_field = { .kind = (yyvsp[-1].val), .field = (yyvsp[0].val) };
					(yyval.tcp_kind_field) = kind_field;
				}
#line 15906 "parser_bison.c"
    break;

  case 1169: /* tcp_hdr_option_kind_and_field: "window" tcpopt_field_window  */
#line 5806 "parser_bison.y"
                                {
					struct tcp_kind_field kind_field = { .kind = TCPOPT_KIND_WINDOW, .field = (yyvsp[0].val) };
					(yyval.tcp_kind_field) = kind_field;
				}
#line 15915 "parser_bison.c"
    break;

  case 1170: /* tcp_hdr_option_kind_and_field: "timestamp" tcpopt_field_tsopt  */
#line 5811 "parser_bison.y"
                                {
					struct tcp_kind_field kind_field = { .kind = TCPOPT_KIND_TIMESTAMP, .field = (yyvsp[0].val) };
					(yyval.tcp_kind_field) = kind_field;
				}
#line 15924 "parser_bison.c"
    break;

  case 1171: /* tcp_hdr_option_kind_and_field: tcp_hdr_option_type "length"  */
#line 5816 "parser_bison.y"
                                {
					struct tcp_kind_field kind_field = { .kind = (yyvsp[-1].val), .field = TCPOPT_COMMON_LENGTH };
					(yyval.tcp_kind_field) = kind_field;
				}
#line 15933 "parser_bison.c"
    break;

  case 1172: /* tcp_hdr_option_kind_and_field: "mptcp" tcpopt_field_mptcp  */
#line 5821 "parser_bison.y"
                                {
					struct tcp_kind_field kind_field = { .kind = TCPOPT_KIND_MPTCP, .field = (yyvsp[0].val) };
					(yyval.tcp_kind_field) = kind_field;
				}
#line 15942 "parser_bison.c"
    break;

  case 1173: /* tcp_hdr_option_sack: "sack"  */
#line 5827 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_KIND_SACK; }
#line 15948 "parser_bison.c"
    break;

  case 1174: /* tcp_hdr_option_sack: "sack0"  */
#line 5828 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_KIND_SACK; }
#line 15954 "parser_bison.c"
    break;

  case 1175: /* tcp_hdr_option_sack: "sack1"  */
#line 5829 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_KIND_SACK1; }
#line 15960 "parser_bison.c"
    break;

  case 1176: /* tcp_hdr_option_sack: "sack2"  */
#line 5830 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_KIND_SACK2; }
#line 15966 "parser_bison.c"
    break;

  case 1177: /* tcp_hdr_option_sack: "sack3"  */
#line 5831 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_KIND_SACK3; }
#line 15972 "parser_bison.c"
    break;

  case 1178: /* tcp_hdr_option_type: "echo"  */
#line 5834 "parser_bison.y"
                                                        { (yyval.val) = TCPOPT_KIND_ECHO; }
#line 15978 "parser_bison.c"
    break;

  case 1179: /* tcp_hdr_option_type: "eol"  */
#line 5835 "parser_bison.y"
                                                        { (yyval.val) = TCPOPT_KIND_EOL; }
#line 15984 "parser_bison.c"
    break;

  case 1180: /* tcp_hdr_option_type: "fastopen"  */
#line 5836 "parser_bison.y"
                                                        { (yyval.val) = TCPOPT_KIND_FASTOPEN; }
#line 15990 "parser_bison.c"
    break;

  case 1181: /* tcp_hdr_option_type: "md5sig"  */
#line 5837 "parser_bison.y"
                                                        { (yyval.val) = TCPOPT_KIND_MD5SIG; }
#line 15996 "parser_bison.c"
    break;

  case 1182: /* tcp_hdr_option_type: "mptcp"  */
#line 5838 "parser_bison.y"
                                                        { (yyval.val) = TCPOPT_KIND_MPTCP; }
#line 16002 "parser_bison.c"
    break;

  case 1183: /* tcp_hdr_option_type: "mss"  */
#line 5839 "parser_bison.y"
                                                        { (yyval.val) = TCPOPT_KIND_MAXSEG; }
#line 16008 "parser_bison.c"
    break;

  case 1184: /* tcp_hdr_option_type: "nop"  */
#line 5840 "parser_bison.y"
                                                        { (yyval.val) = TCPOPT_KIND_NOP; }
#line 16014 "parser_bison.c"
    break;

  case 1185: /* tcp_hdr_option_type: "sack-permitted"  */
#line 5841 "parser_bison.y"
                                                        { (yyval.val) = TCPOPT_KIND_SACK_PERMITTED; }
#line 16020 "parser_bison.c"
    break;

  case 1186: /* tcp_hdr_option_type: "timestamp"  */
#line 5842 "parser_bison.y"
                                                        { (yyval.val) = TCPOPT_KIND_TIMESTAMP; }
#line 16026 "parser_bison.c"
    break;

  case 1187: /* tcp_hdr_option_type: "window"  */
#line 5843 "parser_bison.y"
                                                        { (yyval.val) = TCPOPT_KIND_WINDOW; }
#line 16032 "parser_bison.c"
    break;

  case 1188: /* tcp_hdr_option_type: tcp_hdr_option_sack  */
#line 5844 "parser_bison.y"
                                                        { (yyval.val) = (yyvsp[0].val); }
#line 16038 "parser_bison.c"
    break;

  case 1189: /* tcp_hdr_option_type: "number"  */
#line 5845 "parser_bison.y"
                                                        {
				if ((yyvsp[0].val) > 255) {
					erec_queue(error(&(yylsp[0]), "value too large"), state->msgs);
					YYERROR;
				}
				(yyval.val) = (yyvsp[0].val);
			}
#line 16050 "parser_bison.c"
    break;

  case 1190: /* tcpopt_field_sack: "left"  */
#line 5854 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_SACK_LEFT; }
#line 16056 "parser_bison.c"
    break;

  case 1191: /* tcpopt_field_sack: "right"  */
#line 5855 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_SACK_RIGHT; }
#line 16062 "parser_bison.c"
    break;

  case 1192: /* tcpopt_field_window: "count"  */
#line 5858 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_WINDOW_COUNT; }
#line 16068 "parser_bison.c"
    break;

  case 1193: /* tcpopt_field_tsopt: "tsval"  */
#line 5861 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_TS_TSVAL; }
#line 16074 "parser_bison.c"
    break;

  case 1194: /* tcpopt_field_tsopt: "tsecr"  */
#line 5862 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_TS_TSECR; }
#line 16080 "parser_bison.c"
    break;

  case 1195: /* tcpopt_field_maxseg: "size"  */
#line 5865 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_MAXSEG_SIZE; }
#line 16086 "parser_bison.c"
    break;

  case 1196: /* tcpopt_field_mptcp: "subtype"  */
#line 5868 "parser_bison.y"
                                                { (yyval.val) = TCPOPT_MPTCP_SUBTYPE; }
#line 16092 "parser_bison.c"
    break;

  case 1197: /* dccp_hdr_expr: "dccp" dccp_hdr_field close_scope_dccp  */
#line 5872 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_dccp, (yyvsp[-1].val));
			}
#line 16100 "parser_bison.c"
    break;

  case 1198: /* dccp_hdr_field: "sport"  */
#line 5877 "parser_bison.y"
                                                { (yyval.val) = DCCPHDR_SPORT; }
#line 16106 "parser_bison.c"
    break;

  case 1199: /* dccp_hdr_field: "dport"  */
#line 5878 "parser_bison.y"
                                                { (yyval.val) = DCCPHDR_DPORT; }
#line 16112 "parser_bison.c"
    break;

  case 1200: /* dccp_hdr_field: "type" close_scope_type  */
#line 5879 "parser_bison.y"
                                                                        { (yyval.val) = DCCPHDR_TYPE; }
#line 16118 "parser_bison.c"
    break;

  case 1201: /* sctp_chunk_type: "data"  */
#line 5882 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_DATA; }
#line 16124 "parser_bison.c"
    break;

  case 1202: /* sctp_chunk_type: "init"  */
#line 5883 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_INIT; }
#line 16130 "parser_bison.c"
    break;

  case 1203: /* sctp_chunk_type: "init-ack"  */
#line 5884 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_INIT_ACK; }
#line 16136 "parser_bison.c"
    break;

  case 1204: /* sctp_chunk_type: "sack"  */
#line 5885 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_SACK; }
#line 16142 "parser_bison.c"
    break;

  case 1205: /* sctp_chunk_type: "heartbeat"  */
#line 5886 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_HEARTBEAT; }
#line 16148 "parser_bison.c"
    break;

  case 1206: /* sctp_chunk_type: "heartbeat-ack"  */
#line 5887 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_HEARTBEAT_ACK; }
#line 16154 "parser_bison.c"
    break;

  case 1207: /* sctp_chunk_type: "abort"  */
#line 5888 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_ABORT; }
#line 16160 "parser_bison.c"
    break;

  case 1208: /* sctp_chunk_type: "shutdown"  */
#line 5889 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_SHUTDOWN; }
#line 16166 "parser_bison.c"
    break;

  case 1209: /* sctp_chunk_type: "shutdown-ack"  */
#line 5890 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_SHUTDOWN_ACK; }
#line 16172 "parser_bison.c"
    break;

  case 1210: /* sctp_chunk_type: "error"  */
#line 5891 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_ERROR; }
#line 16178 "parser_bison.c"
    break;

  case 1211: /* sctp_chunk_type: "cookie-echo"  */
#line 5892 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_COOKIE_ECHO; }
#line 16184 "parser_bison.c"
    break;

  case 1212: /* sctp_chunk_type: "cookie-ack"  */
#line 5893 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_COOKIE_ACK; }
#line 16190 "parser_bison.c"
    break;

  case 1213: /* sctp_chunk_type: "ecne"  */
#line 5894 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_ECNE; }
#line 16196 "parser_bison.c"
    break;

  case 1214: /* sctp_chunk_type: "cwr"  */
#line 5895 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_CWR; }
#line 16202 "parser_bison.c"
    break;

  case 1215: /* sctp_chunk_type: "shutdown-complete"  */
#line 5896 "parser_bison.y"
                                                  { (yyval.val) = SCTP_CHUNK_TYPE_SHUTDOWN_COMPLETE; }
#line 16208 "parser_bison.c"
    break;

  case 1216: /* sctp_chunk_type: "asconf-ack"  */
#line 5897 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_ASCONF_ACK; }
#line 16214 "parser_bison.c"
    break;

  case 1217: /* sctp_chunk_type: "forward-tsn"  */
#line 5898 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_FORWARD_TSN; }
#line 16220 "parser_bison.c"
    break;

  case 1218: /* sctp_chunk_type: "asconf"  */
#line 5899 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_TYPE_ASCONF; }
#line 16226 "parser_bison.c"
    break;

  case 1219: /* sctp_chunk_common_field: "type" close_scope_type  */
#line 5902 "parser_bison.y"
                                                                { (yyval.val) = SCTP_CHUNK_COMMON_TYPE; }
#line 16232 "parser_bison.c"
    break;

  case 1220: /* sctp_chunk_common_field: "flags"  */
#line 5903 "parser_bison.y"
                                        { (yyval.val) = SCTP_CHUNK_COMMON_FLAGS; }
#line 16238 "parser_bison.c"
    break;

  case 1221: /* sctp_chunk_common_field: "length"  */
#line 5904 "parser_bison.y"
                                        { (yyval.val) = SCTP_CHUNK_COMMON_LENGTH; }
#line 16244 "parser_bison.c"
    break;

  case 1222: /* sctp_chunk_data_field: "tsn"  */
#line 5907 "parser_bison.y"
                                        { (yyval.val) = SCTP_CHUNK_DATA_TSN; }
#line 16250 "parser_bison.c"
    break;

  case 1223: /* sctp_chunk_data_field: "stream"  */
#line 5908 "parser_bison.y"
                                        { (yyval.val) = SCTP_CHUNK_DATA_STREAM; }
#line 16256 "parser_bison.c"
    break;

  case 1224: /* sctp_chunk_data_field: "ssn"  */
#line 5909 "parser_bison.y"
                                        { (yyval.val) = SCTP_CHUNK_DATA_SSN; }
#line 16262 "parser_bison.c"
    break;

  case 1225: /* sctp_chunk_data_field: "ppid"  */
#line 5910 "parser_bison.y"
                                        { (yyval.val) = SCTP_CHUNK_DATA_PPID; }
#line 16268 "parser_bison.c"
    break;

  case 1226: /* sctp_chunk_init_field: "init-tag"  */
#line 5913 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_INIT_TAG; }
#line 16274 "parser_bison.c"
    break;

  case 1227: /* sctp_chunk_init_field: "a-rwnd"  */
#line 5914 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_INIT_RWND; }
#line 16280 "parser_bison.c"
    break;

  case 1228: /* sctp_chunk_init_field: "num-outbound-streams"  */
#line 5915 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_INIT_OSTREAMS; }
#line 16286 "parser_bison.c"
    break;

  case 1229: /* sctp_chunk_init_field: "num-inbound-streams"  */
#line 5916 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_INIT_ISTREAMS; }
#line 16292 "parser_bison.c"
    break;

  case 1230: /* sctp_chunk_init_field: "initial-tsn"  */
#line 5917 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_INIT_TSN; }
#line 16298 "parser_bison.c"
    break;

  case 1231: /* sctp_chunk_sack_field: "cum-tsn-ack"  */
#line 5920 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_SACK_CTSN_ACK; }
#line 16304 "parser_bison.c"
    break;

  case 1232: /* sctp_chunk_sack_field: "a-rwnd"  */
#line 5921 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_SACK_RWND; }
#line 16310 "parser_bison.c"
    break;

  case 1233: /* sctp_chunk_sack_field: "num-gap-ack-blocks"  */
#line 5922 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_SACK_GACK_BLOCKS; }
#line 16316 "parser_bison.c"
    break;

  case 1234: /* sctp_chunk_sack_field: "num-dup-tsns"  */
#line 5923 "parser_bison.y"
                                                { (yyval.val) = SCTP_CHUNK_SACK_DUP_TSNS; }
#line 16322 "parser_bison.c"
    break;

  case 1235: /* sctp_chunk_alloc: sctp_chunk_type  */
#line 5927 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), (yyvsp[0].val), SCTP_CHUNK_COMMON_TYPE);
				(yyval.expr)->exthdr.flags = NFT_EXTHDR_F_PRESENT;
			}
#line 16331 "parser_bison.c"
    break;

  case 1236: /* sctp_chunk_alloc: sctp_chunk_type sctp_chunk_common_field  */
#line 5932 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), (yyvsp[-1].val), (yyvsp[0].val));
			}
#line 16339 "parser_bison.c"
    break;

  case 1237: /* sctp_chunk_alloc: "data" sctp_chunk_data_field  */
#line 5936 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), SCTP_CHUNK_TYPE_DATA, (yyvsp[0].val));
			}
#line 16347 "parser_bison.c"
    break;

  case 1238: /* sctp_chunk_alloc: "init" sctp_chunk_init_field  */
#line 5940 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), SCTP_CHUNK_TYPE_INIT, (yyvsp[0].val));
			}
#line 16355 "parser_bison.c"
    break;

  case 1239: /* sctp_chunk_alloc: "init-ack" sctp_chunk_init_field  */
#line 5944 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), SCTP_CHUNK_TYPE_INIT_ACK, (yyvsp[0].val));
			}
#line 16363 "parser_bison.c"
    break;

  case 1240: /* sctp_chunk_alloc: "sack" sctp_chunk_sack_field  */
#line 5948 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), SCTP_CHUNK_TYPE_SACK, (yyvsp[0].val));
			}
#line 16371 "parser_bison.c"
    break;

  case 1241: /* sctp_chunk_alloc: "shutdown" "cum-tsn-ack"  */
#line 5952 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), SCTP_CHUNK_TYPE_SHUTDOWN,
							   SCTP_CHUNK_SHUTDOWN_CTSN_ACK);
			}
#line 16380 "parser_bison.c"
    break;

  case 1242: /* sctp_chunk_alloc: "ecne" "lowest-tsn"  */
#line 5957 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), SCTP_CHUNK_TYPE_ECNE,
							   SCTP_CHUNK_ECNE_CWR_MIN_TSN);
			}
#line 16389 "parser_bison.c"
    break;

  case 1243: /* sctp_chunk_alloc: "cwr" "lowest-tsn"  */
#line 5962 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), SCTP_CHUNK_TYPE_CWR,
							   SCTP_CHUNK_ECNE_CWR_MIN_TSN);
			}
#line 16398 "parser_bison.c"
    break;

  case 1244: /* sctp_chunk_alloc: "asconf-ack" "seqno"  */
#line 5967 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), SCTP_CHUNK_TYPE_ASCONF_ACK,
							   SCTP_CHUNK_ASCONF_SEQNO);
			}
#line 16407 "parser_bison.c"
    break;

  case 1245: /* sctp_chunk_alloc: "forward-tsn" "new-cum-tsn"  */
#line 5972 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), SCTP_CHUNK_TYPE_FORWARD_TSN,
							   SCTP_CHUNK_FORWARD_TSN_NCTSN);
			}
#line 16416 "parser_bison.c"
    break;

  case 1246: /* sctp_chunk_alloc: "asconf" "seqno"  */
#line 5977 "parser_bison.y"
                        {
				(yyval.expr) = sctp_chunk_expr_alloc(&(yyloc), SCTP_CHUNK_TYPE_ASCONF,
							   SCTP_CHUNK_ASCONF_SEQNO);
			}
#line 16425 "parser_bison.c"
    break;

  case 1247: /* sctp_hdr_expr: "sctp" sctp_hdr_field close_scope_sctp  */
#line 5984 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_sctp, (yyvsp[-1].val));
			}
#line 16433 "parser_bison.c"
    break;

  case 1248: /* sctp_hdr_expr: "sctp" "chunk" sctp_chunk_alloc close_scope_sctp_chunk close_scope_sctp  */
#line 5988 "parser_bison.y"
                        {
				(yyval.expr) = (yyvsp[-2].expr);
			}
#line 16441 "parser_bison.c"
    break;

  case 1249: /* sctp_hdr_field: "sport"  */
#line 5993 "parser_bison.y"
                                                { (yyval.val) = SCTPHDR_SPORT; }
#line 16447 "parser_bison.c"
    break;

  case 1250: /* sctp_hdr_field: "dport"  */
#line 5994 "parser_bison.y"
                                                { (yyval.val) = SCTPHDR_DPORT; }
#line 16453 "parser_bison.c"
    break;

  case 1251: /* sctp_hdr_field: "vtag"  */
#line 5995 "parser_bison.y"
                                                { (yyval.val) = SCTPHDR_VTAG; }
#line 16459 "parser_bison.c"
    break;

  case 1252: /* sctp_hdr_field: "checksum"  */
#line 5996 "parser_bison.y"
                                                { (yyval.val) = SCTPHDR_CHECKSUM; }
#line 16465 "parser_bison.c"
    break;

  case 1253: /* th_hdr_expr: "th" th_hdr_field close_scope_th  */
#line 6000 "parser_bison.y"
                        {
				(yyval.expr) = payload_expr_alloc(&(yyloc), &proto_th, (yyvsp[-1].val));
				if ((yyval.expr))
					(yyval.expr)->payload.is_raw = true;
			}
#line 16475 "parser_bison.c"
    break;

  case 1254: /* th_hdr_field: "sport"  */
#line 6007 "parser_bison.y"
                                                { (yyval.val) = THDR_SPORT; }
#line 16481 "parser_bison.c"
    break;

  case 1255: /* th_hdr_field: "dport"  */
#line 6008 "parser_bison.y"
                                                { (yyval.val) = THDR_DPORT; }
#line 16487 "parser_bison.c"
    break;

  case 1264: /* hbh_hdr_expr: "hbh" hbh_hdr_field close_scope_hbh  */
#line 6022 "parser_bison.y"
                        {
				(yyval.expr) = exthdr_expr_alloc(&(yyloc), &exthdr_hbh, (yyvsp[-1].val));
			}
#line 16495 "parser_bison.c"
    break;

  case 1265: /* hbh_hdr_field: "nexthdr"  */
#line 6027 "parser_bison.y"
                                                { (yyval.val) = HBHHDR_NEXTHDR; }
#line 16501 "parser_bison.c"
    break;

  case 1266: /* hbh_hdr_field: "hdrlength"  */
#line 6028 "parser_bison.y"
                                                { (yyval.val) = HBHHDR_HDRLENGTH; }
#line 16507 "parser_bison.c"
    break;

  case 1267: /* rt_hdr_expr: "rt" rt_hdr_field close_scope_rt  */
#line 6032 "parser_bison.y"
                        {
				(yyval.expr) = exthdr_expr_alloc(&(yyloc), &exthdr_rt, (yyvsp[-1].val));
			}
#line 16515 "parser_bison.c"
    break;

  case 1268: /* rt_hdr_field: "nexthdr"  */
#line 6037 "parser_bison.y"
                                                { (yyval.val) = RTHDR_NEXTHDR; }
#line 16521 "parser_bison.c"
    break;

  case 1269: /* rt_hdr_field: "hdrlength"  */
#line 6038 "parser_bison.y"
                                                { (yyval.val) = RTHDR_HDRLENGTH; }
#line 16527 "parser_bison.c"
    break;

  case 1270: /* rt_hdr_field: "type" close_scope_type  */
#line 6039 "parser_bison.y"
                                                                        { (yyval.val) = RTHDR_TYPE; }
#line 16533 "parser_bison.c"
    break;

  case 1271: /* rt_hdr_field: "seg-left"  */
#line 6040 "parser_bison.y"
                                                { (yyval.val) = RTHDR_SEG_LEFT; }
#line 16539 "parser_bison.c"
    break;

  case 1272: /* rt0_hdr_expr: "rt0" rt0_hdr_field close_scope_rt  */
#line 6044 "parser_bison.y"
                        {
				(yyval.expr) = exthdr_expr_alloc(&(yyloc), &exthdr_rt0, (yyvsp[-1].val));
			}
#line 16547 "parser_bison.c"
    break;

  case 1273: /* rt0_hdr_field: "addr" '[' "number" ']'  */
#line 6050 "parser_bison.y"
                        {
				(yyval.val) = RT0HDR_ADDR_1 + (yyvsp[-1].val) - 1;
			}
#line 16555 "parser_bison.c"
    break;

  case 1274: /* rt2_hdr_expr: "rt2" rt2_hdr_field close_scope_rt  */
#line 6056 "parser_bison.y"
                        {
				(yyval.expr) = exthdr_expr_alloc(&(yyloc), &exthdr_rt2, (yyvsp[-1].val));
			}
#line 16563 "parser_bison.c"
    break;

  case 1275: /* rt2_hdr_field: "addr"  */
#line 6061 "parser_bison.y"
                                                { (yyval.val) = RT2HDR_ADDR; }
#line 16569 "parser_bison.c"
    break;

  case 1276: /* rt4_hdr_expr: "srh" rt4_hdr_field close_scope_rt  */
#line 6065 "parser_bison.y"
                        {
				(yyval.expr) = exthdr_expr_alloc(&(yyloc), &exthdr_rt4, (yyvsp[-1].val));
			}
#line 16577 "parser_bison.c"
    break;

  case 1277: /* rt4_hdr_field: "last-entry"  */
#line 6070 "parser_bison.y"
                                                { (yyval.val) = RT4HDR_LASTENT; }
#line 16583 "parser_bison.c"
    break;

  case 1278: /* rt4_hdr_field: "flags"  */
#line 6071 "parser_bison.y"
                                                { (yyval.val) = RT4HDR_FLAGS; }
#line 16589 "parser_bison.c"
    break;

  case 1279: /* rt4_hdr_field: "tag"  */
#line 6072 "parser_bison.y"
                                                { (yyval.val) = RT4HDR_TAG; }
#line 16595 "parser_bison.c"
    break;

  case 1280: /* rt4_hdr_field: "sid" '[' "number" ']'  */
#line 6074 "parser_bison.y"
                        {
				(yyval.val) = RT4HDR_SID_1 + (yyvsp[-1].val) - 1;
			}
#line 16603 "parser_bison.c"
    break;

  case 1281: /* frag_hdr_expr: "frag" frag_hdr_field close_scope_frag  */
#line 6080 "parser_bison.y"
                        {
				(yyval.expr) = exthdr_expr_alloc(&(yyloc), &exthdr_frag, (yyvsp[-1].val));
			}
#line 16611 "parser_bison.c"
    break;

  case 1282: /* frag_hdr_field: "nexthdr"  */
#line 6085 "parser_bison.y"
                                                { (yyval.val) = FRAGHDR_NEXTHDR; }
#line 16617 "parser_bison.c"
    break;

  case 1283: /* frag_hdr_field: "reserved"  */
#line 6086 "parser_bison.y"
                                                { (yyval.val) = FRAGHDR_RESERVED; }
#line 16623 "parser_bison.c"
    break;

  case 1284: /* frag_hdr_field: "frag-off"  */
#line 6087 "parser_bison.y"
                                                { (yyval.val) = FRAGHDR_FRAG_OFF; }
#line 16629 "parser_bison.c"
    break;

  case 1285: /* frag_hdr_field: "reserved2"  */
#line 6088 "parser_bison.y"
                                                { (yyval.val) = FRAGHDR_RESERVED2; }
#line 16635 "parser_bison.c"
    break;

  case 1286: /* frag_hdr_field: "more-fragments"  */
#line 6089 "parser_bison.y"
                                                { (yyval.val) = FRAGHDR_MFRAGS; }
#line 16641 "parser_bison.c"
    break;

  case 1287: /* frag_hdr_field: "id"  */
#line 6090 "parser_bison.y"
                                                { (yyval.val) = FRAGHDR_ID; }
#line 16647 "parser_bison.c"
    break;

  case 1288: /* dst_hdr_expr: "dst" dst_hdr_field close_scope_dst  */
#line 6094 "parser_bison.y"
                        {
				(yyval.expr) = exthdr_expr_alloc(&(yyloc), &exthdr_dst, (yyvsp[-1].val));
			}
#line 16655 "parser_bison.c"
    break;

  case 1289: /* dst_hdr_field: "nexthdr"  */
#line 6099 "parser_bison.y"
                                                { (yyval.val) = DSTHDR_NEXTHDR; }
#line 16661 "parser_bison.c"
    break;

  case 1290: /* dst_hdr_field: "hdrlength"  */
#line 6100 "parser_bison.y"
                                                { (yyval.val) = DSTHDR_HDRLENGTH; }
#line 16667 "parser_bison.c"
    break;

  case 1291: /* mh_hdr_expr: "mh" mh_hdr_field close_scope_mh  */
#line 6104 "parser_bison.y"
                        {
				(yyval.expr) = exthdr_expr_alloc(&(yyloc), &exthdr_mh, (yyvsp[-1].val));
			}
#line 16675 "parser_bison.c"
    break;

  case 1292: /* mh_hdr_field: "nexthdr"  */
#line 6109 "parser_bison.y"
                                                { (yyval.val) = MHHDR_NEXTHDR; }
#line 16681 "parser_bison.c"
    break;

  case 1293: /* mh_hdr_field: "hdrlength"  */
#line 6110 "parser_bison.y"
                                                { (yyval.val) = MHHDR_HDRLENGTH; }
#line 16687 "parser_bison.c"
    break;

  case 1294: /* mh_hdr_field: "type" close_scope_type  */
#line 6111 "parser_bison.y"
                                                                        { (yyval.val) = MHHDR_TYPE; }
#line 16693 "parser_bison.c"
    break;

  case 1295: /* mh_hdr_field: "reserved"  */
#line 6112 "parser_bison.y"
                                                { (yyval.val) = MHHDR_RESERVED; }
#line 16699 "parser_bison.c"
    break;

  case 1296: /* mh_hdr_field: "checksum"  */
#line 6113 "parser_bison.y"
                                                { (yyval.val) = MHHDR_CHECKSUM; }
#line 16705 "parser_bison.c"
    break;

  case 1297: /* exthdr_exists_expr: "exthdr" exthdr_key  */
#line 6117 "parser_bison.y"
                        {
				const struct exthdr_desc *desc;

				desc = exthdr_find_proto((yyvsp[0].val));

				/* Assume that NEXTHDR template is always
				 * the fist one in list of templates.
				 */
				(yyval.expr) = exthdr_expr_alloc(&(yyloc), desc, 1);
				(yyval.expr)->exthdr.flags = NFT_EXTHDR_F_PRESENT;
			}
#line 16721 "parser_bison.c"
    break;

  case 1298: /* exthdr_key: "hbh" close_scope_hbh  */
#line 6130 "parser_bison.y"
                                                        { (yyval.val) = IPPROTO_HOPOPTS; }
#line 16727 "parser_bison.c"
    break;

  case 1299: /* exthdr_key: "rt" close_scope_rt  */
#line 6131 "parser_bison.y"
                                                        { (yyval.val) = IPPROTO_ROUTING; }
#line 16733 "parser_bison.c"
    break;

  case 1300: /* exthdr_key: "frag" close_scope_frag  */
#line 6132 "parser_bison.y"
                                                                { (yyval.val) = IPPROTO_FRAGMENT; }
#line 16739 "parser_bison.c"
    break;

  case 1301: /* exthdr_key: "dst" close_scope_dst  */
#line 6133 "parser_bison.y"
                                                        { (yyval.val) = IPPROTO_DSTOPTS; }
#line 16745 "parser_bison.c"
    break;

  case 1302: /* exthdr_key: "mh" close_scope_mh  */
#line 6134 "parser_bison.y"
                                                        { (yyval.val) = IPPROTO_MH; }
#line 16751 "parser_bison.c"
    break;


#line 16755 "parser_bison.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken, &yylloc};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (&yylloc, nft, scanner, state, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= TOKEN_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == TOKEN_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, nft, scanner, state);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, nft, scanner, state);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, nft, scanner, state, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, nft, scanner, state);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, nft, scanner, state);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 6137 "parser_bison.y"

